import DhcpSearchV4, { IDhcpSearchV4 } from './DhcpSearchV4';
import DhcpSearchV6, { IDhcpSearchV6 } from './DhcpSearchV6';

// This file was autogenerated. Please do not change.
// All changes will be overwrited on commit.
export interface IDhcpSearchResult {
    v4?: IDhcpSearchV4;
    v6?: IDhcpSearchV6;
}

export default class DhcpSearchResult {
    readonly _v4: DhcpSearchV4 | undefined;

    get v4(): DhcpSearchV4 | undefined {
        return this._v4;
    }

    readonly _v6: DhcpSearchV6 | undefined;

    get v6(): DhcpSearchV6 | undefined {
        return this._v6;
    }

    constructor(props: IDhcpSearchResult) {
        if (props.v4) {
            this._v4 = new DhcpSearchV4(props.v4);
        }
        if (props.v6) {
            this._v6 = new DhcpSearchV6(props.v6);
        }
    }

    serialize(): IDhcpSearchResult {
        const data: IDhcpSearchResult = {
        };
        if (typeof this._v4 !== 'undefined') {
            data.v4 = this._v4.serialize();
        }
        if (typeof this._v6 !== 'undefined') {
            data.v6 = this._v6.serialize();
        }
        return data;
    }

    validate(): string[] {
        const validate = {
            v4: !this._v4 ? true : this._v4.validate().length === 0,
            v6: !this._v6 ? true : this._v6.validate().length === 0,
        };
        const isError: string[] = [];
        Object.keys(validate).forEach((key) => {
            if (!(validate as any)[key]) {
                isError.push(key);
            }
        });
        return isError;
    }

    update(props: Partial<IDhcpSearchResult>): DhcpSearchResult {
        return new DhcpSearchResult({ ...this.serialize(), ...props });
    }
}
