import AddressInfoBeta, { IAddressInfoBeta } from './AddressInfoBeta';

// This file was autogenerated. Please do not change.
// All changes will be overwrited on commit.
export interface IInitialConfigurationBeta {
    dns: IAddressInfoBeta;
    password: string;
    username: string;
    web: IAddressInfoBeta;
}

export default class InitialConfigurationBeta {
    readonly _dns: AddressInfoBeta;

    get dns(): AddressInfoBeta {
        return this._dns;
    }

    readonly _password: string;

    /**
     * Description: Basic auth password
     * Example: password
     */
    get password(): string {
        return this._password;
    }

    static passwordValidate(password: string): boolean {
        return typeof password === 'string' && !!password.trim();
    }

    readonly _username: string;

    /**
     * Description: Basic auth username
     * Example: admin
     */
    get username(): string {
        return this._username;
    }

    static usernameValidate(username: string): boolean {
        return typeof username === 'string' && !!username.trim();
    }

    readonly _web: AddressInfoBeta;

    get web(): AddressInfoBeta {
        return this._web;
    }

    constructor(props: IInitialConfigurationBeta) {
        this._dns = new AddressInfoBeta(props.dns);
        this._password = props.password.trim();
        this._username = props.username.trim();
        this._web = new AddressInfoBeta(props.web);
    }

    serialize(): IInitialConfigurationBeta {
        const data: IInitialConfigurationBeta = {
            dns: this._dns.serialize(),
            password: this._password,
            username: this._username,
            web: this._web.serialize(),
        };
        return data;
    }

    validate(): string[] {
        const validate = {
            dns: this._dns.validate().length === 0,
            web: this._web.validate().length === 0,
            username: typeof this._username === 'string' && !this._username ? true : this._username,
            password: typeof this._password === 'string' && !this._password ? true : this._password,
        };
        const isError: string[] = [];
        Object.keys(validate).forEach((key) => {
            if (!(validate as any)[key]) {
                isError.push(key);
            }
        });
        return isError;
    }

    update(props: Partial<IInitialConfigurationBeta>): InitialConfigurationBeta {
        return new InitialConfigurationBeta({ ...this.serialize(), ...props });
    }
}
