import Client, { IClient } from './Client';

// This file was autogenerated. Please do not change.
// All changes will be overwrited on commit.
export interface IClientUpdate {
    data?: IClient;
    name?: string;
}

export default class ClientUpdate {
    readonly _data: Client | undefined;

    get data(): Client | undefined {
        return this._data;
    }

    readonly _name: string | undefined;

    get name(): string | undefined {
        return this._name;
    }

    constructor(props: IClientUpdate) {
        if (props.data) {
            this._data = new Client(props.data);
        }
        if (typeof props.name === 'string') {
            this._name = props.name.trim();
        }
    }

    serialize(): IClientUpdate {
        const data: IClientUpdate = {
        };
        if (typeof this._data !== 'undefined') {
            data.data = this._data.serialize();
        }
        if (typeof this._name !== 'undefined') {
            data.name = this._name;
        }
        return data;
    }

    validate(): string[] {
        const validate = {
            name: !this._name ? true : typeof this._name === 'string' && !this._name ? true : this._name,
            data: !this._data ? true : this._data.validate().length === 0,
        };
        const isError: string[] = [];
        Object.keys(validate).forEach((key) => {
            if (!(validate as any)[key]) {
                isError.push(key);
            }
        });
        return isError;
    }

    update(props: Partial<IClientUpdate>): ClientUpdate {
        return new ClientUpdate({ ...this.serialize(), ...props });
    }
}
