import NetInterface, { INetInterface } from './NetInterface';

// This file was autogenerated. Please do not change.
// All changes will be overwrited on commit.
export interface IAddressesInfoBeta {
    dns_port: number;
    interfaces: INetInterface[];
    web_port: number;
}

export default class AddressesInfoBeta {
    readonly _dns_port: number;

    /**
     * Description: undefined
     * Example: 53
     */
    get dnsPort(): number {
        return this._dns_port;
    }

    static dnsPortValidate(dnsPort: number): boolean {
        return typeof dnsPort === 'number';
    }

    readonly _interfaces: NetInterface[];

    /** */
    get interfaces(): NetInterface[] {
        return this._interfaces;
    }

    readonly _web_port: number;

    /**
     * Description: undefined
     * Example: 80
     */
    get webPort(): number {
        return this._web_port;
    }

    static webPortValidate(webPort: number): boolean {
        return typeof webPort === 'number';
    }

    constructor(props: IAddressesInfoBeta) {
        this._dns_port = props.dns_port;
        this._interfaces = props.interfaces.map((p) => new NetInterface(p));
        this._web_port = props.web_port;
    }

    serialize(): IAddressesInfoBeta {
        const data: IAddressesInfoBeta = {
            dns_port: this._dns_port,
            interfaces: this._interfaces.map((p) => p.serialize()),
            web_port: this._web_port,
        };
        return data;
    }

    validate(): string[] {
        const validate = {
            dns_port: typeof this._dns_port === 'number',
            web_port: typeof this._web_port === 'number',
            interfaces: this._interfaces.reduce((result, p) => result && p.validate().length === 0, true),
        };
        const isError: string[] = [];
        Object.keys(validate).forEach((key) => {
            if (!(validate as any)[key]) {
                isError.push(key);
            }
        });
        return isError;
    }

    update(props: Partial<IAddressesInfoBeta>): AddressesInfoBeta {
        return new AddressesInfoBeta({ ...this.serialize(), ...props });
    }
}
