// Code generated by go run ./scripts/blocked-services/main.go; DO NOT EDIT.

package filtering

// blockedService represents a single blocked service.
type blockedService struct {
	ID      string   `json:"id"`
	Name    string   `json:"name"`
	IconSVG []byte   `json:"icon_svg"`
	Rules   []string `json:"rules"`
}

// blockedServices contains raw blocked service data.
var blockedServices = []blockedService{{
	ID:      "9gag",
	Name:    "9GAG",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M 44 14 C 44 13.644531 43.8125 13.316406 43.507813 13.136719 C 40.453125 11.347656 28.46875 4.847656 25.535156 3.136719 C 25.222656 2.957031 24.839844 2.957031 24.527344 3.136719 C 21.128906 5.117188 10.089844 11.621094 7.496094 13.136719 C 7.1875 13.316406 7 13.644531 7 14 L 7 20 C 7 20.378906 7.214844 20.722656 7.550781 20.894531 C 7.660156 20.949219 18.597656 26.453125 24.5 29.867188 C 24.8125 30.046875 25.195313 30.046875 25.507813 29.863281 C 27.269531 28.828125 29.117188 27.859375 30.902344 26.921875 C 32.253906 26.214844 33.636719 25.488281 35.003906 24.722656 C 35.007813 26.820313 35.003906 29.296875 35 30.40625 L 25 35.859375 L 14.480469 30.121094 C 14.144531 29.9375 13.730469 29.964844 13.417969 30.1875 L 6.417969 35.1875 C 6.140625 35.386719 5.980469 35.714844 6.003906 36.054688 C 6.023438 36.398438 6.214844 36.707031 6.515625 36.871094 L 24.542969 46.871094 C 24.695313 46.957031 24.859375 47 25.027344 47 C 25.195313 47 25.363281 46.957031 25.515625 46.875 L 43.484375 36.875 C 43.804688 36.695313 44 36.363281 44 36 C 44 36 43.992188 21.011719 44 14 Z M 25 20 L 18 16 L 25 12 L 32 16 Z\" /></svg>"),
	Rules: []string{
		"||9cache.com^",
		"||9gag.com^",
	},
}, {
	ID:      "amazon",
	Name:    "Amazon",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 32 32\"><path d=\"M16.2,4c-3.3,0-6.9,1.2-7.7,5.3C8.4,9.7,8.7,10,9,10l3.3,0.3c0.3,0,0.6-0.3,0.6-0.6c0.3-1.4,1.5-2.1,2.8-2.1c0.7,0,1.5,0.3,1.9,0.9c0.5,0.7,0.4,1.7,0.4,2.5v0.5c-2,0.2-4.6,0.4-6.5,1.2c-2.2,0.9-3.7,2.8-3.7,5.7c0,3.6,2.3,5.4,5.2,5.4c2.5,0,3.8-0.6,5.7-2.5c0.6,0.9,0.9,1.4,2,2.3c0.3,0.1,0.6,0.1,0.8-0.1v0c0.7-0.6,2-1.7,2.7-2.3c0.3-0.2,0.2-0.6,0-0.9c-0.6-0.9-1.3-1.6-1.3-3.2v-5.4c0-2.3,0.2-4.4-1.5-6C20.1,4.4,17.9,4,16.2,4z M17.1,14.3c0.3,0,0.6,0,0.9,0v0.8c0,1.3,0.1,2.5-0.6,3.7c-0.5,1-1.4,1.6-2.4,1.6c-1.3,0-2.1-1-2.1-2.5C12.9,15.2,14.9,14.5,17.1,14.3z M26.7,22.4c-0.9,0-1.9,0.2-2.7,0.8c-0.2,0.2-0.2,0.4,0.1,0.4c0.9-0.1,2.8-0.4,3.2,0.1s-0.4,2.3-0.7,3.1c-0.1,0.2,0.1,0.3,0.3,0.2c1.5-1.2,1.9-3.8,1.6-4.2C28.3,22.5,27.6,22.4,26.7,22.4z M3.7,22.8c-0.2,0-0.3,0.3-0.1,0.4c3.3,3,7.6,4.7,12.4,4.7c3.4,0,7.4-1.1,10.2-3.1c0.5-0.3,0.1-0.9-0.4-0.7c-3.1,1.3-6.4,1.9-9.5,1.9c-4.5,0-8.8-1.2-12.4-3.3C3.8,22.9,3.7,22.8,3.7,22.8z\" /></svg>"),
	Rules: []string{
		"||a2z.com^",
		"||amazon-adsystem.com^",
		"||amazon.ae^",
		"||amazon.ca^",
		"||amazon.cn^",
		"||amazon.co.jp^",
		"||amazon.co.uk^",
		"||amazon.com.au^",
		"||amazon.com.br^",
		"||amazon.com.mx^",
		"||amazon.com.tr^",
		"||amazon.com^",
		"||amazon.de^",
		"||amazon.es^",
		"||amazon.fr^",
		"||amazon.in^",
		"||amazon.it^",
		"||amazon.nl^",
		"||amazonpay.com^",
		"||amazonpay.in^",
		"||amazontrust.com^",
		"||aws",
		"||createspace.com^",
		"||images-amazon.com^",
		"||media-amazon.com^",
		"||primevideo.com^",
		"||ssl-images-amazon.com^",
	},
}, {
	ID:      "bilibili",
	Name:    "Bilibili",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" viewBox=\"0 0 48 48\"><path fill=\"currentColor\" d=\"M36.5,12h-7.086l3.793-3.793c0.391-0.391,0.391-1.023,0-1.414s-1.023-0.391-1.414,0L26.586,12 h-5.172l-5.207-5.207c-0.391-0.391-1.023-0.391-1.414,0s-0.391,1.023,0,1.414L18.586,12H12.5C9.467,12,7,14.467,7,17.5v15 c0,3.033,2.467,5.5,5.5,5.5h2c0,0.829,0.671,1.5,1.5,1.5s1.5-0.671,1.5-1.5h14c0,0.829,0.671,1.5,1.5,1.5s1.5-0.671,1.5-1.5h2 c3.033,0,5.5-2.467,5.5-5.5v-15C42,14.467,39.533,12,36.5,12z M39,32.5c0,1.378-1.122,2.5-2.5,2.5h-24c-1.378,0-2.5-1.122-2.5-2.5 v-15c0-1.378,1.122-2.5,2.5-2.5h24c1.378,0,2.5,1.122,2.5,2.5V32.5z\"/><rect width=\"2.75\" height=\"7.075\" x=\"30.625\" y=\"18.463\" fill=\"currentColor\" transform=\"rotate(-71.567 32.001 22)\"/><rect width=\"7.075\" height=\"2.75\" x=\"14.463\" y=\"20.625\" fill=\"currentColor\" transform=\"rotate(-18.432 17.998 21.997)\"/><path fill=\"currentColor\" d=\"M28.033,27.526c-0.189,0.593-0.644,0.896-1.326,0.896c-0.076-0.013-0.139-0.013-0.24-0.025 c-0.013,0-0.05-0.013-0.063,0c-0.341-0.05-0.745-0.177-1.061-0.467c-0.366-0.265-0.808-0.745-0.947-1.477 c0,0-0.29,1.174-0.896,1.49c-0.076,0.05-0.164,0.114-0.253,0.164l-0.038,0.025c-0.303,0.164-0.682,0.265-1.086,0.278 c-0.568-0.051-0.947-0.328-1.136-0.821l-0.063-0.164l-1.427,0.656l0.05,0.139c0.467,1.124,1.465,1.768,2.74,1.768 c0.922,0,1.667-0.303,2.209-0.909c0.556,0.606,1.288,0.909,2.209,0.909c1.856,0,2.55-1.288,2.765-1.843l0.051-0.126l-1.427-0.657 L28.033,27.526z\"/></svg>"),
	Rules: []string{
		"||b23.tv^",
		"||biliapi.net^",
		"||bilibili.com^",
		"||bilicdn1.com^",
		"||bilicdn2.com^",
		"||biligame.com^",
		"||bilivideo.cn^",
		"||bilivideo.com^",
		"||dreamcast.hk^",
		"||hdslb.com^",
	},
}, {
	ID:      "cloudflare",
	Name:    "CloudFlare",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M38 10.813l-.906 3.78-1.907-3.405v1.718c2.899 2.301 4.926 5.79 5.126 9.688.699-.2 1.3-.188 2-.188 1.374 0 2.667.297 3.812.875l-1.031-.593 3.812-.875-3.812-.907L48.5 19h-3.813l2.813-2.688-3.688 1.094 2-3.312-3.312 2 1.094-3.688-2.688 2.781.094-3.874-2 3.28zM27 11c-5 0-9.414 2.992-11.313 7.594-.699-.399-1.687-.688-2.687-.688-3.2 0-5.906 2.606-5.906 5.907v.5c-3.899.3-7.094 3.68-7.094 7.78 0 .802.113 1.52.313 2.22.101.398.5.687 1 .687h47c.398 0 .675-.195.874-.594.5-1.101.813-2.207.813-3.406 0-4.2-3.488-7.594-7.688-7.594-.8 0-1.511.082-2.312.282l4.906 6.625-5.5-4.5L22 29.593l15.094-4.905L28.5 21.5l10.688 1.813v-.125C39.188 16.488 33.699 11 27 11zm19.781 12.656c.434.274.844.586 1.219.938h.5z\" /></svg>"),
	Rules: []string{
		"||1.1.1.1^",
		"||argotunnel.com^",
		"||cloudflare-dns.com^",
		"||cloudflare-ipfs.com^",
		"||cloudflare-quic.com^",
		"||cloudflare.cn^",
		"||cloudflare.com^",
		"||cloudflare.net^",
		"||cloudflareaccess.com^",
		"||cloudflareapps.com^",
		"||cloudflarebolt.com^",
		"||cloudflareclient.com^",
		"||cloudflareinsights.com^",
		"||cloudflareresolve.com^",
		"||cloudflarestatus.com^",
		"||cloudflarestream.com^",
		"||cloudflarewarp.com^",
		"||dns4torpnlfs2ifuz2s2yf3fc7rdmsbhm6rw75euj35pac6ap25zgqad.onion^",
		"||one.one^",
		"||pages.dev^",
		"||trycloudflare.com^",
		"||videodelivery.net^",
		"||warp.plus^",
		"||workers.dev^",
	},
}, {
	ID:      "dailymotion",
	Name:    "Dailymotion",
	IconSVG: []byte("<svg viewBox=\"0 0 24 24\" fill=\"currentColor\" xmlns=\"http://www.w3.org/2000/svg\"><path d=\"M13.551 11.485a2.327 2.327 0 0 0-2.328 2.332c0 1.314 1.013 2.313 2.441 2.313l-.012.002c1.192 0 2.193-.983 2.193-2.28.001-1.349-1.001-2.367-2.294-2.367z\"/><path d=\"M3 3v18h18V3H3zm15.52 15.605h-2.682v-1.058c-.825.81-1.667 1.103-2.786 1.103-1.142 0-2.124-.371-2.947-1.114-1.086-.956-1.648-2.227-1.648-3.701 0-1.351.524-2.561 1.507-3.506.878-.859 1.946-1.298 3.139-1.298 1.14 0 2.018.385 2.647 1.192V6.118l2.77-.574v-.002l.002.003h-.002v13.06z\"/></svg>"),
	Rules: []string{
		"||dailymotion.com^",
		"||dm-event.net^",
		"||dmcdn.net^",
	},
}, {
	ID:      "deezer",
	Name:    "Deezer",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 24 24\"><path d=\"M18.81 4.16v3.03H24V4.16h-5.19zM6.27 8.38v3.027h5.189V8.38h-5.19zm12.54 0v3.027H24V8.38h-5.19zM6.27 12.594v3.027h5.189v-3.027h-5.19zm6.271 0v3.027h5.19v-3.027h-5.19zm6.27 0v3.027H24v-3.027h-5.19zM0 16.81v3.029h5.19v-3.03H0zm6.27 0v3.029h5.189v-3.03h-5.19zm6.271 0v3.029h5.19v-3.03h-5.19zm6.27 0v3.029H24v-3.03h-5.19Z\" /></svg>"),
	Rules: []string{
		"||deezer.com^",
		"||dzcdn.net^",
	},
}, {
	ID:      "discord",
	Name:    "Discord",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 24 24\"><path d=\"M20.098 5.559C18.156 4 15.09 3.734 14.96 3.723a.493.493 0 0 0-.484.285c-.004.008-.172.504-.34.984 2.254.395 3.785 1.27 3.867 1.317a.8.8 0 1 1-.805 1.382C17.176 7.68 14.93 6.398 12 6.398c-2.93 0-5.176 1.282-5.2 1.293a.8.8 0 0 1-.805-1.383c.083-.046 1.622-.925 3.88-1.32-.172-.484-.348-.972-.352-.98a.487.487 0 0 0-.484-.285c-.129.011-3.195.273-5.16 1.855C2.852 6.528.8 12.074.8 16.871c0 .082.02.164.062.238 1.418 2.489 5.282 3.141 6.16 3.168h.016c.156 0 .3-.074.395-.199l.949-1.289c-2.086-.504-3.192-1.293-3.258-1.344a.799.799 0 0 1-.168-1.117.794.794 0 0 1 1.113-.172c.032.016 2.067 1.446 5.93 1.446 3.879 0 5.91-1.434 5.93-1.45a.8.8 0 0 1 .945 1.293c-.066.047-1.164.836-3.246 1.34l.937 1.293c.094.125.239.2.395.2h.016c.882-.028 4.742-.68 6.16-3.169a.477.477 0 0 0 .062-.242c0-4.793-2.05-10.34-3.101-11.308zM8.8 15.199c-.887 0-1.602-.894-1.602-2 0-1.105.715-2 1.602-2 .883 0 1.597.895 1.597 2 0 1.106-.714 2-1.597 2zm6.398 0c-.883 0-1.597-.894-1.597-2 0-1.105.714-2 1.597-2 .887 0 1.602.895 1.602 2 0 1.106-.715 2-1.602 2zm0 0\" /></svg>"),
	Rules: []string{
		"||discord.com^",
		"||discord.gg^",
		"||discord.gift",
		"||discord.media^",
		"||discordapp.com^",
		"||discordapp.net^",
	},
}, {
	ID:      "disneyplus",
	Name:    "Disney+",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M19.986,25.212c0,0,0.562-0.878,1.545-1.264s0.667,0.562,0.141,0.948C21.144,25.282,20.617,25.388,19.986,25.212z M20.512,23.631c-0.913,0.176-1.194,0.667-1.089,1.194C19.564,24.404,20.512,23.632,20.512,23.631z M34.771,27.882 c-0.387,0.351-1.159,1.616-1.159,1.616s1.194-0.141,1.546-1.089C35.508,27.46,35.157,27.531,34.771,27.882z M10.398,28.83 c0.667,0.597,1.861,1.089,1.861,1.089l0.07-2.247c-0.526,0-1.755,0.316-2.072,0.386C9.941,28.127,9.73,28.233,10.398,28.83z M46,13 v24c0,4.963-4.038,9-9,9H13c-4.962,0-9-4.037-9-9V13c0-4.963,4.038-9,9-9h24C41.962,4,46,8.037,46,13z M13.541,21.934l0.572,0.223 c0.073,0.006,0.143-0.029,0.182-0.091c2.349-3.742,6.583-6.256,11.456-6.256c5.798,0,10.708,3.552,12.578,8.508 c0.029,0.076,0.1,0.127,0.182,0.127h0.596c0.07,0,0.12-0.071,0.097-0.137c-1.904-5.398-7.217-9.294-13.46-9.294 c-5.214,0-9.786,2.724-12.282,6.764C13.421,21.842,13.466,21.927,13.541,21.934z M15.911,23.843c-2.81-1.37-3.793-1.546-5.971-1.405 c-2.177,0.141-2.177,1.229-1.651,1.265c0.311,0.021,0.487,0.044,0.58,0.055c0.078,0.009,0.089-0.011,0.115-0.046 c0.022-0.03,0.032-0.075,0.043-0.102c0.019-0.049-0.003-0.099-0.047-0.118c-0.045-0.02-0.55-0.245-0.55-0.245 s2.74-0.702,6.146,0.948c3.406,1.65,4.285,3.793,3.337,4.847c-0.948,1.054-2.599,1.581-4.636,1.124 c-0.035-1.44,0.035-2.494,0.035-2.494s1.897-0.07,2.389,0.281c0.42,0.3,0.174,0.497-0.103,0.614 c-0.047,0.02-0.052,0.107-0.009,0.132c0.393,0.218,0.706,0.269,0.99-0.078c0.316-0.386,0.667-2.037-3.196-1.932 c-0.07-0.667,0.141-1.124-0.421-1.791C12.4,24.228,12.4,26.722,12.4,26.722s-1.44,0.21-2.634,1.054 c-1.194,0.843,2.458,2.88,2.458,2.88s0.07,0.913,0.597,1.019c0.527,0.105,0.492-0.667,0.492-0.667s3.16,0.913,5.269-0.948 C20.688,28.197,18.721,25.212,15.911,23.843z M19.74,25.844c0.562,0.247,1.65,0.071,2.353-0.632c0.702-0.702,1.019-2.002-0.21-1.932 c0,0-0.457-0.597-1.44-0.316c-0.983,0.281-2.212,1.581-1.334,2.423C19.108,25.773,19.214,26.511,19.74,25.844z M20.723,30.305 c0-0.527-0.035-2.634-0.106-3.056c-0.07-0.421-0.456-0.773-0.667-0.351c0,0-0.176,2.037-0.106,3.301 C19.88,30.727,20.723,30.831,20.723,30.305z M22.654,27.53c0.737-0.07,1.265-0.106,1.897-0.21c0.632-0.105,0.667-0.562,0.175-0.667 c0,0-1.932-0.421-3.231,0.421c-0.632,0.421-0.457,1.194-0.106,1.229c0.351,0.035,2.142,0.106,2.564,0.386 c0.421,0.281,0.527,0.492,0.07,0.773c-0.457,0.281-1.475,0.421-1.897,0.281c-0.421-0.141-0.562-0.878,0.21-0.492 c0.773,0.386,2.177-0.07,1.229-0.386c-0.948-0.316-1.72-0.245-2.212,0.106c-0.492,0.351,0.176,1.089,0.737,1.334 c0.562,0.245,1.616,0.316,2.248-0.07c0.632-0.386,0.948-1.861-0.07-2.107c-1.019-0.245-1.651-0.21-2.107-0.281 C21.706,27.776,21.917,27.601,22.654,27.53z M27.783,26.338c-1.089-1.265-0.528,0.525-0.457,0.841 c0.07,0.316,0.351,1.51,0.351,2.002c-0.351-0.527-0.913-1.581-1.405-2.072c-0.492-0.492-0.632-0.07-0.632-0.07 s-0.492,1.791-0.351,2.95c0.141,1.159,0.737,0.351,0.773,0c0.035-0.351,0.106-1.51,0.106-1.826c0.316,0.702,0.808,1.51,1.194,1.897 c0.386,0.386,0.773,0.141,0.913-0.21S28.872,27.602,27.783,26.338z M31.54,29.917c0.386-0.316-0.071-0.631-0.457-0.595 c-0.386,0.035-1.51,0.21-1.51,0.21l0.245-0.737c0,0,0.737,0.035,1.334-0.035s0.176-0.737-0.035-0.737c-0.21,0-0.983,0-0.983,0 l0.176-0.492c0,0,1.299-0.035,1.72-0.106c0.421-0.07-0.245-0.773-0.737-0.808c-0.492-0.035-1.546,0.106-2.248,0.245 c-0.702,0.141,0.457,0.667,0.457,0.667s-0.106,0.351-0.245,0.597c-0.421,0.07-0.386,0.316-0.245,0.632 c-0.281,0.737-0.421,1.651,0.386,1.932C30.206,30.97,31.154,30.232,31.54,29.917z M35.826,27.882 c0.105-1.476-1.23-1.159-1.757-0.632c-0.527,0.527-1.44,1.897-1.44,1.897c0.106-0.913,0.351-1.159,0.913-2.072 c0.48-0.78-0.281-0.492-0.281-0.492s-1.791,1.51-1.019,3.231c-0.527,1.299-1.37,3.16-0.141,4.144c0.316,0.21,0.21-0.421,0.316-0.773 c0.106-0.351,0.457-2.142,0.808-2.634C34.07,30.481,35.58,30.165,35.826,27.882z M42.004,27.786c0.003-0.063-0.05-0.115-0.115-0.115 h-2.114c-0.044-0.699-0.128-1.445-0.282-2.146c-0.009-0.039-0.041-0.07-0.081-0.073c-0.287,0-0.331,0.002-0.601,0.002 c-0.078,0.002-0.131,0.075-0.111,0.149c0.088,0.323,0.216,1.147,0.258,2.067H36.95c-0.062,0-0.114,0.051-0.117,0.112l-0.053,0.532 c-0.004,0.085,0.069,0.155,0.154,0.146l2.048,0.007c0.012,0.754,0.018,1.207-0.046,2.004c-0.008,0.053,0.033,0.098,0.087,0.101 c0.322,0.02,0.526,0.045,0.647,0.047c0.049,0.001,0.089-0.036,0.093-0.085c0.019-0.256,0.068-1.06,0.044-2.064l2.08,0.007 c0.065,0,0.117-0.053,0.117-0.118V27.786z\" /></svg>"),
	Rules: []string{
		"||disney-plus.net^",
		"||disney.playback.edge.bamgrid.com^",
		"||disneynow.com^",
		"||disneyplus.com^",
		"||hotstar.com^",
		"||media.dssott.com^",
		"||star.playback.edge.bamgrid.com^",
		"||starplus.com^",
	},
}, {
	ID:      "douban",
	Name:    "Douban",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M36.54 18.51H13.315v8.012H36.54zM8.58 14.32h32.643v16.39H8.581zM5.146 5.754h39.516v4.193H5.145zm11.051 25.652c1.73 2.416 3.28 5.336 4.647 8.748h8.263c1.637-2.632 3.076-5.552 4.31-8.748l4.75 1.631c-1.241 2.694-2.581 5.07-4.003 7.117h11.615v4.147H4.028v-4.147h12.168c-1.117-2.203-2.568-4.574-4.371-7.117z\" /></svg>"),
	Rules: []string{
		"||douban.com^",
		"||doubanio.com^",
	},
}, {
	ID:      "ebay",
	Name:    "EBay",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M 12.601563 13.671875 L 12.636719 24.058594 C 12.632813 22.457031 12.128906 18.101563 6.464844 18.097656 C 0.210938 18.097656 -0.03125 22.964844 0.00390625 24.230469 C 0.00390625 24.230469 -0.304688 29.917969 6.3125 29.917969 C 11.996094 29.917969 12.277344 26.347656 12.277344 26.347656 L 9.664063 26.355469 C 9.664063 26.355469 9.152344 28.320313 6.320313 28.265625 C 2.683594 28.199219 2.546875 24.675781 2.546875 24.675781 L 12.621094 24.675781 C 12.621094 24.675781 12.628906 24.566406 12.636719 24.425781 L 12.644531 26.960938 C 12.644531 26.960938 12.628906 28.507813 12.535156 29.53125 L 14.984375 29.53125 L 15.089844 28.039063 C 15.089844 28.039063 16.230469 29.917969 19.566406 29.917969 C 22.902344 29.917969 25.535156 27.863281 25.609375 24.050781 C 25.675781 20.242188 22.761719 18.117188 19.617188 18.097656 C 16.472656 18.082031 15.121094 19.960938 15.121094 19.960938 L 15.121094 13.671875 Z M 31.054688 18.046875 C 29.566406 18.097656 26.539063 18.558594 26.132813 21.460938 L 28.796875 21.460938 C 28.796875 21.460938 29 19.6875 31.703125 19.738281 C 34.257813 19.785156 34.722656 21.039063 34.707031 22.578125 C 34.707031 22.578125 32.519531 22.585938 31.785156 22.59375 C 30.46875 22.597656 25.863281 22.742188 25.433594 25.550781 C 24.917969 28.890625 27.898438 29.933594 30.230469 29.917969 C 32.5625 29.90625 33.890625 29.207031 34.878906 27.953125 L 34.984375 29.511719 L 37.300781 29.496094 C 37.300781 29.496094 37.242188 28.628906 37.25 26.90625 C 37.257813 25.1875 37.308594 23.65625 37.25 22.574219 C 37.183594 21.316406 37.304688 18.285156 31.875 18.0625 C 31.875 18.0625 31.550781 18.03125 31.054688 18.046875 Z M 35.871094 18.519531 L 41.675781 29.496094 L 39.4375 33.71875 L 42.265625 33.71875 L 50 18.519531 L 47.359375 18.519531 L 43.074219 27.046875 L 38.796875 18.519531 Z M 6.402344 19.765625 C 9.984375 19.761719 9.984375 22.949219 9.984375 22.949219 L 2.628906 22.949219 C 2.628906 22.949219 2.804688 19.765625 6.402344 19.765625 Z M 19.035156 19.800781 C 23.078125 19.699219 22.949219 24.097656 22.949219 24.097656 C 22.949219 24.097656 23.011719 28.167969 19.042969 28.21875 C 15.070313 28.269531 15.136719 24.011719 15.136719 24.011719 C 15.136719 24.011719 14.992188 19.90625 19.035156 19.800781 Z M 34.734375 24.265625 C 34.734375 24.269531 35.195313 28.371094 30.664063 28.3125 C 30.664063 28.3125 28.136719 28.3125 27.988281 26.296875 C 27.832031 24.140625 31.875 24.269531 31.875 24.269531 Z\" /></svg>"),
	Rules: []string{
		"||ebay.at^",
		"||ebay.be^",
		"||ebay.ca^",
		"||ebay.ch^",
		"||ebay.cn^",
		"||ebay.co.uk^",
		"||ebay.com.au^",
		"||ebay.com.cn^",
		"||ebay.com.hk^",
		"||ebay.com.my^",
		"||ebay.com.sg^",
		"||ebay.com^",
		"||ebay.de^",
		"||ebay.es^",
		"||ebay.fr^",
		"||ebay.ie^",
		"||ebay.in^",
		"||ebay.it^",
		"||ebay.nl^",
		"||ebay.ph^",
		"||ebay.pl^",
		"||ebaycdn.net^",
		"||ebayimg.com^",
		"||ebayinc.com^",
		"||ebaystatic.com^",
	},
}, {
	ID:      "epic_games",
	Name:    "Epic Games",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M 10 3 C 6.69 3 4 5.69 4 9 L 4 41.240234 L 25 47.539062 L 46 41.240234 L 46 9 C 46 5.69 43.31 3 40 3 L 10 3 z M 11 8 L 15 8 L 15 11 L 11 11 L 11 18 L 14 18 L 14 21 L 11 21 L 11 28 L 15 28 L 15 31 L 11 31 C 9.34 31 8 29.66 8 28 L 8 11 C 8 9.34 9.34 8 11 8 z M 17 8 L 23 8 C 24.66 8 26 9.34 26 11 L 26 18 C 26 19.66 24.66 21 23 21 L 20 21 L 20 31 L 17 31 L 17 8 z M 28 8 L 31 8 L 31 31 L 28 31 L 28 8 z M 36 8 L 39 8 C 40.66 8 42 9.34 42 11 L 42 15 L 39 15 L 39 11 L 36 11 L 36 28 L 39 28 L 39 24 L 42 24 L 42 28 C 42 29.66 40.66 31 39 31 L 36 31 C 34.34 31 33 29.66 33 28 L 33 11 C 33 9.34 34.34 8 36 8 z M 20 11 L 20 18 L 23 18 L 23 11 L 20 11 z M 9 34 L 13 34 C 13.55 34 14 34.45 14 35 L 14 36 L 13 36 L 13 35.25 C 13 35.11 12.89 35 12.75 35 L 9.25 35 C 9.11 35 9 35.11 9 35.25 L 9 38.75 C 9 38.89 9.11 39 9.25 39 L 12.75 39 C 12.89 39 13 38.89 13 38.75 L 13 38 L 12 38 L 12 37 L 14 37 L 14 39 C 14 39.55 13.55 40 13 40 L 9 40 C 8.45 40 8 39.55 8 39 L 8 35 C 8 34.45 8.45 34 9 34 z M 18 34 L 19 34 L 22 40 L 21 40 L 20.5 39 L 16.5 39 L 16 40 L 15 40 L 18 34 z M 23 34 L 24 34 L 26 38 L 28 34 L 29 34 L 29 40 L 28 40 L 28 36 L 26.5 39 L 25.5 39 L 24 36 L 24 40 L 23 40 L 23 34 z M 30 34 L 35 34 L 35 35 L 31 35 L 31 36.5 L 33 36.5 L 33 37.5 L 31 37.5 L 31 39 L 35 39 L 35 40 L 30 40 L 30 34 z M 37 34 L 41 34 C 41.55 34 42 34.45 42 35 L 42 35.5 L 41 35.5 L 41 35.25 C 41 35.11 40.89 35 40.75 35 L 37.25 35 C 37.11 35 37 35.11 37 35.25 L 37 36.25 C 37 36.39 37.11 36.5 37.25 36.5 L 41 36.5 C 41.55 36.5 42 36.95 42 37.5 L 42 39 C 42 39.55 41.55 40 41 40 L 37 40 C 36.45 40 36 39.55 36 39 L 36 38.5 L 37 38.5 L 37 38.75 C 37 38.89 37.11 39 37.25 39 L 40.75 39 C 40.89 39 41 38.89 41 38.75 L 41 37.75 C 41 37.61 40.89 37.5 40.75 37.5 L 37 37.5 C 36.45 37.5 36 37.05 36 36.5 L 36 35 C 36 34.45 36.45 34 37 34 z M 18.5 35 L 17 38 L 20 38 L 18.5 35 z\"></path></svg>"),
	Rules: []string{
		"||eac-cdn.com^",
		"||easy.ac^",
		"||easyanticheat.net^",
		"||epicgames.com^",
	},
}, {
	ID:      "facebook",
	Name:    "Facebook",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 27 27\"><path d=\"M12 0C5.371 0 0 5.371 0 12c0 6.016 4.434 10.984 10.207 11.852V15.18H7.238v-3.153h2.969V9.926c0-3.473 1.691-5 4.578-5 1.387 0 2.117.105 2.461.148v2.754h-1.969c-1.226 0-1.652 1.164-1.652 2.473v1.726h3.594l-.489 3.153h-3.105v8.699C19.48 23.082 24 18.074 24 12c0-6.629-5.371-12-12-12zm0 0\" /></svg>"),
	Rules: []string{
		"||accountkit.com^",
		"||facebook.com^",
		"||facebook.net^",
		"||facebookcorewwwi.onion^",
		"||fb.com^",
		"||fb.gg^",
		"||fb.me^",
		"||fb.watch^",
		"||fbcdn.com^",
		"||fbcdn.net^",
		"||fbsbx.com^",
		"||fbwat.ch^",
		"||messenger.com^",
	},
}, {
	ID:      "hulu",
	Name:    "Hulu",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M 0 15 L 0 34 L 4 34 L 4 25 C 4 24.5 4.398438 24 5 24 L 8 24 C 8.5 24 9 24.398438 9 25 L 9 34 L 13 34 L 13 24 C 13 21.800781 11.199219 20 9 20 L 4 20 L 4 15 Z M 30 15 L 30 34 L 34 34 L 34 15 Z M 15 20 L 15 30 C 15 32.199219 16.800781 34 19 34 L 24 34 C 26.199219 34 27.992188 32.199219 28.09375 30 L 28.09375 20 L 24.09375 20 L 24.09375 28.90625 C 24.09375 29.507813 23.601563 30 23 30 L 20.09375 30 C 19.492188 30 19 29.507813 19 28.90625 L 19 20 Z M 36 20 L 36 30 C 36 32.199219 37.800781 34 40 34 L 45 34 C 47.199219 34 49 32.199219 49 30 L 49 20 L 45 20 L 45 29 C 45 29.5 44.601563 30 44 30 L 41 30 C 40.5 30 40 29.601563 40 29 L 40 20 Z\" /></svg>"),
	Rules: []string{
		"||hulu.com^",
	},
}, {
	ID:      "icloud_private_relay",
	Name:    "iCloud Private Relay",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 512 512\"><path d=\"M395.748 272.046c-.646-64.841 52.88-95.938 55.271-97.483-30.075-44.01-76.925-50.039-93.62-50.736-39.871-4.037-77.798 23.474-98.033 23.474-20.184 0-51.409-22.877-84.476-22.276-43.458.646-83.529 25.269-105.906 64.19-45.152 78.35-11.563 194.42 32.445 257.963 21.504 31.104 47.146 66.038 80.813 64.79 32.421-1.294 44.681-20.979 83.878-20.979 39.196 0 50.215 20.979 84.524 20.335 34.888-.648 56.991-31.699 78.347-62.898 24.694-36.084 34.862-71.019 35.462-72.812-.775-.354-68.031-26.119-68.705-103.568zM331.28 81.761C349.149 60.082 361.21 30.005 357.92 0c-25.739 1.048-56.938 17.145-75.405 38.775-16.57 19.188-31.075 49.813-27.188 79.218 28.734 2.242 58.065-14.602 75.953-36.232z\" /></svg>"),
	Rules: []string{
		"||mask-h2.icloud.com^$dnsrewrite=NXDOMAIN;;",
		"||mask.icloud.com^$dnsrewrite=NXDOMAIN;;",
	},
}, {
	ID:      "imgur",
	Name:    "Imgur",
	IconSVG: []byte("<svg fill=\"currentColor\" xmlns=\"http://www.w3.org/2000/svg\"  viewBox=\"0 0 50 50\"><path d=\"M 13.890625 4 C 8.440625 4 4 8.440625 4 13.890625 L 4 14 L 4 25.150391 L 4 36 C 4 41.511334 8.4886661 46 14 46 L 25.240234 46 L 36 46 L 36.109375 46 C 41.559375 46 46 41.559375 46 36.109375 L 46 36 L 46 14 L 46 13.890625 C 46 8.440625 41.559375 4 36.109375 4 L 36 4 L 14 4 L 13.890625 4 z M 30.650391 12.841797 C 32.240547 12.849766 33.879609 12.879687 35.599609 12.929688 C 36.589609 12.949687 37.410469 13.759531 37.480469 14.769531 C 37.880469 20.889531 37.589062 26.699063 37.039062 33.539062 C 36.969062 34.359063 36.559688 35.090547 35.929688 35.560547 C 35.919688 35.560547 35.910156 35.570312 35.910156 35.570312 L 27.287109 44 L 14 44 C 9.5693339 44 6 40.430666 6 36 L 6 23.175781 L 15.140625 14.150391 L 15.150391 14.150391 C 15.600391 13.700391 16.199141 13.419141 16.869141 13.369141 C 21.556641 12.986641 25.879922 12.817891 30.650391 12.841797 z M 30.029297 14.839844 C 25.569297 14.839844 21.459297 14.999375 17.029297 15.359375 C 16.569297 15.399375 16.399609 15.740859 16.349609 15.880859 C 16.299609 16.020859 16.209297 16.390937 16.529297 16.710938 L 21.490234 21.669922 L 12.789062 30.369141 C 13.169063 31.119141 14.099922 32.660234 15.919922 34.490234 C 17.749922 36.310234 19.289062 37.229141 20.039062 37.619141 L 28.730469 28.910156 L 33.699219 33.880859 C 34.019219 34.200859 34.379297 34.110547 34.529297 34.060547 C 34.669297 34.010547 35.009062 33.830859 35.039062 33.380859 C 35.589062 26.630859 35.870469 20.910156 35.480469 14.910156 C 33.580469 14.860156 31.779297 14.839844 30.029297 14.839844 z M 14.501953 20 C 14.450328 20 14.399406 20.028938 14.378906 20.085938 C 14.163906 20.686938 13.684938 21.159047 13.085938 21.373047 C 12.971938 21.413047 12.971937 21.580094 13.085938 21.621094 C 13.684937 21.837094 14.162906 22.315062 14.378906 22.914062 C 14.419906 23.028062 14.585953 23.028063 14.626953 22.914062 C 14.840953 22.316062 15.313063 21.837094 15.914062 21.621094 C 16.028062 21.580094 16.027109 21.415047 15.912109 21.373047 C 15.312109 21.160047 14.839 20.685938 14.625 20.085938 C 14.605 20.028938 14.553578 20 14.501953 20 z M 10.503906 24 C 10.417781 23.999875 10.332828 24.047578 10.298828 24.142578 C 9.9398281 25.143578 9.1425312 25.935016 8.1445312 26.291016 C 7.9535313 26.359016 7.9525781 26.635125 8.1425781 26.703125 C 9.1405781 27.063125 9.9398281 27.859422 10.298828 28.857422 C 10.366828 29.047422 10.642938 29.047422 10.710938 28.857422 C 11.066937 27.859422 11.856422 27.062125 12.857422 26.703125 C 13.047422 26.635125 13.047422 26.358016 12.857422 26.291016 C 11.857422 25.936016 11.066937 25.145531 10.710938 24.144531 C 10.677437 24.049031 10.590031 24.000125 10.503906 24 z M 10.501953 33 C 10.450328 33 10.399406 33.028938 10.378906 33.085938 C 10.163906 33.686938 9.6849375 34.159047 9.0859375 34.373047 C 8.9719375 34.413047 8.9719375 34.580094 9.0859375 34.621094 C 9.6849375 34.837094 10.162906 35.315063 10.378906 35.914062 C 10.419906 36.028062 10.585953 36.028062 10.626953 35.914062 C 10.840953 35.316063 11.313063 34.837094 11.914062 34.621094 C 12.028062 34.580094 12.027109 34.415047 11.912109 34.373047 C 11.312109 34.160047 10.839 33.685938 10.625 33.085938 C 10.605 33.028937 10.553578 33 10.501953 33 z M 29.001953 33 C 28.967453 33 28.933422 33.018641 28.919922 33.056641 C 28.775922 33.456641 28.455641 33.774016 28.056641 33.916016 C 27.980641 33.943016 27.980641 34.053078 28.056641 34.080078 C 28.455641 34.224078 28.775922 34.544359 28.919922 34.943359 C 28.947922 35.019359 29.056984 35.019359 29.083984 34.943359 C 29.225984 34.544359 29.543359 34.224078 29.943359 34.080078 C 30.019359 34.053078 30.019359 33.943016 29.943359 33.916016 C 29.543359 33.774016 29.225984 33.456641 29.083984 33.056641 C 29.070484 33.018641 29.036453 33 29.001953 33 z M 26.001953 36 C 25.933078 35.999875 25.865391 36.037281 25.837891 36.113281 C 25.550891 36.914281 24.911281 37.547031 24.113281 37.832031 C 23.960281 37.887031 23.961281 38.107109 24.113281 38.162109 C 24.912281 38.450109 25.549891 39.088719 25.837891 39.886719 C 25.892891 40.038719 26.113969 40.036766 26.167969 39.884766 C 26.452969 39.086766 27.085719 38.450109 27.886719 38.162109 C 28.038719 38.108109 28.037766 37.887031 27.884766 37.832031 C 27.083766 37.547031 26.452969 36.914281 26.167969 36.113281 C 26.140969 36.036781 26.070828 36.000125 26.001953 36 z M 9.0019531 38 C 8.9674531 38 8.9334219 38.018641 8.9199219 38.056641 C 8.7759219 38.456641 8.4556406 38.774016 8.0566406 38.916016 C 7.9806406 38.943016 7.9806406 39.053078 8.0566406 39.080078 C 8.4556406 39.224078 8.7759219 39.544359 8.9199219 39.943359 C 8.9479219 40.019359 9.0569844 40.019359 9.0839844 39.943359 C 9.2259844 39.544359 9.5433594 39.224078 9.9433594 39.080078 C 10.019359 39.053078 10.019359 38.943016 9.9433594 38.916016 C 9.5433594 38.774016 9.2259844 38.456641 9.0839844 38.056641 C 9.0704844 38.018641 9.0364531 38 9.0019531 38 z M 13.501953 39 C 13.450328 39 13.399406 39.028937 13.378906 39.085938 C 13.163906 39.686938 12.684938 40.159047 12.085938 40.373047 C 11.971938 40.413047 11.971937 40.580094 12.085938 40.621094 C 12.684937 40.837094 13.162906 41.315063 13.378906 41.914062 C 13.419906 42.028062 13.585953 42.028062 13.626953 41.914062 C 13.840953 41.316063 14.313063 40.837094 14.914062 40.621094 C 15.028062 40.580094 15.027109 40.415047 14.912109 40.373047 C 14.312109 40.160047 13.839 39.685938 13.625 39.085938 C 13.605 39.028937 13.553578 39 13.501953 39 z M 20.501953 40 C 20.450328 40 20.399406 40.028938 20.378906 40.085938 C 20.163906 40.686938 19.684938 41.159047 19.085938 41.373047 C 18.971937 41.413047 18.971937 41.580094 19.085938 41.621094 C 19.684938 41.837094 20.162906 42.315063 20.378906 42.914062 C 20.419906 43.028062 20.585953 43.028062 20.626953 42.914062 C 20.840953 42.316062 21.313063 41.837094 21.914062 41.621094 C 22.028062 41.580094 22.027109 41.415047 21.912109 41.373047 C 21.312109 41.160047 20.839 40.685938 20.625 40.085938 C 20.605 40.028937 20.553578 40 20.501953 40 z\"/></svg>"),
	Rules: []string{
		"||imgur.com^",
	},
}, {
	ID:      "instagram",
	Name:    "Instagram",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 24 24\"><path d=\"M12 8.8A3.2 3.2 0 0 0 8.8 12a3.2 3.2 0 0 0 3.2 3.2 3.2 3.2 0 0 0 3.2-3.2A3.2 3.2 0 0 0 12 8.8zm0 0\" /><path d=\"M16 2.398H8A5.609 5.609 0 0 0 2.398 8v8A5.609 5.609 0 0 0 8 21.602h8A5.609 5.609 0 0 0 21.602 16V8A5.609 5.609 0 0 0 16 2.398zm-4 14.403A4.805 4.805 0 0 1 7.2 12c0-2.648 2.152-4.8 4.8-4.8 2.648 0 4.8 2.152 4.8 4.8 0 2.648-2.152 4.8-4.8 4.8zm5.602-9.602a.799.799 0 1 1 0 0zm0 0\" /></svg>"),
	Rules: []string{
		"||cdninstagram.com^",
		"||instagram.com^",
	},
}, {
	ID:      "mail_ru",
	Name:    "Mail.ru",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 512 512\"><path d=\"M256 141.176c-63.306 0-114.809 51.503-114.809 114.809S192.694 370.795 256 370.795s114.809-51.503 114.809-114.809S319.306 141.176 256 141.176zm0 188.254c-40.498 0-73.445-32.947-73.445-73.445 0-40.498 32.947-73.445 73.445-73.445 40.499 0 73.445 32.947 73.445 73.445 0 40.498-32.946 73.445-73.445 73.445z\" /><path d=\"M437.008 74.97C388.656 26.623 324.375 0 256 0h-.017C187.603.004 123.318 26.637 74.97 74.992 26.62 123.347-.005 187.637 0 256.017c.004 68.379 26.637 132.666 74.992 181.014C123.344 485.377 187.625 512.001 256 512h.017c55.945-.004 111.216-18.738 155.631-52.752 9.07-6.945 10.792-19.927 3.846-28.995-6.945-9.069-19.926-10.794-28.995-3.846-37.24 28.518-83.58 44.224-130.486 44.228h-.014c-57.324 0-111.224-22.324-151.761-62.856-40.542-40.536-62.871-94.435-62.875-151.766-.006-118.35 96.273-214.641 214.623-214.649H256c118.34 0 214.628 96.279 214.636 214.622v23.532c0 27.523-22.39 49.913-49.913 49.913-27.523 0-49.913-22.391-49.913-49.913v-23.532c0-11.422-9.259-20.682-20.682-20.682s-20.682 9.26-20.682 20.682v23.532c0 50.33 40.947 91.278 91.278 91.278S512 329.848 512 279.518v-23.534c-.005-68.38-26.638-132.666-74.992-181.014z\" /></svg>"),
	Rules: []string{
		"||mail.ru^",
	},
}, {
	ID:      "minecraft",
	Name:    "Minecraft",
	IconSVG: []byte("<svg fill=\"currentColor\" xmlns=\"http://www.w3.org/2000/svg\"  viewBox=\"0 0 50 50\"><path d=\"M 10.5 4 C 10.066406 4 9.695313 4.273438 9.5625 4.6875 L 0.0625 34.28125 C -0.0546875 34.648438 0.0273438 35.078125 0.3125 35.34375 L 10.40625 44.71875 C 10.589844 44.890625 10.839844 45 11.09375 45 L 22 45 C 22.449219 45 22.851563 44.683594 22.96875 44.25 L 24.3125 39.34375 C 24.40625 39.371094 24.492188 39.40625 24.59375 39.40625 L 27.03125 39.40625 L 31.65625 44.65625 C 31.847656 44.875 32.117188 45 32.40625 45 L 43.6875 45 C 44.167969 45 44.597656 44.660156 44.6875 44.1875 L 49.96875 16.1875 C 50.011719 15.96875 49.976563 15.730469 49.875 15.53125 L 44.1875 4.53125 C 44.015625 4.199219 43.6875 4 43.3125 4 L 31.90625 4 C 31.449219 4 31.050781 4.308594 30.9375 4.75 L 29.8125 9.125 L 27.46875 9.1875 C 27.03125 9.203125 26.648438 9.515625 26.53125 9.9375 L 26.46875 10.125 L 22.3125 4.40625 C 22.125 4.148438 21.820313 4 21.5 4 Z M 11.21875 6 L 20.09375 6 L 18.71875 10.59375 L 9.75 10.59375 Z M 32.6875 6 L 41.96875 6 L 39.6875 15.59375 L 35 15.59375 C 35.046875 15.449219 35.074219 15.3125 35.09375 15.15625 L 35.59375 11.71875 C 35.703125 10.734375 35.359375 10.113281 35.0625 9.78125 C 34.78125 9.46875 34.277344 9.09375 33.40625 9.09375 L 31.875 9.09375 Z M 30.625 11.09375 L 33.40625 11.09375 C 33.542969 11.09375 33.589844 11.125 33.59375 11.125 C 33.609375 11.152344 33.644531 11.277344 33.625 11.46875 L 33.09375 14.875 C 33.050781 15.273438 32.679688 15.5 32.3125 15.5 C 32.15625 15.5 32.007813 15.53125 31.875 15.59375 L 27.125 15.59375 L 28.0625 12.15625 C 28.089844 12.054688 28.097656 11.945313 28.09375 11.84375 L 28.28125 11.1875 Z M 9.125 12.59375 L 20.71875 12.59375 L 19.71875 16.34375 C 19.640625 16.644531 19.714844 16.972656 19.90625 17.21875 C 20.09375 17.464844 20.378906 17.59375 20.6875 17.59375 L 39.25 17.59375 L 35.78125 33.6875 L 27 33.6875 L 29.96875 22.65625 C 30.050781 22.355469 29.96875 22.027344 29.78125 21.78125 C 29.59375 21.535156 29.3125 21.40625 29 21.40625 L 25.5 21.40625 C 25.046875 21.40625 24.648438 21.71875 24.53125 22.15625 L 23.21875 27 L 19.125 27 L 20.375 22.5625 C 20.460938 22.261719 20.375 21.9375 20.1875 21.6875 C 20 21.4375 19.71875 21.3125 19.40625 21.3125 L 15.90625 21.3125 C 15.460938 21.3125 15.0625 21.605469 14.9375 22.03125 L 13.8125 25.90625 C 13.742188 26 13.660156 26.101563 13.625 26.21875 L 13.59375 26.40625 L 10.15625 26.40625 L 10.5625 25.1875 C 10.75 24.53125 10.628906 23.84375 10.25 23.34375 C 9.890625 22.867188 9.320313 22.59375 8.6875 22.59375 L 5.90625 22.59375 Z M 5.25 24.59375 L 8.65625 24.59375 L 8.28125 25.71875 C 8.089844 26.167969 8.042969 26.613281 8.15625 27.03125 C 7.808594 27.316406 7.5625 27.6875 7.4375 28.125 L 7.0625 29.46875 C 6.773438 30.195313 6.832031 30.976563 7.21875 31.5625 C 7.53125 32.035156 8.183594 32.59375 9.59375 32.59375 L 11.8125 32.59375 L 11.53125 33.5 L 2.375 33.59375 Z M 10.09375 28.40625 L 13 28.40625 L 12.375 30.59375 L 9.59375 30.59375 C 9.015625 30.59375 8.875 30.46875 8.875 30.46875 C 8.863281 30.441406 8.851563 30.316406 8.90625 30.1875 C 8.921875 30.148438 8.957031 30.101563 8.96875 30.0625 L 9.375 28.6875 C 9.410156 28.558594 9.714844 28.40625 10.09375 28.40625 Z\"/></svg>"),
	Rules: []string{
		"||minecraft.net^",
		"||minecraftservices.com^",
		"||mojang.com^",
	},
}, {
	ID:      "netflix",
	Name:    "Netflix",
	IconSVG: []byte("<svg fill=\"currentColor\" xmlns=\"http://www.w3.org/2000/svg\"  viewBox=\"0 0 30 30\"><path d=\"M24,4H6C4.895,4,4,4.895,4,6v18c0,1.105,0.895,2,2,2h18c1.105,0,2-0.895,2-2V6C26,4.895,25.105,4,24,4z M19,22c0,0-1.5-0.232-3-0.232l-2-5.507v5.507c-1.5,0-3,0.232-3,0.232V8h3l2,5.6V8h3V22z\" /></svg>"),
	Rules: []string{
		"||netflix.com^",
		"||nflxext.com^",
		"||nflximg.net^",
		"||nflxso.net^",
		"||nflxvideo.net^",
	},
}, {
	ID:      "ok",
	Name:    "OK.ru",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 96 96\"><path d=\"M50 28c-3.313 0-6 2.688-6 6 0 3.313 2.688 6 6 6 3.313 0 6-2.688 6-6 0-3.313-2.688-6-6-6zm0 0\" /><path d=\"M50 4C24.637 4 4 24.637 4 50s20.637 46 46 46 46-20.637 46-46S75.363 4 50 4zm0 16c7.73 0 14 6.27 14 14s-6.27 14-14 14-14-6.27-14-14 6.27-14 14-14zm14.828 49.172A3.999 3.999 0 0 1 62 76a3.987 3.987 0 0 1-2.828-1.172L50 65.656l-9.172 9.172a3.999 3.999 0 0 1-5.656 0 3.999 3.999 0 0 1 0-5.656l6.43-6.43c-1.836-.539-3.618-1.207-5.29-2.066A4.302 4.302 0 0 1 34 56.859c0-2.98 3.172-4.761 5.809-3.375A21.767 21.767 0 0 0 50 56c3.684 0 7.148-.91 10.191-2.516C62.828 52.098 66 53.88 66 56.86c0 1.602-.89 3.078-2.313 3.813-1.671.863-3.453 1.531-5.289 2.07zm0 0\" /></svg>"),
	Rules: []string{
		"||ok.ru^",
	},
}, {
	ID:      "origin",
	Name:    "Origin",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 24 24\"><path d=\"M 12 4 C 11.539063 4 11.09375 4.046875 10.65625 4.121094 C 11.082031 3.183594 11.550781 2.445313 12 2 C 12.195313 1.804688 12.011719 1.484375 11.738281 1.539063 C 7.808594 2.359375 4 7.0625 4 12 C 4 16.417969 7.582031 20 12 20 C 12.460938 20 12.90625 19.953125 13.34375 19.878906 C 12.917969 20.816406 12.449219 21.554688 12 22 C 11.804688 22.195313 11.988281 22.515625 12.261719 22.460938 C 16.191406 21.640625 20 16.9375 20 12 C 20 7.582031 16.417969 4 12 4 Z M 12 15 C 10.34375 15 9 13.65625 9 12 C 9 10.34375 10.34375 9 12 9 C 13.65625 9 15 10.34375 15 12 C 15 13.65625 13.65625 15 12 15 Z\" /></svg>"),
	Rules: []string{
		"||accounts.ea.com^",
		"||origin.com^",
		"||signin.ea.com^",
	},
}, {
	ID:      "pinterest",
	Name:    "Pinterest",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M25,2C12.318,2,2,12.317,2,25s10.318,23,23,23s23-10.317,23-23S37.682,2,25,2z M27.542,32.719 c-3.297,0-4.516-2.138-4.516-2.138s-0.588,2.309-1.021,3.95s-0.507,1.665-0.927,2.591c-0.471,1.039-1.626,2.674-1.966,3.177 c-0.271,0.401-0.607,0.735-0.804,0.696c-0.197-0.038-0.197-0.245-0.245-0.678c-0.066-0.595-0.258-2.594-0.166-3.946 c0.06-0.88,0.367-2.371,0.367-2.371l2.225-9.108c-1.368-2.807-0.246-7.192,2.871-7.192c2.211,0,2.79,2.001,2.113,4.406 c-0.301,1.073-1.246,4.082-1.275,4.224c-0.029,0.142-0.099,0.442-0.083,0.738c0,0.878,0.671,2.672,2.995,2.672 c3.744,0,5.517-5.535,5.517-9.237c0-2.977-1.892-6.573-7.416-6.573c-5.628,0-8.732,4.283-8.732,8.214 c0,2.205,0.87,3.091,1.273,3.577c0.328,0.395,0.162,0.774,0.162,0.774l-0.355,1.425c-0.131,0.471-0.552,0.713-1.143,0.368 C15.824,27.948,13,26.752,13,21.649C13,16.42,17.926,11,25.571,11C31.64,11,37,14.817,37,21.001 C37,28.635,32.232,32.719,27.542,32.719z\" /></svg>"),
	Rules: []string{
		"||pinimg.com^",
		"||pinterest.*^",
	},
}, {
	ID:      "qq",
	Name:    "QQ",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 32 32\"><g fill=\"none\" fillRule=\"evenodd\"><path d=\"M0 0h32v32H0z\" /><g fill=\"currentColor\" fillRule=\"nonzero\"><path d=\"M11.25 32C8.342 32 6 30.74 6 29.242c0-1.497 2.342-2.757 5.25-2.757s5.25 1.26 5.25 2.757S14.158 32 11.25 32zM27 29.242c0-1.497-2.342-2.757-5.25-2.757s-5.25 1.26-5.25 2.757S18.842 32 21.75 32 27 30.74 27 29.242zM14.885 7.182c0 .63-.323 1.182-.808 1.182-.485 0-.808-.552-.808-1.182 0-.63.323-1.182.808-1.182.485 0 .808.552.808 1.182zM18.923 6c-.485 0-.808.552-.808 1.182 0 .63.323-.394.808-.394.485 0 .808 1.024.808.394S19.408 6 18.923 6z\" /><path d=\"M6.653 12.638s4.685 2.465 9.926 2.465c5.242 0 9.927-2.465 9.927-2.465.112-.09.217-.161.316-.212-.002-1.088-.078-2.026-.078-2.808C26.744 4.292 22.138 0 16.5 0S6.176 4.292 6.176 9.618v2.78c.146.042.3.113.477.24zm12.626-8.664c1.112 0 1.986 1.272 1.986 2.782s-.874 2.782-1.986 2.782c-1.111 0-1.985-1.271-1.985-2.782 0-1.51.874-2.782 1.985-2.782zm-5.558 0c1.111 0 1.985 1.272 1.985 2.782s-.874 2.782-1.985 2.782c-1.112 0-1.986-1.271-1.986-2.782 0-1.51.874-2.782 1.986-2.782zm2.779 6.624c2.912 0 5.294.464 5.294.994s-2.382 1.656-5.294 1.656c-2.912 0-5.294-1.126-5.294-1.656s2.382-.994 5.294-.994zm11.374 5.182c-.058.038-.108.076-.177.117-.159.08-5.241 3.18-11.038 3.18-1.43 0-2.7-.239-3.97-.477-.239 1.67-.239 3.259-.239 3.974 0 1.272-1.032 1.193-2.303 1.272-1.27 0-2.223.16-2.303-1.033 0-.16-.08-2.782.397-5.564-1.588-.716-2.62-1.272-2.7-1.352a3.293 3.293 0 01-.335-.216C4.012 17.55 3 19.598 3 21.223c0 3.815 1.112 3.418 1.112 3.418.476 0 1.27-.795 1.985-1.67C7.765 27.662 11.735 31 16.5 31c4.765 0 8.735-3.338 10.403-8.028.715.874 1.509 1.669 1.985 1.669 0 0 1.112.397 1.112-3.418 0-1.588-.968-3.631-2.126-5.443z\" /></g></g></svg>"),
	Rules: []string{
		"||qq-video.cdn-go.cn^",
		"||qq.com^$denyallow=wx.qq.com|weixin.qq.com",
		"||url.cn^",
	},
}, {
	ID:      "reddit",
	Name:    "Reddit",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 24 24\"><path d=\"M14.238 15.348c.085.084.085.221 0 .306-.465.462-1.194.687-2.231.687l-.008-.002-.008.002c-1.036 0-1.766-.225-2.231-.688-.085-.084-.085-.221 0-.305.084-.084.222-.084.307 0 .379.377 1.008.561 1.924.561l.008.002.008-.002c.915 0 1.544-.184 1.924-.561.085-.084.223-.084.307 0zm-3.44-2.418c0-.507-.414-.919-.922-.919-.509 0-.923.412-.923.919 0 .506.414.918.923.918.508.001.922-.411.922-.918zm13.202-.93c0 6.627-5.373 12-12 12s-12-5.373-12-12 5.373-12 12-12 12 5.373 12 12zm-5-.129c0-.851-.695-1.543-1.55-1.543-.417 0-.795.167-1.074.435-1.056-.695-2.485-1.137-4.066-1.194l.865-2.724 2.343.549-.003.034c0 .696.569 1.262 1.268 1.262.699 0 1.267-.566 1.267-1.262s-.568-1.262-1.267-1.262c-.537 0-.994.335-1.179.804l-2.525-.592c-.11-.027-.223.037-.257.145l-.965 3.038c-1.656.02-3.155.466-4.258 1.181-.277-.255-.644-.415-1.05-.415-.854.001-1.549.693-1.549 1.544 0 .566.311 1.056.768 1.325-.03.164-.05.331-.05.5 0 2.281 2.805 4.137 6.253 4.137s6.253-1.856 6.253-4.137c0-.16-.017-.317-.044-.472.486-.261.82-.766.82-1.353zm-4.872.141c-.509 0-.922.412-.922.919 0 .506.414.918.922.918s.922-.412.922-.918c0-.507-.413-.919-.922-.919z\" /></svg>"),
	Rules: []string{
		"||redd.it^",
		"||reddit.com^",
		"||redditmedia.com^",
		"||redditstatic.com^",
	},
}, {
	ID:      "roblox",
	Name:    "Roblox",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 24 24\"><path d=\"m13.383 14.341-3.726-.958.959-3.726 3.726.959-.96 3.726zM4.913 0 0 19.088 19.088 24 24 4.912 4.912 0z\" /></svg>"),
	Rules: []string{
		"||rbxadder.com^",
		"||rbxcdn.com^",
		"||roblox.com^",
		"||robloxcdn.com^",
	},
}, {
	ID:      "skype",
	Name:    "Skype",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 26 26\"><path d=\"M23.363 14.387c.153-.739.23-1.5.23-2.266C23.594 5.883 18.45.805 12.122.805c-.594 0-1.191.047-1.781.136A6.891 6.891 0 0 0 6.852 0C3.074 0 0 3.035 0 6.762c0 1.144.293 2.27.852 3.265-.133.688-.2 1.391-.2 2.094 0 6.238 5.149 11.316 11.47 11.316.648 0 1.3-.054 1.94-.164.95.477 2.012.727 3.086.727C20.926 24 24 20.969 24 17.238c0-1.004-.215-1.96-.637-2.851zM17.758 17.3c-.508.707-1.258 1.27-2.23 1.668-.966.394-2.122.593-3.434.593-1.578 0-2.903-.273-3.934-.812a5.074 5.074 0 0 1-1.808-1.582c-.47-.664-.707-1.324-.707-1.961 0-.395.156-.738.457-1.023.304-.278.687-.418 1.148-.418.379 0 .703.109.969.332.254.21.469.523.644.93.192.437.407.808.633 1.1.211.282.524.52.918.704.399.188.938.281 1.598.281.91 0 1.652-.191 2.215-.57.546-.367.812-.813.812-1.352 0-.43-.14-.765-.422-1.027-.3-.277-.699-.492-1.176-.637-.5-.152-1.18-.32-2.015-.496-1.14-.238-2.11-.523-2.88-.847-.788-.332-1.425-.79-1.89-1.364-.472-.582-.71-1.312-.71-2.172 0-.816.253-1.554.75-2.191.488-.633 1.206-1.125 2.132-1.46.91-.333 1.996-.5 3.223-.5.98 0 1.844.108 2.566.331.723.223 1.336.524 1.813.89.484.376.843.774 1.07 1.188.227.418.344.832.344 1.235 0 .386-.153.738-.453 1.046-.297.31-.68.465-1.125.465-.41 0-.727-.097-.95-.289-.207-.18-.418-.46-.656-.863-.273-.516-.605-.918-.984-1.203-.371-.277-.989-.418-1.836-.418-.79 0-1.43.156-1.902.465-.461.293-.684.633-.684 1.039 0 .246.07.449.219.629.156.187.379.351.656.488.289.145.586.258.883.34.308.082.82.207 1.523.367.887.191 1.707.398 2.43.625.73.234 1.363.516 1.879.848.527.34.941.773 1.238 1.293.297.52.445 1.16.445 1.91a4.07 4.07 0 0 1-.77 2.418zm0 0\" /></svg>"),
	Rules: []string{
		"||edge-skype-com.s-0001.s-msedge.net^",
		"||skype-edf.akadns.net^",
		"||skype.com^",
		"||skypeassets.com^",
		"||skypedata.akadns.net^",
	},
}, {
	ID:      "snapchat",
	Name:    "Snapchat",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 24 24\"><path d=\"M12.176 4c.715 0 3.136.191 4.277 2.668.383.828.285 2.273.211 3.437l-.004.051c-.008.164-.02.32-.027.469.015.02.164.156.492.168.25-.012.54-.086.855-.23a.784.784 0 0 1 .57.008h.005c.254.09.422.261.425.44.004.173-.128.43-.789.68a2.694 2.694 0 0 1-.25.082c-.375.118-.945.293-1.117.692-.097.215-.066.48.09.785 0 .004.004.008.004.012.047.105 1.187 2.62 3.73 3.027.094.016.16.094.153.188a.24.24 0 0 1-.024.101c-.105.238-.578.574-2.234.824-.133.02-.188.188-.266.547-.03.13-.058.258-.101.39-.035.118-.11.173-.235.173h-.02a2.34 2.34 0 0 1-.37-.043 4.986 4.986 0 0 0-.996-.102c-.23 0-.473.02-.715.059-.496.078-.918.367-1.363.672-.653.445-1.32.902-2.364.902-.047 0-.09 0-.136-.004-.028.004-.055.004-.086.004-1.043 0-1.711-.457-2.36-.902-.445-.305-.867-.594-1.363-.672a4.533 4.533 0 0 0-.719-.059c-.418 0-.75.063-.992.106a2.02 2.02 0 0 1-.371.054c-.102 0-.211-.023-.258-.18-.039-.136-.07-.269-.101-.394-.075-.328-.125-.531-.266-.55-1.656-.247-2.129-.587-2.234-.825-.012-.035-.024-.066-.024-.101a.182.182 0 0 1 .156-.188c2.54-.406 3.68-2.922 3.727-3.031.004 0 .004-.004.004-.008.156-.305.187-.57.094-.79-.176-.398-.747-.57-1.122-.687a3.147 3.147 0 0 1-.25-.082c-.75-.289-.812-.582-.785-.734.051-.254.407-.434.692-.434a.49.49 0 0 1 .207.04c.336.152.64.23.906.23.363 0 .52-.148.54-.168-.009-.164-.02-.34-.032-.52-.074-1.164-.168-2.609.21-3.433 1.138-2.477 3.555-2.668 4.27-2.668L12.133 4h.043m0-1.602h-.043l-.313.008v-.004c-.953 0-4.187.262-5.722 3.598-.387.844-.45 1.887-.422 2.922-.922.02-2 .625-2.215 1.726-.082.407-.184 1.786 1.781 2.54.012.003.02.007.031.011-.39.559-1.113 1.34-2.168 1.508-.902.14-1.55.941-1.5 1.86.016.226.067.44.153.64.41.938 1.406 1.363 2.543 1.613a1.83 1.83 0 0 0 1.785 1.305c.246 0 .465-.043.66-.078a3.44 3.44 0 0 1 .703-.082c.149 0 .305.012.465.039.14.023.457.238.711.41.73.5 1.727 1.184 3.266 1.184h.101c.04 0 .078.004.121.004 1.532 0 2.528-.68 3.258-1.176.281-.192.582-.399.723-.422.156-.024.312-.04.46-.04.259 0 .458.032.696.075.266.05.477.074.668.074.852 0 1.543-.508 1.785-1.293 1.137-.25 2.129-.672 2.535-1.593.094-.22.149-.43.16-.649a1.783 1.783 0 0 0-1.496-1.871c-1.054-.168-1.78-.95-2.172-1.508l.036-.011c1.601-.618 1.824-1.645 1.816-2.204-.02-.855-.594-1.601-1.477-1.918a2.37 2.37 0 0 0-.777-.156c.027-1.015-.039-2.078-.422-2.914-1.539-3.336-4.773-3.598-5.73-3.598zm0 0\" /></svg>"),
	Rules: []string{
		"||impala-media-production.s3.amazonaws.com^",
		"||sc-cdn.net^",
		"||snap-dev.net^",
		"||snapads.com^",
		"||snapchat.com^",
		"||snapkit.co",
	},
}, {
	ID:      "spotify",
	Name:    "Spotify",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M25.009,1.982C12.322,1.982,2,12.304,2,24.991S12.322,48,25.009,48s23.009-10.321,23.009-23.009S37.696,1.982,25.009,1.982z M34.748,35.333c-0.289,0.434-0.765,0.668-1.25,0.668c-0.286,0-0.575-0.081-0.831-0.252C30.194,34.1,26,33,22.5,33.001 c-3.714,0.002-6.498,0.914-6.526,0.923c-0.784,0.266-1.635-0.162-1.897-0.948s0.163-1.636,0.949-1.897 c0.132-0.044,3.279-1.075,7.474-1.077C26,30,30.868,30.944,34.332,33.253C35.022,33.713,35.208,34.644,34.748,35.333z M37.74,29.193 c-0.325,0.522-0.886,0.809-1.459,0.809c-0.31,0-0.624-0.083-0.906-0.26c-4.484-2.794-9.092-3.385-13.062-3.35 c-4.482,0.04-8.066,0.895-8.127,0.913c-0.907,0.258-1.861-0.272-2.12-1.183c-0.259-0.913,0.272-1.862,1.184-2.12 c0.277-0.079,3.854-0.959,8.751-1c4.465-0.037,10.029,0.61,15.191,3.826C37.995,27.328,38.242,28.388,37.74,29.193z M40.725,22.013 C40.352,22.647,39.684,23,38.998,23c-0.344,0-0.692-0.089-1.011-0.275c-5.226-3.068-11.58-3.719-15.99-3.725 c-0.021,0-0.042,0-0.063,0c-5.333,0-9.44,0.938-9.481,0.948c-1.078,0.247-2.151-0.419-2.401-1.495 c-0.25-1.075,0.417-2.149,1.492-2.4C11.729,16.01,16.117,15,21.934,15c0.023,0,0.046,0,0.069,0 c4.905,0.007,12.011,0.753,18.01,4.275C40.965,19.835,41.284,21.061,40.725,22.013z\" /></svg>"),
	Rules: []string{
		"/_spotify-connect._tcp.local/",
		"||audio-ak-spotify-com.akamaized.net^",
		"||audio4-ak-spotify-com.akamaized.net^",
		"||heads-ak-spotify-com.akamaized.net^",
		"||heads4-ak-spotify-com.akamaized.net^",
		"||scdn.co^",
		"||spotify.com.edgesuite.net^",
		"||spotify.com^",
		"||spotify.map.fastly.net^",
		"||spotify.map.fastlylb.net^",
		"||spotifycdn.net^",
	},
}, {
	ID:      "steam",
	Name:    "Steam",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 22 22\"><path d=\"M14.398 7.2a2.4 2.4 0 1 0 .003 4.799 2.4 2.4 0 0 0-.003-4.8zm0 0\" fill=\"none\" strokeWidth=\"1.6\" stroke=\"currentColor\" strokeMiterlimit=\"10\" /><path d=\"M8 14c-.629 0-1.18.297-1.547.75l1.758.48c.426.114.68.555.562.98a.804.804 0 0 1-.984.563l-1.762-.48A1.998 1.998 0 0 0 10 16c0-1.105-.895-2-2-2zm0 0\" /><path d=\"M19.2 3.2H4.8c-.886 0-1.6.714-1.6 1.6v9.063l2.027.551a3.213 3.213 0 0 1 2.289-1.566l2.136-2.567a4.799 4.799 0 1 1 4.066 4.066l-2.566 2.137A3.195 3.195 0 0 1 8 19.2 3.2 3.2 0 0 1 4.8 16c0-.016.005-.027.005-.043l-1.606-.437v3.68c0 .886.715 1.6 1.602 1.6h14.398c.887 0 1.602-.714 1.602-1.6V4.8c0-.886-.715-1.6-1.602-1.6zm0 0\" /></svg>"),
	Rules: []string{
		"||steam.com^",
		"||steamcdn-a.akamaihd.net^",
		"||steamcommunity.com^",
		"||steampowered.com^",
		"||steamstatic.com^",
		"||steamstore-a.akamaihd.net^",
	},
}, {
	ID:      "telegram",
	Name:    "Telegram",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M46.137,6.552c-0.75-0.636-1.928-0.727-3.146-0.238l-0.002,0C41.708,6.828,6.728,21.832,5.304,22.445 c-0.259,0.09-2.521,0.934-2.288,2.814c0.208,1.695,2.026,2.397,2.248,2.478l8.893,3.045c0.59,1.964,2.765,9.21,3.246,10.758 c0.3,0.965,0.789,2.233,1.646,2.494c0.752,0.29,1.5,0.025,1.984-0.355l5.437-5.043l8.777,6.845l0.209,0.125 c0.596,0.264,1.167,0.396,1.712,0.396c0.421,0,0.825-0.079,1.211-0.237c1.315-0.54,1.841-1.793,1.896-1.935l6.556-34.077 C47.231,7.933,46.675,7.007,46.137,6.552z M22,32l-3,8l-3-10l23-17L22,32z\" /></svg>"),
	Rules: []string{
		"||t.me^",
		"||telegram.me^",
		"||telegram.org^",
	},
}, {
	ID:      "tiktok",
	Name:    "TikTok",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M41 4H9C6.243 4 4 6.243 4 9v32c0 2.757 2.243 5 5 5h32c2.757 0 5-2.243 5-5V9c0-2.757-2.243-5-5-5zm-3.994 18.323a7.482 7.482 0 0 1-.69.035 7.492 7.492 0 0 1-6.269-3.388v11.537a8.527 8.527 0 1 1-8.527-8.527c.178 0 .352.016.527.027v4.202c-.175-.021-.347-.053-.527-.053a4.351 4.351 0 1 0 0 8.704c2.404 0 4.527-1.894 4.527-4.298l.042-19.594h4.016a7.488 7.488 0 0 0 6.901 6.685v4.67z\" /></svg>"),
	Rules: []string{
		"||amemv.com^",
		"||bdurl.com^",
		"||bytecdn.cn^",
		"||bytedance.map.fastly.net^",
		"||bytedapm.com^",
		"||byteimg.com^",
		"||byteoversea.com^",
		"||douyin.com^",
		"||douyincdn.com^",
		"||douyinpic.com^",
		"||douyinstatic.com^",
		"||douyinvod.com^",
		"||ixigua.com^",
		"||ixiguavideo.com^",
		"||muscdn.com^",
		"||musical.ly^",
		"||pstatp.com^",
		"||snssdk.com^",
		"||tiktok.com^",
		"||tiktokcdn.com^",
		"||tiktokv.com^",
		"||toutiao.com^",
		"||toutiaocloud.com^",
		"||toutiaocloud.net^",
		"||toutiaovod.com^",
	},
}, {
	ID:      "tinder",
	Name:    "Tinder",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M25,48C13.225,48,5,39.888,5,28.271c0-6.065,3.922-12.709,9.325-15.797c0.151-0.086,0.322-0.132,0.496-0.132 c0.803,0,1.407,0.547,1.407,1.271c0,1.18,0.456,3.923,1.541,5.738c4.455-1.65,9.074-5.839,7.464-16.308 c-0.008-0.051-0.012-0.102-0.012-0.152c0-0.484,0.217-0.907,0.579-1.132c0.34-0.208,0.764-0.221,1.14-0.034 C31.173,3.808,45,11.892,45,28.407C45,39.394,36.215,48,25,48z M26.052,3.519c0.003,0.001,0.005,0.002,0.008,0.004 C26.057,3.521,26.055,3.52,26.052,3.519z\" /></svg>"),
	Rules: []string{
		"||gotinder.com^",
		"||tinder.com^",
		"||tindersparks.com^",
	},
}, {
	ID:      "twitch",
	Name:    "Twitch",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 24 24\"><path d=\"M4.8 3.2L3.2 6.397V19.2h4v2.403h3.198l2.403-2.403H16l4.8-4.8v-11.2zm14.4 10.402L16.8 16H12l-2.398 2.398V16H6.398V4.8H19.2zm0 0\" /><path d=\"M15.2 12.8h-1.598V7.2h1.597zm-3.2 0h-1.602V7.2H12zm0 0\" /></svg>"),
	Rules: []string{
		"||jtvnw.net^",
		"||ttvnw.net^",
		"||twitch.tv^",
		"||twitchcdn.net^",
	},
}, {
	ID:      "twitter",
	Name:    "Twitter",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 24 24\"><path d=\"M22.398 5.55a8.583 8.583 0 0 1-2.449.673 4.252 4.252 0 0 0 1.875-2.364 8.66 8.66 0 0 1-2.71 1.04A4.251 4.251 0 0 0 16 3.546a4.27 4.27 0 0 0-4.266 4.27c0 .335.036.66.11.972a12.126 12.126 0 0 1-8.797-4.46 4.259 4.259 0 0 0-.578 2.148c0 1.48.754 2.785 1.898 3.55a4.273 4.273 0 0 1-1.933-.535v.055a4.27 4.27 0 0 0 3.425 4.183c-.359.098-.734.149-1.125.149-.273 0-.543-.027-.804-.074a4.276 4.276 0 0 0 3.988 2.965 8.562 8.562 0 0 1-5.3 1.824 8.82 8.82 0 0 1-1.02-.059 12.088 12.088 0 0 0 6.543 1.918c7.851 0 12.14-6.504 12.14-12.144 0-.184-.004-.368-.011-.551a8.599 8.599 0 0 0 2.128-2.207zm0 0\" /></svg>"),
	Rules: []string{
		"||t.co^",
		"||twimg.com^",
		"||twitter.com^",
		"||twttr.com^",
	},
}, {
	ID:      "viber",
	Name:    "Viber",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M 44.78125 13.15625 C 44 10.367188 42.453125 8.164063 40.1875 6.605469 C 37.328125 4.632813 34.039063 3.9375 31.199219 3.511719 C 27.269531 2.925781 23.710938 2.84375 20.316406 3.257813 C 17.136719 3.648438 14.742188 4.269531 12.558594 5.273438 C 8.277344 7.242188 5.707031 10.425781 4.921875 14.734375 C 4.539063 16.828125 4.28125 18.71875 4.132813 20.523438 C 3.789063 24.695313 4.101563 28.386719 5.085938 31.808594 C 6.046875 35.144531 7.722656 37.527344 10.210938 39.09375 C 10.84375 39.492188 11.65625 39.78125 12.441406 40.058594 C 12.886719 40.214844 13.320313 40.367188 13.675781 40.535156 C 14.003906 40.6875 14.003906 40.714844 14 40.988281 C 13.972656 43.359375 14 48.007813 14 48.007813 L 14.007813 49 L 15.789063 49 L 16.078125 48.71875 C 16.269531 48.539063 20.683594 44.273438 22.257813 42.554688 L 22.472656 42.316406 C 22.742188 42.003906 22.742188 42.003906 23.019531 42 C 25.144531 41.957031 27.316406 41.875 29.472656 41.757813 C 32.085938 41.617188 35.113281 41.363281 37.964844 40.175781 C 40.574219 39.085938 42.480469 37.355469 43.625 35.035156 C 44.820313 32.613281 45.527344 29.992188 45.792969 27.019531 C 46.261719 21.792969 45.929688 17.257813 44.78125 13.15625 Z M 35.382813 33.480469 C 34.726563 34.546875 33.75 35.289063 32.597656 35.769531 C 31.753906 36.121094 30.894531 36.046875 30.0625 35.695313 C 23.097656 32.746094 17.632813 28.101563 14.023438 21.421875 C 13.277344 20.046875 12.761719 18.546875 12.167969 17.09375 C 12.046875 16.796875 12.054688 16.445313 12 16.117188 C 12.050781 13.769531 13.851563 12.445313 15.671875 12.046875 C 16.367188 11.890625 16.984375 12.136719 17.5 12.632813 C 18.929688 13.992188 20.058594 15.574219 20.910156 17.347656 C 21.28125 18.125 21.113281 18.8125 20.480469 19.390625 C 20.347656 19.511719 20.210938 19.621094 20.066406 19.730469 C 18.621094 20.816406 18.410156 21.640625 19.179688 23.277344 C 20.492188 26.0625 22.671875 27.933594 25.488281 29.09375 C 26.230469 29.398438 26.929688 29.246094 27.496094 28.644531 C 27.574219 28.566406 27.660156 28.488281 27.714844 28.394531 C 28.824219 26.542969 30.4375 26.726563 31.925781 27.78125 C 32.902344 28.476563 33.851563 29.210938 34.816406 29.917969 C 36.289063 31 36.277344 32.015625 35.382813 33.480469 Z M 26.144531 15 C 25.816406 15 25.488281 15.027344 25.164063 15.082031 C 24.617188 15.171875 24.105469 14.804688 24.011719 14.257813 C 23.921875 13.714844 24.289063 13.199219 24.835938 13.109375 C 25.265625 13.035156 25.707031 13 26.144531 13 C 30.476563 13 34 16.523438 34 20.855469 C 34 21.296875 33.964844 21.738281 33.890625 22.164063 C 33.808594 22.652344 33.386719 23 32.90625 23 C 32.851563 23 32.796875 22.996094 32.738281 22.984375 C 32.195313 22.894531 31.828125 22.378906 31.917969 21.835938 C 31.972656 21.515625 32 21.1875 32 20.855469 C 32 17.628906 29.371094 15 26.144531 15 Z M 31 21 C 31 21.550781 30.550781 22 30 22 C 29.449219 22 29 21.550781 29 21 C 29 19.347656 27.652344 18 26 18 C 25.449219 18 25 17.550781 25 17 C 25 16.449219 25.449219 16 26 16 C 28.757813 16 31 18.242188 31 21 Z M 36.710938 23.222656 C 36.605469 23.6875 36.191406 24 35.734375 24 C 35.660156 24 35.585938 23.992188 35.511719 23.976563 C 34.972656 23.851563 34.636719 23.316406 34.757813 22.777344 C 34.902344 22.140625 34.976563 21.480469 34.976563 20.816406 C 34.976563 15.957031 31.019531 12 26.160156 12 C 25.496094 12 24.835938 12.074219 24.199219 12.21875 C 23.660156 12.34375 23.125 12.003906 23.003906 11.464844 C 22.878906 10.925781 23.21875 10.390625 23.757813 10.269531 C 24.539063 10.089844 25.347656 10 26.160156 10 C 32.125 10 36.976563 14.851563 36.976563 20.816406 C 36.976563 21.628906 36.886719 22.4375 36.710938 23.222656 Z\" /></svg>"),
	Rules: []string{
		"||viber.com^",
	},
}, {
	ID:      "vimeo",
	Name:    "Vimeo",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M 41 5 C 34.210938 4.992188 30.46875 8.796875 28.167969 16.210938 C 29.371094 15.765625 30.578125 15.214844 31.671875 15.214844 C 33.972656 15.214844 34.738281 16.070313 34.410156 18.726563 C 34.300781 20.386719 33.644531 23.066406 31.671875 26.164063 C 29.699219 29.152344 27.984375 30 27 30 C 25.796875 30 24.882813 28.269531 23.898438 23.621094 C 23.570313 22.292969 22.804688 19.304688 21.925781 13.664063 C 21.160156 8.464844 18.613281 5.667969 15 6 C 13.46875 6.109375 11.636719 7.535156 8.570313 10.191406 C 6.378906 12.183594 4.300781 13.621094 2 15.613281 L 4.191406 18.421875 C 6.269531 16.984375 7.476563 16.429688 7.804688 16.429688 C 9.335938 16.429688 10.757813 18.863281 12.183594 23.84375 C 13.386719 28.378906 14.699219 32.914063 15.90625 37.449219 C 17.765625 42.429688 20.066406 44.863281 22.695313 44.863281 C 27.074219 44.863281 32.328125 40.882813 38.570313 32.695313 C 44.699219 24.949219 47.78125 18.535156 48 14 C 48.21875 8.027344 45.816406 5.109375 41 5 Z\" /></svg>"),
	Rules: []string{
		"*vod-adaptive.akamaized.net^",
		"||vimeo.com^",
		"||vimeocdn.com^",
	},
}, {
	ID:      "vk",
	Name:    "VK.com",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 24 24\"><path d=\"M12 .96C5.914.96.96 5.915.96 12c0 6.086 4.954 11.04 11.04 11.04 6.086 0 11.04-4.954 11.04-11.04C23.04 5.914 18.085.96 12 .96zm4.785 13.216c1.074.953 1.3 1.293 1.336 1.351.445.707-.492.793-.492.793h-1.98s-.481.004-.891-.27c-.672-.437-1.375-1.288-1.867-1.14-.414.125-.41.684-.41 1.16 0 .172-.149.25-.481.25h-.617c-1.086 0-2.262-.363-3.434-1.59-1.656-1.734-3.113-5.222-3.113-5.222s-.086-.176.008-.281c.105-.122.394-.106.394-.106h1.918s.18.031.309.125c.11.074.168.219.168.219s.32 1.062.734 1.742c.801 1.32 1.172 1.355 1.445 1.215.399-.207.266-1.617.266-1.617s.02-.602-.187-.871c-.16-.211-.465-.32-.598-.336-.11-.016.07-.203.3-.313.31-.137.727-.172 1.446-.164.563.004.723.04.941.09.665.152.5.555.5 1.969 0 .453-.062 1.09.278 1.3.148.09.652.204 1.55-1.257.43-.692.77-1.84.77-1.84s.067-.125.176-.188c.113-.066.11-.062.262-.062.152 0 1.683-.012 2.02-.012.335 0 .651-.004.702.191.078.282-.246 1.25-1.07 2.305-1.355 1.723-1.504 1.563-.383 2.559zm0 0\" /></svg>"),
	Rules: []string{
		"||userapi.com^",
		"||vk-cdn.net^",
		"||vk.com^",
		"||vkuservideo.net^",
	},
}, {
	ID:      "wechat",
	Name:    "WeChat",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M 19 6 C 9.625 6 2 12.503906 2 20.5 C 2 24.769531 4.058594 28.609375 7.816406 31.390625 L 5.179688 39.304688 L 13.425781 34.199219 C 15.714844 34.917969 18.507813 35.171875 21.203125 34.875 C 23.390625 39.109375 28.332031 42 34 42 C 35.722656 42 37.316406 41.675781 38.796875 41.234375 L 45.644531 45.066406 L 43.734375 38.515625 C 46.3125 36.375 48 33.394531 48 30 C 48 23.789063 42.597656 18.835938 35.75 18.105469 C 34.40625 11.152344 27.367188 6 19 6 Z M 13 14 C 14.101563 14 15 14.898438 15 16 C 15 17.101563 14.101563 18 13 18 C 11.898438 18 11 17.101563 11 16 C 11 14.898438 11.898438 14 13 14 Z M 25 14 C 26.101563 14 27 14.898438 27 16 C 27 17.101563 26.101563 18 25 18 C 23.898438 18 23 17.101563 23 16 C 23 14.898438 23.898438 14 25 14 Z M 34 20 C 40.746094 20 46 24.535156 46 30 C 46 32.957031 44.492188 35.550781 42.003906 37.394531 L 41.445313 37.8125 L 42.355469 40.933594 L 39.105469 39.109375 L 38.683594 39.25 C 37.285156 39.71875 35.6875 40 34 40 C 27.253906 40 22 35.464844 22 30 C 22 24.535156 27.253906 20 34 20 Z M 29.5 26 C 28.699219 26 28 26.699219 28 27.5 C 28 28.300781 28.699219 29 29.5 29 C 30.300781 29 31 28.300781 31 27.5 C 31 26.699219 30.300781 26 29.5 26 Z M 38.5 26 C 37.699219 26 37 26.699219 37 27.5 C 37 28.300781 37.699219 29 38.5 29 C 39.300781 29 40 28.300781 40 27.5 C 40 26.699219 39.300781 26 38.5 26 Z\" /></svg>"),
	Rules: []string{
		"||wechat.com^",
		"||weixin.qq.com.cn^",
		"||weixin.qq.com^",
		"||weixinbridge.com^",
		"||wx.qq.com^",
	},
}, {
	ID:      "weibo",
	Name:    "Weibo",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 50 50\"><path d=\"M 35 6 C 34.222656 6 33.472656 6.078125 32.75 6.207031 C 32.207031 6.300781 31.84375 6.820313 31.9375 7.363281 C 32.03125 7.910156 32.550781 8.273438 33.09375 8.179688 C 33.726563 8.066406 34.359375 8 35 8 C 41.085938 8 46 12.914063 46 19 C 46 20.316406 45.757813 21.574219 45.328125 22.753906 C 45.195313 23.09375 45.253906 23.476563 45.484375 23.757813 C 45.71875 24.039063 46.082031 24.171875 46.441406 24.105469 C 46.800781 24.039063 47.09375 23.78125 47.207031 23.4375 C 47.710938 22.054688 48 20.566406 48 19 C 48 11.832031 42.167969 6 35 6 Z M 35 12 C 34.574219 12 34.171875 12.042969 33.789063 12.109375 C 33.246094 12.207031 32.878906 12.722656 32.976563 13.269531 C 33.070313 13.8125 33.589844 14.175781 34.132813 14.082031 C 34.425781 14.03125 34.714844 14 35 14 C 37.773438 14 40 16.226563 40 19 C 40 19.597656 39.890625 20.167969 39.691406 20.707031 C 39.503906 21.226563 39.773438 21.800781 40.292969 21.988281 C 40.8125 22.175781 41.386719 21.910156 41.574219 21.390625 C 41.84375 20.648438 42 19.84375 42 19 C 42 15.144531 38.855469 12 35 12 Z M 21.175781 12.40625 C 17.964844 12.34375 13.121094 14.878906 8.804688 19.113281 C 4.511719 23.40625 2 27.90625 2 31.78125 C 2 39.3125 11.628906 43.8125 21.152344 43.8125 C 33.5 43.8125 41.765625 36.699219 41.765625 31.046875 C 41.765625 27.59375 38.835938 25.707031 36.21875 24.871094 C 35.59375 24.660156 35.175781 24.558594 35.488281 23.71875 C 35.695313 23.21875 36 22.265625 36 21 C 36 19.5625 35 18.316406 33 18.09375 C 32.007813 17.984375 28 18 25.339844 19.113281 C 25.339844 19.113281 23.871094 19.746094 24.289063 18.59375 C 25.023438 16.292969 24.917969 14.40625 23.765625 13.359375 C 23.140625 12.730469 22.25 12.425781 21.175781 12.40625 Z M 20.3125 23.933594 C 28.117188 23.933594 34.441406 27.914063 34.441406 32.828125 C 34.441406 37.738281 28.117188 41.71875 20.3125 41.71875 C 12.511719 41.71875 6.1875 37.738281 6.1875 32.828125 C 6.1875 27.914063 12.511719 23.933594 20.3125 23.933594 Z M 19.265625 26.023438 C 16.246094 26.046875 13.3125 27.699219 12.039063 30.246094 C 10.46875 33.484375 11.933594 37.042969 15.699219 38.191406 C 19.464844 39.445313 23.960938 37.5625 25.53125 34.113281 C 27.097656 30.769531 25.113281 27.214844 21.347656 26.277344 C 20.660156 26.097656 19.960938 26.019531 19.265625 26.023438 Z M 20.824219 30.25 C 21.402344 30.25 21.871094 30.714844 21.871094 31.292969 C 21.871094 31.871094 21.402344 32.339844 20.824219 32.339844 C 20.246094 32.339844 19.777344 31.871094 19.777344 31.292969 C 19.777344 30.714844 20.246094 30.25 20.824219 30.25 Z M 16.417969 31.292969 C 16.746094 31.296875 17.074219 31.347656 17.382813 31.453125 C 18.722656 31.878906 19.132813 33.148438 18.308594 34.207031 C 17.589844 35.265625 15.945313 35.792969 14.707031 35.265625 C 13.476563 34.738281 13.167969 33.464844 13.886719 32.515625 C 14.425781 31.71875 15.429688 31.28125 16.417969 31.292969 Z\" /></svg>"),
	Rules: []string{
		"||weibo.cn^",
		"||weibo.com^",
		"||weibocdn.com^",
	},
}, {
	ID:      "whatsapp",
	Name:    "WhatsApp",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 24 24\"><path d=\"M3.836 16.668l-1.352 4.934 5.047-1.329zm0 0\" /><path d=\"M12 2.398C6.7 2.398 2.398 6.7 2.398 12c0 5.3 4.301 9.602 9.602 9.602 5.3 0 9.602-4.301 9.602-9.602 0-5.3-4.301-9.602-9.602-9.602zm4.738 12.915c-.195.554-1.168 1.093-1.601 1.128-.442.043-.852.2-2.856-.59-2.418-.953-3.945-3.433-4.062-3.593-.121-.156-.969-1.285-.969-2.453 0-1.172.613-1.746.828-1.985a.875.875 0 0 1 .637-.297c.156 0 .316 0 .453.004.172.004.36.016.535.41.215.47.676 1.645.735 1.766.058.117.101.262.019.418-.078.156-.121.254-.234.399-.121.136-.25.308-.36.41-.117.12-.242.25-.101.488.136.238.613 1.016 1.32 1.645.906.812 1.672 1.062 1.91 1.18.238.12.38.1.516-.06.14-.156.594-.69.754-.93.156-.237.316-.198.531-.12.219.078 1.39.656 1.629.773.238.121.394.18.453.278.063.097.063.574-.137 1.129zm0 0\" /></svg>"),
	Rules: []string{
		"||whatsapp.com^",
		"||whatsapp.net^",
	},
}, {
	ID:      "youtube",
	Name:    "YouTube",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 24 24\"><path d=\"M19.695 4.04S15.348 3.2 12 3.2s-7.695.84-7.695.84L1.602 7.2v9.6l2.703 3.16s4.347.84 7.695.84 7.695-.84 7.695-.84l2.703-3.16V12 7.2zM9.602 15.68V8.32L16 12zm0 0\" /><path d=\"M19.2 4a3.198 3.198 0 1 0 0 6.398c1.769 0 3.198-1.43 3.198-3.199C22.398 5.434 20.968 4 19.2 4zm0 9.602a3.198 3.198 0 1 0 0 6.398c1.769 0 3.198-1.434 3.198-3.2 0-1.769-1.43-3.198-3.199-3.198zM1.601 7.199c0 1.77 1.43 3.2 3.199 3.2 1.765 0 2.398-1.43 2.398-3.2C7.2 5.434 6.566 4 4.801 4 3.03 4 1.6 5.434 1.6 7.2zM4.8 13.602c-1.77 0-3.2 1.43-3.2 3.199A3.198 3.198 0 1 0 8 16.8c0-1.77-1.434-3.2-3.2-3.2zm0 0\" /></svg>"),
	Rules: []string{
		"||googlevideo.com^",
		"||wide-youtube.l.google.com^",
		"||youtu.be^",
		"||youtube",
		"||youtube-nocookie.com^",
		"||youtube.com^",
		"||youtubei.googleapis.com^",
		"||youtubekids.com^",
		"||ytimg.com^",
	},
}, {
	ID:      "zhihu",
	Name:    "Zhihu",
	IconSVG: []byte("<svg xmlns=\"http://www.w3.org/2000/svg\" fill=\"currentColor\" viewBox=\"0 0 30 30\"><path d=\"M14.46 14.191H9.982c0-.471.033-.954.039-1.458v-5.5h5.106V5.935a1.352 1.352 0 00-.404-.957 1.378 1.378 0 00-.968-.396H5.783c.028-.088.056-.177.084-.255.274-.82 1.153-3.326 1.153-3.326a4.262 4.262 0 00-2.413.698c-.57.4-.912.682-1.371 1.946-.532 1.453-.997 2.856-1.31 3.693C1.444 8.674.28 11.025.28 11.025a5.85 5.85 0 002.52-.61c1.119-.593 1.679-1.502 2.054-2.883l.09-.3h2.334v5.5c0 .5-.045.982-.073 1.46h-4.12c-.71 0-1.39.278-1.893.775a2.638 2.638 0 00-.783 1.874h6.527a17.717 17.717 0 01-.778 3.649 16.796 16.796 0 01-3.012 5.273A33.104 33.104 0 010 28.74s3.13 1.175 5.425-.954c1.388-1.292 2.631-3.814 3.23-5.727a28.09 28.09 0 001.12-5.229h5.967v-1.37a1.254 1.254 0 00-.373-.899 1.279 1.279 0 00-.909-.37zm-3.19 5.484l-2.312 1.491 5.038 7.458a6.905 6.905 0 00.672-2.218 3.15 3.15 0 00-.28-2.168l-3.118-4.563zM29.05 4.582H16.733V25.94h3.018l.403 2.572 4.081-2.572h4.815V4.582zm-5.207 18.69l-2.396 1.509-.235-1.508h-1.724V7.233h6.78v16.04h-2.425z\" /></svg>"),
	Rules: []string{
		"||zhihu.com^",
		"||zhimg.com^",
	},
}}
