/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android.multimedia;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.ImageFormat;
import android.graphics.Matrix;
import android.hardware.Camera;
import android.media.ExifInterface;
import android.util.Log;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.qtproject.qt.android.multimedia.QtMultimediaUtils;

public class QtCameraListener
implements Camera.ShutterCallback,
Camera.PictureCallback,
Camera.AutoFocusCallback,
Camera.PreviewCallback {
    private static final String TAG = "Qt Camera";
    private static final int BUFFER_POOL_SIZE = 2;
    private int m_cameraId = -1;
    private boolean m_notifyNewFrames = false;
    private boolean m_notifyWhenFrameAvailable = false;
    private byte[][] m_previewBuffers = null;
    private byte[] m_lastPreviewBuffer = null;
    private Camera.Size m_previewSize = null;
    private int m_previewFormat = 17;
    private int m_previewBytesPerLine = -1;

    private QtCameraListener(int n) {
        this.m_cameraId = n;
    }

    public void notifyNewFrames(boolean bl) {
        this.m_notifyNewFrames = bl;
    }

    public void notifyWhenFrameAvailable(boolean bl) {
        this.m_notifyWhenFrameAvailable = bl;
    }

    public byte[] lastPreviewBuffer() {
        return this.m_lastPreviewBuffer;
    }

    public int previewWidth() {
        if (this.m_previewSize == null) {
            return -1;
        }
        return this.m_previewSize.width;
    }

    public int previewHeight() {
        if (this.m_previewSize == null) {
            return -1;
        }
        return this.m_previewSize.height;
    }

    public int previewFormat() {
        return this.m_previewFormat;
    }

    public int previewBytesPerLine() {
        return this.m_previewBytesPerLine;
    }

    public void clearPreviewCallback(Camera camera) {
        camera.setPreviewCallbackWithBuffer(null);
    }

    public void setupPreviewCallback(Camera camera) {
        this.clearPreviewCallback(camera);
        this.m_lastPreviewBuffer = null;
        Camera.Parameters parameters = camera.getParameters();
        this.m_previewSize = parameters.getPreviewSize();
        this.m_previewFormat = parameters.getPreviewFormat();
        int n = 0;
        if (this.m_previewFormat == 842094169) {
            int n2 = (int)Math.ceil((double)this.m_previewSize.width / 16.0) * 16;
            int n3 = (int)Math.ceil((double)(n2 / 2) / 16.0) * 16;
            int n4 = n2 * this.m_previewSize.height;
            int n5 = n3 * this.m_previewSize.height / 2;
            n = n4 + n5 * 2;
            this.m_previewBytesPerLine = n2;
        } else {
            double d = (double)ImageFormat.getBitsPerPixel((int)this.m_previewFormat) / 8.0;
            n = (int)Math.ceil(d * (double)this.m_previewSize.width * (double)this.m_previewSize.height);
            switch (this.m_previewFormat) {
                case 17: {
                    this.m_previewBytesPerLine = this.m_previewSize.width;
                    break;
                }
                case 4: 
                case 20: {
                    this.m_previewBytesPerLine = this.m_previewSize.width * 2;
                    break;
                }
                default: {
                    this.m_previewBytesPerLine = -1;
                }
            }
        }
        if (this.m_previewBuffers == null || this.m_previewBuffers[0].length != n) {
            this.m_previewBuffers = new byte[2][n];
        }
        camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
        for (byte[] byArray : this.m_previewBuffers) {
            camera.addCallbackBuffer(byArray);
        }
    }

    public void onPreviewFrame(byte[] byArray, Camera camera) {
        if (this.m_lastPreviewBuffer != null) {
            camera.addCallbackBuffer(this.m_lastPreviewBuffer);
        }
        this.m_lastPreviewBuffer = byArray;
        if (byArray != null) {
            if (this.m_notifyWhenFrameAvailable) {
                this.m_notifyWhenFrameAvailable = false;
                QtCameraListener.notifyFrameAvailable(this.m_cameraId);
            }
            if (this.m_notifyNewFrames) {
                QtCameraListener.notifyNewPreviewFrame(this.m_cameraId, byArray, this.m_previewSize.width, this.m_previewSize.height, this.m_previewFormat, this.m_previewBytesPerLine);
            }
        }
    }

    public void onShutter() {
        QtCameraListener.notifyPictureExposed(this.m_cameraId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPictureTaken(byte[] byArray, Camera camera) {
        File file = null;
        try {
            file = File.createTempFile("pic_", ".jpg", QtMultimediaUtils.getCacheDirectory());
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length).compress(Bitmap.CompressFormat.JPEG, 10, (OutputStream)fileOutputStream);
            ExifInterface exifInterface = new ExifInterface(file.getAbsolutePath());
            int n = exifInterface.getAttributeInt("Orientation", 0);
            int n2 = 0;
            switch (n) {
                case 6: {
                    n2 = 90;
                    break;
                }
                case 3: {
                    n2 = 180;
                    break;
                }
                case 8: {
                    n2 = 270;
                }
            }
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            Camera.getCameraInfo((int)this.m_cameraId, (Camera.CameraInfo)cameraInfo);
            int n3 = (cameraInfo.orientation - n2 + 360) % 360;
            Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])byArray, (int)0, (int)byArray.length);
            Matrix matrix = new Matrix();
            matrix.postRotate((float)n3);
            if (cameraInfo.facing == 1) {
                matrix.postScale(-1.0f, 1.0f, (float)bitmap.getWidth() / 2.0f, (float)bitmap.getHeight() / 2.0f);
            }
            Bitmap bitmap2 = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            bitmap2.compress(Bitmap.CompressFormat.JPEG, 100, (OutputStream)byteArrayOutputStream);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            bitmap2.recycle();
            bitmap.recycle();
            QtCameraListener.notifyPictureCaptured(this.m_cameraId, byArray2);
            return;
        }
        catch (Exception exception) {
            Log.w((String)TAG, (String)"Error fixing bitmap orientation.");
            exception.printStackTrace();
        }
        finally {
            if (file != null && file.exists()) {
                file.delete();
            }
        }
        QtCameraListener.notifyPictureCaptured(this.m_cameraId, byArray);
    }

    public void onAutoFocus(boolean bl, Camera camera) {
        QtCameraListener.notifyAutoFocusComplete(this.m_cameraId, bl);
    }

    private static native void notifyAutoFocusComplete(int var0, boolean var1);

    private static native void notifyPictureExposed(int var0);

    private static native void notifyPictureCaptured(int var0, byte[] var1);

    private static native void notifyNewPreviewFrame(int var0, byte[] var1, int var2, int var3, int var4, int var5);

    private static native void notifyFrameAvailable(int var0);
}

