/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android.multimedia;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.CaptureFailure;
import android.hardware.camera2.CaptureRequest;
import android.media.Image;
import android.media.ImageReader;
import android.os.Handler;
import android.os.HandlerThread;
import android.util.Log;
import android.view.Surface;
import java.util.ArrayList;
import java.util.List;

@TargetApi(value=23)
public class QtCamera2 {
    CameraDevice mCameraDevice = null;
    HandlerThread mBackgroundThread;
    Handler mBackgroundHandler;
    ImageReader mImageReader = null;
    CameraManager mCameraManager;
    CameraCaptureSession mCaptureSession;
    CaptureRequest.Builder mPreviewRequestBuilder;
    CaptureRequest mPreviewRequest;
    String mCameraId;
    List<Surface> mTargetSurfaces = new ArrayList<Surface>();
    private static int MaxNumberFrames = 10;
    CameraDevice.StateCallback mStateCallback = new CameraDevice.StateCallback(){

        public void onOpened(CameraDevice cameraDevice) {
            if (QtCamera2.this.mCameraDevice != null) {
                QtCamera2.this.mCameraDevice.close();
            }
            QtCamera2.this.mCameraDevice = cameraDevice;
            QtCamera2.this.onCameraOpened(QtCamera2.this.mCameraId);
        }

        public void onDisconnected(CameraDevice cameraDevice) {
            cameraDevice.close();
            if (QtCamera2.this.mCameraDevice == cameraDevice) {
                QtCamera2.this.mCameraDevice = null;
            }
            QtCamera2.this.onCameraDisconnect(QtCamera2.this.mCameraId);
        }

        public void onError(CameraDevice cameraDevice, int n) {
            cameraDevice.close();
            if (QtCamera2.this.mCameraDevice == cameraDevice) {
                QtCamera2.this.mCameraDevice = null;
            }
            QtCamera2.this.onCameraError(QtCamera2.this.mCameraId, n);
        }
    };
    CameraCaptureSession.StateCallback mCaptureStateCallback = new CameraCaptureSession.StateCallback(){

        public void onConfigured(CameraCaptureSession cameraCaptureSession) {
            QtCamera2.this.mCaptureSession = cameraCaptureSession;
            QtCamera2.this.onCaptureSessionConfigured(QtCamera2.this.mCameraId);
        }

        public void onConfigureFailed(CameraCaptureSession cameraCaptureSession) {
            QtCamera2.this.onCaptureSessionConfigureFailed(QtCamera2.this.mCameraId);
        }

        public void onActive(CameraCaptureSession cameraCaptureSession) {
            super.onActive(cameraCaptureSession);
            QtCamera2.this.onSessionActive(QtCamera2.this.mCameraId);
        }

        public void onClosed(CameraCaptureSession cameraCaptureSession) {
            super.onClosed(cameraCaptureSession);
            QtCamera2.this.onSessionClosed(QtCamera2.this.mCameraId);
        }
    };
    CameraCaptureSession.CaptureCallback mCaptureCallback = new CameraCaptureSession.CaptureCallback(){

        public void onCaptureFailed(CameraCaptureSession cameraCaptureSession, CaptureRequest captureRequest, CaptureFailure captureFailure) {
            super.onCaptureFailed(cameraCaptureSession, captureRequest, captureFailure);
            QtCamera2.this.onCaptureSessionFailed(QtCamera2.this.mCameraId, captureFailure.getReason(), captureFailure.getFrameNumber());
        }
    };
    ImageReader.OnImageAvailableListener mOnImageAvailableListener = new ImageReader.OnImageAvailableListener(){

        public void onImageAvailable(ImageReader imageReader) {
            QtCamera2.this.onFrameAvailable(QtCamera2.this.mCameraId, imageReader.acquireLatestImage());
        }
    };

    native void onCameraOpened(String var1);

    native void onCameraDisconnect(String var1);

    native void onCameraError(String var1, int var2);

    native void onCaptureSessionConfigured(String var1);

    native void onCaptureSessionConfigureFailed(String var1);

    native void onSessionActive(String var1);

    native void onSessionClosed(String var1);

    native void onCaptureSessionFailed(String var1, int var2, long var3);

    public QtCamera2(Context context) {
        this.mCameraManager = (CameraManager)context.getSystemService("camera");
        this.startBackgroundThread();
    }

    void startBackgroundThread() {
        this.mBackgroundThread = new HandlerThread("CameraBackground");
        this.mBackgroundThread.start();
        this.mBackgroundHandler = new Handler(this.mBackgroundThread.getLooper());
    }

    void stopBackgroundThread() {
        this.mBackgroundThread.quitSafely();
        try {
            this.mBackgroundThread.join();
            this.mBackgroundThread = null;
            this.mBackgroundHandler = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public boolean open(String string) {
        try {
            this.mCameraId = string;
            this.mCameraManager.openCamera(string, this.mStateCallback, this.mBackgroundHandler);
            return true;
        }
        catch (Exception exception) {
            Log.w((String)"QtCamera2", (String)("Failed to open camera:" + exception));
            return false;
        }
    }

    native void onFrameAvailable(String var1, Image var2);

    public boolean addImageReader(int n, int n2, int n3) {
        if (this.mImageReader != null) {
            this.removeSurface(this.mImageReader.getSurface());
        }
        this.mImageReader = ImageReader.newInstance((int)n, (int)n2, (int)n3, (int)MaxNumberFrames);
        this.mImageReader.setOnImageAvailableListener(this.mOnImageAvailableListener, this.mBackgroundHandler);
        this.addSurface(this.mImageReader.getSurface());
        return true;
    }

    public boolean addSurface(Surface surface) {
        if (this.mTargetSurfaces.contains(surface)) {
            return true;
        }
        return this.mTargetSurfaces.add(surface);
    }

    public boolean removeSurface(Surface surface) {
        return this.mTargetSurfaces.remove(surface);
    }

    public void clearSurfaces() {
        this.mTargetSurfaces.clear();
    }

    public boolean createSession() {
        if (this.mCameraDevice == null) {
            return false;
        }
        try {
            this.mCameraDevice.createCaptureSession(this.mTargetSurfaces, this.mCaptureStateCallback, this.mBackgroundHandler);
            return true;
        }
        catch (Exception exception) {
            Log.w((String)"QtCamera2", (String)("Failed to create a capture session:" + exception));
            return false;
        }
    }

    public boolean start(int n) {
        if (this.mCameraDevice == null) {
            return false;
        }
        if (this.mCaptureSession == null) {
            return false;
        }
        try {
            this.mPreviewRequestBuilder = this.mCameraDevice.createCaptureRequest(n);
            for (Surface surface : this.mTargetSurfaces) {
                this.mPreviewRequestBuilder.addTarget(surface);
            }
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_AF_MODE, (Object)4);
            this.mPreviewRequestBuilder.set(CaptureRequest.CONTROL_CAPTURE_INTENT, (Object)3);
            this.mPreviewRequest = this.mPreviewRequestBuilder.build();
            this.mCaptureSession.setRepeatingRequest(this.mPreviewRequest, this.mCaptureCallback, this.mBackgroundHandler);
            return true;
        }
        catch (Exception exception) {
            Log.w((String)"QtCamera2", (String)("Failed to start preview:" + exception));
            return false;
        }
    }

    public void stopAndClose() {
        try {
            if (null != this.mCaptureSession) {
                this.mCaptureSession.close();
                this.mCaptureSession = null;
            }
            if (null != this.mCameraDevice) {
                this.mCameraDevice.close();
                this.mCameraDevice = null;
            }
            this.mCameraId = "";
            this.mTargetSurfaces.clear();
        }
        catch (Exception exception) {
            Log.w((String)"QtCamera2", (String)("Failed to stop and close:" + exception));
        }
    }
}

