/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.util.Log;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Objects;
import org.qtproject.qt.android.QtNative;
import org.qtproject.qt.android.QtNativeLibrariesDir;

public class QtServiceDelegate {
    private static final String NATIVE_LIBRARIES_KEY = "native.libraries";
    private static final String BUNDLED_LIBRARIES_KEY = "bundled.libraries";
    private static final String MAIN_LIBRARY_KEY = "main.library";
    private static final String ENVIRONMENT_VARIABLES_KEY = "environment.variables";
    private static final String APPLICATION_PARAMETERS_KEY = "application.parameters";
    private static final String STATIC_INIT_CLASSES_KEY = "static.init.classes";
    private static final String APP_DISPLAY_METRIC_SCREEN_DESKTOP_KEY = "display.screen.desktop";
    private static final String APP_DISPLAY_METRIC_SCREEN_XDPI_KEY = "display.screen.dpi.x";
    private static final String APP_DISPLAY_METRIC_SCREEN_YDPI_KEY = "display.screen.dpi.y";
    private static final String APP_DISPLAY_METRIC_SCREEN_DENSITY_KEY = "display.screen.density";
    private String m_mainLib = null;
    private Service m_service = null;
    private static String m_applicationParameters = null;

    public boolean loadApplication(Service service, ClassLoader classLoader, Bundle bundle) {
        if (!bundle.containsKey(NATIVE_LIBRARIES_KEY) || !bundle.containsKey(BUNDLED_LIBRARIES_KEY)) {
            return false;
        }
        this.m_service = service;
        QtNative.setService(this.m_service, this);
        QtNative.setClassLoader(classLoader);
        QtNative.setApplicationDisplayMetrics(10, 10, 0, 0, 10, 10, 120.0, 120.0, 1.0, 1.0, 60.0f);
        if (bundle.containsKey(STATIC_INIT_CLASSES_KEY)) {
            for (String string2 : Objects.requireNonNull(bundle.getStringArray(STATIC_INIT_CLASSES_KEY))) {
                if (string2.length() == 0) continue;
                try {
                    Method exception;
                    Class<?> exception2 = classLoader.loadClass(string2);
                    Object obj = exception2.newInstance();
                    try {
                        exception = exception2.getMethod("setService", Service.class, Object.class);
                        exception.invoke(obj, this.m_service, this);
                    }
                    catch (Exception exception3) {
                        Log.d((String)"Qt JAVA", (String)("Class " + string2 + " does not implement setService method"));
                    }
                    try {
                        exception = exception2.getMethod("setContext", Context.class);
                        exception.invoke(obj, this.m_service);
                    }
                    catch (Exception exception4) {
                        exception4.printStackTrace();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        QtNative.loadQtLibraries(bundle.getStringArrayList(NATIVE_LIBRARIES_KEY));
        ArrayList arrayList = bundle.getStringArrayList(BUNDLED_LIBRARIES_KEY);
        String string3 = QtNativeLibrariesDir.nativeLibrariesDir((Context)this.m_service);
        QtNative.loadBundledLibraries(arrayList, string3);
        this.m_mainLib = bundle.getString(MAIN_LIBRARY_KEY);
        QtNative.setEnvironmentVariables(bundle.getString(ENVIRONMENT_VARIABLES_KEY));
        QtNative.setEnvironmentVariable("QT_ANDROID_FONTS_MONOSPACE", "Droid Sans Mono;Droid Sans;Droid Sans Fallback");
        QtNative.setEnvironmentVariable("QT_ANDROID_FONTS_SERIF", "Droid Serif");
        QtNative.setEnvironmentVariable("HOME", this.m_service.getFilesDir().getAbsolutePath());
        QtNative.setEnvironmentVariable("TMPDIR", this.m_service.getCacheDir().getAbsolutePath());
        QtNative.setEnvironmentVariable("QT_ANDROID_FONTS", "Roboto;Droid Sans;Droid Sans Fallback");
        m_applicationParameters = bundle.containsKey(APPLICATION_PARAMETERS_KEY) ? bundle.getString(APPLICATION_PARAMETERS_KEY) : "";
        this.m_mainLib = QtNative.loadMainLibrary(this.m_mainLib, string3);
        return this.m_mainLib != null;
    }

    public boolean startApplication() {
        try {
            String string2 = QtNativeLibrariesDir.nativeLibrariesDir((Context)this.m_service);
            QtNative.startApplication(m_applicationParameters, this.m_mainLib);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void onDestroy() {
        QtNative.quitQtCoreApplication();
        QtNative.terminateQt();
        QtNative.setService(null, null);
        QtNative.m_qtThread.exit();
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IBinder onBind(Intent intent) {
        QtServiceDelegate qtServiceDelegate = this;
        synchronized (qtServiceDelegate) {
            return QtNative.onBind(intent);
        }
    }
}

