/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android.multimedia;

import android.content.Context;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.params.StreamConfigurationMap;
import android.util.Range;
import android.util.Size;
import java.util.Map;
import java.util.WeakHashMap;

public class QtVideoDeviceManager {
    CameraManager mCameraManager;
    Map<String, CameraCharacteristics> cache;

    public QtVideoDeviceManager(Context context) {
        this.mCameraManager = (CameraManager)context.getSystemService("camera");
        this.cache = new WeakHashMap<String, CameraCharacteristics>();
    }

    public CameraCharacteristics getCameraCharacteristics(String string) {
        if (this.cache.containsKey(string)) {
            return this.cache.get(string);
        }
        try {
            CameraCharacteristics cameraCharacteristics = this.mCameraManager.getCameraCharacteristics(string);
            this.cache.put(string, cameraCharacteristics);
            return cameraCharacteristics;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public String[] getCameraIdList() {
        try {
            return this.mCameraManager.getCameraIdList();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public int getSensorOrientation(String string) {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics(string);
        if (cameraCharacteristics == null) {
            return 0;
        }
        return (Integer)cameraCharacteristics.get(CameraCharacteristics.SENSOR_ORIENTATION);
    }

    public int getLensFacing(String string) {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics(string);
        if (cameraCharacteristics == null) {
            return 0;
        }
        return (Integer)cameraCharacteristics.get(CameraCharacteristics.LENS_FACING);
    }

    public String[] getFpsRange(String string) {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics(string);
        if (cameraCharacteristics == null) {
            return new String[0];
        }
        Range[] rangeArray = (Range[])cameraCharacteristics.get(CameraCharacteristics.CONTROL_AE_AVAILABLE_TARGET_FPS_RANGES);
        String[] stringArray = new String[rangeArray.length];
        for (int i = 0; i < rangeArray.length; ++i) {
            stringArray[i] = rangeArray[i].toString();
        }
        return stringArray;
    }

    public String[] getStreamConfigurationsSizes(String string, int n) {
        CameraCharacteristics cameraCharacteristics = this.getCameraCharacteristics(string);
        if (cameraCharacteristics == null) {
            return new String[0];
        }
        StreamConfigurationMap streamConfigurationMap = (StreamConfigurationMap)cameraCharacteristics.get(CameraCharacteristics.SCALER_STREAM_CONFIGURATION_MAP);
        Size[] sizeArray = streamConfigurationMap.getOutputSizes(n);
        String[] stringArray = new String[sizeArray.length];
        for (int i = 0; i < sizeArray.length; ++i) {
            stringArray[i] = sizeArray[i].toString();
        }
        return stringArray;
    }
}

