/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt.android.multimedia;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.media.AudioDeviceInfo;
import android.media.AudioManager;
import android.media.AudioRecord;
import android.media.AudioTrack;
import android.media.MediaRecorder;
import android.os.Build;
import android.util.Log;
import java.util.ArrayList;

public class QtAudioDeviceManager {
    private static final String TAG = "QtAudioDeviceManager";
    private static AudioManager m_audioManager = null;
    private static final AudioDevicesReceiver m_audioDevicesReceiver = new AudioDevicesReceiver();
    private static AudioRecord m_recorder = null;
    private static AudioTrack m_streamPlayer = null;
    private static Thread m_streamingThread = null;
    private static boolean m_isStreaming = false;
    private static final int m_sampleRate = 8000;
    private static final int m_channels = 2;
    private static final int m_audioFormat = 2;
    private static final int m_bufferSize = AudioRecord.getMinBufferSize((int)8000, (int)2, (int)2);

    public static native void onAudioInputDevicesUpdated();

    public static native void onAudioOutputDevicesUpdated();

    public static void registerAudioHeadsetStateReceiver(Context context) {
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.HEADSET_PLUG");
        intentFilter.addAction("android.media.action.HDMI_AUDIO_PLUG");
        intentFilter.addAction("android.bluetooth.device.action.ACL_CONNECTED");
        intentFilter.addAction("android.bluetooth.device.action.ACL_DISCONNECTED");
        intentFilter.addAction("android.bluetooth.device.action.ACL_DISCONNECT_REQUESTED");
        intentFilter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.device.action.BOND_STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.headset.profile.action.CONNECTION_STATE_CHANGED");
        intentFilter.addAction("android.media.ACTION_SCO_AUDIO_STATE_UPDATED");
        intentFilter.addAction("android.bluetooth.a2dp.profile.action.CONNECTION_STATE_CHANGED");
        intentFilter.addAction("android.bluetooth.a2dp.profile.action.PLAYING_STATE_CHANGED");
        context.registerReceiver((BroadcastReceiver)m_audioDevicesReceiver, intentFilter);
    }

    public static void setContext(Context context) {
        m_audioManager = (AudioManager)context.getSystemService("audio");
    }

    private static String[] getAudioOutputDevices() {
        return QtAudioDeviceManager.getAudioDevices(2);
    }

    private static String[] getAudioInputDevices() {
        return QtAudioDeviceManager.getAudioDevices(1);
    }

    private static boolean isBluetoothDevice(AudioDeviceInfo audioDeviceInfo) {
        switch (audioDeviceInfo.getType()) {
            case 7: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    private static boolean setAudioInput(MediaRecorder mediaRecorder, int n) {
        AudioDeviceInfo[] audioDeviceInfoArray;
        if (Build.VERSION.SDK_INT < 28) {
            return false;
        }
        for (AudioDeviceInfo audioDeviceInfo : audioDeviceInfoArray = m_audioManager.getDevices(1)) {
            if (audioDeviceInfo.getId() != n) continue;
            boolean bl = mediaRecorder.setPreferredDevice(audioDeviceInfo);
            if (bl && QtAudioDeviceManager.isBluetoothDevice(audioDeviceInfo)) {
                m_audioManager.startBluetoothSco();
                m_audioManager.setBluetoothScoOn(true);
            }
            return bl;
        }
        return false;
    }

    private static void setInputMuted(boolean bl) {
        m_audioManager.setMicrophoneMute(bl);
    }

    private static boolean isMicrophoneMute() {
        return m_audioManager.isMicrophoneMute();
    }

    private static String audioDeviceTypeToString(int n) {
        switch (n) {
            case 19: {
                return "AUX Line";
            }
            case 7: 
            case 8: {
                return "Bluetooth";
            }
            case 1: {
                return "Built in earpiece";
            }
            case 15: {
                return "Built in microphone";
            }
            case 2: {
                return "Built in speaker";
            }
            case 13: {
                return "Dock";
            }
            case 14: {
                return "FM";
            }
            case 16: {
                return "FM TUNER";
            }
            case 9: {
                return "HDMI";
            }
            case 10: {
                return "HDMI ARC";
            }
            case 20: {
                return "IP";
            }
            case 5: {
                return "Line analog";
            }
            case 6: {
                return "Line digital";
            }
            case 17: {
                return "TV tuner";
            }
            case 12: {
                return "USB accessory";
            }
            case 4: {
                return "Wired headphones";
            }
            case 3: {
                return "Wired headset";
            }
        }
        return "Unknown-Type";
    }

    private static String[] getAudioDevices(int n) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (Build.VERSION.SDK_INT >= 23) {
            boolean bl = false;
            boolean bl2 = false;
            for (AudioDeviceInfo audioDeviceInfo : m_audioManager.getDevices(n)) {
                String string = QtAudioDeviceManager.audioDeviceTypeToString(audioDeviceInfo.getType());
                if (string.equals(QtAudioDeviceManager.audioDeviceTypeToString(0))) continue;
                if (string.equals(QtAudioDeviceManager.audioDeviceTypeToString(15))) {
                    if (bl) continue;
                    bl = true;
                } else if (QtAudioDeviceManager.isBluetoothDevice(audioDeviceInfo)) {
                    if (bl2) continue;
                    bl2 = true;
                }
                arrayList.add(audioDeviceInfo.getId() + ":" + string + " (" + audioDeviceInfo.getProductName().toString() + ")");
            }
        }
        String[] stringArray = new String[arrayList.size()];
        stringArray = arrayList.toArray(stringArray);
        return stringArray;
    }

    private static boolean setAudioOutput(int n) {
        AudioDeviceInfo[] audioDeviceInfoArray;
        for (AudioDeviceInfo audioDeviceInfo : audioDeviceInfoArray = m_audioManager.getDevices(2)) {
            if (audioDeviceInfo.getId() != n) continue;
            switch (audioDeviceInfo.getType()) {
                case 7: 
                case 8: {
                    QtAudioDeviceManager.setAudioOutput(3, true, false);
                    return true;
                }
                case 2: {
                    QtAudioDeviceManager.setAudioOutput(3, false, true);
                    return true;
                }
                case 3: 
                case 4: {
                    QtAudioDeviceManager.setAudioOutput(3, false, false);
                    return true;
                }
                case 1: {
                    Log.w((String)TAG, (String)"Built in Earpiece may not work when Wired Headphones are connected");
                    QtAudioDeviceManager.setAudioOutput(2, false, false);
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private static void setAudioOutput(int n, boolean bl, boolean bl2) {
        m_audioManager.setMode(n);
        if (bl) {
            m_audioManager.startBluetoothSco();
        } else {
            m_audioManager.stopBluetoothSco();
        }
        m_audioManager.setBluetoothScoOn(bl);
        m_audioManager.setSpeakerphoneOn(bl2);
    }

    private static void streamSound() {
        byte[] byArray = new byte[m_bufferSize];
        while (m_isStreaming) {
            m_recorder.read(byArray, 0, m_bufferSize);
            m_streamPlayer.play();
            m_streamPlayer.write(byArray, 0, m_bufferSize);
            m_streamPlayer.stop();
        }
    }

    private static void startSoundStreaming(int n, int n2) {
        AudioDeviceInfo[] audioDeviceInfoArray;
        if (m_isStreaming) {
            QtAudioDeviceManager.stopSoundStreaming();
        }
        m_recorder = new AudioRecord(0, 8000, 2, 2, m_bufferSize);
        m_streamPlayer = new AudioTrack(3, 8000, 2, 2, m_bufferSize, 1);
        for (AudioDeviceInfo audioDeviceInfo : audioDeviceInfoArray = m_audioManager.getDevices(3)) {
            if (audioDeviceInfo.getId() == n2) {
                m_streamPlayer.setPreferredDevice(audioDeviceInfo);
                continue;
            }
            if (audioDeviceInfo.getId() != n) continue;
            m_recorder.setPreferredDevice(audioDeviceInfo);
        }
        m_recorder.startRecording();
        m_isStreaming = true;
        m_streamingThread = new Thread(new Runnable(){

            @Override
            public void run() {
                QtAudioDeviceManager.streamSound();
            }
        });
        m_streamingThread.start();
    }

    private static void stopSoundStreaming() {
        if (!m_isStreaming) {
            return;
        }
        m_isStreaming = false;
        try {
            m_streamingThread.join();
            m_streamingThread = null;
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        m_recorder.stop();
        m_recorder.release();
        m_streamPlayer.release();
        m_streamPlayer = null;
        m_recorder = null;
    }

    private static class AudioDevicesReceiver
    extends BroadcastReceiver {
        private AudioDevicesReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            QtAudioDeviceManager.onAudioInputDevicesUpdated();
            QtAudioDeviceManager.onAudioOutputDevicesUpdated();
        }
    }
}

