/*
 * Decompiled with CFR 0.152.
 */
package org.qtproject.qt5.android;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.ResultReceiver;
import android.text.method.MetaKeyKeyListener;
import android.util.Base64;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.ContextMenu;
import android.view.Display;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.inputmethod.InputMethodManager;
import android.widget.ImageView;
import android.widget.PopupMenu;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import org.qtproject.qt5.android.CursorHandle;
import org.qtproject.qt5.android.EditPopupMenu;
import org.qtproject.qt5.android.ExtractStyle;
import org.qtproject.qt5.android.QtEditText;
import org.qtproject.qt5.android.QtLayout;
import org.qtproject.qt5.android.QtNative;
import org.qtproject.qt5.android.QtNativeInputConnection;
import org.qtproject.qt5.android.QtNativeLibrariesDir;
import org.qtproject.qt5.android.QtSurface;
import org.qtproject.qt5.android.accessibility.QtAccessibilityDelegate;

public class QtActivityDelegate {
    private Activity m_activity = null;
    private Method m_super_dispatchKeyEvent = null;
    private Method m_super_onRestoreInstanceState = null;
    private Method m_super_onRetainNonConfigurationInstance = null;
    private Method m_super_onSaveInstanceState = null;
    private Method m_super_onKeyDown = null;
    private Method m_super_onKeyUp = null;
    private Method m_super_onConfigurationChanged = null;
    private Method m_super_onActivityResult = null;
    private Method m_super_dispatchGenericMotionEvent = null;
    private Method m_super_onWindowFocusChanged = null;
    private static final String NATIVE_LIBRARIES_KEY = "native.libraries";
    private static final String BUNDLED_LIBRARIES_KEY = "bundled.libraries";
    private static final String MAIN_LIBRARY_KEY = "main.library";
    private static final String ENVIRONMENT_VARIABLES_KEY = "environment.variables";
    private static final String APPLICATION_PARAMETERS_KEY = "application.parameters";
    private static final String STATIC_INIT_CLASSES_KEY = "static.init.classes";
    private static final String NECESSITAS_API_LEVEL_KEY = "necessitas.api.level";
    private static final String EXTRACT_STYLE_KEY = "extract.android.style";
    private static final String EXTRACT_STYLE_MINIMAL_KEY = "extract.android.style.option";
    private static String m_environmentVariables = null;
    private static String m_applicationParameters = null;
    private int m_currentRotation = -1;
    private int m_nativeOrientation = 0;
    private String m_mainLib;
    private long m_metaState;
    private int m_lastChar = 0;
    private int m_softInputMode = 0;
    private boolean m_fullScreen = false;
    private boolean m_started = false;
    private HashMap<Integer, QtSurface> m_surfaces = null;
    private HashMap<Integer, View> m_nativeViews = null;
    private QtLayout m_layout = null;
    private ImageView m_splashScreen = null;
    private boolean m_splashScreenSticky = false;
    private QtEditText m_editText = null;
    private InputMethodManager m_imm = null;
    private boolean m_quitApp = true;
    private View m_dummyView = null;
    private boolean m_keyboardIsVisible = false;
    public boolean m_backKeyPressedSent = false;
    private long m_showHideTimeStamp = System.nanoTime();
    private int m_portraitKeyboardHeight = 0;
    private int m_landscapeKeyboardHeight = 0;
    private int m_probeKeyboardHeightDelay = 50;
    private CursorHandle m_cursorHandle;
    private CursorHandle m_leftSelectionHandle;
    private CursorHandle m_rightSelectionHandle;
    private EditPopupMenu m_editPopupMenu;
    private boolean m_isPluginRunning = false;
    private final int ImhHiddenText = 1;
    private final int ImhSensitiveData = 2;
    private final int ImhNoAutoUppercase = 4;
    private final int ImhPreferNumbers = 8;
    private final int ImhPreferUppercase = 16;
    private final int ImhPreferLowercase = 32;
    private final int ImhNoPredictiveText = 64;
    private final int ImhDate = 128;
    private final int ImhTime = 256;
    private final int ImhPreferLatin = 512;
    private final int ImhMultiLine = 1024;
    private final int ImhDigitsOnly = 65536;
    private final int ImhFormattedNumbersOnly = 131072;
    private final int ImhUppercaseOnly = 262144;
    private final int ImhLowercaseOnly = 524288;
    private final int ImhDialableCharactersOnly = 0x100000;
    private final int ImhEmailCharactersOnly = 0x200000;
    private final int ImhUrlCharactersOnly = 0x400000;
    private final int ImhLatinOnly = 0x800000;
    private final int EnterKeyDefault = 0;
    private final int EnterKeyReturn = 1;
    private final int EnterKeyDone = 2;
    private final int EnterKeyGo = 3;
    private final int EnterKeySend = 4;
    private final int EnterKeySearch = 5;
    private final int EnterKeyNext = 6;
    private final int EnterKeyPrevious = 7;
    public static final int ApplicationSuspended = 0;
    public static final int ApplicationHidden = 1;
    public static final int ApplicationInactive = 2;
    public static final int ApplicationActive = 4;
    private QtAccessibilityDelegate m_accessibilityDelegate = null;
    private static final int CursorHandleNotShown = 0;
    private static final int CursorHandleShowNormal = 1;
    private static final int CursorHandleShowSelection = 2;
    private static final int CursorHandleShowEdit = 256;
    private boolean m_optionsMenuIsVisible = false;
    private boolean m_contextMenuVisible = false;

    public void setFullScreen(boolean bl) {
        if (this.m_fullScreen == bl) {
            return;
        }
        this.m_fullScreen = bl;
        if (this.m_fullScreen) {
            this.m_activity.getWindow().addFlags(1024);
            this.m_activity.getWindow().clearFlags(2048);
            try {
                int n = 2;
                n |= 0x100;
                n |= 0x200;
                n |= 0x400;
                n |= 4;
                this.m_activity.getWindow().getDecorView().setSystemUiVisibility((n |= View.class.getDeclaredField("SYSTEM_UI_FLAG_IMMERSIVE_STICKY").getInt(null)) | 4);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            this.m_activity.getWindow().addFlags(2048);
            this.m_activity.getWindow().clearFlags(1024);
            this.m_activity.getWindow().getDecorView().setSystemUiVisibility(0);
        }
        this.m_layout.requestLayout();
    }

    public void updateFullScreen() {
        if (this.m_fullScreen) {
            this.m_fullScreen = false;
            this.setFullScreen(true);
        }
    }

    public boolean isKeyboardVisible() {
        return this.m_keyboardIsVisible;
    }

    public boolean setKeyboardVisibility(boolean bl, long l) {
        if (this.m_showHideTimeStamp > l) {
            return false;
        }
        this.m_showHideTimeStamp = l;
        if (this.m_keyboardIsVisible == bl) {
            return false;
        }
        this.m_keyboardIsVisible = bl;
        QtNative.keyboardVisibilityUpdated(this.m_keyboardIsVisible);
        if (!bl) {
            this.updateFullScreen();
        }
        return true;
    }

    public void resetSoftwareKeyboard() {
        if (this.m_imm == null) {
            return;
        }
        this.m_editText.postDelayed(new Runnable(){

            @Override
            public void run() {
                QtActivityDelegate.this.m_imm.restartInput((View)QtActivityDelegate.this.m_editText);
                ((QtActivityDelegate)QtActivityDelegate.this).m_editText.m_optionsChanged = false;
            }
        }, 5L);
    }

    public void showSoftwareKeyboard(final int n, final int n2, final int n3, final int n4, final int n5, final int n6) {
        int n7;
        int n8;
        if (this.m_imm == null) {
            return;
        }
        DisplayMetrics displayMetrics = new DisplayMetrics();
        this.m_activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        if (displayMetrics.widthPixels < displayMetrics.heightPixels) {
            n8 = this.m_portraitKeyboardHeight != 0 ? this.m_portraitKeyboardHeight : displayMetrics.heightPixels * 3 / 5;
        } else {
            int n9 = n8 = this.m_landscapeKeyboardHeight != 0 ? this.m_landscapeKeyboardHeight : displayMetrics.heightPixels / 3;
        }
        if (this.m_softInputMode != 0) {
            this.m_activity.getWindow().setSoftInputMode(this.m_softInputMode);
            int n10 = n7 = (this.m_softInputMode & 2) != 0 ? 1 : 0;
            if (n7 != 0) {
                return;
            }
        } else if (n4 > n8) {
            this.m_activity.getWindow().setSoftInputMode(17);
        } else {
            this.m_activity.getWindow().setSoftInputMode(33);
        }
        n7 = 0;
        int n11 = 6;
        switch (n6) {
            case 1: {
                n11 = 0x40000000;
                break;
            }
            case 3: {
                n11 = 2;
                break;
            }
            case 4: {
                n11 = 4;
                break;
            }
            case 5: {
                n11 = 3;
                break;
            }
            case 6: {
                n11 = 5;
                break;
            }
            case 7: {
                n11 = 7;
            }
        }
        int n12 = 1;
        if ((n5 & 0x30008) != 0) {
            n12 = 2;
            if ((n5 & 0x20000) != 0) {
                n12 |= 0x3000;
            }
            if ((n5 & 1) != 0) {
                n12 |= 0x10;
            }
        } else if ((n5 & 0x100000) != 0) {
            n12 = 3;
        } else if ((n5 & 0x180) != 0) {
            n12 = 4;
            if ((n5 & 0x180) != 384) {
                n12 = (n5 & 0x80) != 0 ? (n12 |= 0x10) : (n12 |= 0x20);
            }
        } else {
            if ((n5 & 1) != 0) {
                n12 |= 0x80;
            } else if ((n5 & 2) != 0 || (n5 & 0x40) != 0 && System.getenv("QT_ANDROID_ENABLE_WORKAROUND_TO_DISABLE_PREDICTIVE_TEXT") != null) {
                n12 |= 0x90;
            } else if ((n5 & 0x400000) != 0) {
                n12 |= 0x10;
                if (n6 == 0) {
                    n11 = 2;
                }
            } else if ((n5 & 0x200000) != 0) {
                n12 |= 0x20;
            }
            if ((n5 & 0x400) != 0) {
                n12 |= 0x20000;
                n11 = 6;
            }
            if ((n5 & 0x43) != 0) {
                n12 |= 0x80000;
            }
            if ((n5 & 0x40000) != 0) {
                n7 |= 0x1000;
                n12 |= 0x1000;
            } else if ((n5 & 0x80000) == 0 && (n5 & 4) == 0) {
                n7 |= 0x4000;
                n12 |= 0x4000;
            }
        }
        if (n6 == 0 && (n5 & 0x400) != 0) {
            n11 = 0x40000000;
        }
        this.m_editText.setInitialCapsMode(n7);
        this.m_editText.setImeOptions(n11);
        this.m_editText.setInputType(n12);
        this.m_layout.setLayoutParams(this.m_editText, new QtLayout.LayoutParams(n3, n4, n, n2), false);
        this.m_editText.requestFocus();
        this.m_editText.postDelayed(new Runnable(){

            @Override
            public void run() {
                QtActivityDelegate.this.m_imm.showSoftInput((View)QtActivityDelegate.this.m_editText, 0, new ResultReceiver(new Handler()){

                    protected void onReceiveResult(int n, Bundle bundle) {
                        switch (n) {
                            case 2: {
                                QtNativeInputConnection.updateCursorPosition();
                            }
                            case 0: {
                                QtActivityDelegate.this.setKeyboardVisibility(true, System.nanoTime());
                                if (QtActivityDelegate.this.m_softInputMode != 0) break;
                                QtActivityDelegate.this.m_layout.postDelayed(new Runnable(){

                                    @Override
                                    public void run() {
                                        if (!QtActivityDelegate.this.m_keyboardIsVisible) {
                                            return;
                                        }
                                        DisplayMetrics displayMetrics = new DisplayMetrics();
                                        QtActivityDelegate.this.m_activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
                                        Rect rect = new Rect();
                                        QtActivityDelegate.this.m_activity.getWindow().getDecorView().getWindowVisibleDisplayFrame(rect);
                                        if (displayMetrics.heightPixels != rect.bottom) {
                                            if (displayMetrics.widthPixels > displayMetrics.heightPixels) {
                                                if (QtActivityDelegate.this.m_landscapeKeyboardHeight != rect.bottom) {
                                                    QtActivityDelegate.this.m_landscapeKeyboardHeight = rect.bottom;
                                                    QtActivityDelegate.this.showSoftwareKeyboard(n, n2, n3, n4, n5, n6);
                                                }
                                            } else if (QtActivityDelegate.this.m_portraitKeyboardHeight != rect.bottom) {
                                                QtActivityDelegate.this.m_portraitKeyboardHeight = rect.bottom;
                                                QtActivityDelegate.this.showSoftwareKeyboard(n, n2, n3, n4, n5, n6);
                                            }
                                        } else if (QtActivityDelegate.this.m_probeKeyboardHeightDelay < 1000) {
                                            QtActivityDelegate.this.m_probeKeyboardHeightDelay = QtActivityDelegate.this.m_probeKeyboardHeightDelay * 2;
                                        }
                                    }
                                }, QtActivityDelegate.this.m_probeKeyboardHeightDelay);
                                break;
                            }
                            case 1: 
                            case 3: {
                                QtActivityDelegate.this.setKeyboardVisibility(false, System.nanoTime());
                            }
                        }
                    }
                });
                if (((QtActivityDelegate)QtActivityDelegate.this).m_editText.m_optionsChanged) {
                    QtActivityDelegate.this.m_imm.restartInput((View)QtActivityDelegate.this.m_editText);
                    ((QtActivityDelegate)QtActivityDelegate.this).m_editText.m_optionsChanged = false;
                }
            }
        }, 15L);
    }

    public void hideSoftwareKeyboard() {
        if (this.m_imm == null) {
            return;
        }
        this.m_imm.hideSoftInputFromWindow(this.m_editText.getWindowToken(), 0, new ResultReceiver(new Handler()){

            protected void onReceiveResult(int n, Bundle bundle) {
                switch (n) {
                    case 0: 
                    case 2: {
                        QtActivityDelegate.this.setKeyboardVisibility(true, System.nanoTime());
                        break;
                    }
                    case 1: 
                    case 3: {
                        QtActivityDelegate.this.setKeyboardVisibility(false, System.nanoTime());
                    }
                }
            }
        });
    }

    String getAppIconSize(Activity activity) {
        int n = activity.getResources().getDimensionPixelSize(0x1050000);
        if (n < 36 || n > 512) {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
            n = displayMetrics.densityDpi / 10 * 3;
            if (n < 36) {
                n = 36;
            }
            if (n > 512) {
                n = 512;
            }
        }
        return "\tQT_ANDROID_APP_ICON_SIZE=" + n;
    }

    public void updateSelection(int n, int n2, int n3, int n4) {
        if (this.m_imm == null) {
            return;
        }
        this.m_imm.updateSelection((View)this.m_editText, n, n2, n3, n4);
    }

    public void updateHandles(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, boolean bl) {
        switch (n & 0xFF) {
            case 0: {
                if (this.m_cursorHandle != null) {
                    this.m_cursorHandle.hide();
                    this.m_cursorHandle = null;
                }
                if (this.m_rightSelectionHandle != null) {
                    this.m_rightSelectionHandle.hide();
                    this.m_leftSelectionHandle.hide();
                    this.m_rightSelectionHandle = null;
                    this.m_leftSelectionHandle = null;
                }
                if (this.m_editPopupMenu == null) break;
                this.m_editPopupMenu.hide();
                break;
            }
            case 1: {
                if (this.m_cursorHandle == null) {
                    this.m_cursorHandle = new CursorHandle(this.m_activity, (View)this.m_layout, 1, 16843463, false);
                }
                this.m_cursorHandle.setPosition(n5, n6);
                if (this.m_rightSelectionHandle == null) break;
                this.m_rightSelectionHandle.hide();
                this.m_leftSelectionHandle.hide();
                this.m_rightSelectionHandle = null;
                this.m_leftSelectionHandle = null;
                break;
            }
            case 2: {
                if (this.m_rightSelectionHandle == null) {
                    this.m_leftSelectionHandle = new CursorHandle(this.m_activity, (View)this.m_layout, 2, !bl ? 16843461 : 16843462, bl);
                    this.m_rightSelectionHandle = new CursorHandle(this.m_activity, (View)this.m_layout, 3, !bl ? 16843462 : 16843461, bl);
                }
                this.m_leftSelectionHandle.setPosition(n5, n6);
                this.m_rightSelectionHandle.setPosition(n7, n8);
                if (this.m_cursorHandle != null) {
                    this.m_cursorHandle.hide();
                    this.m_cursorHandle = null;
                }
                n |= 0x100;
            }
        }
        n4 = QtNative.hasClipboardText() ? (n4 |= 4) : (n4 &= 0xFFFFFFFB);
        if ((n & 0x100) == 256 && n4 != 0) {
            this.m_editPopupMenu.setPosition(n2, n3, n4, this.m_cursorHandle, this.m_leftSelectionHandle, this.m_rightSelectionHandle);
        } else if (this.m_editPopupMenu != null) {
            this.m_editPopupMenu.hide();
        }
    }

    public boolean loadApplication(Activity activity, ClassLoader classLoader, Bundle bundle) {
        Object object;
        Object object2;
        String string22;
        if (!(bundle.containsKey(NATIVE_LIBRARIES_KEY) && bundle.containsKey(BUNDLED_LIBRARIES_KEY) && bundle.containsKey(ENVIRONMENT_VARIABLES_KEY))) {
            return false;
        }
        this.m_activity = activity;
        this.setActionBarVisibility(false);
        QtNative.setActivity(this.m_activity, this);
        QtNative.setClassLoader(classLoader);
        if (bundle.containsKey(STATIC_INIT_CLASSES_KEY)) {
            for (String string22 : Objects.requireNonNull(bundle.getStringArray(STATIC_INIT_CLASSES_KEY))) {
                if (string22.length() == 0) continue;
                try {
                    Method method;
                    object2 = classLoader.loadClass(string22);
                    object = ((Class)object2).newInstance();
                    try {
                        method = ((Class)object2).getMethod("setActivity", Activity.class, Object.class);
                        method.invoke(object, this.m_activity, this);
                    }
                    catch (Exception exception) {
                        Log.d((String)"Qt JAVA", (String)("Class " + string22 + " does not implement setActivity method"));
                    }
                    try {
                        method = ((Class)object2).getMethod("setContext", Context.class);
                        method.invoke(object, this.m_activity);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        QtNative.loadQtLibraries(bundle.getStringArrayList(NATIVE_LIBRARIES_KEY));
        ArrayList arrayList = bundle.getStringArrayList(BUNDLED_LIBRARIES_KEY);
        String string3 = QtNativeLibrariesDir.nativeLibrariesDir((Context)this.m_activity);
        QtNative.loadBundledLibraries(arrayList, string3);
        this.m_mainLib = bundle.getString(MAIN_LIBRARY_KEY);
        if (null == this.m_mainLib && arrayList.size() > 0) {
            this.m_mainLib = (String)arrayList.get(arrayList.size() - 1);
            arrayList.remove(arrayList.size() - 1);
        }
        if (bundle.containsKey(EXTRACT_STYLE_KEY)) {
            String string4 = bundle.getString(EXTRACT_STYLE_KEY);
            new ExtractStyle((Context)this.m_activity, string4, bundle.containsKey(EXTRACT_STYLE_MINIMAL_KEY) && bundle.getBoolean(EXTRACT_STYLE_MINIMAL_KEY));
        }
        try {
            this.m_super_dispatchKeyEvent = this.m_activity.getClass().getMethod("super_dispatchKeyEvent", KeyEvent.class);
            this.m_super_onRestoreInstanceState = this.m_activity.getClass().getMethod("super_onRestoreInstanceState", Bundle.class);
            this.m_super_onRetainNonConfigurationInstance = this.m_activity.getClass().getMethod("super_onRetainNonConfigurationInstance", new Class[0]);
            this.m_super_onSaveInstanceState = this.m_activity.getClass().getMethod("super_onSaveInstanceState", Bundle.class);
            this.m_super_onKeyDown = this.m_activity.getClass().getMethod("super_onKeyDown", Integer.TYPE, KeyEvent.class);
            this.m_super_onKeyUp = this.m_activity.getClass().getMethod("super_onKeyUp", Integer.TYPE, KeyEvent.class);
            this.m_super_onConfigurationChanged = this.m_activity.getClass().getMethod("super_onConfigurationChanged", Configuration.class);
            this.m_super_onActivityResult = this.m_activity.getClass().getMethod("super_onActivityResult", Integer.TYPE, Integer.TYPE, Intent.class);
            this.m_super_onWindowFocusChanged = this.m_activity.getClass().getMethod("super_onWindowFocusChanged", Boolean.TYPE);
            this.m_super_dispatchGenericMotionEvent = this.m_activity.getClass().getMethod("super_dispatchGenericMotionEvent", MotionEvent.class);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        int n = 1;
        if (bundle.containsKey(NECESSITAS_API_LEVEL_KEY)) {
            n = bundle.getInt(NECESSITAS_API_LEVEL_KEY);
        }
        m_environmentVariables = bundle.getString(ENVIRONMENT_VARIABLES_KEY);
        string22 = "QT_ANDROID_FONTS_MONOSPACE=Droid Sans Mono;Droid Sans;Droid Sans Fallback\tQT_ANDROID_FONTS_SERIF=Droid Serif\tNECESSITAS_API_LEVEL=" + n + "\tHOME=" + this.m_activity.getFilesDir().getAbsolutePath() + "\tTMPDIR=" + this.m_activity.getFilesDir().getAbsolutePath();
        string22 = string22 + "\tQT_ANDROID_FONTS=Roboto;Droid Sans;Droid Sans Fallback";
        string22 = string22 + this.getAppIconSize(activity);
        m_environmentVariables = m_environmentVariables != null && m_environmentVariables.length() > 0 ? string22 + "\t" + m_environmentVariables : string22;
        m_applicationParameters = bundle.containsKey(APPLICATION_PARAMETERS_KEY) ? bundle.getString(APPLICATION_PARAMETERS_KEY) : "";
        try {
            this.m_softInputMode = this.m_activity.getPackageManager().getActivityInfo((ComponentName)this.m_activity.getComponentName(), (int)0).softInputMode;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        object2 = new DisplayManager.DisplayListener(){

            public void onDisplayAdded(int n) {
            }

            private boolean isSimilarRotation(int n, int n2) {
                return n == n2 || n == 0 && n2 == 2 || n == 2 && n2 == 0 || n == 1 && n2 == 3 || n == 3 && n2 == 1;
            }

            public void onDisplayChanged(int n) {
                Display display = Build.VERSION.SDK_INT < 30 ? QtActivityDelegate.this.m_activity.getWindowManager().getDefaultDisplay() : QtActivityDelegate.this.m_activity.getDisplay();
                QtActivityDelegate.this.m_currentRotation = display.getRotation();
                QtActivityDelegate.this.m_layout.setActivityDisplayRotation(QtActivityDelegate.this.m_currentRotation);
                if (this.isSimilarRotation(QtActivityDelegate.this.m_currentRotation, QtActivityDelegate.this.m_layout.displayRotation())) {
                    QtNative.handleOrientationChanged(QtActivityDelegate.this.m_currentRotation, QtActivityDelegate.this.m_nativeOrientation);
                }
                float f = display.getRefreshRate();
                QtNative.handleRefreshRateChanged(f);
            }

            public void onDisplayRemoved(int n) {
            }
        };
        try {
            object = (DisplayManager)this.m_activity.getSystemService("display");
            object.registerDisplayListener((DisplayManager.DisplayListener)object2, null);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_mainLib = QtNative.loadMainLibrary(this.m_mainLib, string3);
        return this.m_mainLib != null;
    }

    public boolean startApplication() {
        try {
            Bundle bundle = this.m_activity.getIntent().getExtras();
            if (bundle != null) {
                try {
                    boolean bl;
                    boolean bl2 = bl = (this.m_activity.getApplicationInfo().flags & 2) != 0;
                    if (!bl) {
                        throw new Exception();
                    }
                    if (bundle.containsKey("extraenvvars")) {
                        try {
                            m_environmentVariables = m_environmentVariables + "\t" + new String(Base64.decode((String)bundle.getString("extraenvvars"), (int)0), "UTF-8");
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    if (bundle.containsKey("extraappparams")) {
                        try {
                            m_applicationParameters = m_applicationParameters + "\t" + new String(Base64.decode((String)bundle.getString("extraappparams"), (int)0), "UTF-8");
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                }
                catch (Exception exception) {
                    Log.e((String)"Qt JAVA", (String)"Not in debug mode! It is not allowed to use extra arguments in non-debug mode.");
                }
            }
            if (null == this.m_surfaces) {
                this.onCreate(null);
            }
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void onTerminate() {
        QtNative.terminateQt();
        QtNative.m_qtThread.exit();
    }

    public void onCreate(Bundle bundle) {
        int n;
        this.m_quitApp = true;
        Runnable runnable = null;
        if (null == bundle) {
            runnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        QtNative.startApplication(m_applicationParameters, m_environmentVariables, QtActivityDelegate.this.m_mainLib);
                        QtActivityDelegate.this.m_started = true;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        QtActivityDelegate.this.m_activity.finish();
                    }
                }
            };
        }
        this.m_layout = new QtLayout((Context)this.m_activity, runnable);
        int n2 = this.m_activity.getResources().getConfiguration().orientation;
        try {
            ActivityInfo activityInfo = this.m_activity.getPackageManager().getActivityInfo(this.m_activity.getComponentName(), 128);
            String string2 = "android.app.splash_screen_drawable_" + (n2 == 2 ? "landscape" : "portrait");
            if (!activityInfo.metaData.containsKey(string2)) {
                string2 = "android.app.splash_screen_drawable";
            }
            if (activityInfo.metaData.containsKey(string2)) {
                this.m_splashScreenSticky = activityInfo.metaData.containsKey("android.app.splash_screen_sticky") && activityInfo.metaData.getBoolean("android.app.splash_screen_sticky");
                n = activityInfo.metaData.getInt(string2);
                this.m_splashScreen = new ImageView((Context)this.m_activity);
                this.m_splashScreen.setImageDrawable(this.m_activity.getResources().getDrawable(n));
                this.m_splashScreen.setScaleType(ImageView.ScaleType.FIT_XY);
                this.m_splashScreen.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
                this.m_layout.addView((View)this.m_splashScreen);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_editText = new QtEditText((Context)this.m_activity, this);
        this.m_imm = (InputMethodManager)this.m_activity.getSystemService("input_method");
        this.m_surfaces = new HashMap();
        this.m_nativeViews = new HashMap();
        this.m_activity.registerForContextMenu((View)this.m_layout);
        this.m_activity.setContentView((View)this.m_layout, new ViewGroup.LayoutParams(-1, -1));
        int n3 = this.m_activity.getWindowManager().getDefaultDisplay().getRotation();
        boolean bl = n3 == 1 || n3 == 3;
        n = n2 == 2 ? 1 : 0;
        this.m_nativeOrientation = n != 0 && !bl || n == 0 && bl ? 2 : 1;
        this.m_layout.setNativeOrientation(this.m_nativeOrientation);
        QtNative.handleOrientationChanged(n3, this.m_nativeOrientation);
        this.m_currentRotation = n3;
        float f = Build.VERSION.SDK_INT < 30 ? this.m_activity.getWindowManager().getDefaultDisplay().getRefreshRate() : this.m_activity.getDisplay().getRefreshRate();
        QtNative.handleRefreshRateChanged(f);
        this.m_layout.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                if (!QtActivityDelegate.this.m_keyboardIsVisible) {
                    return true;
                }
                Rect rect = new Rect();
                QtActivityDelegate.this.m_activity.getWindow().getDecorView().getWindowVisibleDisplayFrame(rect);
                DisplayMetrics displayMetrics = new DisplayMetrics();
                QtActivityDelegate.this.m_activity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
                int n = displayMetrics.heightPixels - rect.bottom;
                if (n < 0) {
                    QtActivityDelegate.this.setKeyboardVisibility(false, System.nanoTime());
                    return true;
                }
                int[] nArray = new int[2];
                QtActivityDelegate.this.m_layout.getLocationOnScreen(nArray);
                QtNative.keyboardGeometryChanged(nArray[0], rect.bottom - nArray[1], rect.width(), n);
                return true;
            }
        });
        this.m_editPopupMenu = new EditPopupMenu(this.m_activity, (View)this.m_layout);
    }

    public void hideSplashScreen() {
        this.hideSplashScreen(0);
    }

    public void hideSplashScreen(int n) {
        if (this.m_splashScreen == null) {
            return;
        }
        if (n <= 0) {
            this.m_layout.removeView((View)this.m_splashScreen);
            this.m_splashScreen = null;
            return;
        }
        AlphaAnimation alphaAnimation = new AlphaAnimation(1.0f, 0.0f);
        alphaAnimation.setInterpolator((Interpolator)new AccelerateInterpolator());
        alphaAnimation.setDuration((long)n);
        alphaAnimation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationEnd(Animation animation) {
                QtActivityDelegate.this.hideSplashScreen(0);
            }

            public void onAnimationRepeat(Animation animation) {
            }

            public void onAnimationStart(Animation animation) {
            }
        });
        this.m_splashScreen.startAnimation((Animation)alphaAnimation);
    }

    public void notifyAccessibilityLocationChange(int n) {
        if (this.m_accessibilityDelegate == null) {
            return;
        }
        this.m_accessibilityDelegate.notifyLocationChange(n);
    }

    public void notifyObjectHide(int n, int n2) {
        if (this.m_accessibilityDelegate == null) {
            return;
        }
        this.m_accessibilityDelegate.notifyObjectHide(n, n2);
    }

    public void notifyObjectFocus(int n) {
        if (this.m_accessibilityDelegate == null) {
            return;
        }
        this.m_accessibilityDelegate.notifyObjectFocus(n);
    }

    public void notifyValueChanged(int n, String string2) {
        if (this.m_accessibilityDelegate == null) {
            return;
        }
        this.m_accessibilityDelegate.notifyValueChanged(n, string2);
    }

    public void notifyQtAndroidPluginRunning(boolean bl) {
        this.m_isPluginRunning = bl;
    }

    public void initializeAccessibility() {
        this.m_accessibilityDelegate = new QtAccessibilityDelegate(this.m_activity, this.m_layout, this);
    }

    public void onWindowFocusChanged(boolean bl) {
        try {
            this.m_super_onWindowFocusChanged.invoke((Object)this.m_activity, bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bl) {
            this.updateFullScreen();
        }
    }

    public void onConfigurationChanged(Configuration configuration) {
        try {
            this.m_super_onConfigurationChanged.invoke((Object)this.m_activity, configuration);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onDestroy() {
        if (this.m_quitApp) {
            QtNative.terminateQt();
            QtNative.setActivity(null, null);
            QtNative.m_qtThread.exit();
            System.exit(0);
        }
    }

    public void onPause() {
        if (Build.VERSION.SDK_INT < 24 || !this.m_activity.isInMultiWindowMode()) {
            QtNative.setApplicationState(2);
        }
    }

    public void onResume() {
        QtNative.setApplicationState(4);
        if (this.m_started) {
            QtNative.updateWindow();
            this.updateFullScreen();
        }
    }

    public void onNewIntent(Intent intent) {
        QtNative.onNewIntent(intent);
    }

    public void onActivityResult(int n, int n2, Intent intent) {
        try {
            this.m_super_onActivityResult.invoke((Object)this.m_activity, n, n2, intent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        QtNative.onActivityResult(n, n2, intent);
    }

    public void onStop() {
        QtNative.setApplicationState(0);
    }

    public Object onRetainNonConfigurationInstance() {
        try {
            this.m_super_onRetainNonConfigurationInstance.invoke((Object)this.m_activity, new Object[0]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_quitApp = false;
        return true;
    }

    public void onSaveInstanceState(Bundle bundle) {
        try {
            this.m_super_onSaveInstanceState.invoke((Object)this.m_activity, bundle);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        bundle.putBoolean("FullScreen", this.m_fullScreen);
        bundle.putBoolean("Started", this.m_started);
    }

    public void onRestoreInstanceState(Bundle bundle) {
        try {
            this.m_super_onRestoreInstanceState.invoke((Object)this.m_activity, bundle);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.m_started = bundle.getBoolean("Started");
    }

    public boolean onKeyDown(int n, KeyEvent keyEvent) {
        int n2;
        if (!this.m_started || !this.m_isPluginRunning) {
            return false;
        }
        this.m_metaState = MetaKeyKeyListener.handleKeyDown((long)this.m_metaState, (int)n, (KeyEvent)keyEvent);
        int n3 = n2 = keyEvent.getUnicodeChar(MetaKeyKeyListener.getMetaState((long)this.m_metaState) | keyEvent.getMetaState());
        this.m_metaState = MetaKeyKeyListener.adjustMetaAfterKeypress((long)this.m_metaState);
        if ((n2 & Integer.MIN_VALUE) != 0) {
            int n4;
            n2 &= Integer.MAX_VALUE;
            n2 = n4 = KeyEvent.getDeadChar((int)this.m_lastChar, (int)n2);
        }
        if ((n == 24 || n == 25 || n == 91) && System.getenv("QT_ANDROID_VOLUME_KEYS") == null) {
            return false;
        }
        this.m_lastChar = n3;
        if (n == 4) {
            boolean bl = this.m_backKeyPressedSent = !this.m_keyboardIsVisible;
            if (!this.m_backKeyPressedSent) {
                return true;
            }
        }
        QtNative.keyDown(n, n2, keyEvent.getMetaState(), keyEvent.getRepeatCount() > 0);
        return true;
    }

    public boolean onKeyUp(int n, KeyEvent keyEvent) {
        if (!this.m_started || !this.m_isPluginRunning) {
            return false;
        }
        if ((n == 24 || n == 25 || n == 91) && System.getenv("QT_ANDROID_VOLUME_KEYS") == null) {
            return false;
        }
        if (n == 4 && !this.m_backKeyPressedSent) {
            this.hideSoftwareKeyboard();
            this.setKeyboardVisibility(false, System.nanoTime());
            return true;
        }
        this.m_metaState = MetaKeyKeyListener.handleKeyUp((long)this.m_metaState, (int)n, (KeyEvent)keyEvent);
        QtNative.keyUp(n, keyEvent.getUnicodeChar(), keyEvent.getMetaState(), keyEvent.getRepeatCount() > 0);
        return true;
    }

    public boolean dispatchKeyEvent(KeyEvent keyEvent) {
        if (this.m_started && keyEvent.getAction() == 2 && keyEvent.getCharacters() != null && keyEvent.getCharacters().length() == 1 && keyEvent.getKeyCode() == 0) {
            QtNative.keyDown(0, keyEvent.getCharacters().charAt(0), keyEvent.getMetaState(), keyEvent.getRepeatCount() > 0);
            QtNative.keyUp(0, keyEvent.getCharacters().charAt(0), keyEvent.getMetaState(), keyEvent.getRepeatCount() > 0);
        }
        if (QtNative.dispatchKeyEvent(keyEvent)) {
            return true;
        }
        try {
            return (Boolean)this.m_super_dispatchKeyEvent.invoke((Object)this.m_activity, keyEvent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        menu.clear();
        return true;
    }

    public boolean onPrepareOptionsMenu(Menu menu) {
        this.m_optionsMenuIsVisible = true;
        boolean bl = QtNative.onPrepareOptionsMenu(menu);
        this.setActionBarVisibility(bl && menu.size() > 0);
        return bl;
    }

    public boolean onOptionsItemSelected(MenuItem menuItem) {
        return QtNative.onOptionsItemSelected(menuItem.getItemId(), menuItem.isChecked());
    }

    public void onOptionsMenuClosed(Menu menu) {
        this.m_optionsMenuIsVisible = false;
        QtNative.onOptionsMenuClosed(menu);
    }

    public void resetOptionsMenu() {
        this.m_activity.invalidateOptionsMenu();
    }

    public void onCreateContextMenu(ContextMenu contextMenu, View view, ContextMenu.ContextMenuInfo contextMenuInfo) {
        contextMenu.clearHeader();
        QtNative.onCreateContextMenu(contextMenu);
        this.m_contextMenuVisible = true;
    }

    public void onCreatePopupMenu(Menu menu) {
        QtNative.fillContextMenu(menu);
        this.m_contextMenuVisible = true;
    }

    public void onContextMenuClosed(Menu menu) {
        if (!this.m_contextMenuVisible) {
            return;
        }
        this.m_contextMenuVisible = false;
        QtNative.onContextMenuClosed(menu);
    }

    public boolean onContextItemSelected(MenuItem menuItem) {
        this.m_contextMenuVisible = false;
        return QtNative.onContextItemSelected(menuItem.getItemId(), menuItem.isChecked());
    }

    public void openContextMenu(final int n, final int n2, final int n3, final int n4) {
        this.m_layout.postDelayed(new Runnable(){

            @Override
            public void run() {
                QtActivityDelegate.this.m_layout.setLayoutParams(QtActivityDelegate.this.m_editText, new QtLayout.LayoutParams(n3, n4, n, n2), false);
                PopupMenu popupMenu = new PopupMenu((Context)QtActivityDelegate.this.m_activity, (View)QtActivityDelegate.this.m_editText);
                QtActivityDelegate.this.onCreatePopupMenu(popupMenu.getMenu());
                popupMenu.setOnMenuItemClickListener(new PopupMenu.OnMenuItemClickListener(){

                    public boolean onMenuItemClick(MenuItem menuItem) {
                        return QtActivityDelegate.this.onContextItemSelected(menuItem);
                    }
                });
                popupMenu.setOnDismissListener(new PopupMenu.OnDismissListener(){

                    public void onDismiss(PopupMenu popupMenu) {
                        QtActivityDelegate.this.onContextMenuClosed(popupMenu.getMenu());
                    }
                });
                popupMenu.show();
            }
        }, 100L);
    }

    public void closeContextMenu() {
        this.m_activity.closeContextMenu();
    }

    private void setActionBarVisibility(boolean bl) {
        if (this.m_activity.getActionBar() == null) {
            return;
        }
        if (ViewConfiguration.get((Context)this.m_activity).hasPermanentMenuKey() || !bl) {
            this.m_activity.getActionBar().hide();
        } else {
            this.m_activity.getActionBar().show();
        }
    }

    public void insertNativeView(int n, View view, int n2, int n3, int n4, int n5) {
        if (this.m_dummyView != null) {
            this.m_layout.removeView(this.m_dummyView);
            this.m_dummyView = null;
        }
        if (this.m_nativeViews.containsKey(n)) {
            this.m_layout.removeView(this.m_nativeViews.remove(n));
        }
        if (n4 < 0 || n5 < 0) {
            view.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        } else {
            view.setLayoutParams((ViewGroup.LayoutParams)new QtLayout.LayoutParams(n4, n5, n2, n3));
        }
        view.setId(n);
        this.m_layout.addView(view);
        this.m_nativeViews.put(n, view);
    }

    public void createSurface(int n, boolean bl, int n2, int n3, int n4, int n5, int n6) {
        Object object;
        if (this.m_surfaces.size() == 0) {
            object = new TypedValue();
            this.m_activity.getTheme().resolveAttribute(16842836, object, true);
            if (object.type >= 28 && object.type <= 31) {
                this.m_activity.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(object.data));
            } else {
                this.m_activity.getWindow().setBackgroundDrawable(this.m_activity.getResources().getDrawable(object.resourceId));
            }
            if (this.m_dummyView != null) {
                this.m_layout.removeView(this.m_dummyView);
                this.m_dummyView = null;
            }
        }
        if (this.m_surfaces.containsKey(n)) {
            this.m_layout.removeView((View)this.m_surfaces.remove(n));
        }
        object = new QtSurface((Context)this.m_activity, n, bl, n6);
        if (n4 < 0 || n5 < 0) {
            object.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        } else {
            object.setLayoutParams((ViewGroup.LayoutParams)new QtLayout.LayoutParams(n4, n5, n2, n3));
        }
        int n7 = this.getSurfaceCount();
        this.m_layout.addView((View)object, n7);
        this.m_surfaces.put(n, (QtSurface)((Object)object));
        if (!this.m_splashScreenSticky) {
            this.hideSplashScreen();
        }
    }

    public void setSurfaceGeometry(int n, int n2, int n3, int n4, int n5) {
        if (this.m_surfaces.containsKey(n)) {
            QtSurface qtSurface = this.m_surfaces.get(n);
            qtSurface.setLayoutParams(new QtLayout.LayoutParams(n4, n5, n2, n3));
        } else if (this.m_nativeViews.containsKey(n)) {
            View view = this.m_nativeViews.get(n);
            view.setLayoutParams((ViewGroup.LayoutParams)new QtLayout.LayoutParams(n4, n5, n2, n3));
        } else {
            Log.e((String)"Qt JAVA", (String)("Surface " + n + " not found!"));
            return;
        }
    }

    public void destroySurface(int n) {
        View view = null;
        if (this.m_surfaces.containsKey(n)) {
            view = (View)this.m_surfaces.remove(n);
        } else if (this.m_nativeViews.containsKey(n)) {
            view = this.m_nativeViews.remove(n);
        } else {
            Log.e((String)"Qt JAVA", (String)("Surface " + n + " not found!"));
        }
        if (view == null) {
            return;
        }
        if (this.m_surfaces.size() == 0 && this.m_nativeViews.size() == 0) {
            this.m_dummyView = view;
        } else {
            this.m_layout.removeView(view);
        }
    }

    public int getSurfaceCount() {
        return this.m_surfaces.size();
    }

    public void bringChildToFront(int n) {
        View view = (View)this.m_surfaces.get(n);
        if (view != null) {
            int n2 = this.getSurfaceCount();
            if (n2 > 0) {
                this.m_layout.moveChild(view, n2 - 1);
            }
            return;
        }
        view = this.m_nativeViews.get(n);
        if (view != null) {
            this.m_layout.moveChild(view, -1);
        }
    }

    public void bringChildToBack(int n) {
        View view = (View)this.m_surfaces.get(n);
        if (view != null) {
            this.m_layout.moveChild(view, 0);
            return;
        }
        view = this.m_nativeViews.get(n);
        if (view != null) {
            int n2 = this.getSurfaceCount();
            this.m_layout.moveChild(view, n2);
        }
    }

    public boolean dispatchGenericMotionEvent(MotionEvent motionEvent) {
        if (this.m_started && QtNative.dispatchGenericMotionEvent(motionEvent)) {
            return true;
        }
        try {
            return (Boolean)this.m_super_dispatchGenericMotionEvent.invoke((Object)this.m_activity, motionEvent);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public void onRequestPermissionsResult(int n, String[] stringArray, int[] nArray) {
        QtNative.sendRequestPermissionsResult(n, stringArray, nArray);
    }
}

