#!/sbin/sh
# 
# ADDOND_VERSION=2
# 
# /system/addon.d/69-flame.sh
#
. /tmp/backuptool.functions

mount_extras() {
  local ab_device=$(getprop ro.build.ab_update)
  local dynamic_partition=$(getprop ro.boot.dynamic_partitions)
  if [ -z "$ab_device" ]; then
    for block in product system_ext vendor; do
      if [ -e /$block ]; then
        if [ "$dynamic_partition" = "true" ]; then
          mount -o ro -t auto /dev/block/mapper/$block /$block 2>/dev/null
          blockdev --setrw /dev/block/mapper/$block 2>/dev/null
          mount -o rw,remount -t auto /dev/block/mapper/$block /$block 2>/dev/null
        else
          mount -o ro -t auto /$block 2>/dev/null
          mount -o rw,remount -t auto /$block 2>/dev/null
        fi
      fi
    done
  fi
}

unmount_extras() {
  umount /product /system_ext /vendor 2>/dev/null
}

if [ -z $backuptool_ab ]; then
  SYS=$S
  TMP=/tmp
else
  SYS=/postinstall/system
  TMP=/postinstall/tmp
fi

list_files() {
cat <<EOF
app/GoogleExtShared/GoogleExtShared.apk
app/GoogleContactsSyncAdapter/GoogleContactsSyncAdapter.apk
app/GoogleCalendarSyncAdapter/GoogleCalendarSyncAdapter.apk
app/SoundPickerPrebuilt/SoundPickerPrebuilt.apk
app/MarkupGoogle/MarkupGoogle.apk
priv-app/GoogleExtServices/GoogleExtServices.apk
priv-app/CarrierSetup/CarrierSetup.apk
priv-app/ConfigUpdater/ConfigUpdater.apk
priv-app/GmsCoreSetupPrebuilt/GmsCoreSetupPrebuilt.apk
priv-app/AndroidMigratePrebuilt/AndroidMigratePrebuilt.apk
priv-app/GoogleBackupTransport/GoogleBackupTransport.apk
priv-app/GoogleRestore/GoogleRestore.apk
priv-app/GoogleServicesFramework/GoogleServicesFramework.apk
priv-app/GooglePackageInstaller/GooglePackageInstaller.apk
priv-app/Phonesky/Phonesky.apk
priv-app/PrebuiltGmsCore/PrebuiltGmsCore.apk
priv-app/SetupWizard/SetupWizard.apk
priv-app/WellbeingPrebuilt/WellbeingPrebuilt.apk
etc/default-permissions/default-permissions.xml
etc/default-permissions/opengapps-permissions.xml
etc/permissions/com.google.android.dialer.support.xml
etc/permissions/com.google.android.maps.xml
etc/permissions/com.google.android.media.effects.xml
etc/permissions/privapp-permissions-google.xml
etc/permissions/split-permissions-google.xml
etc/preferred-apps/google.xml
etc/sysconfig/dialer_experience.xml
etc/sysconfig/google-hiddenapi-package-whitelist.xml
etc/sysconfig/google.xml
etc/sysconfig/nexus.xml
etc/sysconfig/pixel_2018_exclusive.xml
etc/sysconfig/pixel_experience_2017.xml
etc/sysconfig/pixel_experience_2018.xml
etc/sysconfig/google_build.xml
etc/sysconfig/google_exclusives_enable.xml
etc/flame.prop
framework/com.google.android.dialer.support.jar
framework/com.google.android.maps.jar
framework/com.google.android.media.effects.jar
lib64/libsketchology_native.so
EOF
}

rm_list="
app/ExtShared
app/FaceLock
app/GoogleExtShared
app/GoogleContactSyncAdapter
priv-app/ExtServices
priv-app/AndroidPlatformServices
priv-app/GoogleServicesFramework
priv-app/GmsCoreSetupPrebuilt
priv-app/GmsCore
priv-app/PackageInstaller
priv-app/GooglePackageInstaller
priv-app/PrebuiltGmsCore
priv-app/PrebuiltGmsCorePi
priv-app/PrebuiltGmsCoreQt
priv-app/Phonesky
priv-app/Wellbeing
priv-app/WellbeingGooglePrebuilt
priv-app/WellbeingPrebuilt
priv-app/SetupWizard
priv-app/Provision
priv-app/LineageSetupWizard"

case "$1" in
  backup)
    list_files | while read -r FILE DUMMY; do
      backup_file "$S"/"$FILE"
    done
    unmount_extras
  ;;
  restore)
    list_files | while read -r FILE REPLACEMENT; do
      R=""
      [ -n "$REPLACEMENT" ] && R="$S/$REPLACEMENT"
      [ -f "$C/$S/$FILE" ] && restore_file "$S"/"$FILE" "$R"
    done
  ;;
  pre-backup)
    mount_extras
  ;;
  post-backup)
    # Stub
  ;;
  pre-restore)
    mount_extras
    # Remove AOSP apps
    for f in $rm_list; do
      rm -rf $SYS/$f
      rm -rf $SYS/product/$f
      rm -rf $SYS/system_ext/$f
    done
    
  ;;
  post-restore)
    # Create lib symlinks
    install -d "$SYS/app/MarkupGoogle/lib/arm64"
    ln -sfn "$SYS/lib64/libsketchology_native.so" "$SYS/app/MarkupGoogle/lib/arm64/libsketchology_native.so"

    for i in $(list_files); do
      chown root:root "$SYS/$i"
      chmod 644 "$SYS/$i"
      chmod 755 "$(dirname "$SYS/$i")"
    done
    unmount_extras
    chmod 600 $SYS/build.prop
  ;;
esac

