#!/sbin/sh
# 
# ADDOND_VERSION=2
#
. /tmp/backuptool.functions

mount_extras() {
  local ab_device=$(getprop ro.build.ab_update)
  local dynamic_partition=$(getprop ro.boot.dynamic_partitions)
  if [ -z "$ab_device" ]; then
    for block in product system_ext vendor; do
      if [ -e /$block ]; then
        if [ "$dynamic_partition" = "true" ]; then
          mount -o ro -t auto /dev/block/mapper/$block /$block 2>/dev/null
          blockdev --setrw /dev/block/mapper/$block 2>/dev/null
          mount -o rw,remount -t auto /dev/block/mapper/$block /$block 2>/dev/null
        else
          mount -o ro -t auto /$block 2>/dev/null
          mount -o rw,remount -t auto /$block 2>/dev/null
        fi
      fi
    done
  fi
}

unmount_extras() {
  umount /product /system_ext /vendor 2>/dev/null
}

if [ -z $backuptool_ab ]; then
  SYS=$S
  TMP=/tmp
else
  SYS=/postinstall/system
  TMP=/postinstall/tmp
fi

list_files() {
cat <<EOF
priv-app/MatchmakerPrebuilt/MatchmakerPrebuilt.apk
product/overlay/DevicePersonalizationServicesConfig.apk
EOF
}

rm_list="
priv-app/MatchmakerPrebuilt
priv-app/MatchmakerPrebuiltP4
priv-app/DevicePersonalizationPrebuiltPixel4
product/overlay/DevicePersonalizationServicesConfig.apk"

case "$1" in
  backup)
    list_files | while read -r FILE DUMMY; do
      backup_file "$S"/"$FILE"
    done
    unmount_extras
  ;;
  restore)
    list_files | while read -r FILE REPLACEMENT; do
      R=""
      [ -n "$REPLACEMENT" ] && R="$S/$REPLACEMENT"
      [ -f "$C/$S/$FILE" ] && restore_file "$S"/"$FILE" "$R"
    done
  ;;
  pre-backup)
    mount_extras
  ;;
  post-backup)
    # Stub
  ;;
  pre-restore)
    mount_extras
    # Remove AOSP apps
    for f in $rm_list; do
      rm -rf $SYS/$f
      rm -rf $SYS/product/$f
      if [ -e $SYS/system_ext ]; then
        rm -rf $SYS/system_ext/$f
      fi
    done
  ;;
  post-restore)
    ##
    for i in $(list_files); do
      chown root:root "$SYS/$i"
      chmod 644 "$SYS/$i"
      chmod 755 "$(dirname "$SYS/$i")"
    done
    
    unmount_extras

  ;;
esac

