#include "config.h"
#include "cygwin_version.h"

#define strval(x) #x
#define str(x) strval(x)
#define shared_data_version str(CYGWIN_VERSION_SHARED_DATA)

const char *cygwin_version_strings =
  "BEGIN_CYGWIN_VERSION_INFO\n"
  "%%% Cygwin dll major: 2011\n"
  "%%% Cygwin dll minor: 1\n"
  "%%% Cygwin dll epoch: 19\n"
  "%%% Cygwin dll old termios: 5\n"
  "%%% Cygwin dll malloc env: 28\n"
  "%%% Cygwin cygwin conv: 181\n"
  "%%% Cygwin api major: 0\n"
  "%%% Cygwin api minor: 329\n"
  "%%% Cygwin shared data: 5\n"
  "%%% Cygwin dll identifier: cygwin1\n"
  "%%% Cygwin mount registry: 3\n"
  "%%% Cygwin cygwin registry name: Cygwin\n"
  "%%% Cygwin installations name: Installations\n"
  "%%% Cygwin cygdrive default prefix: \n"
  "%%% Cygwin build date: \n"
#ifdef DEBUGGING
  "%%% Cygwin shared id: " CYGWIN_VERSION_DLL_IDENTIFIER "S" shared_data_version "-2018-11-08 21:30\n"
#else
  "%%% Cygwin shared id: " CYGWIN_VERSION_DLL_IDENTIFIER "S" shared_data_version "\n"
#endif
  "END_CYGWIN_VERSION_INFO\n\0";
cygwin_version_info cygwin_version =
{
  CYGWIN_VERSION_API_MAJOR, CYGWIN_VERSION_API_MINOR,
  CYGWIN_VERSION_DLL_MAJOR, CYGWIN_VERSION_DLL_MINOR,
  CYGWIN_VERSION_SHARED_DATA,
  CYGWIN_VERSION_MOUNT_REGISTRY,
  "2018-11-08 21:30",
#ifdef DEBUGGING
  CYGWIN_VERSION_DLL_IDENTIFIER "S" shared_data_version "-2018-11-08 21:30"
#else
  CYGWIN_VERSION_DLL_IDENTIFIER "S" shared_data_version
#endif
};
