/*
 * Decompiled with CFR 0.152.
 */
package org.jf.baksmali.Adaptors;

import java.io.IOException;
import org.jf.baksmali.BaksmaliOptions;
import org.jf.baksmali.formatter.BaksmaliWriter;

public class RegisterFormatter {
    public final BaksmaliOptions options;
    public final int registerCount;
    public final int parameterRegisterCount;

    public RegisterFormatter(BaksmaliOptions options, int registerCount, int parameterRegisterCount) {
        this.options = options;
        this.registerCount = registerCount;
        this.parameterRegisterCount = parameterRegisterCount;
    }

    public void writeRegisterRange(BaksmaliWriter writer, int startRegister, int lastRegister) throws IOException {
        if (this.options.parameterRegisters) {
            assert (startRegister <= lastRegister);
            if (startRegister >= this.registerCount - this.parameterRegisterCount) {
                writer.write("{p");
                writer.writeSignedIntAsDec(startRegister - (this.registerCount - this.parameterRegisterCount));
                writer.write(" .. p");
                writer.writeSignedIntAsDec(lastRegister - (this.registerCount - this.parameterRegisterCount));
                writer.write(125);
                return;
            }
        }
        writer.write("{v");
        writer.writeSignedIntAsDec(startRegister);
        writer.write(" .. v");
        writer.writeSignedIntAsDec(lastRegister);
        writer.write(125);
    }

    public void writeTo(BaksmaliWriter writer, int register) throws IOException {
        if (this.options.parameterRegisters && register >= this.registerCount - this.parameterRegisterCount) {
            writer.write(112);
            writer.writeSignedIntAsDec(register - (this.registerCount - this.parameterRegisterCount));
            return;
        }
        writer.write(118);
        writer.writeSignedIntAsDec(register);
    }
}

