/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.ui.swt.widget;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.herac.tuxguitar.ui.UIComponent;
import org.herac.tuxguitar.ui.event.UICloseEvent;
import org.herac.tuxguitar.ui.event.UICloseListener;
import org.herac.tuxguitar.ui.event.UICloseListenerManager;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.resource.UISize;
import org.herac.tuxguitar.ui.swt.event.SWTSelectionListenerManager;
import org.herac.tuxguitar.ui.swt.widget.SWTContainer;
import org.herac.tuxguitar.ui.swt.widget.SWTControl;
import org.herac.tuxguitar.ui.swt.widget.SWTTabItem;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UITabFolder;
import org.herac.tuxguitar.ui.widget.UITabItem;

public class SWTTabFolder
extends SWTControl<CTabFolder>
implements UITabFolder {
    private static final int TAB_HEIGHT = 28;
    private boolean showClose;
    private List<SWTTabItem> tabs = new ArrayList<SWTTabItem>();
    private UICloseListenerManager closeListener = new UICloseListenerManager();
    private SWTSelectionListenerManager selectionListener = new SWTSelectionListenerManager(this);

    public SWTTabFolder(SWTContainer<? extends Composite> container, boolean showClose) {
        super(new CTabFolder(container.getControl(), 128), container);
        this.showClose = showClose;
        ((CTabFolder)this.getControl()).setTabHeight(28);
        ((CTabFolder)this.getControl()).addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                SWTTabFolder.this.onTabClose(event);
            }
        });
        ((CTabFolder)this.getControl()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SWTTabFolder.this.onTabSelected();
            }
        });
    }

    public void dispose(SWTTabItem item) {
        if (this.tabs.contains(item)) {
            this.tabs.remove(item);
        }
        item.disposeControl();
    }

    public UITabItem createTab() {
        SWTTabItem tabItem = new SWTTabItem(new CTabItem((CTabFolder)this.getControl(), this.showClose ? 64 : 0), this);
        this.tabs.add(tabItem);
        return tabItem;
    }

    public List<UITabItem> getTabs() {
        return new ArrayList<UITabItem>(this.tabs);
    }

    public UITabItem findTab(CTabItem cTabItem) {
        if (cTabItem != null) {
            for (SWTTabItem tab : this.tabs) {
                if (!cTabItem.equals(tab.getItem())) continue;
                return tab;
            }
        }
        return null;
    }

    public UITabItem getSelectedTab() {
        return this.findTab(((CTabFolder)this.getControl()).getSelection());
    }

    public void setSelectedTab(UITabItem tab) {
        ((CTabFolder)this.getControl()).setSelection(((SWTTabItem)tab).getItem());
        this.onTabSelected();
    }

    public int getSelectedIndex() {
        return ((CTabFolder)this.getControl()).getSelectionIndex();
    }

    public void setSelectedIndex(int index) {
        ((CTabFolder)this.getControl()).setSelection(index);
        this.onTabSelected();
    }

    public void addSelectionListener(UISelectionListener listener) {
        if (this.selectionListener.isEmpty()) {
            ((CTabFolder)this.getControl()).addSelectionListener((SelectionListener)this.selectionListener);
        }
        this.selectionListener.addListener(listener);
    }

    public void removeSelectionListener(UISelectionListener listener) {
        this.selectionListener.removeListener(listener);
        if (this.selectionListener.isEmpty()) {
            ((CTabFolder)this.getControl()).removeSelectionListener((SelectionListener)this.selectionListener);
        }
    }

    public void addTabCloseListener(UICloseListener listener) {
        this.closeListener.addListener(listener);
    }

    public void removeTabCloseListener(UICloseListener listener) {
        this.closeListener.removeListener(listener);
    }

    public void onTabClose(CTabFolderEvent event) {
        event.doit = false;
        UITabItem uiTabItem = this.findTab((CTabItem)event.item);
        UICloseEvent uiCloseEvent = new UICloseEvent((UIComponent)uiTabItem);
        this.closeListener.onClose(uiCloseEvent);
    }

    public void onTabSelected() {
        UITabItem selectedTab = this.getSelectedTab();
        if (selectedTab != null) {
            ((SWTTabItem)selectedTab).onSelect();
        }
    }

    @Override
    public void computePackedSize() {
        for (UIControl uIControl : this.getTabs()) {
            uIControl.computePackedSize();
        }
        UISize packedSize = this.getPackedSize();
        if (packedSize.getWidth() == 0.0f && packedSize.getHeight() == 0.0f) {
            super.computePackedSize();
        }
    }
}

