/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.ui.swt.toolbar;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.herac.tuxguitar.ui.UIComponent;
import org.herac.tuxguitar.ui.resource.UIRectangle;
import org.herac.tuxguitar.ui.resource.UISize;
import org.herac.tuxguitar.ui.swt.SWTEnvironment;
import org.herac.tuxguitar.ui.swt.toolbar.SWTToolActionItem;
import org.herac.tuxguitar.ui.swt.toolbar.SWTToolActionMenuItem;
import org.herac.tuxguitar.ui.swt.toolbar.SWTToolCheckableItem;
import org.herac.tuxguitar.ui.swt.toolbar.SWTToolCustomItem;
import org.herac.tuxguitar.ui.swt.toolbar.SWTToolItem;
import org.herac.tuxguitar.ui.swt.toolbar.SWTToolMenuItem;
import org.herac.tuxguitar.ui.swt.widget.SWTContainer;
import org.herac.tuxguitar.ui.swt.widget.SWTControl;
import org.herac.tuxguitar.ui.toolbar.UIToolActionItem;
import org.herac.tuxguitar.ui.toolbar.UIToolActionMenuItem;
import org.herac.tuxguitar.ui.toolbar.UIToolBar;
import org.herac.tuxguitar.ui.toolbar.UIToolCheckableItem;
import org.herac.tuxguitar.ui.toolbar.UIToolCustomItem;
import org.herac.tuxguitar.ui.toolbar.UIToolMenuItem;

public class SWTToolBar
extends SWTControl<ToolBar>
implements UIToolBar {
    private boolean horizontal;
    private List<SWTToolItem> toolItems;
    private List<SWTToolCustomItem> toolCustomItems;

    public SWTToolBar(SWTContainer<? extends Composite> container, int orientation) {
        super(new ToolBar(container.getControl(), 0x800040 | orientation), container);
        this.horizontal = (orientation & 0x100) != 0;
        this.toolItems = new ArrayList<SWTToolItem>();
        this.toolCustomItems = new ArrayList<SWTToolCustomItem>();
    }

    public UIComponent createSeparator() {
        ToolItem toolItem = new ToolItem((ToolBar)this.getControl(), 2);
        return this.append(new SWTToolItem(toolItem, this));
    }

    public UIToolActionItem createActionItem() {
        ToolItem toolItem = new ToolItem((ToolBar)this.getControl(), 8);
        return (UIToolActionItem)this.append(new SWTToolActionItem(toolItem, this));
    }

    public UIToolCheckableItem createCheckItem() {
        ToolItem toolItem = new ToolItem((ToolBar)this.getControl(), 32);
        return (UIToolCheckableItem)this.append(new SWTToolCheckableItem(toolItem, this));
    }

    public UIToolMenuItem createMenuItem() {
        ToolItem toolItem = new ToolItem((ToolBar)this.getControl(), 8);
        return (UIToolMenuItem)this.append(new SWTToolMenuItem(toolItem, this));
    }

    public UIToolActionMenuItem createActionMenuItem() {
        ToolItem toolItem = new ToolItem((ToolBar)this.getControl(), 4);
        return (UIToolActionMenuItem)this.append(new SWTToolActionMenuItem(toolItem, this));
    }

    public UIToolCustomItem createCustomItem() {
        ToolItem toolItem = new ToolItem((ToolBar)this.getControl(), 2);
        return (UIToolCustomItem)this.append(new SWTToolCustomItem(toolItem, this));
    }

    public <T extends UIComponent> T append(SWTToolItem item) {
        this.toolItems.add(item);
        return (T)item;
    }

    public <T extends UIComponent> T append(SWTToolCustomItem item) {
        this.toolCustomItems.add(item);
        return (T)item;
    }

    public void dispose(SWTToolItem item) {
        if (this.toolItems.contains(item)) {
            this.toolItems.remove(item);
        }
        item.disposeControl();
    }

    public void dispose(SWTToolCustomItem item) {
        if (this.toolCustomItems.contains(item)) {
            this.toolCustomItems.remove(item);
        }
        item.disposeControl();
    }

    @Override
    public void computePackedSize() {
        super.computePackedSize();
        if (!this.toolCustomItems.isEmpty()) {
            UISize defaultPackedSize = this.getPackedSize();
            float packedSize = this.findClientMargin();
            for (SWTToolItem sWTToolItem : this.toolItems) {
                packedSize += (float)this.findLeftMargin((ToolItem)sWTToolItem.getControl());
                packedSize += (float)this.findItemWidth((ToolItem)sWTToolItem.getControl());
            }
            for (SWTToolCustomItem sWTToolCustomItem : this.toolCustomItems) {
                sWTToolCustomItem.computePackedSize();
                packedSize += (float)this.findLeftMargin(sWTToolCustomItem.getItem());
                packedSize += this.findSize(sWTToolCustomItem.getPackedSize());
            }
            if (this.horizontal) {
                defaultPackedSize.setWidth(packedSize);
            } else {
                defaultPackedSize.setHeight(packedSize);
            }
            super.setPackedSize(defaultPackedSize);
        }
    }

    @Override
    public void setBounds(UIRectangle bounds) {
        super.setBounds(this.getPreferredBounds(bounds));
        if (!this.toolCustomItems.isEmpty()) {
            int clientWidth = this.findSize(((ToolBar)this.getControl()).getClientArea());
            int itemsWidth = this.findClientMargin();
            int itemsHeight = 0;
            int itemsToFill = 0;
            for (SWTToolItem sWTToolItem : this.toolItems) {
                itemsWidth += this.findLeftMargin((ToolItem)sWTToolItem.getControl());
                itemsWidth += this.findItemWidth((ToolItem)sWTToolItem.getControl());
                itemsHeight = Math.max(itemsHeight, this.findHeight(((ToolItem)sWTToolItem.getControl()).getBounds()));
            }
            for (SWTToolCustomItem sWTToolCustomItem : this.toolCustomItems) {
                itemsWidth += this.findLeftMargin(sWTToolCustomItem.getItem());
                itemsWidth += Math.round(this.findSize(sWTToolCustomItem.getPackedSize()));
                itemsHeight = Math.max(itemsHeight, Math.round(this.findHeight(sWTToolCustomItem.getPackedSize())));
                if (!Boolean.TRUE.equals(sWTToolCustomItem.getLayoutAttribute("fill"))) continue;
                ++itemsToFill;
            }
            float widthToFill = itemsToFill > 0 && clientWidth > itemsWidth ? (clientWidth - itemsWidth) / itemsToFill : 0;
            for (SWTToolCustomItem control : this.toolCustomItems) {
                float controlWidth = this.findSize(control.getPackedSize());
                if (Boolean.TRUE.equals(control.getLayoutAttribute("fill"))) {
                    controlWidth += widthToFill;
                }
                int width = this.horizontal ? Math.round(controlWidth) : itemsHeight;
                int height = this.horizontal ? itemsHeight : Math.round(controlWidth);
                control.setSize(width, height);
            }
        }
    }

    private UIRectangle getPreferredBounds(UIRectangle bounds) {
        UIRectangle preferred = new UIRectangle(bounds.getPosition(), this.getPackedSize());
        if (this.horizontal) {
            preferred.getSize().setWidth(bounds.getWidth());
        } else {
            preferred.getSize().setHeight(bounds.getHeight());
        }
        return preferred;
    }

    private int findClientMargin() {
        ToolItem firstItem = this.findFirstItem();
        if (firstItem != null) {
            return this.findPosition(firstItem.getBounds()) * 2;
        }
        return 0;
    }

    private int findLeftMargin(ToolItem item) {
        ToolItem previousItem = this.findPreviousItem(item);
        if (previousItem != null) {
            Rectangle itemBounds = item.getBounds();
            Rectangle previousBounds = previousItem.getBounds();
            return Math.max(0, this.findPosition(itemBounds) - (this.findPosition(previousBounds) + this.findSize(previousBounds)));
        }
        return 0;
    }

    private ToolItem findFirstItem() {
        ToolItem[] items = ((ToolBar)this.getControl()).getItems();
        return items.length > 0 ? items[0] : null;
    }

    private ToolItem findPreviousItem(ToolItem item) {
        ToolItem[] items = ((ToolBar)this.getControl()).getItems();
        for (int i = 0; i < items.length; ++i) {
            if (!items[i].equals(item)) continue;
            return i > 0 ? items[i - 1] : null;
        }
        return null;
    }

    private int findItemWidth(ToolItem control) {
        return SWTEnvironment.getInstance().getToolItemWidth(control);
    }

    private int findPosition(Rectangle r) {
        return this.horizontal ? r.x : r.y;
    }

    private int findSize(Rectangle r) {
        return this.horizontal ? r.width : r.height;
    }

    private float findSize(UISize r) {
        return this.horizontal ? r.getWidth() : r.getHeight();
    }

    private int findHeight(Rectangle r) {
        return this.horizontal ? r.height : r.width;
    }

    private float findHeight(UISize r) {
        return this.horizontal ? r.getHeight() : r.getWidth();
    }
}

