/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.transport;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.document.TGDocumentContextAttributes;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.player.base.MidiPlayerMode;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UICheckBox;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIDropDownSelect;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UILegendPanel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIRadioButton;
import org.herac.tuxguitar.ui.widget.UISelectItem;
import org.herac.tuxguitar.ui.widget.UISpinner;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;

public class TGTransportModeDialog {
    protected static final int MIN_SELECTION = 1;
    protected static final int MAX_SELECTION = 500;
    protected static final int[] DEFAULT_PERCENTS = new int[]{25, 50, 75, 100, 125, 150, 175, 200};
    private TGViewContext context;
    protected UIRadioButton simple;
    protected UICheckBox simpleLoop;
    protected UIDropDownSelect<Integer> simplePercent;
    protected UIRadioButton custom;
    protected UISpinner customFrom;
    protected UISpinner customTo;
    protected UISpinner customIncrement;
    protected UIDropDownSelect<Integer> loopSHeader;
    protected UIDropDownSelect<Integer> loopEHeader;

    public TGTransportModeDialog(TGViewContext context) {
        this.context = context;
    }

    public void show() {
        MidiPlayerMode mode = MidiPlayer.getInstance((TGContext)this.context.getContext()).getMode();
        UIFactory uiFactory = TGApplication.getInstance(this.context.getContext()).getFactory();
        UIWindow uiParent = (UIWindow)this.context.getAttribute("parent");
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(uiParent, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setText(TuxGuitar.getProperty("transport.mode"));
        this.simple = uiFactory.createRadioButton((UIContainer)dialog);
        this.simple.setText(TuxGuitar.getProperty("transport.mode.simple"));
        this.simple.setSelected(mode.getType() == 1);
        dialogLayout.set((UIControl)this.simple, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        RadioSelectionAdapter simpleAdapter = new RadioSelectionAdapter(this.simple);
        UITableLayout simpleLayout = new UITableLayout();
        UILegendPanel simpleGroup = uiFactory.createLegendPanel((UIContainer)dialog);
        simpleGroup.setLayout((UILayout)simpleLayout);
        simpleGroup.setText(TuxGuitar.getProperty("transport.mode.simple"));
        simpleAdapter.addControl((UIControl)simpleGroup);
        dialogLayout.set((UIControl)simpleGroup, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel simplePercentLabel = uiFactory.createLabel((UIContainer)simpleGroup);
        simplePercentLabel.setText(TuxGuitar.getProperty("transport.mode.simple.tempo-percent"));
        simpleLayout.set((UIControl)simplePercentLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        simpleAdapter.addControl((UIControl)simplePercentLabel);
        this.simplePercent = uiFactory.createDropDownSelect((UIContainer)simpleGroup);
        for (int i = 0; i < DEFAULT_PERCENTS.length; ++i) {
            this.simplePercent.addItem(new UISelectItem(Integer.toString(DEFAULT_PERCENTS[i]) + "%", (Object)DEFAULT_PERCENTS[i]));
        }
        this.simplePercent.setSelectedValue((Object)mode.getSimplePercent());
        simpleLayout.set(this.simplePercent, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        simpleAdapter.addControl((UIControl)this.simplePercent);
        this.simpleLoop = uiFactory.createCheckBox((UIContainer)simpleGroup);
        this.simpleLoop.setText(TuxGuitar.getProperty("transport.mode.simple.loop"));
        this.simpleLoop.setSelected(mode.isLoop());
        simpleLayout.set((UIControl)this.simpleLoop, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(2));
        simpleAdapter.addControl((UIControl)this.simpleLoop);
        this.custom = uiFactory.createRadioButton((UIContainer)dialog);
        this.custom.setText(TuxGuitar.getProperty("transport.mode.trainer"));
        this.custom.setSelected(mode.getType() == 2);
        dialogLayout.set((UIControl)this.custom, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        RadioSelectionAdapter customAdapter = new RadioSelectionAdapter(this.custom);
        UITableLayout customLayout = new UITableLayout();
        UILegendPanel customGroup = uiFactory.createLegendPanel((UIContainer)dialog);
        customGroup.setLayout((UILayout)customLayout);
        customGroup.setText(TuxGuitar.getProperty("transport.mode.trainer"));
        customAdapter.addControl((UIControl)customGroup);
        dialogLayout.set((UIControl)customGroup, Integer.valueOf(4), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel tempoLabel = uiFactory.createLabel((UIContainer)customGroup);
        tempoLabel.setText(TuxGuitar.getProperty("composition.tempo"));
        customLayout.set((UIControl)tempoLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        customAdapter.addControl((UIControl)tempoLabel);
        this.customFrom = uiFactory.createSpinner((UIContainer)customGroup);
        this.customFrom.setMinimum(1);
        this.customFrom.setMaximum(500);
        this.customFrom.setValue(mode.getCustomPercentFrom());
        customAdapter.addControl((UIControl)this.customFrom);
        customLayout.set((UIControl)this.customFrom, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel tempoPercentLabel = uiFactory.createLabel((UIContainer)customGroup);
        tempoPercentLabel.setText("%");
        customLayout.set((UIControl)tempoPercentLabel, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        customAdapter.addControl((UIControl)tempoPercentLabel);
        UILabel tempoToLabel = uiFactory.createLabel((UIContainer)customGroup);
        tempoToLabel.setText(TuxGuitar.getProperty("edit.to"));
        customLayout.set((UIControl)tempoToLabel, Integer.valueOf(1), Integer.valueOf(4), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        customAdapter.addControl((UIControl)tempoToLabel);
        this.customTo = uiFactory.createSpinner((UIContainer)customGroup);
        this.customTo.setMinimum(1);
        this.customTo.setMaximum(500);
        this.customTo.setValue(mode.getCustomPercentTo());
        customLayout.set((UIControl)this.customTo, Integer.valueOf(1), Integer.valueOf(5), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        customAdapter.addControl((UIControl)this.customTo);
        UILabel tempoToPercentLabel = uiFactory.createLabel((UIContainer)customGroup);
        tempoToPercentLabel.setText("%");
        customLayout.set((UIControl)tempoToPercentLabel, Integer.valueOf(1), Integer.valueOf(6), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        customAdapter.addControl((UIControl)tempoToPercentLabel);
        UILabel incrementLabel = uiFactory.createLabel((UIContainer)customGroup);
        incrementLabel.setText(TuxGuitar.getProperty("transport.mode.trainer.increment-description"));
        customLayout.set((UIControl)incrementLabel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(4));
        customAdapter.addControl((UIControl)incrementLabel);
        this.customIncrement = uiFactory.createSpinner((UIContainer)customGroup);
        this.customIncrement.setMinimum(1);
        this.customIncrement.setMaximum(500);
        this.customIncrement.setValue(mode.getCustomPercentIncrement());
        customLayout.set((UIControl)this.customIncrement, Integer.valueOf(2), Integer.valueOf(5), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        customAdapter.addControl((UIControl)this.customIncrement);
        UILabel incrementPercentLabel = uiFactory.createLabel((UIContainer)customGroup);
        incrementPercentLabel.setText("%");
        customLayout.set((UIControl)incrementPercentLabel, Integer.valueOf(2), Integer.valueOf(6), UITableLayout.ALIGN_LEFT, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        customAdapter.addControl((UIControl)incrementPercentLabel);
        SpinnerSelectionAdapter spinnerAdapter = new SpinnerSelectionAdapter(this.customFrom, this.customTo, this.customIncrement);
        this.customFrom.addSelectionListener((UISelectionListener)spinnerAdapter);
        this.customTo.addSelectionListener((UISelectionListener)spinnerAdapter);
        this.customIncrement.addSelectionListener((UISelectionListener)spinnerAdapter);
        MHeaderRangeStatus mHeaderRangeStatus = new MHeaderRangeStatus(this.simple, this.simpleLoop, this.custom);
        UITableLayout rangeLayout = new UITableLayout();
        UILegendPanel rangeGroup = uiFactory.createLegendPanel((UIContainer)dialog);
        rangeGroup.setLayout((UILayout)rangeLayout);
        rangeGroup.setText(TuxGuitar.getProperty("transport.mode.loop-range"));
        dialogLayout.set((UIControl)rangeGroup, Integer.valueOf(5), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        mHeaderRangeStatus.addControl((UIControl)rangeGroup);
        UILabel loopSLabel = uiFactory.createLabel((UIContainer)rangeGroup);
        loopSLabel.setText(TuxGuitar.getProperty("transport.mode.loop-range.from"));
        rangeLayout.set((UIControl)loopSLabel, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        mHeaderRangeStatus.addControl((UIControl)loopSLabel);
        this.loopSHeader = uiFactory.createDropDownSelect((UIContainer)rangeGroup);
        rangeLayout.set(this.loopSHeader, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        mHeaderRangeStatus.addControl((UIControl)this.loopSHeader);
        UILabel loopELabel = uiFactory.createLabel((UIContainer)rangeGroup);
        loopELabel.setText(TuxGuitar.getProperty("transport.mode.loop-range.to"));
        rangeLayout.set((UIControl)loopELabel, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(false), Boolean.valueOf(true));
        mHeaderRangeStatus.addControl((UIControl)loopELabel);
        this.loopEHeader = uiFactory.createDropDownSelect((UIContainer)rangeGroup);
        rangeLayout.set(this.loopEHeader, Integer.valueOf(2), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        mHeaderRangeStatus.addControl((UIControl)this.loopEHeader);
        MHeaderComboController mHeaderController = new MHeaderComboController(this.loopSHeader, this.loopEHeader);
        mHeaderController.updateLoopSHeader(mode.getLoopSHeader());
        mHeaderController.updateLoopEHeader(mode.getLoopSHeader(), mode.getLoopEHeader());
        mHeaderController.appendListener();
        simpleAdapter.update();
        customAdapter.update();
        mHeaderRangeStatus.update();
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(6), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty("ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGTransportModeDialog.this.changeTransportMode();
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty("cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog(dialog, 5);
    }

    public void changeTransportMode() {
        Integer type = this.custom.isSelected() ? 2 : 1;
        Boolean loop = type == 2 || type == 1 && this.simpleLoop.isSelected();
        Integer simplePercent = (Integer)this.simplePercent.getSelectedValue();
        Integer loopSHeader = (Integer)this.loopSHeader.getSelectedValue();
        Integer loopEHeader = (Integer)this.loopEHeader.getSelectedValue();
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context.getContext(), "action.transport.mode");
        tgActionProcessor.setAttribute("type", (Object)type);
        tgActionProcessor.setAttribute("loop", (Object)loop);
        tgActionProcessor.setAttribute("simplePercent", (Object)(simplePercent != null ? simplePercent : 100));
        tgActionProcessor.setAttribute("customPercentFrom", (Object)this.customFrom.getValue());
        tgActionProcessor.setAttribute("customPercentTo", (Object)this.customTo.getValue());
        tgActionProcessor.setAttribute("customPercentIncrement", (Object)this.customIncrement.getValue());
        tgActionProcessor.setAttribute("loopSHeader", (Object)(loop != false && loopSHeader != null ? loopSHeader : -1));
        tgActionProcessor.setAttribute("loopEHeader", (Object)(loop != false && loopEHeader != null ? loopEHeader : -1));
        tgActionProcessor.process();
    }

    private class MHeaderComboController {
        protected UIDropDownSelect<Integer> loopSHeader;
        protected UIDropDownSelect<Integer> loopEHeader;

        public MHeaderComboController(UIDropDownSelect<Integer> loopSHeader, UIDropDownSelect<Integer> loopEHeader) {
            this.loopSHeader = loopSHeader;
            this.loopEHeader = loopEHeader;
        }

        public void updateLoopSHeader(int sHeader) {
            TGSong song = (TGSong)TGTransportModeDialog.this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
            this.loopSHeader.removeItems();
            this.loopSHeader.addItem(new UISelectItem(TuxGuitar.getProperty("transport.mode.loop-range.from-default"), (Object)-1));
            for (int i = 0; i < song.countMeasureHeaders(); ++i) {
                TGMeasureHeader header = song.getMeasureHeader(i);
                this.loopSHeader.addItem(new UISelectItem(this.getItemText(header), (Object)header.getNumber()));
            }
            this.loopSHeader.setSelectedValue((Object)sHeader);
        }

        public void updateLoopEHeader(Integer sHeader, Integer eHeader) {
            TGSong song = (TGSong)TGTransportModeDialog.this.context.getAttribute(TGDocumentContextAttributes.ATTRIBUTE_SONG);
            this.loopEHeader.removeItems();
            this.loopEHeader.addItem(new UISelectItem(TuxGuitar.getProperty("transport.mode.loop-range.to-default"), (Object)-1));
            for (int i = 0; i < song.countMeasureHeaders(); ++i) {
                TGMeasureHeader header = song.getMeasureHeader(i);
                if (sHeader != null && header.getNumber() < sHeader) continue;
                this.loopEHeader.addItem(new UISelectItem(this.getItemText(header), (Object)header.getNumber()));
            }
            this.loopEHeader.setSelectedValue((Object)eHeader);
        }

        public void updateLoopEHeader() {
            Integer sHeader = (Integer)this.loopSHeader.getSelectedValue();
            Integer eHeader = (Integer)this.loopEHeader.getSelectedValue();
            if (eHeader != null && sHeader != null && sHeader > eHeader) {
                eHeader = sHeader;
            }
            this.updateLoopEHeader(sHeader, eHeader);
        }

        public String getItemText(TGMeasureHeader header) {
            String text = "#" + header.getNumber();
            if (header.hasMarker()) {
                text = text + " (" + header.getMarker().getTitle() + ")";
            }
            return text;
        }

        public void appendListener() {
            this.loopSHeader.addSelectionListener(new UISelectionListener(){

                public void onSelect(UISelectionEvent event) {
                    MHeaderComboController.this.updateLoopEHeader();
                }
            });
        }
    }

    private class MHeaderRangeStatus
    implements UISelectionListener {
        private List<UIControl> controls = new ArrayList<UIControl>();
        private boolean enabled = false;
        private UIRadioButton simpleMode;
        private UICheckBox simpleLoop;
        private UIRadioButton customLoop;

        public MHeaderRangeStatus(UIRadioButton simpleMode, UICheckBox simpleLoop, UIRadioButton customLoop) {
            this.simpleMode = simpleMode;
            this.simpleLoop = simpleLoop;
            this.customLoop = customLoop;
            this.simpleMode.addSelectionListener((UISelectionListener)this);
            this.simpleLoop.addSelectionListener((UISelectionListener)this);
            this.customLoop.addSelectionListener((UISelectionListener)this);
        }

        public void addControl(UIControl control) {
            this.controls.add(control);
        }

        public void update() {
            this.enabled = this.customLoop.isSelected();
            if (!this.enabled && this.simpleMode.isSelected()) {
                this.enabled = this.simpleLoop.isSelected();
            }
            for (UIControl uiControl : this.controls) {
                uiControl.setEnabled(this.enabled);
            }
        }

        public void onSelect(UISelectionEvent event) {
            this.update();
        }
    }

    private class SpinnerSelectionAdapter
    implements UISelectionListener {
        private UISpinner to;
        private UISpinner from;
        private UISpinner increment;

        public SpinnerSelectionAdapter(UISpinner from, UISpinner to, UISpinner increment) {
            this.from = from;
            this.to = to;
            this.increment = increment;
        }

        public void onSelect(UISelectionEvent event) {
            if (event.getComponent().equals(this.from)) {
                if (this.from.getValue() < 1) {
                    this.from.setValue(1);
                } else if (this.from.getValue() >= this.to.getValue()) {
                    this.from.setValue(this.to.getValue() - 1);
                }
            } else if (event.getComponent().equals(this.to)) {
                if (this.to.getValue() <= this.from.getValue()) {
                    this.to.setValue(this.from.getValue() + 1);
                } else if (this.to.getValue() > 500) {
                    this.to.setValue(500);
                }
            }
            if (this.increment.getValue() > this.to.getValue() - this.from.getValue()) {
                this.increment.setValue(this.to.getValue() - this.from.getValue());
            }
        }
    }

    private class RadioSelectionAdapter
    implements UISelectionListener {
        private UIRadioButton control;
        private List<UIControl> controls = new ArrayList<UIControl>();

        public RadioSelectionAdapter(UIRadioButton control) {
            this.control = control;
            this.control.addSelectionListener((UISelectionListener)this);
        }

        public void addControl(UIControl control) {
            this.controls.add(control);
        }

        public void update() {
            boolean enabled = this.control.isSelected();
            for (UIControl control : this.controls) {
                control.setEnabled(enabled);
            }
        }

        public void onSelect(UISelectionEvent event) {
            this.update();
        }
    }
}

