/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.system.language;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import org.herac.tuxguitar.app.system.language.TGLanguageEvent;
import org.herac.tuxguitar.app.system.language.TGResourceBundle;
import org.herac.tuxguitar.app.util.TGFileUtils;
import org.herac.tuxguitar.event.TGEvent;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.event.TGEventManager;
import org.herac.tuxguitar.util.TGContext;

public class TGLanguageManager {
    public static final String PACKAGE = "lang";
    public static final String PREFIX = "messages";
    public static final String EXTENSION = ".properties";
    private TGContext context;
    private TGResourceBundle resources;
    private String[] languages;

    public TGLanguageManager(TGContext context) {
        this.context = context;
        this.loadLanguages();
    }

    public void addLoader(TGEventListener listener) {
        TGEventManager.getInstance((TGContext)this.context).addListener("language", listener);
    }

    public void removeLoader(TGEventListener listener) {
        TGEventManager.getInstance((TGContext)this.context).removeListener("language", listener);
    }

    private void fireChanges() {
        TGEventManager.getInstance((TGContext)this.context).fireEvent((TGEvent)new TGLanguageEvent());
    }

    public void setLanguage(String lang) {
        try {
            String baseName = "lang.messages";
            Locale locale = this.getLocale(lang);
            this.resources = TGResourceBundle.getBundle(this.context, baseName, locale);
            this.fireChanges();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private Locale getLocale(String lang) {
        if (this.isSupportedLanguage(lang)) {
            String[] locale = lang.split("_");
            String language = locale.length > 0 ? locale[0] : "";
            String country = locale.length > 1 ? locale[1] : "";
            String variant = locale.length > 2 ? locale[2] : "";
            return new Locale(language, country, variant);
        }
        return Locale.getDefault();
    }

    private boolean isSupportedLanguage(String lang) {
        if (lang != null && lang.length() > 0 && this.languages != null) {
            for (int i = 0; i < this.languages.length; ++i) {
                if (!this.languages[i].equals(lang)) continue;
                return true;
            }
        }
        return false;
    }

    public String getProperty(String key, String value) {
        try {
            String property = this.resources.getString(key);
            return property == null ? value : property;
        }
        catch (Throwable throwable) {
            return value;
        }
    }

    public String getProperty(String key) {
        return this.getProperty(key, key);
    }

    public String getProperty(String key, Object[] arguments) {
        return this.getProperty(key, key, arguments);
    }

    public String getProperty(String key, String value, Object[] arguments) {
        String property = this.getProperty(key, value);
        return arguments != null ? MessageFormat.format(property, arguments) : property;
    }

    public String[] getLanguages() {
        return this.languages;
    }

    public String getLanguage() {
        if (this.resources != null) {
            Locale locale = this.resources.getLocale();
            boolean language = locale.getLanguage() != null && locale.getLanguage().length() > 0;
            boolean country = locale.getCountry() != null && locale.getCountry().length() > 0;
            boolean variant = locale.getVariant() != null && locale.getVariant().length() > 0;
            String localeId = new String();
            if (language) {
                localeId = localeId + locale.getLanguage();
            }
            if (country) {
                localeId = localeId + "_" + locale.getCountry();
            }
            if (variant) {
                localeId = localeId + "_" + (country ? locale.getVariant() : "_" + locale.getVariant());
            }
            return localeId;
        }
        return null;
    }

    private void loadLanguages() {
        int i;
        ArrayList<String> availableList = new ArrayList<String>();
        String[] fileNames = TGFileUtils.getFileNames(this.context, PACKAGE);
        if (fileNames != null) {
            for (i = 0; i < fileNames.length; ++i) {
                if (fileNames[i].indexOf("messages_") != 0) continue;
                int prefixIndex = fileNames[i].indexOf("messages_");
                int extensionIndex = fileNames[i].indexOf(EXTENSION);
                if (prefixIndex != 0 || extensionIndex <= "messages_".length()) continue;
                availableList.add(fileNames[i].substring("messages_".length(), extensionIndex));
            }
        }
        this.languages = new String[availableList.size()];
        for (i = 0; i < this.languages.length; ++i) {
            this.languages[i] = (String)availableList.get(i);
        }
    }
}

