/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.io.stream;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.action.TGActionInterceptor;
import org.herac.tuxguitar.action.TGActionManager;
import org.herac.tuxguitar.app.io.stream.TGSongStreamActionInterceptor;
import org.herac.tuxguitar.app.io.stream.TGSongStreamSettingsHandler;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

public class TGSongStreamAdapterManager {
    private TGContext context;
    private List<TGSongStreamSettingsHandler> handlers;

    private TGSongStreamAdapterManager(TGContext context) {
        this.context = context;
        this.handlers = new ArrayList<TGSongStreamSettingsHandler>();
        this.appendListeners();
    }

    public TGContext getContext() {
        return this.context;
    }

    public void addSettingsHandler(TGSongStreamSettingsHandler handler) {
        this.handlers.add(handler);
    }

    public void removeSettingsHandler(TGSongStreamSettingsHandler handler) {
        if (this.handlers.contains(handler)) {
            this.handlers.remove(handler);
        }
    }

    public TGSongStreamSettingsHandler findSettingsHandler(String providerId) {
        for (TGSongStreamSettingsHandler handler : this.handlers) {
            if (!handler.getProviderId().equals(providerId)) continue;
            return handler;
        }
        return null;
    }

    public void appendListeners() {
        TGActionManager.getInstance((TGContext)this.getContext()).addInterceptor((TGActionInterceptor)new TGSongStreamActionInterceptor(this.context));
    }

    public static TGSongStreamAdapterManager getInstance(TGContext context) {
        return (TGSongStreamAdapterManager)TGSingletonUtil.getInstance((TGContext)context, (String)TGSongStreamAdapterManager.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGSongStreamAdapterManager>(){

            public TGSongStreamAdapterManager createInstance(TGContext context) {
                return new TGSongStreamAdapterManager(context);
            }
        });
    }
}

