/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app;

import java.net.URL;
import org.herac.tuxguitar.action.TGActionManager;
import org.herac.tuxguitar.app.action.TGActionAdapterManager;
import org.herac.tuxguitar.app.action.impl.file.TGReadURLAction;
import org.herac.tuxguitar.app.document.TGDocumentListManager;
import org.herac.tuxguitar.app.editor.EditorCache;
import org.herac.tuxguitar.app.synchronizer.TGSynchronizerControllerImpl;
import org.herac.tuxguitar.app.system.config.TGConfigManager;
import org.herac.tuxguitar.app.system.error.TGErrorAdapter;
import org.herac.tuxguitar.app.system.icons.TGIconManager;
import org.herac.tuxguitar.app.system.keybindings.KeyBindingActionManager;
import org.herac.tuxguitar.app.system.language.TGLanguageManager;
import org.herac.tuxguitar.app.system.properties.TGPropertiesAdapter;
import org.herac.tuxguitar.app.system.variables.TGVarAdapter;
import org.herac.tuxguitar.app.tools.scale.ScaleManager;
import org.herac.tuxguitar.app.transport.TGTransportListener;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.util.TGClassLoader;
import org.herac.tuxguitar.app.util.TGFileUtils;
import org.herac.tuxguitar.app.util.TGSplash;
import org.herac.tuxguitar.app.view.component.tab.TablatureEditor;
import org.herac.tuxguitar.app.view.component.table.TGTableViewer;
import org.herac.tuxguitar.app.view.dialog.browser.main.TGBrowserDialog;
import org.herac.tuxguitar.app.view.dialog.channel.TGChannelManagerDialog;
import org.herac.tuxguitar.app.view.dialog.chord.TGCustomChordManager;
import org.herac.tuxguitar.app.view.dialog.fretboard.TGFretBoardEditor;
import org.herac.tuxguitar.app.view.dialog.lyric.TGLyricEditor;
import org.herac.tuxguitar.app.view.dialog.matrix.TGMatrixEditor;
import org.herac.tuxguitar.app.view.dialog.piano.TGPianoEditor;
import org.herac.tuxguitar.app.view.main.TGWindow;
import org.herac.tuxguitar.app.view.menu.TGMenuManager;
import org.herac.tuxguitar.document.TGDocumentManager;
import org.herac.tuxguitar.editor.TGEditorManager;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.editor.undo.TGUndoableManager;
import org.herac.tuxguitar.event.TGEventListener;
import org.herac.tuxguitar.event.TGEventManager;
import org.herac.tuxguitar.io.base.TGFileFormatManager;
import org.herac.tuxguitar.player.base.MidiPlayer;
import org.herac.tuxguitar.player.base.MidiPlayerException;
import org.herac.tuxguitar.player.base.MidiSequencerProvider;
import org.herac.tuxguitar.player.impl.sequencer.MidiSequencerProviderImpl;
import org.herac.tuxguitar.resource.TGResourceLoader;
import org.herac.tuxguitar.resource.TGResourceManager;
import org.herac.tuxguitar.song.managers.TGSongManager;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.thread.TGMultiThreadHandler;
import org.herac.tuxguitar.thread.TGThreadHandler;
import org.herac.tuxguitar.thread.TGThreadManager;
import org.herac.tuxguitar.util.TGAbstractContext;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGException;
import org.herac.tuxguitar.util.TGLock;
import org.herac.tuxguitar.util.TGSynchronizer;
import org.herac.tuxguitar.util.error.TGErrorHandler;
import org.herac.tuxguitar.util.error.TGErrorManager;
import org.herac.tuxguitar.util.plugin.TGPluginManager;
import org.herac.tuxguitar.util.properties.TGPropertiesManager;

public class TuxGuitar {
    private static TuxGuitar instance;
    private boolean initialized = false;
    private TGLock lock;
    private TGContext context = new TGContext();
    private TGLanguageManager languageManager;
    private EditorCache editorCache;
    private TGMenuManager itemManager;
    private TGCustomChordManager customChordManager;

    public TuxGuitar() {
        this.lock = new TGLock(this.context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TuxGuitar getInstance() {
        if (instance != null) return instance;
        Class<TuxGuitar> clazz = TuxGuitar.class;
        synchronized (TuxGuitar.class) {
            instance = new TuxGuitar();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void createApplication(URL url) {
        this.createMainContext();
        this.createUIContext(url);
    }

    private void createMainContext() {
        TGThreadManager.getInstance((TGContext)this.context).setThreadHandler((TGThreadHandler)new TGMultiThreadHandler());
        TGResourceManager.getInstance((TGContext)this.context).setResourceLoader((TGResourceLoader)TGClassLoader.getInstance(this.context));
        TGFileUtils.loadLibraries(this.context);
        TGFileUtils.loadClasspath(this.context);
        TGErrorAdapter.initialize(this.context);
        TGPropertiesAdapter.initialize(this.context);
        TGVarAdapter.initialize(this.context);
    }

    private void createUIContext(final URL url) {
        TGSynchronizer.getInstance((TGContext)this.context).setController((TGSynchronizer.TGSynchronizerController)new TGSynchronizerControllerImpl(this.context));
        TGApplication.getInstance(this.context).getApplication().start(new Runnable(){

            @Override
            public void run() {
                TGSplash.getInstance(TuxGuitar.this.context).init();
                TGSynchronizer.getInstance((TGContext)TuxGuitar.this.context).executeLater(new Runnable(){

                    @Override
                    public void run() {
                        TuxGuitar.this.startUIContext(url);
                        TGSplash.getInstance(TuxGuitar.this.context).finish();
                    }
                });
            }
        });
    }

    private void startUIContext(URL url) {
        TGWindow.getInstance(this.context).createWindow();
        this.initMidiPlayer();
        this.getEditorManager().setLockControl(this.lock);
        this.getActionAdapterManager().initialize();
        this.getPluginManager().connectEnabled();
        this.restoreControlsConfig();
        this.restorePlayerConfig();
        TGWindow.getInstance(this.context).open();
        this.startSong(url);
        this.setInitialized(true);
    }

    private void startSong(URL url) {
        TGDocumentListManager.getInstance(this.context).findCurrentDocument().setUnwanted(true);
        if (url != null) {
            TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.url.read");
            tgActionProcessor.setAttribute(TGReadURLAction.ATTRIBUTE_URL, (Object)url);
            tgActionProcessor.setAttribute(TGErrorHandler.class.getName(), (Object)new TGErrorHandler(){

                public void handleError(Throwable throwable) {
                    TuxGuitar.this.startDefaultSong();
                    TGErrorManager.getInstance((TGContext)TuxGuitar.this.getContext()).handleError(throwable);
                }
            });
            tgActionProcessor.process();
        } else {
            this.startDefaultSong();
        }
    }

    private void startDefaultSong() {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.song.new-from-template");
        tgActionProcessor.setAttribute("unwanted", (Object)true);
        tgActionProcessor.process();
    }

    public void restoreControlsConfig() {
        TGConfigManager config = this.getConfig();
        if (config.getBooleanValue("show.instruments")) {
            new TGActionProcessor(this.context, "action.gui.toggle-channels-dialog").process();
        }
        if (config.getBooleanValue("show.transport")) {
            new TGActionProcessor(this.context, "action.gui.toggle-transport-dialog").process();
        }
        if (config.getBooleanValue("show.matrix")) {
            new TGActionProcessor(this.context, "action.gui.toggle-matrix-editor").process();
        }
        if (config.getBooleanValue("show.piano")) {
            new TGActionProcessor(this.context, "action.gui.toggle-piano-editor").process();
        }
        if (config.getBooleanValue("show.markers")) {
            new TGActionProcessor(this.context, "action.gui.toggle-marker-list").process();
        }
    }

    public TGTableViewer getTable() {
        return TGTableViewer.getInstance(this.context);
    }

    public TablatureEditor getTablatureEditor() {
        return TablatureEditor.getInstance(this.context);
    }

    public TGFretBoardEditor getFretBoardEditor() {
        return TGFretBoardEditor.getInstance(this.context);
    }

    public TGPianoEditor getPianoEditor() {
        return TGPianoEditor.getInstance(this.context);
    }

    public TGMatrixEditor getMatrixEditor() {
        return TGMatrixEditor.getInstance(this.context);
    }

    public TGChannelManagerDialog getChannelManager() {
        return TGChannelManagerDialog.getInstance(this.context);
    }

    public EditorCache getEditorCache() {
        if (this.editorCache == null) {
            this.editorCache = new EditorCache();
        }
        return this.editorCache;
    }

    public TGEditorManager getEditorManager() {
        return TGEditorManager.getInstance((TGContext)this.context);
    }

    public TGLyricEditor getLyricEditor() {
        return TGLyricEditor.getInstance(this.context);
    }

    public TGBrowserDialog getBrowser() {
        return TGBrowserDialog.getInstance(this.context);
    }

    public TGUndoableManager getUndoableManager() {
        return TGUndoableManager.getInstance((TGContext)this.context);
    }

    public ScaleManager getScaleManager() {
        return ScaleManager.getInstance(this.context);
    }

    public TGSongManager getSongManager() {
        return this.getDocumentManager().getSongManager();
    }

    public TGDocumentManager getDocumentManager() {
        return TGDocumentManager.getInstance((TGContext)this.context);
    }

    public TGPluginManager getPluginManager() {
        return TGPluginManager.getInstance((TGContext)this.context);
    }

    public TGErrorManager getErrorManager() {
        return TGErrorManager.getInstance((TGContext)this.context);
    }

    public TGEventManager getEventManager() {
        return TGEventManager.getInstance((TGContext)this.context);
    }

    public TGPropertiesManager getPropertiesManager() {
        return TGPropertiesManager.getInstance((TGContext)this.context);
    }

    public TGConfigManager getConfig() {
        return TGConfigManager.getInstance(this.context);
    }

    public TGFileFormatManager getFileFormatManager() {
        return TGFileFormatManager.getInstance((TGContext)this.context);
    }

    public TGIconManager getIconManager() {
        return TGIconManager.getInstance(this.context);
    }

    public TGCustomChordManager getCustomChordManager() {
        if (this.customChordManager == null) {
            this.customChordManager = new TGCustomChordManager();
        }
        return this.customChordManager;
    }

    public TGMenuManager getItemManager() {
        if (this.itemManager == null) {
            this.itemManager = new TGMenuManager(this.context);
        }
        return this.itemManager;
    }

    public TGActionAdapterManager getActionAdapterManager() {
        return TGActionAdapterManager.getInstance(this.context);
    }

    public TGActionManager getActionManager() {
        return TGActionManager.getInstance((TGContext)this.context);
    }

    public TGLanguageManager getLanguageManager() {
        if (this.languageManager == null) {
            this.languageManager = new TGLanguageManager(this.context);
            this.languageManager.setLanguage(this.getConfig().getStringValue("language"));
        }
        return this.languageManager;
    }

    public KeyBindingActionManager getKeyBindingManager() {
        return KeyBindingActionManager.getInstance(this.context);
    }

    public MidiPlayer getPlayer() {
        return MidiPlayer.getInstance((TGContext)this.context);
    }

    public void initMidiPlayer() {
        MidiPlayer midiPlayer = MidiPlayer.getInstance((TGContext)this.context);
        midiPlayer.init(this.getDocumentManager());
        midiPlayer.addListener((TGEventListener)new TGTransportListener(this.context));
        try {
            this.getPlayer().addSequencerProvider((MidiSequencerProvider)new MidiSequencerProviderImpl(this.context), false);
        }
        catch (MidiPlayerException e) {
            e.printStackTrace();
        }
    }

    public void restorePlayerConfig() {
        this.getPlayer().setTryOpenFistDevice(true);
        this.getPlayer().openSequencer(this.getConfig().getStringValue("midi.sequencer"), true);
        this.getPlayer().openOutputPort(this.getConfig().getStringValue("midi.port"), true);
    }

    public void updateCache(boolean updateItems) {
        this.updateCache(updateItems, null);
    }

    public void updateCache(boolean updateItems, TGAbstractContext sourceContext) {
        this.lock();
        this.getEditorCache().updateEditMode();
        this.unlock();
        if (updateItems) {
            this.getEditorManager().updateSelection(sourceContext);
        }
        this.getEditorManager().redraw(sourceContext);
    }

    public void redrawPlayingMode() {
        if (!this.isDisposed() && !this.isLocked()) {
            this.lock();
            this.getEditorCache().updatePlayMode();
            if (this.getEditorCache().shouldRedraw()) {
                this.getEditorManager().redrawPlayingNewBeat();
            } else {
                this.getEditorManager().redrawPlayingThread();
            }
            this.unlock();
        }
    }

    public static String getProperty(String key) {
        return TuxGuitar.getInstance().getLanguageManager().getProperty(key);
    }

    public static String getProperty(String key, String[] arguments) {
        return TuxGuitar.getInstance().getLanguageManager().getProperty(key, arguments);
    }

    public boolean isDisposed() {
        return TGApplication.getInstance(this.context).isDisposed() || TGWindow.getInstance(this.context).isDisposed();
    }

    public void updateSong() {
        this.lock();
        this.getEditorCache().reset();
        this.getEditorManager().updateSong();
        this.unlock();
    }

    public void playBeat(final TGBeat beat) {
        TGThreadManager.getInstance((TGContext)this.context).start(new Runnable(){

            @Override
            public void run() throws TGException {
                if (!TuxGuitar.this.isDisposed() && !TuxGuitar.this.getPlayer().isRunning()) {
                    TuxGuitar.this.getPlayer().playBeat(beat);
                }
            }
        });
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    public TGContext getContext() {
        return this.context;
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public boolean isLocked() {
        return this.lock.isLocked();
    }
}

