/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.jsa.assistant;

import java.net.MalformedURLException;
import java.net.URL;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.action.impl.view.TGOpenViewAction;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.dialog.confirm.TGConfirmDialog;
import org.herac.tuxguitar.app.view.dialog.confirm.TGConfirmDialogController;
import org.herac.tuxguitar.app.view.main.TGWindow;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.player.impl.jsa.assistant.SBInstallerGui;
import org.herac.tuxguitar.player.impl.jsa.assistant.SBUrl;
import org.herac.tuxguitar.player.impl.jsa.midiport.MidiPortSynthesizer;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UILegendPanel;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UIRadioButton;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGSynchronizer;

public class SBAssistant {
    public static final SBUrl[] URLS = new SBUrl[]{new SBUrl(SBAssistant.toURL("http://www.oracle.com/technetwork/java/soundbank-min-150078.zip"), TuxGuitar.getProperty((String)"jsa.soundbank-assistant.minimal")), new SBUrl(SBAssistant.toURL("http://www.oracle.com/technetwork/java/soundbank-mid-149984.zip"), TuxGuitar.getProperty((String)"jsa.soundbank-assistant.medium")), new SBUrl(SBAssistant.toURL("http://www.oracle.com/technetwork/java/soundbank-deluxe-150042.zip"), TuxGuitar.getProperty((String)"jsa.soundbank-assistant.deluxe"))};
    private TGContext context;
    private MidiPortSynthesizer synthesizer;

    public SBAssistant(TGContext context, MidiPortSynthesizer synthesizer) {
        this.context = context;
        this.synthesizer = synthesizer;
    }

    public void process() {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(this.context, "action.gui.open-view");
        tgActionProcessor.setAttribute(TGOpenViewAction.ATTRIBUTE_CONTROLLER, (Object)new TGConfirmDialogController());
        tgActionProcessor.setAttribute("message", (Object)TuxGuitar.getProperty((String)"jsa.soundbank-assistant.confirm-message"));
        tgActionProcessor.setAttribute("style", (Object)(TGConfirmDialog.BUTTON_YES | TGConfirmDialog.BUTTON_NO));
        tgActionProcessor.setAttribute("defaultButton", (Object)TGConfirmDialog.BUTTON_NO);
        tgActionProcessor.setAttribute("yesRunnable", (Object)new Runnable(){

            @Override
            public void run() {
                TGSynchronizer.getInstance((TGContext)SBAssistant.this.context).executeLater(new Runnable(){

                    @Override
                    public void run() {
                        SBAssistant.this.open();
                    }
                });
            }
        });
        tgActionProcessor.process();
    }

    protected void open() {
        UIFactory uiFactory = TGApplication.getInstance((TGContext)this.context).getFactory();
        UIWindow uiParent = TGWindow.getInstance((TGContext)this.context).getWindow();
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(uiParent, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        UITableLayout groupLayout = new UITableLayout();
        UILegendPanel group = uiFactory.createLegendPanel((UIContainer)dialog);
        group.setLayout((UILayout)groupLayout);
        group.setText(TuxGuitar.getProperty((String)"jsa.soundbank-assistant.select"));
        dialogLayout.set((UIControl)group, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(250.0f), null, null);
        final UIRadioButton[] urls = new UIRadioButton[URLS.length];
        for (int i = 0; i < URLS.length; ++i) {
            urls[i] = uiFactory.createRadioButton((UIContainer)group);
            urls[i].setText(URLS[i].getName());
            urls[i].setData(SBUrl.class.getName(), (Object)URLS[i]);
            urls[i].setSelected(i == 0);
            groupLayout.set((UIControl)urls[i], Integer.valueOf(i + 1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_CENTER, Boolean.valueOf(true), Boolean.valueOf(false));
        }
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton buttonOK = uiFactory.createButton((UIContainer)buttons);
        buttonOK.setText(TuxGuitar.getProperty((String)"ok"));
        buttonOK.setDefaultButton();
        buttonOK.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                URL url = SBAssistant.this.getSelection(urls);
                dialog.dispose();
                if (url != null) {
                    SBAssistant.this.install(url);
                }
            }
        });
        buttonsLayout.set((UIControl)buttonOK, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonCancel = uiFactory.createButton((UIContainer)buttons);
        buttonCancel.setText(TuxGuitar.getProperty((String)"cancel"));
        buttonCancel.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonCancel, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonCancel, "margin_right", (Object)Float.valueOf(0.0f));
        TGDialogUtil.openDialog((UIWindow)dialog, (int)5);
    }

    protected URL getSelection(UIRadioButton[] buttons) {
        for (int i = 0; i < buttons.length; ++i) {
            if (!buttons[i].isSelected()) continue;
            return ((SBUrl)buttons[i].getData(SBUrl.class.getName())).getUrl();
        }
        return null;
    }

    protected void install(URL url) {
        new SBInstallerGui(this.context, url, this.synthesizer).open();
    }

    private static URL toURL(String s) {
        try {
            return new URL(s);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }
}

