/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.editor.undo.impl.track;

import org.herac.tuxguitar.action.TGActionContext;
import org.herac.tuxguitar.editor.undo.TGCannotRedoException;
import org.herac.tuxguitar.editor.undo.TGCannotUndoException;
import org.herac.tuxguitar.editor.undo.impl.track.TGUndoableTrackBase;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGLyric;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.util.TGContext;

public class TGUndoableTrackLyrics
extends TGUndoableTrackBase {
    private int doAction;
    private int trackNumber;
    private TGLyric undoLyric;
    private TGLyric redoLyric;

    private TGUndoableTrackLyrics(TGContext context) {
        super(context);
    }

    @Override
    public void redo(TGActionContext actionContext) throws TGCannotRedoException {
        if (!this.canRedo()) {
            throw new TGCannotRedoException();
        }
        this.setTrackLyrics(actionContext, this.getTrack(this.trackNumber), this.redoLyric.clone(this.getSongManager().getFactory()));
        this.doAction = 1;
    }

    @Override
    public void undo(TGActionContext actionContext) throws TGCannotUndoException {
        if (!this.canUndo()) {
            throw new TGCannotUndoException();
        }
        this.setTrackLyrics(actionContext, this.getTrack(this.trackNumber), this.undoLyric.clone(this.getSongManager().getFactory()));
        this.doAction = 2;
    }

    @Override
    public boolean canRedo() {
        return this.doAction == 2;
    }

    @Override
    public boolean canUndo() {
        return this.doAction == 1;
    }

    public static TGUndoableTrackLyrics startUndo(TGContext context, TGTrack track) {
        TGUndoableTrackLyrics undoable = new TGUndoableTrackLyrics(context);
        undoable.doAction = 1;
        undoable.trackNumber = track.getNumber();
        undoable.undoLyric = track.getLyrics().clone(new TGFactory());
        return undoable;
    }

    public TGUndoableTrackLyrics endUndo(TGTrack track) {
        this.redoLyric = track.getLyrics().clone(new TGFactory());
        return this;
    }

    public TGTrack getTrack(int number) {
        return this.getSongManager().getTrack(this.getSong(), number);
    }

    public TGChannel getChannel(int channelId) {
        return this.getSongManager().getChannel(this.getSong(), channelId);
    }
}

