/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.tg;

import java.io.DataInputStream;
import java.io.IOException;
import org.herac.tuxguitar.io.base.TGFileFormat;
import org.herac.tuxguitar.io.base.TGFileFormatException;
import org.herac.tuxguitar.io.base.TGSongReader;
import org.herac.tuxguitar.io.base.TGSongReaderHandle;
import org.herac.tuxguitar.io.tg.TGFileFormatDetectorImpl;
import org.herac.tuxguitar.io.tg.TGFileFormatVersion;
import org.herac.tuxguitar.io.tg.TGStream;
import org.herac.tuxguitar.song.factory.TGFactory;
import org.herac.tuxguitar.song.models.TGBeat;
import org.herac.tuxguitar.song.models.TGChannel;
import org.herac.tuxguitar.song.models.TGChannelParameter;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.song.models.TGColor;
import org.herac.tuxguitar.song.models.TGDivisionType;
import org.herac.tuxguitar.song.models.TGDuration;
import org.herac.tuxguitar.song.models.TGLyric;
import org.herac.tuxguitar.song.models.TGMarker;
import org.herac.tuxguitar.song.models.TGMeasure;
import org.herac.tuxguitar.song.models.TGMeasureHeader;
import org.herac.tuxguitar.song.models.TGNote;
import org.herac.tuxguitar.song.models.TGNoteEffect;
import org.herac.tuxguitar.song.models.TGSong;
import org.herac.tuxguitar.song.models.TGString;
import org.herac.tuxguitar.song.models.TGStroke;
import org.herac.tuxguitar.song.models.TGTempo;
import org.herac.tuxguitar.song.models.TGText;
import org.herac.tuxguitar.song.models.TGTimeSignature;
import org.herac.tuxguitar.song.models.TGTrack;
import org.herac.tuxguitar.song.models.TGVoice;
import org.herac.tuxguitar.song.models.effects.TGEffectBend;
import org.herac.tuxguitar.song.models.effects.TGEffectGrace;
import org.herac.tuxguitar.song.models.effects.TGEffectHarmonic;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloBar;
import org.herac.tuxguitar.song.models.effects.TGEffectTremoloPicking;
import org.herac.tuxguitar.song.models.effects.TGEffectTrill;

public class TGSongReaderImpl
extends TGStream
implements TGSongReader {
    public static final TGFileFormatVersion SUPPORTED_FORMAT = new TGFileFormatVersion(TG_FORMAT, TG_FORMAT_VERSION);
    private DataInputStream dataInputStream;
    private TGFactory factory;

    @Override
    public TGFileFormat getFileFormat() {
        return TG_FORMAT;
    }

    @Override
    public void read(TGSongReaderHandle handle) throws TGFileFormatException {
        try {
            this.factory = handle.getFactory();
            this.dataInputStream = new DataInputStream(handle.getInputStream());
            TGFileFormat fileFormat = new TGFileFormatDetectorImpl(SUPPORTED_FORMAT).getFileFormat(this.dataInputStream);
            if (fileFormat == null || !fileFormat.equals(this.getFileFormat())) {
                throw new TGFileFormatException("Unsupported Version");
            }
            TGSong song = this.read();
            this.dataInputStream.close();
            handle.setSong(song);
        }
        catch (Throwable throwable) {
            throw new TGFileFormatException(throwable);
        }
    }

    private TGSong read() throws IOException {
        TGSong song = this.factory.newSong();
        song.setName(this.readUnsignedByteString());
        song.setArtist(this.readUnsignedByteString());
        song.setAlbum(this.readUnsignedByteString());
        song.setAuthor(this.readUnsignedByteString());
        song.setDate(this.readUnsignedByteString());
        song.setCopyright(this.readUnsignedByteString());
        song.setWriter(this.readUnsignedByteString());
        song.setTranscriber(this.readUnsignedByteString());
        song.setComments(this.readIntegerString());
        int channelCount = this.readByte();
        for (int i = 0; i < channelCount; ++i) {
            TGChannel channel = this.factory.newChannel();
            this.readChannel(channel);
            song.addChannel(channel);
        }
        int headerCount = this.readShort();
        TGMeasureHeader lastHeader = null;
        long headerStart = 960L;
        for (int i = 0; i < headerCount; ++i) {
            TGMeasureHeader header = this.readMeasureHeader(i + 1, headerStart, lastHeader);
            song.addMeasureHeader(header);
            headerStart += header.getLength();
            lastHeader = header;
        }
        int trackCount = this.readByte();
        for (int i = 0; i < trackCount; ++i) {
            song.addTrack(this.readTrack(i + 1, song));
        }
        return song;
    }

    private TGTrack readTrack(int number, TGSong song) throws IOException {
        int header = this.readHeader();
        TGTrack track = this.factory.newTrack();
        track.setNumber(number);
        track.setName(this.readUnsignedByteString());
        track.setSolo((header & 1) != 0);
        track.setMute((header & 2) != 0);
        track.setChannelId(this.readShort());
        int measureCount = song.countMeasureHeaders();
        TGMeasure lastMeasure = null;
        for (int i = 0; i < measureCount; ++i) {
            TGMeasure measure = this.readMeasure(song.getMeasureHeader(i), lastMeasure);
            track.addMeasure(measure);
            lastMeasure = measure;
        }
        int stringCount = this.readByte();
        for (int i = 0; i < stringCount; ++i) {
            track.getStrings().add(this.readInstrumentString(i + 1));
        }
        track.setOffset(-24 + this.readByte());
        this.readRGBColor(track.getColor());
        if ((header & 4) != 0) {
            this.readLyrics(track.getLyrics());
        }
        return track;
    }

    private TGMeasureHeader readMeasureHeader(int number, long start, TGMeasureHeader lastMeasureHeader) throws IOException {
        int header = this.readHeader();
        TGMeasureHeader measureHeader = this.factory.newHeader();
        measureHeader.setNumber(number);
        measureHeader.setStart(start);
        if ((header & 1) != 0) {
            this.readTimeSignature(measureHeader.getTimeSignature());
        } else if (lastMeasureHeader != null) {
            measureHeader.getTimeSignature().copyFrom(lastMeasureHeader.getTimeSignature());
        }
        if ((header & 2) != 0) {
            this.readTempo(measureHeader.getTempo());
        } else if (lastMeasureHeader != null) {
            measureHeader.getTempo().copyFrom(lastMeasureHeader.getTempo());
        }
        measureHeader.setRepeatOpen((header & 4) != 0);
        if ((header & 8) != 0) {
            measureHeader.setRepeatClose(this.readShort());
        }
        if ((header & 0x10) != 0) {
            measureHeader.setRepeatAlternative(this.readByte());
        }
        if ((header & 0x20) != 0) {
            measureHeader.setMarker(this.readMarker(number));
        }
        measureHeader.setTripletFeel(lastMeasureHeader != null ? lastMeasureHeader.getTripletFeel() : 1);
        if ((header & 0x40) != 0) {
            measureHeader.setTripletFeel(this.readByte());
        }
        return measureHeader;
    }

    private TGMeasure readMeasure(TGMeasureHeader measureHeader, TGMeasure lastMeasure) throws IOException {
        int header = this.readHeader();
        TGMeasure measure = this.factory.newMeasure(measureHeader);
        TGStream.TGBeatData data = new TGStream.TGBeatData(this, measure);
        this.readBeats(measure, data);
        measure.setClef(lastMeasure == null ? 1 : lastMeasure.getClef());
        if ((header & 1) != 0) {
            measure.setClef(this.readByte());
        }
        measure.setKeySignature(lastMeasure == null ? 0 : lastMeasure.getKeySignature());
        if ((header & 2) != 0) {
            measure.setKeySignature(this.readByte());
        }
        return measure;
    }

    private void readChannel(TGChannel channel) throws IOException {
        channel.setChannelId(this.readShort());
        channel.setBank((short)(this.readByte() & 0xFF));
        channel.setProgram((short)(this.readByte() & 0xFF));
        channel.setVolume((short)(this.readByte() & 0xFF));
        channel.setBalance((short)(this.readByte() & 0xFF));
        channel.setChorus((short)(this.readByte() & 0xFF));
        channel.setReverb((short)(this.readByte() & 0xFF));
        channel.setPhaser((short)(this.readByte() & 0xFF));
        channel.setTremolo((short)(this.readByte() & 0xFF));
        channel.setName(this.readUnsignedByteString());
        this.readChannelParameters(channel);
    }

    private void readChannelParameters(TGChannel channel) throws IOException {
        int count = this.readShort();
        for (int i = 0; i < count; ++i) {
            this.readChannelParameter(channel);
        }
    }

    private void readChannelParameter(TGChannel channel) throws IOException {
        TGChannelParameter parameter = this.factory.newChannelParameter();
        parameter.setKey(this.readUnsignedByteString());
        parameter.setValue(this.readIntegerString());
        channel.addParameter(parameter);
    }

    private void readBeats(TGMeasure measure, TGStream.TGBeatData data) throws IOException {
        int header = 1;
        while (header & true) {
            header = this.readHeader();
            this.readBeat(header, measure, data);
        }
    }

    private void readBeat(int header, TGMeasure measure, TGStream.TGBeatData data) throws IOException {
        TGBeat beat = this.factory.newBeat();
        beat.setStart(data.getCurrentStart());
        this.readVoices(header, beat, data);
        if ((header & 2) != 0) {
            this.readStroke(beat.getStroke());
        }
        if ((header & 4) != 0) {
            this.readChord(beat);
        }
        if ((header & 8) != 0) {
            this.readText(beat);
        }
        measure.addBeat(beat);
    }

    private void readVoices(int header, TGBeat beat, TGStream.TGBeatData data) throws IOException {
        for (int i = 0; i < 2; ++i) {
            int flags;
            int shift = i * 2;
            beat.getVoice(i).setEmpty(true);
            if ((header & 16 << shift) == 0) continue;
            if ((header & 32 << shift) != 0) {
                data.getVoice(i).setFlags(this.readHeader());
            }
            if (((flags = data.getVoice(i).getFlags()) & 2) != 0) {
                this.readDuration(data.getVoice(i).getDuration());
            }
            if ((flags & 1) != 0) {
                this.readNotes(beat.getVoice(i), data);
            }
            if ((flags & 4) != 0) {
                beat.getVoice(i).setDirection(1);
            } else if ((flags & 8) != 0) {
                beat.getVoice(i).setDirection(2);
            }
            beat.getVoice(i).getDuration().copyFrom(data.getVoice(i).getDuration());
            data.getVoice(i).setStart(data.getVoice(i).getStart() + beat.getVoice(i).getDuration().getTime());
            beat.getVoice(i).setEmpty(false);
        }
    }

    private void readNotes(TGVoice voice, TGStream.TGBeatData data) throws IOException {
        int header = 1;
        while (header & true) {
            header = this.readHeader();
            this.readNote(header, voice, data);
        }
    }

    private void readNote(int header, TGVoice voice, TGStream.TGBeatData data) throws IOException {
        TGNote note = this.factory.newNote();
        note.setValue(this.readByte());
        note.setString(this.readByte());
        note.setTiedNote((header & 2) != 0);
        if ((header & 8) != 0) {
            data.getVoice(voice.getIndex()).setVelocity(this.readByte());
        }
        note.setVelocity(data.getVoice(voice.getIndex()).getVelocity());
        if ((header & 4) != 0) {
            this.readNoteEffect(note.getEffect());
        }
        voice.addNote(note);
    }

    private void readChord(TGBeat beat) throws IOException {
        TGChord chord = this.factory.newChord(this.readByte());
        chord.setName(this.readUnsignedByteString());
        chord.setFirstFret(this.readByte());
        for (int string = 0; string < chord.countStrings(); ++string) {
            chord.addFretValue(string, this.readByte());
        }
        beat.setChord(chord);
    }

    private void readText(TGBeat beat) throws IOException {
        TGText text = this.factory.newText();
        text.setValue(this.readUnsignedByteString());
        beat.setText(text);
    }

    private TGString readInstrumentString(int number) throws IOException {
        TGString string = this.factory.newString();
        string.setNumber(number);
        string.setValue(this.readByte());
        return string;
    }

    private void readTempo(TGTempo tempo) throws IOException {
        tempo.setValue(this.readShort());
    }

    private void readTimeSignature(TGTimeSignature timeSignature) throws IOException {
        timeSignature.setNumerator(this.readByte());
        this.readDuration(timeSignature.getDenominator());
    }

    private void readDuration(TGDuration duration) throws IOException {
        int header = this.readHeader();
        duration.setDotted((header & 1) != 0);
        duration.setDoubleDotted((header & 2) != 0);
        duration.setValue(this.readByte());
        if ((header & 4) != 0) {
            this.readDivisionType(duration.getDivision());
        } else {
            duration.getDivision().copyFrom(TGDivisionType.NORMAL);
        }
    }

    private void readDivisionType(TGDivisionType divisionType) throws IOException {
        divisionType.setEnters(this.readByte());
        divisionType.setTimes(this.readByte());
    }

    private void readStroke(TGStroke stroke) throws IOException {
        stroke.setDirection(this.readByte());
        stroke.setValue(this.readByte());
    }

    private void readNoteEffect(TGNoteEffect effect) throws IOException {
        int header = this.readHeader(3);
        if ((header & 1) != 0) {
            effect.setBend(this.readBendEffect());
        }
        if ((header & 2) != 0) {
            effect.setTremoloBar(this.readTremoloBarEffect());
        }
        if ((header & 4) != 0) {
            effect.setHarmonic(this.readHarmonicEffect());
        }
        if ((header & 8) != 0) {
            effect.setGrace(this.readGraceEffect());
        }
        if ((header & 0x10) != 0) {
            effect.setTrill(this.readTrillEffect());
        }
        if ((header & 0x20) != 0) {
            effect.setTremoloPicking(this.readTremoloPickingEffect());
        }
        effect.setVibrato((header & 0x40) != 0);
        effect.setDeadNote((header & 0x80) != 0);
        effect.setSlide((header & 0x100) != 0);
        effect.setHammer((header & 0x200) != 0);
        effect.setGhostNote((header & 0x400) != 0);
        effect.setAccentuatedNote((header & 0x800) != 0);
        effect.setHeavyAccentuatedNote((header & 0x1000) != 0);
        effect.setPalmMute((header & 0x2000) != 0);
        effect.setStaccato((header & 0x4000) != 0);
        effect.setTapping((header & 0x8000) != 0);
        effect.setSlapping((header & 0x10000) != 0);
        effect.setPopping((header & 0x20000) != 0);
        effect.setFadeIn((header & 0x40000) != 0);
        effect.setLetRing((header & 0x80000) != 0);
    }

    private TGEffectBend readBendEffect() throws IOException {
        TGEffectBend bend = this.factory.newEffectBend();
        int count = this.readByte();
        for (int i = 0; i < count; ++i) {
            byte position = this.readByte();
            byte value = this.readByte();
            bend.addPoint(position, value);
        }
        return bend;
    }

    private TGEffectTremoloBar readTremoloBarEffect() throws IOException {
        TGEffectTremoloBar tremoloBar = this.factory.newEffectTremoloBar();
        int count = this.readByte();
        for (int i = 0; i < count; ++i) {
            byte position = this.readByte();
            int value = this.readByte() - 12;
            tremoloBar.addPoint(position, value);
        }
        return tremoloBar;
    }

    private TGEffectHarmonic readHarmonicEffect() throws IOException {
        TGEffectHarmonic effect = this.factory.newEffectHarmonic();
        effect.setType(this.readByte());
        if (effect.getType() != 1) {
            effect.setData(this.readByte());
        }
        return effect;
    }

    private TGEffectGrace readGraceEffect() throws IOException {
        int header = this.readHeader();
        TGEffectGrace effect = this.factory.newEffectGrace();
        effect.setDead((header & 1) != 0);
        effect.setOnBeat((header & 2) != 0);
        effect.setFret(this.readByte());
        effect.setDuration(this.readByte());
        effect.setDynamic(this.readByte());
        effect.setTransition(this.readByte());
        return effect;
    }

    private TGEffectTremoloPicking readTremoloPickingEffect() throws IOException {
        TGEffectTremoloPicking effect = this.factory.newEffectTremoloPicking();
        effect.getDuration().setValue(this.readByte());
        return effect;
    }

    private TGEffectTrill readTrillEffect() throws IOException {
        TGEffectTrill effect = this.factory.newEffectTrill();
        effect.setFret(this.readByte());
        effect.getDuration().setValue(this.readByte());
        return effect;
    }

    private TGMarker readMarker(int measure) throws IOException {
        TGMarker marker = this.factory.newMarker();
        marker.setMeasure(measure);
        marker.setTitle(this.readUnsignedByteString());
        this.readRGBColor(marker.getColor());
        return marker;
    }

    private void readRGBColor(TGColor color) throws IOException {
        color.setR(this.readByte() & 0xFF);
        color.setG(this.readByte() & 0xFF);
        color.setB(this.readByte() & 0xFF);
    }

    private void readLyrics(TGLyric lyrics) throws IOException {
        lyrics.setFrom(this.readShort());
        lyrics.setLyrics(this.readIntegerString());
    }

    private byte readByte() throws IOException {
        return (byte)this.dataInputStream.read();
    }

    private int readHeader() throws IOException {
        return this.dataInputStream.read();
    }

    private int readHeader(int bCount) throws IOException {
        int header = 0;
        for (int i = bCount; i > 0; --i) {
            header += this.readHeader() << 8 * i - 8;
        }
        return header;
    }

    private short readShort() throws IOException {
        return this.dataInputStream.readShort();
    }

    private String readUnsignedByteString() throws IOException {
        return this.readString(this.dataInputStream.read() & 0xFF);
    }

    private String readIntegerString() throws IOException {
        return this.readString(this.dataInputStream.readInt());
    }

    private String readString(int length) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            sb.append(this.dataInputStream.readChar());
        }
        return sb.toString();
    }
}

