/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.pdf.PdfArray;
import com.itextpdf.text.pdf.PdfDictionary;
import com.itextpdf.text.pdf.PdfIndirectReference;
import com.itextpdf.text.pdf.PdfName;
import com.itextpdf.text.pdf.PdfNull;
import com.itextpdf.text.pdf.PdfNumber;
import com.itextpdf.text.pdf.PdfObject;
import com.itextpdf.text.pdf.PdfStructureTreeRoot;
import com.itextpdf.text.pdf.interfaces.IPdfStructureElement;

public class PdfStructureElement
extends PdfDictionary
implements IPdfStructureElement {
    private PdfStructureElement parent;
    private PdfStructureTreeRoot top;
    private PdfIndirectReference reference;

    public PdfStructureElement(PdfStructureElement parent, PdfName structureType) {
        this.top = parent.top;
        this.init(parent, structureType);
        this.parent = parent;
        this.put(PdfName.P, parent.reference);
        this.put(PdfName.TYPE, PdfName.STRUCTELEM);
    }

    public PdfStructureElement(PdfStructureTreeRoot parent, PdfName structureType) {
        this.top = parent;
        this.init(parent, structureType);
        this.put(PdfName.P, parent.getReference());
        this.put(PdfName.TYPE, PdfName.STRUCTELEM);
    }

    protected PdfStructureElement(PdfDictionary parent, PdfName structureType) {
        if (parent instanceof PdfStructureElement) {
            this.top = ((PdfStructureElement)parent).top;
            this.init(parent, structureType);
            this.parent = (PdfStructureElement)parent;
            this.put(PdfName.P, ((PdfStructureElement)parent).reference);
            this.put(PdfName.TYPE, PdfName.STRUCTELEM);
        } else if (parent instanceof PdfStructureTreeRoot) {
            this.top = (PdfStructureTreeRoot)parent;
            this.init(parent, structureType);
            this.put(PdfName.P, ((PdfStructureTreeRoot)parent).getReference());
            this.put(PdfName.TYPE, PdfName.STRUCTELEM);
        }
    }

    private void init(PdfDictionary parent, PdfName structureType) {
        PdfObject kido = parent.get(PdfName.K);
        PdfArray kids = null;
        if (kido == null) {
            kids = new PdfArray();
            parent.put(PdfName.K, kids);
        } else if (kido instanceof PdfArray) {
            kids = (PdfArray)kido;
        } else {
            kids = new PdfArray();
            kids.add(kido);
            parent.put(PdfName.K, kids);
        }
        kids.add(this);
        this.put(PdfName.S, structureType);
        this.reference = this.top.getWriter().getPdfIndirectReference();
    }

    public PdfDictionary getParent() {
        return this.parent;
    }

    void setPageMark(int page, int mark) {
        if (mark >= 0) {
            this.put(PdfName.K, new PdfNumber(mark));
        }
        if (this.parent == null) {
            this.top.setPageMark(page, this.reference);
        }
    }

    public PdfIndirectReference getReference() {
        return this.reference;
    }

    public PdfObject getAttribute(PdfName name) {
        PdfDictionary attr = this.getAsDict(PdfName.A);
        if (attr != null && attr.contains(name)) {
            return attr.get(name);
        }
        PdfDictionary parent = this.getParent();
        if (parent instanceof PdfStructureElement) {
            return ((PdfStructureElement)parent).getAttribute(name);
        }
        if (parent instanceof PdfStructureTreeRoot) {
            return ((PdfStructureTreeRoot)parent).getAttribute(name);
        }
        return new PdfNull();
    }

    public void setAttribute(PdfName name, PdfObject obj) {
        PdfDictionary attr = this.getAsDict(PdfName.A);
        if (attr == null) {
            attr = new PdfDictionary();
            this.put(PdfName.A, attr);
        }
        attr.put(name, obj);
    }
}

