/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.userscript.kernel;

import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.userscript.kernel.Script;

public class ScriptListTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ScriptListTableModel.class);
    private static final String[] colNames = new String[]{s_stringMgr.getString("userscript.tableColName"), s_stringMgr.getString("userscript.scriptClass"), s_stringMgr.getString("userscript.showInStandardMenues")};
    private transient Script[] m_scripts = new Script[0];

    void setScripts(Script[] scripts) {
        this.m_scripts = scripts;
    }

    @Override
    public int getRowCount() {
        return this.m_scripts.length;
    }

    @Override
    public int getColumnCount() {
        return colNames.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.m_scripts[rowIndex].getName();
            }
            case 1: {
                return this.m_scripts[rowIndex].getScriptClass();
            }
            case 2: {
                return this.m_scripts[rowIndex].isShowInStandard();
            }
        }
        throw new IllegalArgumentException("Invalid column index " + columnIndex);
    }

    @Override
    public String getColumnName(int column) {
        return colNames[column];
    }

    TableColumn[] getTableColumns() {
        TableColumn[] ret = new TableColumn[]{new TableColumn(0), new TableColumn(1), new TableColumn(2)};
        final JCheckBox chkShowInStandard = new JCheckBox();
        chkShowInStandard.setHorizontalAlignment(0);
        final Color unselectedBg = new JTextField().getBackground();
        final Color selectedBg = new JTextField().getSelectionColor();
        TableCellRenderer chkRenderer = new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                chkShowInStandard.setSelected((Boolean)value);
                if (isSelected) {
                    chkShowInStandard.setBackground(selectedBg);
                } else {
                    chkShowInStandard.setBackground(unselectedBg);
                }
                return chkShowInStandard;
            }
        };
        ret[2].setCellRenderer(chkRenderer);
        return ret;
    }

    void addScript(Script newScript) {
        Vector<Script> buf = new Vector<Script>();
        buf.addAll(Arrays.asList(this.m_scripts));
        buf.add(newScript);
        this.m_scripts = buf.toArray(new Script[buf.size()]);
        this.refresh();
    }

    public Script[] getScripts() {
        return this.m_scripts;
    }

    public void refresh() {
        this.fireTableDataChanged();
    }

    public void remove(int ix) {
        Vector<Script> buf = new Vector<Script>();
        buf.addAll(Arrays.asList(this.m_scripts));
        buf.remove(ix);
        this.m_scripts = buf.toArray(new Script[buf.size()]);
        this.refresh();
    }
}

