/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.userscript;

import java.net.URLClassLoader;
import java.util.Hashtable;
import javax.swing.Action;
import javax.swing.JMenu;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.gui.session.ObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.gui.session.SQLInternalFrame;
import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPluginResourcesFactory;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginResourcesFactory;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.util.IResources;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.userscript.UserScriptAction;
import net.sourceforge.squirrel_sql.plugins.userscript.UserScriptSQLAction;
import net.sourceforge.squirrel_sql.plugins.userscript.kernel.UserScriptAdmin;

public class UserScriptPlugin
extends DefaultSessionPlugin {
    private static ILogger s_log = LoggerController.createLogger(UserScriptPlugin.class);
    private IResources _resources;
    private IPluginResourcesFactory _resourcesFactory = new PluginResourcesFactory();
    private Hashtable<IIdentifier, UserScriptAdmin> _userScriptAdminsBySessionId = new Hashtable();
    private URLClassLoader m_userScriptClassLoader;

    public void setResourcesFactory(IPluginResourcesFactory resourcesFactory) {
        this._resourcesFactory = resourcesFactory;
    }

    public String getInternalName() {
        return "userscript";
    }

    public String getDescriptiveName() {
        return "User Scripts Plugin";
    }

    public String getVersion() {
        return "0.01";
    }

    public String getAuthor() {
        return "Gerd Wagner";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "doc/readme.txt";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public synchronized void initialize() throws PluginException {
        super.initialize();
        IApplication app = this.getApplication();
        this._resources = this._resourcesFactory.createResource("net.sourceforge.squirrel_sql.plugins.userscript.userscript", (IPlugin)this);
        ActionCollection coll = app.getActionCollection();
        coll.add((Action)((Object)new UserScriptAction(app, this._resources, this)));
        coll.add((Action)((Object)new UserScriptSQLAction(app, this._resources, this)));
        this.createMenu();
    }

    public void unload() {
        super.unload();
    }

    public boolean allowsSessionStartedInBackground() {
        return true;
    }

    public PluginSessionCallback sessionStarted(final ISession session) {
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ActionCollection coll = UserScriptPlugin.this.getApplication().getActionCollection();
                IObjectTreeAPI api = session.getSessionInternalFrame().getObjectTreeAPI();
                api.addToPopup(DatabaseObjectType.TABLE, coll.get(UserScriptAction.class));
                api.addToPopup(DatabaseObjectType.PROCEDURE, coll.get(UserScriptAction.class));
                api.addToPopup(DatabaseObjectType.SESSION, coll.get(UserScriptAction.class));
            }
        });
        UserScriptAdmin adm = new UserScriptAdmin(this, session);
        this._userScriptAdminsBySessionId.put(session.getIdentifier(), adm);
        PluginSessionCallback ret = new PluginSessionCallback(){

            public void sqlInternalFrameOpened(SQLInternalFrame sqlInternalFrame, ISession sess) {
            }

            public void objectTreeInternalFrameOpened(ObjectTreeInternalFrame objectTreeInternalFrame, ISession sess) {
            }
        };
        return ret;
    }

    private void createMenu() {
        IApplication app = this.getApplication();
        ActionCollection coll = app.getActionCollection();
        JMenu menu = this._resources.createMenu("userscript");
        this._resources.addToMenu(coll.get(UserScriptSQLAction.class), menu);
        app.addToMenu(2, menu);
    }

    public UserScriptAdmin getUserScriptAdmin(ISession session) {
        return this._userScriptAdminsBySessionId.get(session.getIdentifier());
    }

    public URLClassLoader getUserScriptClassLoader() {
        return this.m_userScriptClassLoader;
    }

    public void setUserScriptClassLoader(URLClassLoader urlClassLoader) {
        this.m_userScriptClassLoader = urlClassLoader;
    }

    private static interface IMenuResourceKeys {
        public static final String USER_SCRIPT = "userscript";
    }
}

