/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.fw.datasetviewer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.Enumeration;
import javax.swing.DefaultCellEditor;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.datasetviewer.BaseDataSetViewerDestination;
import net.sourceforge.squirrel_sql.fw.datasetviewer.CellDataPopup;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnHeaderDisplay;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ContinueReadChannel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ContinueReadHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTableListSelectionHandler;
import net.sourceforge.squirrel_sql.fw.datasetviewer.DataSetViewerTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ExtTableColumn;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataModelImplementationDetails;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetTableControls;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.IDataSetUpdateableTableModel;
import net.sourceforge.squirrel_sql.fw.datasetviewer.RowColSelectedCountListener;
import net.sourceforge.squirrel_sql.fw.datasetviewer.RowNumberTableColumn;
import net.sourceforge.squirrel_sql.fw.datasetviewer.RowSelectionListener;
import net.sourceforge.squirrel_sql.fw.datasetviewer.TableState;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.RestorableJTextField;
import net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind.DefaultFindService;
import net.sourceforge.squirrel_sql.fw.datasetviewer.tablefind.FindService;
import net.sourceforge.squirrel_sql.fw.gui.ButtonTableHeader;
import net.sourceforge.squirrel_sql.fw.gui.RectangleSelectionHandler;
import net.sourceforge.squirrel_sql.fw.gui.SortableTableModel;
import net.sourceforge.squirrel_sql.fw.gui.TablePopupMenu;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

public class DataSetViewerTablePanel
extends BaseDataSetViewerDestination
implements IDataSetTableControls,
Printable {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DataSetViewerTablePanel.class);
    private ILogger s_log = LoggerController.createLogger(DataSetViewerTablePanel.class);
    private MyJTable _table = null;
    private DataSetViewerTableModel _typedModel;
    private IDataSetUpdateableModel _updateableModel;
    private DataSetViewerTableListSelectionHandler _selectionHandler;
    private IDataModelImplementationDetails _dataModelImplementationDetails = new IDataModelImplementationDetails(){

        @Override
        public String getStatementSeparator() {
            return ";";
        }
    };
    private ContinueReadHandler _continueReadHandler;
    private RowColSelectedCountListener _rowColSelectedCountListener;
    JTableHeader tableHeader;
    int[] subTableSplit = null;
    boolean pageinfoCalculated = false;
    int totalNumPages = 0;
    int prevPageIndex = 0;
    int subPageIndex = 0;
    int subTableSplitSize = 0;
    double tableHeightOnFullPage;
    double headerHeight;
    double pageWidth;
    double pageHeight;
    int fontHeight;
    int fontDesent;
    double tableHeight;
    double rowHeight;
    double scale = 0.6666666666666666;

    @Override
    public void init(IDataSetUpdateableModel updateableModel, ISession session) {
        this.init(updateableModel, 1, session);
    }

    public void init(IDataSetUpdateableModel updateableModel, int listSelectionMode, ISession session) {
        this.init(updateableModel, listSelectionMode, null, session);
    }

    @Override
    public void init(IDataSetUpdateableModel updateableModel, IDataModelImplementationDetails dataModelImplementationDetails, ISession session) {
        this.init(updateableModel, 1, dataModelImplementationDetails, session);
    }

    public void init(IDataSetUpdateableModel updateableModel, int listSelectionMode, IDataModelImplementationDetails dataModelImplementationDetails, ISession session) {
        if (null != dataModelImplementationDetails) {
            this._dataModelImplementationDetails = dataModelImplementationDetails;
        }
        this._table = new MyJTable(this, updateableModel, listSelectionMode, session);
        this._continueReadHandler = new ContinueReadHandler(this._table);
        this._selectionHandler = new DataSetViewerTableListSelectionHandler(this._table);
        this._updateableModel = updateableModel;
        this._table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                DataSetViewerTablePanel.this.onSelectionChanged();
            }
        });
    }

    private void onSelectionChanged() {
        if (null != this._rowColSelectedCountListener) {
            this._rowColSelectedCountListener.rowColSelectedCountChanged(this._table.getSelectedRowCount(), this._table.getSelectedColumnCount());
        }
    }

    @Override
    public void setRowColSelectedCountListener(RowColSelectedCountListener rowColSelectedCountListener) {
        this._rowColSelectedCountListener = rowColSelectedCountListener;
    }

    public IDataSetUpdateableModel getUpdateableModel() {
        return this._updateableModel;
    }

    public IDataModelImplementationDetails getDataModelImplementationDetails() {
        return this._dataModelImplementationDetails;
    }

    @Override
    public void clear() {
        this._typedModel.clear();
        this._typedModel.fireTableDataChanged();
    }

    @Override
    public void setColumnDefinitions(ColumnDisplayDefinition[] colDefs) {
        super.setColumnDefinitions(colDefs);
        this._table.setColumnDefinitions(colDefs);
    }

    @Override
    public void moveToTop() {
        if (this._table.getRowCount() > 0) {
            this._table.setRowSelectionInterval(0, 0);
        }
    }

    @Override
    public Component getComponent() {
        return this._table;
    }

    @Override
    protected void addRow(Object[] row) {
        this._typedModel.addRow(row);
    }

    protected Object[] getRow(int row) {
        Object[] values = new Object[this._typedModel.getColumnCount()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = this._typedModel.getValueAt(row, i);
        }
        return values;
    }

    @Override
    protected void allRowsAdded() {
        this._typedModel.fireTableStructureChanged();
        this._table.initColWidths();
    }

    @Override
    public int getRowCount() {
        return this._typedModel.getRowCount();
    }

    public void setShowRowNumbers(boolean showRowNumbers) {
        this._table.setShowRowNumbers(showRowNumbers);
    }

    public void addRowSelectionListener(RowSelectionListener rowSelectionListener) {
        this._selectionHandler.addRowSelectionListener(rowSelectionListener);
    }

    public void removeRowSelectionListener(RowSelectionListener rowSelectionListener) {
        this._selectionHandler.removeRowSelectionListener(rowSelectionListener);
    }

    public int[] getSeletedRows() {
        return this._table.getSelectedRows();
    }

    public int[] getSeletedModelRows() {
        int[] selectedViewRows = this._table.getSelectedRows();
        int[] ret = new int[selectedViewRows.length];
        for (int i = 0; i < selectedViewRows.length; ++i) {
            ret[i] = ((SortableTableModel)this._table.getModel()).transfromToModelRow(selectedViewRows[i]);
        }
        return ret;
    }

    public int getColumnWidthForHeader(String header) {
        TableColumnModel columnModel = this._table.getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            if (!columnModel.getColumn(i).getHeaderValue().equals(header)) continue;
            return columnModel.getColumn(i).getWidth();
        }
        throw new IllegalStateException("No col with header: " + header);
    }

    public FindService createFindService() {
        return new DefaultFindService(this._table, this.getColumnDefinitions(), this._table.getTypedModel());
    }

    @Override
    public void switchColumnHeader(ColumnHeaderDisplay columnHeaderDisplay) {
        Enumeration<TableColumn> e = this._table.getColumnModel().getColumns();
        while (e.hasMoreElements()) {
            ExtTableColumn col = (ExtTableColumn)e.nextElement();
            if (ColumnHeaderDisplay.COLUMN_NAME == columnHeaderDisplay) {
                col.setHeaderValue(col.getColumnDisplayDefinition().getColumnName());
                continue;
            }
            if (ColumnHeaderDisplay.COLUMN_LABEL != columnHeaderDisplay) continue;
            col.setHeaderValue(col.getColumnDisplayDefinition().getLabel());
        }
        this._table.getTableHeader().repaint();
    }

    @Override
    public boolean isTableEditable() {
        return false;
    }

    @Override
    public boolean isColumnEditable(int col, Object originalValue) {
        return false;
    }

    @Override
    public boolean needToReRead(int col, Object originalValue) {
        return CellComponentFactory.needToReRead(this._colDefs[col], originalValue);
    }

    @Override
    public Object reReadDatum(Object[] values, int col, StringBuffer message) {
        return ((IDataSetUpdateableTableModel)this._updateableModel).reReadDatum(values, this._colDefs, col, message);
    }

    @Override
    public void setCellEditors(JTable table) {
    }

    @Override
    public int[] changeUnderlyingValueAt(int row, int col, Object newValue, Object oldValue) {
        return new int[0];
    }

    @Override
    public void deleteRows(int[] rows) {
    }

    @Override
    public void insertRow() {
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) throws PrinterException {
        Graphics2D g2 = (Graphics2D)g;
        if (pageIndex == 0) {
            this.pageinfoCalculated = false;
        }
        if (!this.pageinfoCalculated) {
            this.getPageInfo(g, pageFormat);
        }
        g2.setColor(Color.black);
        if (pageIndex >= this.totalNumPages) {
            return 1;
        }
        if (this.prevPageIndex != pageIndex) {
            ++this.subPageIndex;
            if (this.subPageIndex == this.subTableSplitSize - 1) {
                this.subPageIndex = 0;
            }
        }
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        int rowIndex = pageIndex / (this.subTableSplitSize - 1);
        this.printTablePart(g2, pageFormat, rowIndex, this.subPageIndex);
        this.prevPageIndex = pageIndex;
        return 0;
    }

    public void getPageInfo(Graphics g, PageFormat pageFormat) {
        this.subTableSplit = null;
        this.subTableSplitSize = 0;
        this.subPageIndex = 0;
        this.prevPageIndex = 0;
        this.fontHeight = (int)((double)g.getFontMetrics().getHeight() * this.scale);
        this.fontDesent = (int)((double)g.getFontMetrics().getDescent() * this.scale);
        this.tableHeader = this._table.getTableHeader();
        this.headerHeight = (double)this.tableHeader.getHeight() + (double)this._table.getRowMargin() * this.scale;
        this.pageHeight = pageFormat.getImageableHeight();
        this.pageWidth = pageFormat.getImageableWidth();
        this.tableHeight = (double)this._table.getHeight() * this.scale;
        this.rowHeight = (double)this._table.getRowHeight() + (double)this._table.getRowMargin() * this.scale;
        this.tableHeightOnFullPage = (int)(this.pageHeight - this.headerHeight - (double)(this.fontHeight * 2));
        this.tableHeightOnFullPage = this.tableHeightOnFullPage / this.rowHeight * this.rowHeight;
        TableColumnModel tableColumnModel = this.tableHeader.getColumnModel();
        int columns = tableColumnModel.getColumnCount();
        int columnMargin = (int)((double)tableColumnModel.getColumnMargin() * this.scale);
        int[] temp = new int[columns];
        temp[0] = 0;
        int length = 0;
        this.subTableSplitSize = 0;
        for (int columnIndex = 0; columnIndex < columns; ++columnIndex) {
            int columnWidth = (int)((double)tableColumnModel.getColumn(columnIndex).getWidth() * this.scale);
            if ((double)(length + columnWidth + columnMargin) > this.pageWidth) {
                temp[this.subTableSplitSize + 1] = temp[this.subTableSplitSize] + length;
                length = columnWidth;
                ++this.subTableSplitSize;
                continue;
            }
            length += columnWidth + columnMargin;
        }
        if (length > 0) {
            temp[this.subTableSplitSize + 1] = temp[this.subTableSplitSize] + length;
            ++this.subTableSplitSize;
        }
        ++this.subTableSplitSize;
        this.subTableSplit = new int[this.subTableSplitSize];
        for (int i = 0; i < this.subTableSplitSize; ++i) {
            this.subTableSplit[i] = temp[i];
        }
        this.totalNumPages = (int)(this.tableHeight / this.tableHeightOnFullPage);
        if (this.tableHeight % this.tableHeightOnFullPage >= this.rowHeight) {
            ++this.totalNumPages;
        }
        this.totalNumPages *= this.subTableSplitSize - 1;
        this.pageinfoCalculated = true;
    }

    public void printTablePart(Graphics2D g2, PageFormat pageFormat, int rowIndex, int columnIndex) {
        String pageNumber = "Page: " + (rowIndex + 1);
        if (this.subTableSplitSize > 1) {
            pageNumber = pageNumber + "-" + (columnIndex + 1);
        }
        int pageLeft = this.subTableSplit[columnIndex];
        int pageRight = this.subTableSplit[columnIndex + 1];
        int pageWidth = pageRight - pageLeft;
        g2.setFont(new Font(g2.getFont().getName(), g2.getFont().getStyle(), 8));
        g2.drawString(pageNumber, pageWidth / 2 - 35, (int)(this.pageHeight - (double)this.fontHeight));
        double clipHeight = Math.min(this.tableHeightOnFullPage, this.tableHeight - (double)rowIndex * this.tableHeightOnFullPage);
        g2.translate(-this.subTableSplit[columnIndex], 0);
        g2.setClip(pageLeft, 0, pageWidth, (int)this.headerHeight);
        g2.scale(this.scale, this.scale);
        this.tableHeader.paint(g2);
        g2.scale(1.0 / this.scale, 1.0 / this.scale);
        g2.translate(0.0, this.headerHeight);
        g2.translate(0.0, -this.tableHeightOnFullPage * (double)rowIndex);
        g2.setClip(pageLeft, (int)this.tableHeightOnFullPage * rowIndex, pageWidth, (int)clipHeight);
        g2.scale(this.scale, this.scale);
        this._table.paint(g2);
        g2.scale(1.0 / this.scale, 1.0 / this.scale);
        double pageTop = this.tableHeightOnFullPage * (double)rowIndex - this.headerHeight;
        g2.drawRect(pageLeft, (int)pageTop, pageWidth, (int)(clipHeight + this.headerHeight));
    }

    @Override
    public TableState getResultSortableTableState() {
        return new TableState(this._table);
    }

    @Override
    public void applyResultSortableTableState(TableState sortableTableState) {
        sortableTableState.apply(this._table);
    }

    @Override
    public void setContinueReadChannel(ContinueReadChannel continueReadChannel) {
        this._continueReadHandler.setContinueReadChannel(continueReadChannel);
    }

    @Override
    public void disableContinueRead() {
        this._continueReadHandler.disableContinueRead();
    }

    protected final class MyJTable
    extends JTable {
        private final int _multiplier;
        private static final String data = "THE QUICK BROWN FOX JUMPED OVER THE LAZY DOG";
        private TablePopupMenu _tablePopupMenu;
        private IDataSetTableControls _creator;
        private RectangleSelectionHandler _rectangleSelectionHandler;
        private RowNumberTableColumn _rntc;
        private ButtonTableHeader _tableHeader;

        MyJTable(IDataSetTableControls creator, IDataSetUpdateableModel updateableObject, int listSelectionMode, ISession session) {
            super(new SortableTableModel(new DataSetViewerTableModel(creator)));
            this._rectangleSelectionHandler = new RectangleSelectionHandler(this);
            this._tableHeader = new ButtonTableHeader();
            this._creator = creator;
            DataSetViewerTablePanel.this._typedModel = (DataSetViewerTableModel)((SortableTableModel)this.getModel()).getActualModel();
            this._multiplier = this.getFontMetrics(this.getFont()).stringWidth(data) / data.length();
            this.setRowHeight(this.getFontMetrics(this.getFont()).getHeight());
            boolean allowUpdate = false;
            if (updateableObject != null && !creator.isTableEditable()) {
                allowUpdate = true;
            }
            this.createGUI(allowUpdate, updateableObject, listSelectionMode, session);
            this._creator.setCellEditors(this);
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            this._rectangleSelectionHandler.paintRectWhenNeeded(g);
        }

        public IDataSetTableControls getCreator() {
            return this._creator;
        }

        @Override
        public TableCellEditor getCellEditor(int row, int col) {
            TableCellEditor cellEditor = super.getCellEditor(row, col);
            DataSetViewerTablePanel.this.currentCellEditor = (DefaultCellEditor)cellEditor;
            return cellEditor;
        }

        @Override
        public void processKeyEvent(KeyEvent e) {
            if (e.getKeyChar() == '\b' && this.getEditorComponent() != null && ((RestorableJTextField)this.getEditorComponent()).getText().equals("<null>")) {
                return;
            }
            super.processKeyEvent(e);
            if (this.getEditorComponent() != null && e.getID() == 400 && ((RestorableJTextField)this.getEditorComponent()).getText().length() == 7 && ((RestorableJTextField)this.getEditorComponent()).getText().equals("<null>" + e.getKeyChar())) {
                ((RestorableJTextField)this.getEditorComponent()).updateText("" + e.getKeyChar());
            }
        }

        @Override
        public void setValueAt(Object newValueString, int row, int col) {
            if (!(newValueString instanceof String)) {
                super.setValueAt(newValueString, row, col);
                return;
            }
            StringBuffer messageBuffer = new StringBuffer();
            int modelIndex = this.getColumnModel().getColumn(col).getModelIndex();
            ColumnDisplayDefinition colDef = DataSetViewerTablePanel.this.getColumnDefinitions()[modelIndex];
            Object newValueObject = CellComponentFactory.validateAndConvert(colDef, this.getValueAt(row, col), (String)newValueString, messageBuffer);
            if (messageBuffer.length() > 0) {
                String msg = s_stringMgr.getString("dataSetViewerTablePanel.textCantBeConverted", messageBuffer);
                if (DataSetViewerTablePanel.this.s_log.isDebugEnabled()) {
                    DataSetViewerTablePanel.this.s_log.debug("setValueAt: msg from DataTypeComponent was: " + msg);
                }
                JOptionPane.showMessageDialog(this, msg, s_stringMgr.getString("dataSetViewerTablePanel.conversionError"), 0);
            } else {
                super.setValueAt(newValueObject, row, col);
            }
        }

        public void setColumnDefinitions(ColumnDisplayDefinition[] colDefs) {
            TableColumnModel tcm = this.createColumnModel(colDefs);
            this.setColumnModel(tcm);
            DataSetViewerTablePanel.this._typedModel.setHeadings(colDefs);
            this._creator.setCellEditors(this);
            this._tablePopupMenu.reset();
        }

        DataSetViewerTableModel getTypedModel() {
            return DataSetViewerTablePanel.this._typedModel;
        }

        private void displayPopupMenu(MouseEvent evt) {
            this._tablePopupMenu.show(evt.getComponent(), evt.getX(), evt.getY());
        }

        private TableColumnModel createColumnModel(ColumnDisplayDefinition[] colDefs) {
            DefaultTableColumnModel cm = new DefaultTableColumnModel();
            this._rntc = new RowNumberTableColumn();
            for (int i = 0; i < colDefs.length; ++i) {
                int colWidth;
                ColumnDisplayDefinition colDef = colDefs[i];
                if (null == colDef.getAbsoluteWidth()) {
                    colWidth = colDef.getDisplayWidth() * this._multiplier;
                    if (colWidth > 50 * this._multiplier) {
                        colWidth = 50 * this._multiplier;
                    } else if (colWidth < 3 * this._multiplier) {
                        colWidth = 3 * this._multiplier;
                    }
                } else {
                    colWidth = colDef.getAbsoluteWidth();
                }
                ExtTableColumn col = new ExtTableColumn(i, colWidth, CellComponentFactory.getTableCellRenderer(colDefs[i]), null);
                String headerValue = colDef.getColumnHeading();
                col.setHeaderValue(headerValue);
                col.setColumnDisplayDefinition(colDef);
                cm.addColumn(col);
            }
            return cm;
        }

        void setShowRowNumbers(boolean show) {
            try {
                int rowNumColIx = this.getColumnModel().getColumnIndex(RowNumberTableColumn.ROW_NUMBER_COL_IDENTIFIER);
                this._tableHeader.columnIndexWillBeRemoved(rowNumColIx);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.getColumnModel().removeColumn(this._rntc);
            if (show) {
                this._tableHeader.columnIndexWillBeAdded(0);
                this.getColumnModel().addColumn(this._rntc);
                this.getColumnModel().moveColumn(this.getColumnModel().getColumnCount() - 1, 0);
            }
        }

        private void createGUI(boolean allowUpdate, IDataSetUpdateableModel updateableObject, int selectionMode, ISession session) {
            this.setSelectionMode(selectionMode);
            this.setRowSelectionAllowed(false);
            this.setColumnSelectionAllowed(false);
            this.setCellSelectionEnabled(true);
            this.getTableHeader().setResizingAllowed(true);
            this.getTableHeader().setReorderingAllowed(true);
            this.setAutoCreateColumnsFromModel(false);
            this.setAutoResizeMode(0);
            this.setTableHeader(this._tableHeader);
            this._tableHeader.setTable(this);
            this._tablePopupMenu = new TablePopupMenu(allowUpdate, updateableObject, DataSetViewerTablePanel.this, DataSetViewerTablePanel.this.getDataModelImplementationDetails(), session);
            this._tablePopupMenu.setTable(this);
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    MyJTable.this.onMousePressed(evt, false);
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    MyJTable.this.onMouseReleased(evt);
                }
            });
            this.getTableHeader().addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent evt) {
                    MyJTable.this.onMousePressed(evt, true);
                }

                @Override
                public void mouseReleased(MouseEvent evt) {
                    MyJTable.this.onMouseReleased(evt);
                }
            });
        }

        private void onMouseReleased(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                this.displayPopupMenu(evt);
            }
        }

        private void onMousePressed(MouseEvent evt, boolean clickedOnTableHeader) {
            if (evt.isPopupTrigger()) {
                this.displayPopupMenu(evt);
            } else if (evt.getClickCount() == 2 && !clickedOnTableHeader) {
                int columnIndexAtX;
                Point pt = evt.getPoint();
                TableColumnModel cm = this.getColumnModel();
                int modelIndex = cm.getColumn(columnIndexAtX = cm.getColumnIndexAtX(pt.x)).getModelIndex();
                if (-42 != modelIndex) {
                    ColumnDisplayDefinition[] colDefs = DataSetViewerTablePanel.this.getColumnDefinitions();
                    CellDataPopup.showDialog(this, colDefs[modelIndex], evt, this._creator.isTableEditable());
                }
            }
        }

        public void initColWidths() {
            this._tableHeader.initColWidths();
        }
    }
}

