/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.EventListenerList;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.gui.session.SessionColoringUtil;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.CopyQualifiedObjectNameAction;
import net.sourceforge.squirrel_sql.client.session.action.CopySimpleObjectNameAction;
import net.sourceforge.squirrel_sql.client.session.action.DeleteSelectedTablesAction;
import net.sourceforge.squirrel_sql.client.session.action.EditWhereColsAction;
import net.sourceforge.squirrel_sql.client.session.action.FilterObjectsAction;
import net.sourceforge.squirrel_sql.client.session.action.RefreshObjectTreeItemAction;
import net.sourceforge.squirrel_sql.client.session.action.RefreshSchemaInfoAction;
import net.sourceforge.squirrel_sql.client.session.action.SQLFilterAction;
import net.sourceforge.squirrel_sql.client.session.action.SetDefaultCatalogAction;
import net.sourceforge.squirrel_sql.client.session.action.ShowTableReferencesAction;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.IObjectTreeListener;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeCellRenderer;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeListenerEvent;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeModel;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.TreeLoader;
import net.sourceforge.squirrel_sql.fw.gui.CursorChanger;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ITableInfo;
import net.sourceforge.squirrel_sql.fw.util.EnumerationIterator;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

class ObjectTree
extends JTree {
    private static final long serialVersionUID = 1L;
    private static final ILogger s_log = LoggerController.createLogger(ObjectTree.class);
    private final ObjectTreeModel _model;
    private final ISession _session;
    private final Map<IIdentifier, JPopupMenu> _popups = new HashMap<IIdentifier, JPopupMenu>();
    private final JPopupMenu _globalPopup = new JPopupMenu();
    private final List<Action> _globalActions = new ArrayList<Action>();
    private Object _syncObject = new Object();
    private Map<String, Object> _expandedPathNames = new HashMap<String, Object>();
    private EventListenerList _listenerList = new EventListenerList();
    private boolean _startExpandInThread = true;

    ObjectTree(ISession session) {
        super(new ObjectTreeModel(session));
        if (session == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        this.setRowHeight(this.getFontMetrics(this.getFont()).getHeight());
        this._session = session;
        this._model = (ObjectTreeModel)this.getModel();
        this.setModel(this._model);
        this.addTreeExpansionListener(new NodeExpansionListener());
        this.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                if (null != e.getNewLeadSelectionPath()) {
                    ObjectTree.this.scrollPathToVisible(e.getNewLeadSelectionPath());
                }
            }
        });
        this.setShowsRootHandles(true);
        final ActionCollection actions = session.getApplication().getActionCollection();
        this.addToPopup(actions.get(RefreshSchemaInfoAction.class));
        this.addToPopup(actions.get(RefreshObjectTreeItemAction.class));
        this.addToPopup(DatabaseObjectType.TABLE, actions.get(EditWhereColsAction.class));
        this.addToPopup(DatabaseObjectType.TABLE, actions.get(SQLFilterAction.class));
        this.addToPopup(DatabaseObjectType.VIEW, actions.get(SQLFilterAction.class));
        this.addToPopup(DatabaseObjectType.TABLE, actions.get(DeleteSelectedTablesAction.class));
        this.addToPopup(DatabaseObjectType.TABLE, actions.get(ShowTableReferencesAction.class));
        this.addToPopup(DatabaseObjectType.SESSION, actions.get(FilterObjectsAction.class));
        session.getApplication().getThreadPool().addTask(new Runnable(){

            @Override
            public void run() {
                try {
                    if (ObjectTree.this._session.getSQLConnection().getSQLMetaData().supportsCatalogs()) {
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ObjectTree.this.addToPopup(DatabaseObjectType.CATALOG, actions.get(SetDefaultCatalogAction.class));
                            }
                        });
                    }
                }
                catch (Throwable th) {
                    s_log.debug(th);
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ObjectTree.this.addToPopup(actions.get(CopySimpleObjectNameAction.class));
                        ObjectTree.this.addToPopup(actions.get(CopyQualifiedObjectNameAction.class));
                        ObjectTree.this.addMouseListener(new ObjectTreeMouseListener());
                        ObjectTree.this.setCellRenderer(new ObjectTreeCellRenderer(ObjectTree.this._model, ObjectTree.this._session));
                        ObjectTree.this.refresh(false);
                        ObjectTree.this.setSelectionPath(ObjectTree.this.getPathForRow(0));
                    }
                });
            }
        });
        SessionColoringUtil.colorTree(session, this);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        ToolTipManager.sharedInstance().unregisterComponent(this);
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        String tip = null;
        TreePath path = this.getPathForLocation(evt.getX(), evt.getY());
        tip = path != null ? path.getLastPathComponent().toString() : this.getToolTipText();
        return tip;
    }

    public ObjectTreeModel getTypedModel() {
        return this._model;
    }

    public void refresh(final boolean reloadSchemaInfo) {
        Runnable task = new Runnable(){

            @Override
            public void run() {
                if (reloadSchemaInfo) {
                    ObjectTree.this._session.getSchemaInfo().reloadAll();
                }
                GUIUtils.processOnSwingEventThread(new Runnable(){

                    @Override
                    public void run() {
                        ObjectTree.this.refreshTree();
                    }
                });
            }
        };
        if (reloadSchemaInfo) {
            this._session.getApplication().getThreadPool().addTask(task);
        } else {
            task.run();
        }
    }

    private void refreshTree() {
        TreePath[] selectedPaths = this.getSelectionPaths();
        HashMap<String, Object> selectedPathNames = new HashMap<String, Object>();
        if (selectedPaths != null) {
            for (int i = 0; i < selectedPaths.length; ++i) {
                selectedPathNames.put(selectedPaths[i].toString(), null);
            }
        }
        ObjectTreeNode root = this._model.getRootObjectTreeNode();
        root.removeAllChildren();
        this.fireObjectTreeCleared();
        this.startExpandingTree(root, false, selectedPathNames, false);
        this.fireObjectTreeRefreshed();
    }

    public void refreshSelectedNodes() {
        TreePath[] selectedPaths = this.getSelectionPaths();
        ObjectTreeNode[] nodes = this.getSelectedNodes();
        HashMap<String, Object> selectedPathNames = new HashMap<String, Object>();
        if (selectedPaths != null) {
            for (int i = 0; i < selectedPaths.length; ++i) {
                selectedPathNames.put(selectedPaths[i].toString(), null);
            }
        }
        this.clearSelection();
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)nodes[0].getParent();
        if (parent != null) {
            parent.removeAllChildren();
            this.startExpandingTree((ObjectTreeNode)parent, false, selectedPathNames, true);
        } else {
            nodes[0].removeAllChildren();
            this.startExpandingTree(nodes[0], false, selectedPathNames, true);
        }
    }

    public void addObjectTreeListener(IObjectTreeListener lis) {
        this._listenerList.add(IObjectTreeListener.class, lis);
    }

    void removeObjectTreeListener(IObjectTreeListener lis) {
        this._listenerList.remove(IObjectTreeListener.class, lis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreExpansionState(ObjectTreeNode node, Map<String, Object> previouslySelectedTreePathNames, List<TreePath> selectedTreePaths) {
        if (node == null) {
            throw new IllegalArgumentException("ObjectTreeNode == null");
        }
        TreePath nodePath = new TreePath(node.getPath());
        if (this.matchKeyPrefix(previouslySelectedTreePathNames, node, nodePath.toString())) {
            selectedTreePaths.add(nodePath);
        }
        try {
            this._startExpandInThread = false;
            this.expandPath(nodePath);
        }
        finally {
            this._startExpandInThread = true;
        }
        Enumeration<TreeNode> childEnumeration = node.children();
        EnumerationIterator<TreeNode> it = new EnumerationIterator<TreeNode>(childEnumeration);
        while (it.hasNext()) {
            TreePath childPath;
            String childPathName;
            ObjectTreeNode child = (ObjectTreeNode)it.next();
            if (this.matchKeyPrefix(previouslySelectedTreePathNames, child, childPathName = (childPath = new TreePath(child.getPath())).toString())) {
                selectedTreePaths.add(childPath);
            }
            if (!this._expandedPathNames.containsKey(childPathName)) continue;
            this.restoreExpansionState(child, previouslySelectedTreePathNames, selectedTreePaths);
        }
    }

    protected boolean matchKeyPrefix(Map<String, Object> map, ObjectTreeNode node, String path) {
        if (node.getDatabaseObjectType() != DatabaseObjectType.TABLE && node.getDatabaseObjectType() != DatabaseObjectType.VIEW) {
            return map.containsKey(path);
        }
        Set<String> s = map.keySet();
        Iterator<String> i = s.iterator();
        String pathPrefix = path;
        if (path.indexOf("(") != -1) {
            pathPrefix = path.substring(0, path.lastIndexOf("("));
        }
        boolean result = false;
        while (i.hasNext()) {
            String key;
            String keyPrefix = key = i.next();
            if (key.indexOf("(") != -1) {
                keyPrefix = key.substring(0, key.lastIndexOf("("));
            }
            if (!keyPrefix.equals(pathPrefix)) continue;
            result = true;
            break;
        }
        return result;
    }

    private void startExpandingTree(ObjectTreeNode node, boolean selectNode, Map<String, Object> selectedPathNames, boolean refreshSchemaInfo) {
        ExpansionController exp = new ExpansionController(node, selectNode, selectedPathNames, refreshSchemaInfo);
        exp.run();
    }

    private void expandNode(ObjectTreeNode node, boolean selectNode) {
        if (node == null) {
            throw new IllegalArgumentException("ObjectTreeNode == null");
        }
        if (node.getChildCount() == 0 && !node.hasNoChildrenFoundWithExpander()) {
            DatabaseObjectType dboType = node.getDatabaseObjectType();
            INodeExpander[] stdExpanders = this._model.getExpanders(dboType);
            INodeExpander[] extraExpanders = node.getExpanders();
            if (stdExpanders.length > 0 || extraExpanders.length > 0) {
                INodeExpander[] expanders = null;
                if (stdExpanders.length > 0 && extraExpanders.length == 0) {
                    expanders = stdExpanders;
                } else if (stdExpanders.length == 0 && extraExpanders.length > 0) {
                    expanders = extraExpanders;
                } else {
                    expanders = new INodeExpander[stdExpanders.length + extraExpanders.length];
                    System.arraycopy(stdExpanders, 0, expanders, 0, stdExpanders.length);
                    System.arraycopy(extraExpanders, 0, expanders, stdExpanders.length, extraExpanders.length);
                }
                new TreeLoader(this._session, this, this._model, node, expanders, selectNode).execute();
            }
        }
    }

    void addToPopup(DatabaseObjectType dboType, Action action) {
        if (dboType == null) {
            throw new IllegalArgumentException("Null DatabaseObjectType passed");
        }
        if (action == null) {
            throw new IllegalArgumentException("Null Action passed");
        }
        JPopupMenu pop = this.getPopup(dboType, true);
        pop.add(action);
    }

    void addToPopup(Action action) {
        if (action == null) {
            throw new IllegalArgumentException("Null Action passed");
        }
        this._globalPopup.add(action);
        this._globalActions.add(action);
        for (JPopupMenu pop : this._popups.values()) {
            pop.add(action);
        }
    }

    public void addToPopup(DatabaseObjectType dboType, JMenu menu) {
        if (dboType == null) {
            throw new IllegalArgumentException("DatabaseObjectType == null");
        }
        if (menu == null) {
            throw new IllegalArgumentException("JMenu == null");
        }
        JPopupMenu pop = this.getPopup(dboType, true);
        pop.add(menu);
    }

    public void addToPopup(JMenu menu) {
        if (menu == null) {
            throw new IllegalArgumentException("JMenu == null");
        }
        this._globalPopup.add(menu);
        this._globalActions.add(menu.getAction());
        for (JPopupMenu pop : this._popups.values()) {
            pop.add(menu);
        }
    }

    private JPopupMenu getPopup(DatabaseObjectType dboType, boolean create) {
        if (dboType == null) {
            throw new IllegalArgumentException("Null DatabaseObjectType passed");
        }
        IIdentifier key = dboType.getIdentifier();
        JPopupMenu pop = this._popups.get(key);
        if (pop == null && create) {
            pop = new JPopupMenu();
            this._popups.put(key, pop);
            Iterator<Action> it = this._globalActions.iterator();
            while (it.hasNext()) {
                pop.add(it.next());
            }
        }
        return pop;
    }

    ObjectTreeNode[] getSelectedNodes() {
        TreePath[] paths = this.getSelectionPaths();
        ArrayList<ObjectTreeNode> list = new ArrayList<ObjectTreeNode>();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                Object obj = paths[i].getLastPathComponent();
                if (!(obj instanceof ObjectTreeNode)) continue;
                list.add((ObjectTreeNode)obj);
            }
        }
        ObjectTreeNode[] ar = list.toArray(new ObjectTreeNode[list.size()]);
        Arrays.sort(ar, new NodeComparator());
        return ar;
    }

    IDatabaseObjectInfo[] getSelectedDatabaseObjects() {
        ObjectTreeNode[] nodes = this.getSelectedNodes();
        IDatabaseObjectInfo[] dbObjects = new IDatabaseObjectInfo[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            dbObjects[i] = nodes[i].getDatabaseObjectInfo();
        }
        return dbObjects;
    }

    List<ITableInfo> getSelectedTables() {
        ObjectTreeNode[] nodes = this.getSelectedNodes();
        ArrayList<ITableInfo> result = new ArrayList<ITableInfo>();
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i].getDatabaseObjectType() != DatabaseObjectType.TABLE) continue;
            result.add((ITableInfo)nodes[i].getDatabaseObjectInfo());
        }
        return result;
    }

    private void showPopup(int x, int y) {
        ObjectTreeNode[] selObj = this.getSelectedNodes();
        if (selObj.length > 0) {
            boolean sameType = true;
            DatabaseObjectType dboType = selObj[0].getDatabaseObjectType();
            for (int i = 1; i < selObj.length; ++i) {
                if (selObj[i].getDatabaseObjectType() == dboType) continue;
                sameType = false;
                break;
            }
            JPopupMenu pop = null;
            if (sameType) {
                pop = this.getPopup(dboType, false);
            }
            if (pop == null) {
                pop = this._globalPopup;
            }
            pop.show(this, x, y);
        }
    }

    private void fireObjectTreeCleared() {
        Object[] listeners = this._listenerList.getListenerList();
        ObjectTreeListenerEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IObjectTreeListener.class) continue;
            if (evt == null) {
                evt = new ObjectTreeListenerEvent(this);
            }
            ((IObjectTreeListener)listeners[i + 1]).objectTreeCleared(evt);
        }
    }

    private void fireObjectTreeRefreshed() {
        Object[] listeners = this._listenerList.getListenerList();
        ObjectTreeListenerEvent evt = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != IObjectTreeListener.class) continue;
            if (evt == null) {
                evt = new ObjectTreeListenerEvent(this);
            }
            ((IObjectTreeListener)listeners[i + 1]).objectTreeRefreshed(evt);
        }
    }

    public void dispose() {
        this._globalPopup.removeAll();
        this._globalPopup.setInvoker(null);
        this._globalActions.clear();
        for (JPopupMenu popup : this._popups.values()) {
            popup.removeAll();
            popup.setInvoker(null);
        }
        this._popups.clear();
    }

    private class ExpansionController
    implements Runnable {
        private final ObjectTreeNode _node;
        private final boolean _selectNode;
        private final Map<String, Object> _selectedPathNames;
        private boolean _refreshSchemaInfo;

        ExpansionController(ObjectTreeNode node, boolean selectNode, Map<String, Object> selectedPathNames, boolean refreshSchemaInfo) {
            this._node = node;
            this._selectNode = selectNode;
            this._selectedPathNames = selectedPathNames;
            this._refreshSchemaInfo = refreshSchemaInfo;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = ObjectTree.this._syncObject;
            synchronized (object) {
                CursorChanger cursorChg = new CursorChanger(ObjectTree.this);
                cursorChg.show();
                try {
                    if (this._refreshSchemaInfo) {
                        ObjectTree.this._session.getSchemaInfo().reload(this._node.getDatabaseObjectInfo());
                    }
                    ObjectTree.this.expandNode(this._node, this._selectNode);
                    if (this._selectedPathNames != null) {
                        final ArrayList newlySelectedTreepaths = new ArrayList();
                        GUIUtils.processOnSwingEventThread(new Runnable(){

                            @Override
                            public void run() {
                                ObjectTree.this.restoreExpansionState(ExpansionController.this._node, ExpansionController.this._selectedPathNames, newlySelectedTreepaths);
                                ObjectTree.this.setSelectionPaths(newlySelectedTreepaths.toArray(new TreePath[newlySelectedTreepaths.size()]));
                            }
                        });
                    }
                }
                finally {
                    cursorChg.restore();
                }
            }
        }
    }

    private static class NodeComparator
    implements Comparator<ObjectTreeNode>,
    Serializable {
        private static final long serialVersionUID = 1L;

        private NodeComparator() {
        }

        @Override
        public int compare(ObjectTreeNode obj1, ObjectTreeNode obj2) {
            return obj1.toString().compareToIgnoreCase(obj2.toString());
        }
    }

    private final class NodeExpansionListener
    implements TreeExpansionListener {
        private NodeExpansionListener() {
        }

        @Override
        public void treeExpanded(TreeExpansionEvent evt) {
            TreePath path = evt.getPath();
            Object parentObj = path.getLastPathComponent();
            if (parentObj instanceof ObjectTreeNode) {
                ObjectTree.this.startExpandingTree((ObjectTreeNode)parentObj, false, null, false);
                ObjectTree.this._expandedPathNames.put(path.toString(), null);
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent evt) {
            ObjectTree.this._expandedPathNames.remove(evt.getPath().toString());
        }
    }

    private class ObjectTreeMouseListener
    extends MouseAdapter {
        private ObjectTreeMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent evt) {
            this.checkSelectAndPopUp(evt);
        }

        private void checkSelectAndPopUp(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                if (ObjectTree.this._session.getApplication().getSquirrelPreferences().getSelectOnRightMouseClick()) {
                    TreePath path = ObjectTree.this.getPathForLocation(evt.getX(), evt.getY());
                    boolean alreadySelected = false;
                    TreePath[] selectedPaths = ObjectTree.this.getSelectionPaths();
                    if (selectedPaths != null) {
                        for (TreePath selectedPath : selectedPaths) {
                            if (path == null || !path.equals(selectedPath)) continue;
                            alreadySelected = true;
                            break;
                        }
                    }
                    if (!alreadySelected) {
                        ObjectTree.this.setSelectionPath(path);
                    }
                }
                ObjectTree.this.showPopup(evt.getX(), evt.getY());
            }
        }

        @Override
        public void mouseReleased(MouseEvent evt) {
            this.checkSelectAndPopUp(evt);
        }
    }
}

