/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.preferences;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import net.sourceforge.squirrel_sql.client.action.ActionKeys;
import net.sourceforge.squirrel_sql.client.gui.mainframe.MainFrameWindowState;
import net.sourceforge.squirrel_sql.client.plugin.PluginStatus;
import net.sourceforge.squirrel_sql.client.preferences.IUpdateSettings;
import net.sourceforge.squirrel_sql.client.preferences.UpdateSettings;
import net.sourceforge.squirrel_sql.client.session.properties.SessionProperties;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.fw.util.PropertyChangeReporter;
import net.sourceforge.squirrel_sql.fw.util.ProxySettings;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.StringUtilities;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanReader;
import net.sourceforge.squirrel_sql.fw.xml.XMLBeanWriter;

public class SquirrelPreferences
implements Serializable {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(SquirrelPreferences.class);
    private static final ILogger s_log = LoggerController.createLogger(SquirrelPreferences.class);
    private MainFrameWindowState _mainFrameState = new MainFrameWindowState();
    private SessionProperties _sessionProps = new SessionProperties();
    private boolean _showContentsWhenDragging = false;
    private boolean _tabbedStyle = true;
    private boolean _useScrollableTabbedPanesForSessionTabs;
    private boolean _showTabbedStyleHint = true;
    private boolean _fileOpenInPreviousDir = true;
    private boolean _fileOpenInSpecifiedDir = false;
    private String _fileSpecifiedDir = "";
    private String _filePreviousDir = System.getProperty("user.home");
    private int _jdbcDebugType = 0;
    private int _loginTimeout = 30;
    private int _largeScriptStmtCount = 200;
    private boolean _copyQuotedSqlsToClip;
    private boolean _allowRunAllSQLsInEditor = true;
    private String _newSessionView;
    private boolean _showToolTips = true;
    private boolean _useScrollableTabbedPanes = false;
    private boolean _showMainStatusBar = true;
    private boolean _showMainToolBar = true;
    private boolean _showDriversToolBar = true;
    private boolean _maxSessionSheetOnOpen = false;
    private boolean _showAliasesToolBar = true;
    private boolean _showColorIconsInToolbars = true;
    private boolean _showPluginFilesInSplashScreen = false;
    private ActionKeys[] _actionsKeys = new ActionKeys[0];
    private ProxySettings _proxySettings = new ProxySettings();
    private IUpdateSettings _updateSettings = new UpdateSettings();
    private boolean _showLoadedDriversOnly;
    private boolean _firstRun = true;
    private boolean _confirmSessionClose = true;
    private boolean _warnJreJdbcMismatch = true;
    private final ArrayList<PluginStatus> _pluginStatusInfoColl = new ArrayList();
    private boolean _warnForUnsavedFileEdits = true;
    private boolean _warnForUnsavedBufferEdits = true;
    private boolean _showSessionStartupTimeHint = true;
    private boolean _showDebugLogMessages = true;
    private boolean _showInfoLogMessages = true;
    private boolean _showErrorLogMessages = true;
    private boolean _savePreferencesImmediately = false;
    private boolean _selectOnRightMouseClick = true;
    private transient PropertyChangeReporter _propChgReporter;
    private boolean _showPleaseWaitDialog;
    private String _preferredLocale = SquirrelPreferences.getDontChangeLocaleConstant();
    private boolean _maxColumnAdjustLengthDefined = false;
    private int _maxColumnAdjustLength = -1;
    private boolean _useShortSessionTitle = false;
    private int _currentSqlMarkColorRGB = Color.blue.getRGB();
    private boolean _markCurrentSql = true;
    private boolean _rememberValueOfPopup = false;
    private boolean _reloadSqlContents;

    public SquirrelPreferences() {
        this.loadDefaults();
    }

    public static String getDontChangeLocaleConstant() {
        return s_stringMgr.getString("preferences.dont.change.locale");
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeReporter().addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeReporter().removePropertyChangeListener(listener);
    }

    public String getNewSessionView() {
        return this._newSessionView;
    }

    public synchronized void setNewSessionView(String data) {
        if (data == null && this._newSessionView != null || data != null && !data.equals(this._newSessionView)) {
            String oldValue = this._newSessionView;
            this._newSessionView = data;
            this.getPropertyChangeReporter().firePropertyChange("newSessionView", oldValue, this._newSessionView);
        }
    }

    public SessionProperties getSessionProperties() {
        return this._sessionProps;
    }

    public synchronized void setSessionProperties(SessionProperties data) {
        if (this._sessionProps != data) {
            SessionProperties oldValue = this._sessionProps;
            this._sessionProps = data;
            this.getPropertyChangeReporter().firePropertyChange("sessionProperties", oldValue, this._sessionProps);
        }
    }

    public MainFrameWindowState getMainFrameWindowState() {
        return this._mainFrameState;
    }

    public synchronized void setMainFrameWindowState(MainFrameWindowState data) {
        MainFrameWindowState oldValue = this._mainFrameState;
        this._mainFrameState = data;
        this.getPropertyChangeReporter().firePropertyChange("mainFrameWindowState", oldValue, this._mainFrameState);
    }

    public boolean getTabbedStyle() {
        return this._tabbedStyle;
    }

    public synchronized void setTabbedStyle(boolean data) {
        if (data != this._tabbedStyle) {
            boolean oldValue = this._tabbedStyle;
            this._tabbedStyle = data;
            this.getPropertyChangeReporter().firePropertyChange("tabbedStyle", oldValue, this._tabbedStyle);
        }
    }

    public boolean getUseScrollableTabbedPanesForSessionTabs() {
        return this._useScrollableTabbedPanesForSessionTabs;
    }

    public synchronized void setUseScrollableTabbedPanesForSessionTabs(boolean data) {
        if (data != this._useScrollableTabbedPanesForSessionTabs) {
            boolean oldValue = this._useScrollableTabbedPanesForSessionTabs;
            this._useScrollableTabbedPanesForSessionTabs = data;
            this.getPropertyChangeReporter().firePropertyChange("useScrollableTabbedPanesForSessionTabs", oldValue, this._useScrollableTabbedPanesForSessionTabs);
        }
    }

    public boolean getShowTabbedStyleHint() {
        return this._showTabbedStyleHint;
    }

    public synchronized void setShowTabbedStyleHint(boolean data) {
        if (data != this._showTabbedStyleHint) {
            boolean oldValue = this._showTabbedStyleHint;
            this._showTabbedStyleHint = data;
            this.getPropertyChangeReporter().firePropertyChange("showTabbedStyleHint", oldValue, this._showTabbedStyleHint);
        }
    }

    public boolean getShowContentsWhenDragging() {
        return this._showContentsWhenDragging;
    }

    public synchronized void setShowContentsWhenDragging(boolean data) {
        if (data != this._showContentsWhenDragging) {
            boolean oldValue = this._showContentsWhenDragging;
            this._showContentsWhenDragging = data;
            this.getPropertyChangeReporter().firePropertyChange("showContentsWhenDragging", oldValue, this._showContentsWhenDragging);
        }
    }

    public boolean getShowMainStatusBar() {
        return this._showMainStatusBar;
    }

    public synchronized void setShowMainStatusBar(boolean data) {
        if (data != this._showMainStatusBar) {
            boolean oldValue = this._showMainStatusBar;
            this._showMainStatusBar = data;
            this.getPropertyChangeReporter().firePropertyChange("showMainStatusBar", oldValue, this._showMainStatusBar);
        }
    }

    public boolean getShowMainToolBar() {
        return this._showMainToolBar;
    }

    public synchronized void setShowMainToolBar(boolean data) {
        if (data != this._showMainToolBar) {
            boolean oldValue = this._showMainToolBar;
            this._showMainToolBar = data;
            this.getPropertyChangeReporter().firePropertyChange("showMainToolBar", oldValue, this._showMainToolBar);
        }
    }

    public boolean getShowAliasesToolBar() {
        return this._showAliasesToolBar;
    }

    public synchronized void setShowAliasesToolBar(boolean data) {
        if (data != this._showAliasesToolBar) {
            boolean oldValue = this._showAliasesToolBar;
            this._showAliasesToolBar = data;
            this.getPropertyChangeReporter().firePropertyChange("showAliasesToolBar", oldValue, this._showAliasesToolBar);
        }
    }

    public boolean getShowDriversToolBar() {
        return this._showDriversToolBar;
    }

    public synchronized void setShowDriversToolBar(boolean data) {
        if (data != this._showDriversToolBar) {
            boolean oldValue = this._showDriversToolBar;
            this._showDriversToolBar = data;
            this.getPropertyChangeReporter().firePropertyChange("showDriversToolBar", oldValue, this._showDriversToolBar);
        }
    }

    public boolean getShowColoriconsInToolbar() {
        return this._showColorIconsInToolbars;
    }

    public synchronized void setShowColoriconsInToolbar(boolean data) {
        if (data != this._showColorIconsInToolbars) {
            boolean oldValue = this._showColorIconsInToolbars;
            this._showColorIconsInToolbars = data;
            this.getPropertyChangeReporter().firePropertyChange("showColorIconsInToolbars", oldValue, this._showColorIconsInToolbars);
        }
    }

    public boolean getShowPluginFilesInSplashScreen() {
        return this._showPluginFilesInSplashScreen;
    }

    public synchronized void setShowPluginFilesInSplashScreen(boolean data) {
        if (data != this._showPluginFilesInSplashScreen) {
            boolean oldValue = this._showPluginFilesInSplashScreen;
            this._showPluginFilesInSplashScreen = data;
            this.getPropertyChangeReporter().firePropertyChange("showPluginFilesInSplashScreen", oldValue, this._showPluginFilesInSplashScreen);
        }
    }

    public int getLoginTimeout() {
        return this._loginTimeout;
    }

    public synchronized void setLoginTimeout(int data) {
        if (data != this._loginTimeout) {
            int oldValue = this._loginTimeout;
            this._loginTimeout = data;
            this.getPropertyChangeReporter().firePropertyChange("loginTimeout", oldValue, this._loginTimeout);
        }
    }

    public int getLargeScriptStmtCount() {
        return this._largeScriptStmtCount;
    }

    public synchronized void setLargeScriptStmtCount(int count) {
        if (count != this._largeScriptStmtCount) {
            int oldValue = this._largeScriptStmtCount;
            this._largeScriptStmtCount = count;
            this.getPropertyChangeReporter().firePropertyChange("largeScriptStmtCount", oldValue, this._largeScriptStmtCount);
        }
    }

    public int getJdbcDebugType() {
        return this._jdbcDebugType;
    }

    public synchronized void setJdbcDebugType(int data) {
        if (data < 0 || data > 2) {
            throw new IllegalArgumentException("Invalid setDebugJdbcToStream of :" + data);
        }
        if (data != this._jdbcDebugType) {
            int oldValue = this._jdbcDebugType;
            this._jdbcDebugType = data;
            this.getPropertyChangeReporter().firePropertyChange("jdbcDebugtype", oldValue, this._jdbcDebugType);
        }
    }

    public boolean getShowToolTips() {
        return this._showToolTips;
    }

    public synchronized void setShowToolTips(boolean data) {
        if (data != this._showToolTips) {
            boolean oldValue = this._showToolTips;
            this._showToolTips = data;
            this.getPropertyChangeReporter().firePropertyChange("showToolTips", oldValue, this._showToolTips);
        }
    }

    public boolean getUseScrollableTabbedPanes() {
        return this._useScrollableTabbedPanes;
    }

    public synchronized void setUseScrollableTabbedPanes(boolean data) {
        if (data != this._useScrollableTabbedPanes) {
            boolean oldValue = this._useScrollableTabbedPanes;
            this._useScrollableTabbedPanes = data;
            this.getPropertyChangeReporter().firePropertyChange("useScrollableTabbedPanes", oldValue, this._useScrollableTabbedPanes);
        }
    }

    public boolean getMaximizeSessionSheetOnOpen() {
        return this._maxSessionSheetOnOpen;
    }

    public synchronized void setMaximizeSessionSheetOnOpen(boolean data) {
        if (data != this._maxSessionSheetOnOpen) {
            boolean oldValue = this._maxSessionSheetOnOpen;
            this._maxSessionSheetOnOpen = data;
            this.getPropertyChangeReporter().firePropertyChange("maximizeSessionSheetOnOpen", oldValue, this._maxSessionSheetOnOpen);
        }
    }

    public ActionKeys[] getActionKeys() {
        return this._actionsKeys;
    }

    public ActionKeys getActionKeys(int idx) {
        return this._actionsKeys[idx];
    }

    public synchronized void setActionKeys(ActionKeys[] data) {
        ActionKeys[] oldValue = this._actionsKeys;
        this._actionsKeys = data != null ? data : new ActionKeys[]{};
        this.getPropertyChangeReporter().firePropertyChange("actionKeys", oldValue, this._actionsKeys);
    }

    public void setActionKeys(int idx, ActionKeys value) {
        ActionKeys[] oldValue = this._actionsKeys;
        this._actionsKeys[idx] = value;
        this.getPropertyChangeReporter().firePropertyChange("actionKeys", oldValue, this._actionsKeys);
    }

    public synchronized PluginStatus[] getPluginStatuses() {
        PluginStatus[] ar = new PluginStatus[this._pluginStatusInfoColl.size()];
        return this._pluginStatusInfoColl.toArray(ar);
    }

    public PluginStatus getPluginStatus(int idx) {
        return this._pluginStatusInfoColl.get(idx);
    }

    public synchronized void setPluginStatuses(PluginStatus[] data) {
        if (data == null) {
            data = new PluginStatus[]{};
        }
        PluginStatus[] oldValue = new PluginStatus[this._pluginStatusInfoColl.size()];
        oldValue = this._pluginStatusInfoColl.toArray(oldValue);
        this._pluginStatusInfoColl.clear();
        this._pluginStatusInfoColl.addAll(Arrays.asList(data));
        this.getPropertyChangeReporter().firePropertyChange("pluginStatuses", oldValue, data);
    }

    public synchronized void setPluginStatus(int idx, PluginStatus value) {
        this._pluginStatusInfoColl.ensureCapacity(idx + 1);
        PluginStatus oldValue = this._pluginStatusInfoColl.get(idx);
        this._pluginStatusInfoColl.set(idx, value);
        this.getPropertyChangeReporter().firePropertyChange("pluginStatuses", oldValue, value);
    }

    public ProxySettings getProxySettings() {
        return (ProxySettings)this._proxySettings.clone();
    }

    public IUpdateSettings getUpdateSettings() {
        return new UpdateSettings(this._updateSettings);
    }

    public synchronized void setUpdateSettings(IUpdateSettings data) {
        if (data == null) {
            data = new UpdateSettings();
        }
        IUpdateSettings oldValue = this._updateSettings;
        this._updateSettings = data;
        this.getPropertyChangeReporter().firePropertyChange("updatePreferences", oldValue, this._updateSettings);
    }

    public synchronized void setProxySettings(ProxySettings data) {
        if (data == null) {
            data = new ProxySettings();
        }
        ProxySettings oldValue = this._proxySettings;
        this._proxySettings = data;
        this.getPropertyChangeReporter().firePropertyChange("proxyPerferences", oldValue, this._proxySettings);
    }

    public boolean getShowLoadedDriversOnly() {
        return this._showLoadedDriversOnly;
    }

    public synchronized void setShowLoadedDriversOnly(boolean data) {
        if (data != this._showLoadedDriversOnly) {
            boolean oldValue = this._showLoadedDriversOnly;
            this._showLoadedDriversOnly = data;
            this.getPropertyChangeReporter().firePropertyChange("showLoadedDriversOnly", oldValue, this._showLoadedDriversOnly);
        }
    }

    public boolean isFirstRun() {
        return this._firstRun;
    }

    public synchronized void setFirstRun(boolean data) {
        if (data != this._firstRun) {
            boolean oldValue = this._firstRun;
            this._firstRun = data;
            this.getPropertyChangeReporter().firePropertyChange("firstRun", oldValue, this._firstRun);
        }
    }

    public boolean getConfirmSessionClose() {
        return this._confirmSessionClose;
    }

    public synchronized void setConfirmSessionClose(boolean data) {
        if (data != this._confirmSessionClose) {
            boolean oldValue = this._confirmSessionClose;
            this._confirmSessionClose = data;
            this.getPropertyChangeReporter().firePropertyChange("confirmSessionClose", oldValue, this._confirmSessionClose);
        }
    }

    public boolean isFileOpenInPreviousDir() {
        return this._fileOpenInPreviousDir;
    }

    public synchronized void setFileOpenInPreviousDir(boolean data) {
        if (data != this._fileOpenInPreviousDir) {
            boolean oldValue = this._fileOpenInPreviousDir;
            this._fileOpenInPreviousDir = data;
            this.getPropertyChangeReporter().firePropertyChange("fileOpenInPreviousDir", oldValue, this._fileOpenInPreviousDir);
        }
    }

    public boolean isFileOpenInSpecifiedDir() {
        return this._fileOpenInSpecifiedDir;
    }

    public synchronized void setFileOpenInSpecifiedDir(boolean data) {
        if (data != this._fileOpenInSpecifiedDir) {
            boolean oldValue = this._fileOpenInSpecifiedDir;
            this._fileOpenInSpecifiedDir = data;
            this.getPropertyChangeReporter().firePropertyChange("fileOpenInSpecifiedDir", oldValue, this._fileOpenInSpecifiedDir);
        }
    }

    public String getFileSpecifiedDir() {
        return this._fileSpecifiedDir;
    }

    public synchronized void setFileSpecifiedDir(String data) {
        if (!("" + data).equals(this._fileSpecifiedDir)) {
            String oldValue = this._fileSpecifiedDir;
            this._fileSpecifiedDir = data;
            this.getPropertyChangeReporter().firePropertyChange("fileSpecifiedDir", oldValue, this._fileSpecifiedDir);
        }
    }

    public String getFilePreviousDir() {
        return this._filePreviousDir;
    }

    public synchronized void setFilePreviousDir(String data) {
        if (!("" + data).equals(this._filePreviousDir)) {
            String oldValue = this._filePreviousDir;
            this._filePreviousDir = data;
            this.getPropertyChangeReporter().firePropertyChange("filePreviousdDir", oldValue, this._filePreviousDir);
        }
    }

    public boolean isJdbcDebugToStream() {
        return this._jdbcDebugType == 1;
    }

    public boolean isJdbcDebugToWriter() {
        return this._jdbcDebugType == 2;
    }

    public boolean isJdbcDebugDontDebug() {
        return !this.isJdbcDebugToStream() && !this.isJdbcDebugToWriter();
    }

    public void doJdbcDebugToStream() {
        this.setJdbcDebugType(1);
    }

    public void doJdbcDebugToWriter() {
        this.setJdbcDebugType(2);
    }

    public void dontDoJdbcDebug() {
        this.setJdbcDebugType(0);
    }

    public static SquirrelPreferences load() {
        File prefsFile = new ApplicationFiles().getUserPreferencesFile();
        try {
            XMLBeanReader doc = new XMLBeanReader();
            doc.load(prefsFile);
            Iterator<Object> it = doc.iterator();
            if (it.hasNext()) {
                return (SquirrelPreferences)it.next();
            }
        }
        catch (FileNotFoundException doc) {
        }
        catch (Exception ex) {
            s_log.error(s_stringMgr.getString("SquirrelPreferences.error.reading", prefsFile.getPath()), ex);
        }
        return new SquirrelPreferences();
    }

    public synchronized void save() {
        File prefsFile = new ApplicationFiles().getUserPreferencesFile();
        try {
            XMLBeanWriter wtr = new XMLBeanWriter(this);
            wtr.save(prefsFile);
        }
        catch (Exception ex) {
            s_log.error(s_stringMgr.getString("SquirrelPreferences.error.writing", prefsFile.getPath()), ex);
        }
    }

    private void loadDefaults() {
        if (this._loginTimeout == -1) {
            this._loginTimeout = DriverManager.getLoginTimeout();
        }
    }

    private synchronized PropertyChangeReporter getPropertyChangeReporter() {
        if (this._propChgReporter == null) {
            this._propChgReporter = new PropertyChangeReporter(this);
        }
        return this._propChgReporter;
    }

    public synchronized void setWarnJreJdbcMismatch(boolean data) {
        if (data != this._warnJreJdbcMismatch) {
            boolean oldValue = this._warnJreJdbcMismatch;
            this._warnJreJdbcMismatch = data;
            this.getPropertyChangeReporter().firePropertyChange("warnJreJdbcMismatch", oldValue, this._warnJreJdbcMismatch);
        }
    }

    public boolean getWarnJreJdbcMismatch() {
        return this._warnJreJdbcMismatch;
    }

    public synchronized void setWarnForUnsavedFileEdits(boolean data) {
        if (data != this._warnForUnsavedFileEdits) {
            boolean oldValue = this._warnForUnsavedFileEdits;
            this._warnForUnsavedFileEdits = data;
            this.getPropertyChangeReporter().firePropertyChange("warnForUnsavedFileEdits", oldValue, this._warnForUnsavedFileEdits);
        }
    }

    public boolean getWarnForUnsavedFileEdits() {
        return this._warnForUnsavedFileEdits;
    }

    public synchronized void setWarnForUnsavedBufferEdits(boolean data) {
        if (data != this._warnForUnsavedBufferEdits) {
            boolean oldValue = this._warnForUnsavedBufferEdits;
            this._warnForUnsavedBufferEdits = data;
            this.getPropertyChangeReporter().firePropertyChange("warnForUnsavedBufferEdits", oldValue, this._warnForUnsavedBufferEdits);
        }
    }

    public boolean getWarnForUnsavedBufferEdits() {
        return this._warnForUnsavedBufferEdits;
    }

    public synchronized void setShowSessionStartupTimeHint(boolean data) {
        if (data != this._showSessionStartupTimeHint) {
            boolean oldValue = this._showSessionStartupTimeHint;
            this._showSessionStartupTimeHint = data;
            this.getPropertyChangeReporter().firePropertyChange("showSessionStartupTimeHint", oldValue, this._showSessionStartupTimeHint);
        }
    }

    public boolean getShowSessionStartupTimeHint() {
        return this._showSessionStartupTimeHint;
    }

    public synchronized void setShowDebugLogMessages(boolean data) {
        if (data != this._showDebugLogMessages) {
            boolean oldValue = this._showDebugLogMessages;
            this._showDebugLogMessages = data;
            this.getPropertyChangeReporter().firePropertyChange("showDebugLogMessages", oldValue, this._showDebugLogMessages);
        }
    }

    public boolean getShowDebugLogMessage() {
        return this._showDebugLogMessages;
    }

    public void setShowInfoLogMessages(boolean data) {
        if (data != this._showInfoLogMessages) {
            boolean oldValue = this._showInfoLogMessages;
            this._showInfoLogMessages = data;
            this.getPropertyChangeReporter().firePropertyChange("showInfoLogMessages", oldValue, this._showInfoLogMessages);
        }
    }

    public boolean getShowInfoLogMessages() {
        return this._showInfoLogMessages;
    }

    public void setShowErrorLogMessages(boolean data) {
        if (data != this._showErrorLogMessages) {
            boolean oldValue = this._showErrorLogMessages;
            this._showErrorLogMessages = data;
            this.getPropertyChangeReporter().firePropertyChange("showErrorLogMessages", oldValue, this._showErrorLogMessages);
        }
    }

    public boolean getShowErrorLogMessages() {
        return this._showErrorLogMessages;
    }

    public void setSavePreferencesImmediately(boolean data) {
        if (data != this._savePreferencesImmediately) {
            boolean oldValue = this._savePreferencesImmediately;
            this._savePreferencesImmediately = data;
            this.getPropertyChangeReporter().firePropertyChange("savePreferencesImmediately", oldValue, this._savePreferencesImmediately);
        }
    }

    public boolean getSavePreferencesImmediately() {
        return this._savePreferencesImmediately;
    }

    public void setSelectOnRightMouseClick(boolean selectOnRightMouseClick) {
        this._selectOnRightMouseClick = selectOnRightMouseClick;
    }

    public boolean getSelectOnRightMouseClick() {
        return this._selectOnRightMouseClick;
    }

    public boolean getShowPleaseWaitDialog() {
        return this._showPleaseWaitDialog;
    }

    public void setShowPleaseWaitDialog(boolean showPleaseWaitDialog) {
        this._showPleaseWaitDialog = showPleaseWaitDialog;
    }

    public String getPreferredLocale() {
        if (StringUtilities.isEmpty(this._preferredLocale, true)) {
            return SquirrelPreferences.getDontChangeLocaleConstant();
        }
        return this._preferredLocale;
    }

    public void setPreferredLocale(String locale) {
        this._preferredLocale = locale;
    }

    public void setMaxColumnAdjustLengthDefined(boolean maxColumnAdjustLengthDefined) {
        this._maxColumnAdjustLengthDefined = maxColumnAdjustLengthDefined;
    }

    public void setMaxColumnAdjustLength(int maxColumnAdjustLength) {
        this._maxColumnAdjustLength = maxColumnAdjustLength;
    }

    public boolean getMaxColumnAdjustLengthDefined() {
        return this._maxColumnAdjustLengthDefined;
    }

    public int getMaxColumnAdjustLength() {
        return this._maxColumnAdjustLength;
    }

    public void setUseShortSessionTitle(boolean useShortSessionTitle) {
        this._useShortSessionTitle = useShortSessionTitle;
    }

    public boolean getUseShortSessionTitle() {
        return this._useShortSessionTitle;
    }

    public boolean getCopyQuotedSqlsToClip() {
        return this._copyQuotedSqlsToClip;
    }

    public boolean isCopyQuotedSqlsToClip() {
        return this._copyQuotedSqlsToClip;
    }

    public void setCopyQuotedSqlsToClip(boolean copyQuotedSqlsToClip) {
        this._copyQuotedSqlsToClip = copyQuotedSqlsToClip;
    }

    public boolean getAllowRunAllSQLsInEditor() {
        return this._allowRunAllSQLsInEditor;
    }

    public boolean isAllowRunAllSQLsInEditor() {
        return this._allowRunAllSQLsInEditor;
    }

    public void setAllowRunAllSQLsInEditor(boolean allowRunAllSQLsInEditor) {
        this._allowRunAllSQLsInEditor = allowRunAllSQLsInEditor;
    }

    public boolean isMarkCurrentSql() {
        return this._markCurrentSql;
    }

    public void setMarkCurrentSql(boolean markCurrentSql) {
        this._markCurrentSql = markCurrentSql;
    }

    public int getCurrentSqlMarkColorRGB() {
        return this._currentSqlMarkColorRGB;
    }

    public void setCurrentSqlMarkColorRGB(int currentSqlMarkColorRGB) {
        this._currentSqlMarkColorRGB = currentSqlMarkColorRGB;
    }

    public Color getCurrentSqlMarkColor() {
        return new Color(this._currentSqlMarkColorRGB);
    }

    public boolean isRememberValueOfPopup() {
        return this._rememberValueOfPopup;
    }

    public void setRememberValueOfPopup(boolean b) {
        this._rememberValueOfPopup = b;
    }

    public boolean isReloadSqlContents() {
        return this._reloadSqlContents;
    }

    public void setReloadSqlContents(boolean reloadSqlContents) {
        this._reloadSqlContents = reloadSqlContents;
    }

    public static interface IJdbcDebugTypes {
        public static final int NONE = 0;
        public static final int TO_STREAM = 1;
        public static final int TO_WRITER = 2;
    }

    public static interface IPropertyNames {
        public static final String ACTION_KEYS = "actionKeys";
        public static final String CONFIRM_SESSION_CLOSE = "confirmSessionClose";
        public static final String FIRST_RUN = "firstRun";
        public static final String JDBC_DEBUG_TYPE = "jdbcDebugtype";
        public static final String LOGIN_TIMEOUT = "loginTimeout";
        public static final String LARGE_SCRIPT_STMT_COUNT = "largeScriptStmtCount";
        public static final String COPY_QUOTED_SQLS_TO_CLIP = "copyQuotedSqlsToClip";
        public static final String ALLOW_RUN_ALL_SQLS_IN_EDITOR = "allowRunAllSQLsInEditor";
        public static final String MARK_CURRENT_SQL = "markCurrentSql";
        public static final String CURRENT_SQL_MARK_COLOR_RGB = "currentSqlMarkColorRGB";
        public static final String MAIN_FRAME_STATE = "mainFrameWindowState";
        public static final String MAXIMIMIZE_SESSION_SHEET_ON_OPEN = "maximizeSessionSheetOnOpen";
        public static final String NEW_SESSION_VIEW = "newSessionView";
        public static final String PLUGIN_OBJECTS = "pluginObjects";
        public static final String PLUGIN_STATUSES = "pluginStatuses";
        public static final String PROXY = "proxyPerferences";
        public static final String UPDATE = "updatePreferences";
        public static final String SCROLLABLE_TABBED_PANES = "useScrollableTabbedPanes";
        public static final String SESSION_PROPERTIES = "sessionProperties";
        public static final String SHOW_ALIASES_TOOL_BAR = "showAliasesToolBar";
        public static final String SHOW_CONTENTS_WHEN_DRAGGING = "showContentsWhenDragging";
        public static final String TABBED_STYLE = "tabbedStyle";
        public static final String USE_SCROLLABLE_TABBED_PANES_FOR_SESSION_TABS = "useScrollableTabbedPanesForSessionTabs";
        public static final String SHOW_TABBED_STYLE_HINT = "showTabbedStyleHint";
        public static final String SHOW_DRIVERS_TOOL_BAR = "showDriversToolBar";
        public static final String SHOW_LOADED_DRIVERS_ONLY = "showLoadedDriversOnly";
        public static final String SHOW_MAIN_STATUS_BAR = "showMainStatusBar";
        public static final String SHOW_MAIN_TOOL_BAR = "showMainToolBar";
        public static final String SHOW_TOOLTIPS = "showToolTips";
        public static final String SHOW_COLOR_ICONS_IN_TOOLBAR = "showColorIconsInToolbars";
        public static final String SHOW_PLUGIN_FILES_IN_SPLASH_SCREEN = "showPluginFilesInSplashScreen";
        public static final String USE_SHORT_SESSION_TITLE = "useShortSessionTitle";
        public static final String FILE_OPEN_IN_PREVIOUS_DIR = "fileOpenInPreviousDir";
        public static final String FILE_OPEN_IN_SPECIFIED_DIR = "fileOpenInSpecifiedDir";
        public static final String FILE_SPECIFIED_DIR = "fileSpecifiedDir";
        public static final String FILE_PREVIOUS_DIR = "filePreviousdDir";
        public static final String WARN_JRE_JDBC_MISMATCH = "warnJreJdbcMismatch";
        public static final String WARN_FOR_UNSAVED_FILE_EDITS = "warnForUnsavedFileEdits";
        public static final String WARN_FOR_UNSAVED_BUFFER_EDITS = "warnForUnsavedBufferEdits";
        public static final String SHOW_SESSION_STARTUP_TIME_HINT = "showSessionStartupTimeHint";
        public static final String SHOW_DEBUG_LOG_MESSAGES = "showDebugLogMessages";
        public static final String SHOW_INFO_LOG_MESSAGES = "showInfoLogMessages";
        public static final String SHOW_ERROR_LOG_MESSAGES = "showErrorLogMessages";
        public static final String SAVE_PREFERENCES_IMMEDIATELY = "savePreferencesImmediately";
        public static final String SELECT_ON_RIGHT_MOUSE_CLICK = "selectOnRightMouseClick";
        public static final String SHOW_PLEASE_WAIT_DIALOG = "showPleaseWaitDialog";
        public static final String PREFERRED_LOCALE = "preferredLocale";
        public static final String MAX_COLUMN_ADJUST_LENGTH_DEFINED = "maxColumnAdjustLengthDefined";
        public static final String MAX_COLUMN_ADJUST_LENGTH = "maxColumnAdjustLength";
        public static final String REMEMBER_VALUE_OF_POPUP = "rememberValueOfPopup";
        public static final String RELOAD_SQL_CONTENTS = "ReloadSqlContents";
    }
}

