/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.preferences;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.Icon;

public class ColorIcon
implements Icon {
    private int iWidth;
    private int iHeight;
    private Color color;
    private Color border;
    private Insets insets;

    public ColorIcon() {
        this(32, 16);
    }

    public ColorIcon(int width, int height) {
        this(width, height, Color.black);
    }

    public ColorIcon(int width, int height, Color c) {
        this.iWidth = width;
        this.iHeight = height;
        this.color = c;
        this.border = Color.black;
        this.insets = new Insets(1, 1, 1, 1);
    }

    public void setColor(Color c) {
        this.color = c;
    }

    public Color getColor() {
        return this.color;
    }

    public void setBorderColor(Color c) {
        this.border = c;
    }

    @Override
    public int getIconWidth() {
        return this.iWidth;
    }

    @Override
    public int getIconHeight() {
        return this.iHeight;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        g.setColor(this.border);
        g.drawRect(x, y, this.iWidth - 1, this.iHeight - 2);
        int w = this.iWidth - this.insets.left - this.insets.right;
        int h = this.iHeight - this.insets.top - this.insets.bottom - 1;
        g.setColor(this.color);
        g.fillRect(x += this.insets.left, y += this.insets.top, w, h);
    }
}

