/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.session;

import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.SessionTabWidget;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetAdapter;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.WidgetEvent;
import net.sourceforge.squirrel_sql.client.gui.session.MainPanelFactory;
import net.sourceforge.squirrel_sql.client.gui.session.SessionPanel;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeInternalFrame;
import net.sourceforge.squirrel_sql.client.session.ISQLInternalFrame;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;

public class SessionInternalFrame
extends SessionTabWidget
implements ISQLInternalFrame,
IObjectTreeInternalFrame {
    static final long serialVersionUID = 6961615570741567740L;
    private final IApplication _app;
    private SessionPanel _sessionPanel;

    public SessionInternalFrame(ISession session) {
        super(session.getTitle(), true, true, true, true, session);
        this._app = session.getApplication();
        this.setVisible(false);
        this.createGUI(session);
    }

    public SessionPanel getSessionPanel() {
        return this._sessionPanel;
    }

    @Override
    public ISQLPanelAPI getSQLPanelAPI() {
        return this._sessionPanel.getSQLPaneAPI();
    }

    @Override
    public IObjectTreeAPI getObjectTreeAPI() {
        return this._sessionPanel.getObjectTreePanel();
    }

    void addToToolbar(Action action) {
        this._sessionPanel.addToToolbar(action);
    }

    public void addSeparatorToToolbar() {
        this._sessionPanel.addSeparatorToToolbar();
    }

    public void addToToolsPopUp(String selectionString, Action action) {
        this._sessionPanel.addToToolsPopUp(selectionString, action);
    }

    private void createGUI(final ISession session) {
        this.setVisible(false);
        this.setDefaultCloseOperation(0);
        IApplication app = session.getApplication();
        ImageIcon icon = app.getResources().getIcon(this.getClass(), "frameIcon");
        if (icon != null) {
            this.setFrameIcon(icon);
        }
        this.addWidgetListener(new WidgetAdapter(){

            @Override
            public boolean widgetClosing(WidgetEvent evt) {
                if (!session.isfinishedLoading()) {
                    return false;
                }
                ISession mySession = SessionInternalFrame.this.getSession();
                if (mySession != null) {
                    boolean success = SessionInternalFrame.this._app.getSessionManager().closeSession(mySession, true);
                    if (success) {
                        SessionInternalFrame.this._sessionPanel.sessionWindowClosing();
                    }
                    return success;
                }
                return true;
            }
        });
        this._sessionPanel = new SessionPanel(session);
        this._sessionPanel.setMainPanelFactory(new MainPanelFactory());
        this._sessionPanel.initialize(session);
        this.setContentPane(this._sessionPanel);
        this.validate();
    }

    public void requestFocus() {
        if (1 == this.getSession().getSelectedMainTabIndex()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SessionInternalFrame.this._sessionPanel.getSQLEntryPanel().requestFocus();
                }
            });
        } else if (0 == this.getSession().getSelectedMainTabIndex()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    SessionInternalFrame.this._sessionPanel.getObjectTreePanel().requestFocus();
                }
            });
        }
    }

    @Override
    public boolean hasSQLPanelAPI() {
        return true;
    }

    @Override
    public void moveToFront() {
        super.moveToFront();
        if (1 == this._sessionPanel.getSelectedMainTabIndex()) {
            this._sessionPanel.getSQLEntryPanel().requestFocus();
        }
    }
}

