/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.pastefromhistory;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.prefs.Preferences;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sourceforge.squirrel_sql.client.Main;
import net.sourceforge.squirrel_sql.client.gui.pastefromhistory.PasteFromHistoryDialog;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.session.mainpanel.multiclipboard.PasteHistory;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;

public class PasteFromHistoryController {
    private static final String PREF_KEY_PASTE_HIST_DIALOG_WIDTH = "Squirrel.paste.history.dialog.width";
    private static final String PREF_KEY_PASTE_HIST_DIALOG_HEIGHT = "Squirrel.paste.history.dialog.height";
    private final PasteFromHistoryDialog _dlg;
    private ISQLPanelAPI _sqlPanelAPI;

    public PasteFromHistoryController(ISQLPanelAPI sqlPanelAPI) {
        this._sqlPanelAPI = sqlPanelAPI;
        this._dlg = new PasteFromHistoryDialog();
        this._dlg.txtHistoryDetail.setEditable(false);
        PasteHistory pasteHistory = Main.getApplication().getPasteHistory();
        String[] histroy = pasteHistory.getHistroy();
        this._dlg.lstHistoryItems.setListData(histroy);
        if (0 < histroy.length) {
            this._dlg.lstHistoryItems.setSelectedIndex(0);
            this._dlg.txtHistoryDetail.setText(histroy[0]);
        }
        this._dlg.setSize(this.getDimension());
        this._dlg.btnCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PasteFromHistoryController.this.close();
            }
        });
        this._dlg.btnOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PasteFromHistoryController.this.onOk();
            }
        });
        this._dlg.lstHistoryItems.requestFocus();
        this._dlg.lstHistoryItems.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PasteFromHistoryController.this.onSelectionChanged(e);
            }
        });
        this._dlg.lstHistoryItems.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PasteFromHistoryController.this.onListMouseClicked(e);
            }
        });
        this._dlg.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PasteFromHistoryController.this.onWindowClosing();
            }
        });
        this._dlg.setVisible(true);
        GUIUtils.centerWithinParent(this._dlg);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((PasteFromHistoryController)PasteFromHistoryController.this)._dlg.lstHistoryItems.requestFocus();
            }
        });
    }

    private void onListMouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.onOk();
        }
    }

    private void onOk() {
        String selected = (String)this._dlg.lstHistoryItems.getSelectedValue();
        if (null != selected) {
            this._sqlPanelAPI.getSQLEntryPanel().replaceSelection(selected);
        }
        Main.getApplication().getPasteHistory().addToPasteHistory(selected);
        this.close();
    }

    private void close() {
        this.onWindowClosing();
        this._dlg.setVisible(false);
        this._dlg.dispose();
    }

    private Dimension getDimension() {
        return new Dimension(Preferences.userRoot().getInt(PREF_KEY_PASTE_HIST_DIALOG_WIDTH, 800), Preferences.userRoot().getInt(PREF_KEY_PASTE_HIST_DIALOG_HEIGHT, 500));
    }

    private void onSelectionChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        String selectedValue = (String)this._dlg.lstHistoryItems.getSelectedValue();
        if (null == selectedValue) {
            this._dlg.txtHistoryDetail.setText("");
        } else {
            this._dlg.txtHistoryDetail.setText(selectedValue);
        }
    }

    private void onWindowClosing() {
        Dimension size = this._dlg.getSize();
        Preferences.userRoot().putInt(PREF_KEY_PASTE_HIST_DIALOG_WIDTH, size.width);
        Preferences.userRoot().putInt(PREF_KEY_PASTE_HIST_DIALOG_HEIGHT, size.height);
    }
}

