/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.client.gui.mainframe;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.gui.desktopcontainer.IDesktopContainer;
import net.sourceforge.squirrel_sql.client.gui.mainframe.IHasJDesktopPane;
import net.sourceforge.squirrel_sql.client.mainframe.action.AboutAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.AliasFileOpenAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.AliasPropertiesAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CascadeAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CloseAllButCurrentSessionsAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CloseAllSessionsAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CollapseAllAliasFolderAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ConnectToAliasAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CopyAliasAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CopyDriverAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CopyToPasteAliasFolderAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CreateAliasAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CreateDriverAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.CutAliasFolderAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.DeleteAliasAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.DeleteDriverAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.DisplayPluginSummaryAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.DumpApplicationAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ExitAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ExpandAllAliasFolderAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.GlobalPreferencesAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.InstallDefaultDriversAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.MaximizeAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ModifyAliasAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ModifyDriverAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.NewAliasFolderAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.NewSessionPropertiesAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.PasteAliasFolderAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.SavePreferencesAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ShowDriverWebsiteAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ShowLoadedDriversOnlyAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.SortAliasesAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.TileAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.TileHorizontalAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.TileVerticalAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ToggleTreeViewAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ViewAliasesAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ViewDriversAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ViewHelpAction;
import net.sourceforge.squirrel_sql.client.mainframe.action.ViewLogsAction;
import net.sourceforge.squirrel_sql.client.plugin.IPluginManager;
import net.sourceforge.squirrel_sql.client.plugin.PluginInfo;
import net.sourceforge.squirrel_sql.client.resources.SquirrelResources;
import net.sourceforge.squirrel_sql.client.session.action.CloseAllSQLResultTabsAction;
import net.sourceforge.squirrel_sql.client.session.action.CloseAllSQLResultTabsButCurrentAction;
import net.sourceforge.squirrel_sql.client.session.action.CloseAllSQLResultWindowsAction;
import net.sourceforge.squirrel_sql.client.session.action.CloseCurrentSQLResultTabAction;
import net.sourceforge.squirrel_sql.client.session.action.CloseSessionAction;
import net.sourceforge.squirrel_sql.client.session.action.CloseSessionWindowAction;
import net.sourceforge.squirrel_sql.client.session.action.CommitAction;
import net.sourceforge.squirrel_sql.client.session.action.ConvertToStringBufferAction;
import net.sourceforge.squirrel_sql.client.session.action.CopySqlAction;
import net.sourceforge.squirrel_sql.client.session.action.CutSqlAction;
import net.sourceforge.squirrel_sql.client.session.action.DumpSessionAction;
import net.sourceforge.squirrel_sql.client.session.action.EditWhereColsAction;
import net.sourceforge.squirrel_sql.client.session.action.EscapeDateAction;
import net.sourceforge.squirrel_sql.client.session.action.ExecuteAllSqlsAction;
import net.sourceforge.squirrel_sql.client.session.action.ExecuteSqlAction;
import net.sourceforge.squirrel_sql.client.session.action.FileAppendAction;
import net.sourceforge.squirrel_sql.client.session.action.FileCloseAction;
import net.sourceforge.squirrel_sql.client.session.action.FileDetachAction;
import net.sourceforge.squirrel_sql.client.session.action.FileNewAction;
import net.sourceforge.squirrel_sql.client.session.action.FileOpenAction;
import net.sourceforge.squirrel_sql.client.session.action.FileOpenRecentAction;
import net.sourceforge.squirrel_sql.client.session.action.FilePrintAction;
import net.sourceforge.squirrel_sql.client.session.action.FileSaveAction;
import net.sourceforge.squirrel_sql.client.session.action.FileSaveAsAction;
import net.sourceforge.squirrel_sql.client.session.action.FormatSQLAction;
import net.sourceforge.squirrel_sql.client.session.action.GotoNextResultsTabAction;
import net.sourceforge.squirrel_sql.client.session.action.GotoPreviousResultsTabAction;
import net.sourceforge.squirrel_sql.client.session.action.InQuotesAction;
import net.sourceforge.squirrel_sql.client.session.action.NewObjectTreeAction;
import net.sourceforge.squirrel_sql.client.session.action.NewSQLWorksheetAction;
import net.sourceforge.squirrel_sql.client.session.action.NextSessionAction;
import net.sourceforge.squirrel_sql.client.session.action.NextSqlAction;
import net.sourceforge.squirrel_sql.client.session.action.PasteFromHistoryAction;
import net.sourceforge.squirrel_sql.client.session.action.PasteFromHistoryAltAcceleratorAction;
import net.sourceforge.squirrel_sql.client.session.action.PreviousSessionAction;
import net.sourceforge.squirrel_sql.client.session.action.PreviousSqlAction;
import net.sourceforge.squirrel_sql.client.session.action.ReconnectAction;
import net.sourceforge.squirrel_sql.client.session.action.RefreshSchemaInfoAction;
import net.sourceforge.squirrel_sql.client.session.action.RemoveNewLinesAction;
import net.sourceforge.squirrel_sql.client.session.action.RemoveQuotesAction;
import net.sourceforge.squirrel_sql.client.session.action.RenameSessionAction;
import net.sourceforge.squirrel_sql.client.session.action.RerunCurrentSQLResultTabAction;
import net.sourceforge.squirrel_sql.client.session.action.RollbackAction;
import net.sourceforge.squirrel_sql.client.session.action.SQLFilterAction;
import net.sourceforge.squirrel_sql.client.session.action.SelectSqlAction;
import net.sourceforge.squirrel_sql.client.session.action.SessionPropertiesAction;
import net.sourceforge.squirrel_sql.client.session.action.ShowNativeSQLAction;
import net.sourceforge.squirrel_sql.client.session.action.ToggleAutoCommitAction;
import net.sourceforge.squirrel_sql.client.session.action.ToggleCurrentSQLResultTabStickyAction;
import net.sourceforge.squirrel_sql.client.session.action.ToggleMinimizeResultsAction;
import net.sourceforge.squirrel_sql.client.session.action.ToolsPopupAction;
import net.sourceforge.squirrel_sql.client.session.action.ViewObjectAtCursorInObjectTreeAction;
import net.sourceforge.squirrel_sql.fw.gui.IToggleAction;
import net.sourceforge.squirrel_sql.fw.util.Resources;
import net.sourceforge.squirrel_sql.fw.util.SystemProperties;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;

final class MainFrameMenuBar
extends JMenuBar {
    private static final ILogger s_log = LoggerController.createLogger(MainFrameMenuBar.class);
    private final IApplication _app;
    private final JMenu _pluginsMenu;
    private final JMenu _sessionMenu;
    private final JMenu _windowsMenu;
    private JMenu _aliasesMenu;
    private JMenu _driversMenu;
    private final ActionCollection _actions;
    private JCheckBoxMenuItem _showLoadedDriversOnlyItem;
    private SquirrelPropertiesListener _propsLis;
    private final boolean _osxPluginLoaded;

    MainFrameMenuBar(IApplication app, IDesktopContainer desktopContainer, ActionCollection actions) {
        if (app == null) {
            throw new IllegalArgumentException("Null IApplication passed");
        }
        if (desktopContainer == null) {
            throw new IllegalArgumentException("Null JDesktopPane passed");
        }
        if (actions == null) {
            throw new IllegalArgumentException("Null ActionCollection passed");
        }
        SquirrelResources rsrc = app.getResources();
        if (rsrc == null) {
            throw new IllegalStateException("No Resources object in IApplication");
        }
        this._actions = actions;
        this._app = app;
        this._osxPluginLoaded = this.isOsxPluginLoaded();
        this.add(this.createOsxFileMenu(rsrc));
        this._driversMenu = this.createDriversMenu(rsrc);
        this.add(this._driversMenu);
        this._aliasesMenu = this.createAliasesMenu(rsrc);
        this.add(this._aliasesMenu);
        this._pluginsMenu = this.createPluginsMenu(rsrc);
        this.add(this._pluginsMenu);
        this._sessionMenu = this.createSessionMenu(rsrc);
        this.add(this._sessionMenu);
        this._windowsMenu = this.createWindowsMenu(rsrc, desktopContainer);
        this.add(this._windowsMenu);
        this.add(this.createHelpMenu(rsrc));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.propertiesChanged(null);
        if (this._propsLis == null) {
            this._propsLis = new SquirrelPropertiesListener();
            this._app.getSquirrelPreferences().addPropertyChangeListener(this._propsLis);
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        if (this._propsLis != null) {
            this._app.getSquirrelPreferences().removePropertyChangeListener(this._propsLis);
            this._propsLis = null;
        }
    }

    JMenu getWindowsMenu() {
        return this._windowsMenu;
    }

    JMenu getSessionMenu() {
        return this._sessionMenu;
    }

    void addToMenu(int menuId, JMenu menu) {
        if (menu == null) {
            throw new IllegalArgumentException("Null JMenu passed");
        }
        switch (menuId) {
            case 1: {
                this._pluginsMenu.add(menu);
                break;
            }
            case 2: {
                this._sessionMenu.add(menu);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid menuId passed: " + menuId);
            }
        }
    }

    void addToMenu(int menuId, Action action) {
        if (action == null) {
            throw new IllegalArgumentException("Null Action passed");
        }
        switch (menuId) {
            case 1: {
                this._pluginsMenu.add(action);
                break;
            }
            case 2: {
                this._sessionMenu.add(action);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid menuId passed: " + menuId);
            }
        }
    }

    void addToMenu(int menuId, Component comp) {
        if (comp == null) {
            throw new IllegalArgumentException("Component == null");
        }
        switch (menuId) {
            case 1: {
                this._pluginsMenu.add(comp);
                break;
            }
            case 2: {
                this._sessionMenu.add(comp);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid menuId passed: " + menuId);
            }
        }
    }

    private JMenu createOsxFileMenu(Resources rsrc) {
        JMenu menu = rsrc.createMenu("osxFile");
        if (!this._osxPluginLoaded) {
            this.addToMenu(rsrc, GlobalPreferencesAction.class, menu);
        }
        this.addToMenu(rsrc, NewSessionPropertiesAction.class, menu);
        menu.addSeparator();
        this.addToMenu(rsrc, DumpApplicationAction.class, menu);
        this.addToMenu(rsrc, SavePreferencesAction.class, menu);
        menu.addSeparator();
        if (!this._osxPluginLoaded) {
            this.addToMenu(rsrc, ExitAction.class, menu);
        }
        return menu;
    }

    public void setEnabledAliasesMenu(boolean b) {
        this._aliasesMenu.setEnabled(b);
    }

    public void setEnabledDriversMenu(boolean b) {
        this._driversMenu.setEnabled(b);
    }

    private JMenu createSessionMenu(Resources rsrc) {
        JMenu menu = rsrc.createMenu("session");
        this.addToMenu(rsrc, SessionPropertiesAction.class, menu);
        this.addToMenu(rsrc, DumpSessionAction.class, menu);
        menu.addSeparator();
        this.addToMenu(rsrc, ToolsPopupAction.class, menu);
        this.addToMenu(rsrc, RefreshSchemaInfoAction.class, menu);
        this.addToMenu(rsrc, ExecuteSqlAction.class, menu);
        this.addToMenu(rsrc, ExecuteAllSqlsAction.class, menu);
        menu.add(this.createTransactionMenu(rsrc));
        this.addToMenu(rsrc, SQLFilterAction.class, menu);
        menu.addSeparator();
        this.addToMenu(rsrc, ViewObjectAtCursorInObjectTreeAction.class, menu);
        menu.addSeparator();
        menu.add(this.createFileMenu(rsrc));
        menu.addSeparator();
        this.addToMenu(rsrc, GotoPreviousResultsTabAction.class, menu);
        this.addToMenu(rsrc, GotoNextResultsTabAction.class, menu);
        this.addToMenu(rsrc, ToggleCurrentSQLResultTabStickyAction.class, menu);
        this.addToMenu(rsrc, RerunCurrentSQLResultTabAction.class, menu);
        menu.addSeparator();
        this.addToMenu(rsrc, ShowNativeSQLAction.class, menu);
        menu.addSeparator();
        this.addToMenu(rsrc, ReconnectAction.class, menu);
        this.addToMenu(rsrc, CloseSessionWindowAction.class, menu);
        this.addToMenu(rsrc, CloseSessionAction.class, menu);
        this.addToMenu(rsrc, RenameSessionAction.class, menu);
        menu.add(this.createSQLResultsCloseMenu(rsrc));
        menu.addSeparator();
        this.addToMenu(rsrc, PreviousSessionAction.class, menu);
        this.addToMenu(rsrc, NextSessionAction.class, menu);
        menu.addSeparator();
        this.addToMenu(rsrc, PreviousSqlAction.class, menu);
        this.addToMenu(rsrc, NextSqlAction.class, menu);
        this.addToMenu(rsrc, SelectSqlAction.class, menu);
        menu.addSeparator();
        this.addToMenu(rsrc, FormatSQLAction.class, menu);
        this.addToMenu(rsrc, InQuotesAction.class, menu);
        this.addToMenu(rsrc, RemoveQuotesAction.class, menu);
        this.addToMenu(rsrc, ConvertToStringBufferAction.class, menu);
        this.addToMenu(rsrc, EscapeDateAction.class, menu);
        this.addToMenu(rsrc, CutSqlAction.class, menu);
        this.addToMenu(rsrc, CopySqlAction.class, menu);
        this.addToMenu(rsrc, RemoveNewLinesAction.class, menu);
        menu.addSeparator();
        this.addToMenu(rsrc, EditWhereColsAction.class, menu);
        menu.addSeparator();
        this.addToMenu(rsrc, NewSQLWorksheetAction.class, menu);
        this.addToMenu(rsrc, NewObjectTreeAction.class, menu);
        menu.addSeparator();
        this.addToMenu(rsrc, PasteFromHistoryAction.class, menu);
        this.addToMenu(rsrc, PasteFromHistoryAltAcceleratorAction.class, menu);
        menu.addSeparator();
        this.addToMenu(rsrc, ToggleMinimizeResultsAction.class, menu);
        menu.addSeparator();
        menu.setEnabled(false);
        return menu;
    }

    private JMenu createPluginsMenu(Resources rsrc) {
        JMenu menu = rsrc.createMenu("plugins");
        this.addToMenu(rsrc, DisplayPluginSummaryAction.class, menu);
        menu.addSeparator();
        return menu;
    }

    private JMenu createAliasesMenu(Resources rsrc) {
        JMenu menu = rsrc.createMenu("aliases");
        this.addToMenu(rsrc, ConnectToAliasAction.class, menu);
        menu.addSeparator();
        this.addToMenu(rsrc, CreateAliasAction.class, menu);
        this.addToMenu(rsrc, ModifyAliasAction.class, menu);
        this.addToMenu(rsrc, DeleteAliasAction.class, menu);
        this.addToMenu(rsrc, CopyAliasAction.class, menu);
        menu.addSeparator();
        this.addToMenu(rsrc, AliasPropertiesAction.class, menu);
        menu.addSeparator();
        this.addToMenu(rsrc, AliasFileOpenAction.class, menu);
        menu.addSeparator();
        this.addToMenu(rsrc, SortAliasesAction.class, menu);
        menu.addSeparator();
        this.addToMenuAsCheckBoxMenuItem(rsrc, ToggleTreeViewAction.class, menu);
        this.addToMenu(rsrc, NewAliasFolderAction.class, menu);
        this.addToMenu(rsrc, CopyToPasteAliasFolderAction.class, menu);
        this.addToMenu(rsrc, CutAliasFolderAction.class, menu);
        this.addToMenu(rsrc, PasteAliasFolderAction.class, menu);
        this.addToMenu(rsrc, CollapseAllAliasFolderAction.class, menu);
        this.addToMenu(rsrc, ExpandAllAliasFolderAction.class, menu);
        return menu;
    }

    private JMenu createDriversMenu(Resources rsrc) {
        JMenu menu = rsrc.createMenu("drivers");
        this.addToMenu(rsrc, CreateDriverAction.class, menu);
        menu.addSeparator();
        this.addToMenu(rsrc, ModifyDriverAction.class, menu);
        this.addToMenu(rsrc, DeleteDriverAction.class, menu);
        this.addToMenu(rsrc, CopyDriverAction.class, menu);
        this.addToMenu(rsrc, ShowDriverWebsiteAction.class, menu);
        menu.addSeparator();
        this.addToMenu(rsrc, InstallDefaultDriversAction.class, menu);
        menu.addSeparator();
        this._showLoadedDriversOnlyItem = this.addToMenuAsCheckBoxMenuItem(rsrc, ShowLoadedDriversOnlyAction.class, menu);
        return menu;
    }

    private JMenu createWindowsMenu(Resources rsrc, IDesktopContainer desktopPane) {
        JMenu menu = rsrc.createMenu("windows");
        this.addToMenu(rsrc, ViewAliasesAction.class, menu);
        this.addToMenu(rsrc, ViewDriversAction.class, menu);
        this.addToMenu(rsrc, ViewLogsAction.class, menu);
        if (this._app.getDesktopStyle().isInternalFrameStyle()) {
            menu.addSeparator();
            this.addDesktopPaneActionToMenu(rsrc, TileAction.class, menu, desktopPane);
            this.addDesktopPaneActionToMenu(rsrc, TileHorizontalAction.class, menu, desktopPane);
            this.addDesktopPaneActionToMenu(rsrc, TileVerticalAction.class, menu, desktopPane);
            this.addDesktopPaneActionToMenu(rsrc, CascadeAction.class, menu, desktopPane);
            this.addDesktopPaneActionToMenu(rsrc, MaximizeAction.class, menu, desktopPane);
            menu.addSeparator();
        }
        this.addToMenu(rsrc, CloseAllSessionsAction.class, menu);
        this.addToMenu(rsrc, CloseAllButCurrentSessionsAction.class, menu);
        menu.addSeparator();
        return menu;
    }

    private JMenu createHelpMenu(Resources rsrc) {
        JMenu menu = rsrc.createMenu("help");
        this.addToMenu(rsrc, ViewHelpAction.class, menu);
        menu.addSeparator();
        if (!this._osxPluginLoaded) {
            this.addToMenu(rsrc, AboutAction.class, menu);
        }
        return menu;
    }

    private JMenu createSQLResultsCloseMenu(Resources rsrc) {
        JMenu menu = rsrc.createMenu("close_all_sql_results");
        this.addToMenu(rsrc, CloseAllSQLResultTabsAction.class, menu);
        this.addToMenu(rsrc, CloseCurrentSQLResultTabAction.class, menu);
        this.addToMenu(rsrc, CloseAllSQLResultTabsButCurrentAction.class, menu);
        this.addToMenu(rsrc, CloseAllSQLResultWindowsAction.class, menu);
        return menu;
    }

    private Component createFileMenu(Resources rsrc) {
        JMenu menu = rsrc.createMenu("file");
        this.addToMenu(rsrc, FileNewAction.class, menu);
        this.addToMenu(rsrc, FileDetachAction.class, menu);
        this.addToMenu(rsrc, FileOpenAction.class, menu);
        this.addToMenu(rsrc, FileOpenRecentAction.class, menu);
        this.addToMenu(rsrc, FileSaveAction.class, menu);
        this.addToMenu(rsrc, FileSaveAsAction.class, menu);
        this.addToMenu(rsrc, FileCloseAction.class, menu);
        this.addToMenu(rsrc, FileAppendAction.class, menu);
        this.addToMenu(rsrc, FilePrintAction.class, menu);
        return menu;
    }

    private Component createTransactionMenu(Resources rsrc) {
        JMenu menu = rsrc.createMenu("transaction");
        this.addToMenuAsCheckBoxMenuItem(rsrc, ToggleAutoCommitAction.class, menu);
        this.addToMenu(rsrc, CommitAction.class, menu);
        this.addToMenu(rsrc, RollbackAction.class, menu);
        return menu;
    }

    private Action addDesktopPaneActionToMenu(Resources rsrc, Class actionClass, JMenu menu, IDesktopContainer desktopContainer) {
        Action act = this.addToMenu(rsrc, actionClass, menu);
        if (act != null) {
            if (act instanceof IHasJDesktopPane) {
                ((IHasJDesktopPane)((Object)act)).setDesktopContainer(desktopContainer);
            } else {
                s_log.error("Tryimg to add non IHasJDesktopPane (" + actionClass.getName() + ") in MainFrameMenuBar.addDesktopPaneActionToMenu");
            }
        }
        return act;
    }

    private Action addToMenu(Resources rsrc, Class actionClass, JMenu menu) {
        Action act = this._actions.get(actionClass);
        if (act != null) {
            rsrc.addToMenu(act, menu);
        } else {
            s_log.error("Could not retrieve instance of " + actionClass.getName() + ") in MainFrameMenuBar.addToMenu");
        }
        return act;
    }

    private JCheckBoxMenuItem addToMenuAsCheckBoxMenuItem(Resources rsrc, Class actionClass, JMenu menu) {
        Action act = this._actions.get(actionClass);
        if (act != null) {
            JCheckBoxMenuItem mnu = rsrc.addToMenuAsCheckBoxMenuItem(act, menu);
            if (act instanceof IToggleAction) {
                ((IToggleAction)act).getToggleComponentHolder().addToggleableComponent(mnu);
            }
            return mnu;
        }
        s_log.error("Could not retrieve instance of " + actionClass.getName() + ") in MainFrameMenuBar.addToMenu");
        return null;
    }

    private void propertiesChanged(String propName) {
        if (propName == null || propName.equals("showLoadedDriversOnly")) {
            boolean show = this._app.getSquirrelPreferences().getShowLoadedDriversOnly();
            this._showLoadedDriversOnlyItem.setSelected(show);
        }
    }

    private boolean isOsxPluginLoaded() {
        if (SystemProperties.isRunningOnOSX()) {
            IPluginManager mgr = this._app.getPluginManager();
            PluginInfo[] ar = mgr.getPluginInformation();
            for (int i = 0; i < ar.length; ++i) {
                if (!ar[i].getInternalName().equals("macosx")) continue;
                return ar[i].isLoaded();
            }
        }
        return false;
    }

    private class SquirrelPropertiesListener
    implements PropertyChangeListener {
        private SquirrelPropertiesListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            String propName = evt != null ? evt.getPropertyName() : null;
            MainFrameMenuBar.this.propertiesChanged(propName);
        }
    }

    public static interface IMenuIDs {
        public static final int PLUGINS_MENU = 1;
        public static final int SESSION_MENU = 2;
    }
}

