/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.dataimport.importer.excel;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import javax.swing.JComponent;
import net.sourceforge.squirrel_sql.plugins.dataimport.importer.IFileImporter;
import net.sourceforge.squirrel_sql.plugins.dataimport.importer.UnsupportedFormatException;
import net.sourceforge.squirrel_sql.plugins.dataimport.importer.excel.ExcelSettingsBean;
import net.sourceforge.squirrel_sql.plugins.dataimport.importer.excel.ExcelSettingsPanel;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class ExcelFileImporter
implements IFileImporter {
    private File importFile = null;
    private int pointer = -1;
    private int size = 0;
    private Workbook workbook = null;
    private Sheet sheet = null;
    private ExcelSettingsBean settings = null;

    public ExcelFileImporter(File importFile) {
        this.importFile = importFile;
        this.settings = new ExcelSettingsBean();
    }

    @Override
    public boolean open() throws IOException {
        try {
            this.workbook = WorkbookFactory.create((File)this.importFile);
        }
        catch (InvalidFormatException fe) {
            throw new IOException(fe.toString());
        }
        this.reset();
        return true;
    }

    @Override
    public boolean close() throws IOException {
        return true;
    }

    @Override
    public String[][] getPreview(int noOfLines) throws IOException {
        String[][] data = null;
        Workbook wb = null;
        Sheet sht = null;
        try {
            wb = WorkbookFactory.create((File)this.importFile);
            sht = this.getSheet(wb);
        }
        catch (InvalidFormatException fe) {
            throw new IOException(fe.toString());
        }
        int y = 0;
        int x = 0;
        int maxLines = noOfLines < sht.getPhysicalNumberOfRows() ? noOfLines : sht.getPhysicalNumberOfRows();
        Row row = sht.getRow(0);
        data = new String[maxLines][row.getPhysicalNumberOfCells()];
        for (y = 0; y < maxLines; ++y) {
            for (x = 0; x < row.getPhysicalNumberOfCells(); ++x) {
                data[y][x] = row.getCell(x).toString();
            }
        }
        return data;
    }

    @Override
    public boolean reset() throws IOException {
        this.sheet = this.getSheet(this.workbook);
        this.size = this.sheet.getPhysicalNumberOfRows();
        this.pointer = -1;
        return true;
    }

    @Override
    public int getRows() {
        return this.size;
    }

    @Override
    public boolean next() throws IOException {
        if (this.pointer >= this.size - 1) {
            return false;
        }
        ++this.pointer;
        return true;
    }

    private void checkPointer() throws IOException {
        if (this.pointer < 0) {
            throw new IOException("Use next() to get to the first record.");
        }
    }

    @Override
    public String getString(int column) throws IOException {
        this.checkPointer();
        return this.sheet.getRow(this.pointer).getCell(column).toString();
    }

    @Override
    public Integer getInt(int column) throws IOException, UnsupportedFormatException {
        this.checkPointer();
        Cell cell = this.sheet.getRow(this.pointer).getCell(column);
        if (cell.getCellType() != 0) {
            throw new UnsupportedFormatException("Could not interpret value as numeric type. String of value is: " + cell);
        }
        return Double.valueOf(cell.getNumericCellValue()).intValue();
    }

    @Override
    public Date getDate(int column) throws IOException, UnsupportedFormatException {
        this.checkPointer();
        Cell cell = this.sheet.getRow(this.pointer).getCell(column);
        if (DateUtil.isCellDateFormatted((Cell)cell)) {
            throw new UnsupportedFormatException("Could not interpret value as date type. String of value is: " + cell);
        }
        return DateUtil.getJavaDate((double)cell.getNumericCellValue());
    }

    @Override
    public Long getLong(int column) throws IOException, UnsupportedFormatException {
        this.checkPointer();
        Cell cell = this.sheet.getRow(this.pointer).getCell(column);
        if (cell.getCellType() != 0) {
            throw new UnsupportedFormatException("Could not interpret value as numeric type. String of value is: " + cell);
        }
        return Double.valueOf(cell.getNumericCellValue()).longValue();
    }

    @Override
    public JComponent getConfigurationPanel() {
        return new ExcelSettingsPanel(this.settings, this.importFile);
    }

    private Sheet getSheet(Workbook wb) {
        Sheet s = null;
        if (this.settings.getSheetName() != null) {
            s = wb.getSheet(this.settings.getSheetName());
        }
        if (s == null) {
            s = wb.getSheetAt(0);
        }
        return s;
    }
}

