/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.mssql.action;

import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.ICommand;
import net.sourceforge.squirrel_sql.plugins.mssql.MssqlPlugin;

public class UpdateStatisticsCommand
implements ICommand {
    private ISession _session;
    private final MssqlPlugin _plugin;

    public UpdateStatisticsCommand(ISession session, MssqlPlugin plugin) {
        if (session == null) {
            throw new IllegalArgumentException("ISession == null");
        }
        this._session = session;
        this._plugin = plugin;
    }

    public void execute() {
        String sqlSep = this._session.getQueryTokenizer().getSQLStatementSeparator();
        IObjectTreeAPI api = this._session.getSessionInternalFrame().getObjectTreeAPI();
        IDatabaseObjectInfo[] dbObjs = api.getSelectedDatabaseObjects();
        StringBuffer cmd = new StringBuffer(512);
        for (int i = 0; i < dbObjs.length; ++i) {
            cmd.append("UPDATE STATISTICS ");
            cmd.append(dbObjs[i].getCatalogName());
            cmd.append(".");
            cmd.append(dbObjs[i].getSchemaName());
            cmd.append(".");
            cmd.append(dbObjs[i].getSimpleName());
            cmd.append(" WITH FULLSCAN, ALL\n");
            cmd.append(sqlSep);
            cmd.append("\n");
        }
        if (cmd != null && cmd.length() > 0) {
            this._session.getSessionInternalFrame().getSQLPanelAPI().appendSQLScript(cmd.toString(), true);
            this._session.getSessionInternalFrame().getSQLPanelAPI().executeCurrentSQL();
            this._session.selectMainTab(1);
        }
    }
}

