/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.oracle.invalidobjects;

import java.awt.BorderLayout;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.oracle.common.AutoWidthResizeTable;

public class InvalidObjectsPanel
extends JPanel {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(InvalidObjectsPanel.class);
    private static final ILogger s_log = LoggerController.createLogger(InvalidObjectsPanel.class);
    private ISession _session;
    private AutoWidthResizeTable _invalidObjects;
    private boolean hasResized = false;
    private static final String invalidObjectSQL = "SELECT owner, object_name, object_type FROM sys.all_objects WHERE status = 'INVALID'";

    public InvalidObjectsPanel(ISession session) {
        this._session = session;
        this.createGUI();
    }

    public ISession getSession() {
        return this._session;
    }

    protected DefaultTableModel createTableModel() {
        DefaultTableModel tm = new DefaultTableModel(){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        tm.addColumn(s_stringMgr.getString("oracle.owner"));
        tm.addColumn(s_stringMgr.getString("oracle.objectName"));
        tm.addColumn(s_stringMgr.getString("oracle.objectType"));
        return tm;
    }

    public synchronized void repopulateInvalidObjects() {
        try {
            PreparedStatement s = this._session.getSQLConnection().getConnection().prepareStatement(invalidObjectSQL);
            if (s.execute()) {
                ResultSet rs = s.getResultSet();
                DefaultTableModel tm = this.createTableModel();
                while (rs.next()) {
                    String owner = rs.getString(1);
                    String object_name = rs.getString(2);
                    String object_type = rs.getString(3);
                    tm.addRow(new Object[]{owner, object_name, object_type});
                }
                this._invalidObjects.setModel(tm);
                if (!this.hasResized) {
                    this.hasResized = true;
                    this._invalidObjects.resizeColumnWidth(300);
                }
            }
        }
        catch (SQLException ex) {
            this._session.showErrorMessage((Throwable)ex);
        }
    }

    private void createGUI() {
        this.setLayout(new BorderLayout());
        this._invalidObjects = new AutoWidthResizeTable();
        this._invalidObjects.setAutoResizeMode(0);
        this.add(new JScrollPane(this._invalidObjects));
        this.repopulateInvalidObjects();
    }
}

