/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.oracle.expander;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.ISQLConnection;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.SQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.plugins.oracle.OraclePlugin;

public class UserParentExpander
implements INodeExpander {
    private static final String SQL_ADMIN = "select username from dba_users order by username";
    private static final String SQL_USER = "select username from user_users order by username";
    protected final boolean isAdmin;

    public UserParentExpander(ISession session) {
        this.isAdmin = OraclePlugin.checkObjectAccessible(session, SQL_ADMIN);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ObjectTreeNode> createChildren(ISession session, ObjectTreeNode parentNode) throws SQLException {
        ArrayList<ObjectTreeNode> childNodes = new ArrayList<ObjectTreeNode>();
        ISQLConnection conn = session.getSQLConnection();
        SQLDatabaseMetaData md = session.getSQLConnection().getSQLMetaData();
        IDatabaseObjectInfo parentDbinfo = parentNode.getDatabaseObjectInfo();
        String schemaName = parentDbinfo.getSchemaName();
        PreparedStatement pstmt = conn.prepareStatement(this.isAdmin ? SQL_ADMIN : SQL_USER);
        try {
            ResultSet rs = pstmt.executeQuery();
            try {
                while (rs.next()) {
                    DatabaseObjectInfo doi = new DatabaseObjectInfo(null, schemaName, rs.getString(1), DatabaseObjectType.USER, (ISQLDatabaseMetaData)md);
                    childNodes.add(new ObjectTreeNode(session, (IDatabaseObjectInfo)doi));
                }
            }
            finally {
                rs.close();
            }
        }
        finally {
            pstmt.close();
        }
        return childNodes;
    }
}

