/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.connection;

import com.mchange.v2.c3p0.DataSources;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Environment;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.connection.ConnectionProviderFactory;
import org.hibernate.util.PropertiesHelper;
import org.hibernate.util.ReflectHelper;

public class C3P0ConnectionProvider
implements ConnectionProvider {
    private static final Log log = LogFactory.getLog((Class)C3P0ConnectionProvider.class);
    private static final String C3P0_STYLE_MIN_POOL_SIZE = "c3p0.minPoolSize";
    private static final String C3P0_STYLE_MAX_POOL_SIZE = "c3p0.maxPoolSize";
    private static final String C3P0_STYLE_MAX_IDLE_TIME = "c3p0.maxIdleTime";
    private static final String C3P0_STYLE_MAX_STATEMENTS = "c3p0.maxStatements";
    private static final String C3P0_STYLE_ACQUIRE_INCREMENT = "c3p0.acquireIncrement";
    private static final String C3P0_STYLE_IDLE_CONNECTION_TEST_PERIOD = "c3p0.idleConnectionTestPeriod";
    private static final String C3P0_STYLE_TEST_CONNECTION_ON_CHECKOUT = "c3p0.testConnectionOnCheckout";
    private static final String C3P0_STYLE_INITIAL_POOL_SIZE = "c3p0.initialPoolSize";
    private DataSource ds;
    private Integer isolation;
    private boolean autocommit;

    public Connection getConnection() throws SQLException {
        Connection c = this.ds.getConnection();
        if (this.isolation != null) {
            c.setTransactionIsolation(this.isolation);
        }
        if (c.getAutoCommit() != this.autocommit) {
            c.setAutoCommit(this.autocommit);
        }
        return c;
    }

    public void closeConnection(Connection conn) throws SQLException {
        conn.close();
    }

    public void configure(Properties props) throws HibernateException {
        String jdbcDriverClass = props.getProperty("hibernate.connection.driver_class");
        String jdbcUrl = props.getProperty("hibernate.connection.url");
        Properties connectionProps = ConnectionProviderFactory.getConnectionProperties(props);
        log.info((Object)("C3P0 using driver: " + jdbcDriverClass + " at URL: " + jdbcUrl));
        log.info((Object)("Connection properties: " + PropertiesHelper.maskOut(connectionProps, "password")));
        this.autocommit = PropertiesHelper.getBoolean("hibernate.connection.autocommit", props);
        log.info((Object)("autocommit mode: " + this.autocommit));
        if (jdbcDriverClass == null) {
            log.warn((Object)"No JDBC Driver class was specified by property hibernate.connection.driver_class");
        } else {
            try {
                Class.forName(jdbcDriverClass);
            }
            catch (ClassNotFoundException cnfe) {
                try {
                    ReflectHelper.classForName(jdbcDriverClass);
                }
                catch (ClassNotFoundException e) {
                    String msg = "JDBC Driver class not found: " + jdbcDriverClass;
                    log.fatal((Object)msg, (Throwable)e);
                    throw new HibernateException(msg, e);
                }
            }
        }
        try {
            Integer minPoolSize = PropertiesHelper.getInteger("hibernate.c3p0.min_size", props);
            Integer maxPoolSize = PropertiesHelper.getInteger("hibernate.c3p0.max_size", props);
            Integer maxIdleTime = PropertiesHelper.getInteger("hibernate.c3p0.timeout", props);
            Integer maxStatements = PropertiesHelper.getInteger("hibernate.c3p0.max_statements", props);
            Integer acquireIncrement = PropertiesHelper.getInteger("hibernate.c3p0.acquire_increment", props);
            Integer idleTestPeriod = PropertiesHelper.getInteger("hibernate.c3p0.idle_test_period", props);
            Properties c3props = new Properties();
            Iterator<Object> ii = props.keySet().iterator();
            while (ii.hasNext()) {
                String key = (String)ii.next();
                if (!key.startsWith("hibernate.c3p0.")) continue;
                String newKey = key.substring(10);
                if (props.containsKey(newKey)) {
                    this.warnPropertyConflict(key, newKey);
                }
                c3props.put(newKey, props.get(key));
            }
            this.setOverwriteProperty("hibernate.c3p0.min_size", C3P0_STYLE_MIN_POOL_SIZE, props, c3props, minPoolSize);
            this.setOverwriteProperty("hibernate.c3p0.max_size", C3P0_STYLE_MAX_POOL_SIZE, props, c3props, maxPoolSize);
            this.setOverwriteProperty("hibernate.c3p0.timeout", C3P0_STYLE_MAX_IDLE_TIME, props, c3props, maxIdleTime);
            this.setOverwriteProperty("hibernate.c3p0.max_statements", C3P0_STYLE_MAX_STATEMENTS, props, c3props, maxStatements);
            this.setOverwriteProperty("hibernate.c3p0.acquire_increment", C3P0_STYLE_ACQUIRE_INCREMENT, props, c3props, acquireIncrement);
            this.setOverwriteProperty("hibernate.c3p0.idle_test_period", C3P0_STYLE_IDLE_CONNECTION_TEST_PERIOD, props, c3props, idleTestPeriod);
            Integer initialPoolSize = PropertiesHelper.getInteger(C3P0_STYLE_INITIAL_POOL_SIZE, props);
            if (initialPoolSize == null && minPoolSize != null) {
                c3props.put(C3P0_STYLE_INITIAL_POOL_SIZE, String.valueOf(minPoolSize).trim());
            }
            DataSource unpooled = DataSources.unpooledDataSource((String)jdbcUrl, (Properties)connectionProps);
            Properties allProps = (Properties)props.clone();
            allProps.putAll((Map<?, ?>)c3props);
            this.ds = DataSources.pooledDataSource((DataSource)unpooled, (Properties)allProps);
        }
        catch (Exception e) {
            log.fatal((Object)"could not instantiate C3P0 connection pool", (Throwable)e);
            throw new HibernateException("Could not instantiate C3P0 connection pool", e);
        }
        String i = props.getProperty("hibernate.connection.isolation");
        if (i == null) {
            this.isolation = null;
        } else {
            this.isolation = new Integer(i);
            log.info((Object)("JDBC isolation level: " + Environment.isolationLevelToString(this.isolation)));
        }
    }

    public void close() {
        try {
            DataSources.destroy((DataSource)this.ds);
        }
        catch (SQLException sqle) {
            log.warn((Object)"could not destroy C3P0 connection pool", (Throwable)sqle);
        }
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }

    private void setOverwriteProperty(String hibernateStyleKey, String c3p0StyleKey, Properties hibp, Properties c3p, Integer value) {
        if (value != null) {
            String longC3p0StyleKey;
            c3p.put(c3p0StyleKey, String.valueOf(value).trim());
            if (hibp.getProperty(c3p0StyleKey) != null) {
                this.warnPropertyConflict(hibernateStyleKey, c3p0StyleKey);
            }
            if (hibp.getProperty(longC3p0StyleKey = "hibernate." + c3p0StyleKey) != null) {
                this.warnPropertyConflict(hibernateStyleKey, longC3p0StyleKey);
            }
        }
    }

    private void warnPropertyConflict(String hibernateStyle, String c3p0Style) {
        log.warn((Object)("Both hibernate-style property '" + hibernateStyle + "' and c3p0-style property '" + c3p0Style + "' have been set in hibernate.properties. " + "Hibernate-style property '" + hibernateStyle + "' will be used " + "and c3p0-style property '" + c3p0Style + "' will be ignored!"));
    }
}

