/*
 * Decompiled with CFR 0.152.
 */
package org.postgis;

import java.io.IOException;
import java.util.Properties;

public class Version {
    private static final String RESSOURCENAME = "org/postgis/version.properties";
    public static final int MAJOR;
    public static final int MINOR;
    public static final String MICRO;
    public static final String FULL;

    public static void main(String[] args) {
        System.out.println(FULL);
    }

    public static String getFullVersion() {
        return FULL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        int major = -1;
        int minor = -1;
        String micro = null;
        try {
            ClassLoader loader = Version.class.getClassLoader();
            Properties prop = new Properties();
            try {
                prop.load(loader.getResourceAsStream(RESSOURCENAME));
            }
            catch (IOException e) {
                throw new ExceptionInInitializerError("Error initializing PostGIS JDBC version! Cause: Ressource org/postgis/version.properties cannot be read! " + e.getMessage());
            }
            catch (NullPointerException e) {
                throw new ExceptionInInitializerError("Error initializing PostGIS JDBC version! Cause: Ressource org/postgis/version.properties not found! " + e.getMessage());
            }
            try {
                major = Integer.parseInt(prop.getProperty("REL_MAJOR_VERSION"));
            }
            catch (NullPointerException e) {
                throw new ExceptionInInitializerError("Error initializing PostGIS JDBC version! Missing REL_MAJOR_VERSION! " + e.getMessage());
            }
            catch (NumberFormatException e) {
                throw new ExceptionInInitializerError("Error initializing PostGIS JDBC version! Error parsing REL_MAJOR_VERSION! " + e.getMessage());
            }
            try {
                minor = Integer.parseInt(prop.getProperty("REL_MINOR_VERSION"));
            }
            catch (NullPointerException e) {
                throw new ExceptionInInitializerError("Error initializing PostGIS JDBC version! Missing REL_MINOR_VERSION! " + e.getMessage());
            }
            catch (NumberFormatException e) {
                throw new ExceptionInInitializerError("Error initializing PostGIS JDBC version! Error parsing REL_MINOR_VERSION! " + e.getMessage());
            }
            micro = prop.getProperty("REL_MICRO_VERSION");
            if (micro == null) {
                throw new ExceptionInInitializerError("Error initializing PostGIS JDBC version! Missing REL_MICRO_VERSION! ");
            }
        }
        finally {
            MAJOR = major;
            MINOR = minor;
            MICRO = micro;
        }
        FULL = "PostGIS JDBC V" + MAJOR + "." + MINOR + "." + MICRO;
    }
}

