/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.laf;

import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JComboBox;
import javax.swing.UIManager;
import net.sourceforge.squirrel_sql.plugins.laf.SubstanceLafPlaceholder;
import net.sourceforge.squirrel_sql.plugins.laf.jtattoo.JTattooLafPlaceholder;

public class LookAndFeelComboBox
extends JComboBox {
    private static final long serialVersionUID = 1L;
    private Map<String, UIManager.LookAndFeelInfo> _lafsByName = new TreeMap<String, UIManager.LookAndFeelInfo>();
    private Map<String, UIManager.LookAndFeelInfo> _lafsByClassName = new TreeMap<String, UIManager.LookAndFeelInfo>();

    public LookAndFeelComboBox() {
        this((String)null);
    }

    public LookAndFeelComboBox(String selectedLafName) {
        this.generateLookAndFeelInfo();
        if (selectedLafName == null) {
            selectedLafName = UIManager.getLookAndFeel().getName();
        }
        this.setSelectedLookAndFeelName(selectedLafName);
    }

    public UIManager.LookAndFeelInfo getSelectedLookAndFeel() {
        return this._lafsByName.get(this.getSelectedItem());
    }

    public void setSelectedLookAndFeelName(String selectedLafName) {
        if (selectedLafName != null) {
            this.getModel().setSelectedItem(selectedLafName);
        }
    }

    public void setSelectedLookAndFeelClassName(String selectedLafClassName) {
        UIManager.LookAndFeelInfo info;
        if (selectedLafClassName != null && (info = this._lafsByClassName.get(selectedLafClassName)) != null) {
            this.setSelectedLookAndFeelName(info.getName());
        }
    }

    private void generateLookAndFeelInfo() {
        UIManager.LookAndFeelInfo[] info = UIManager.getInstalledLookAndFeels();
        this._lafsByName = new TreeMap<String, UIManager.LookAndFeelInfo>();
        for (int i = 0; i < info.length; ++i) {
            this._lafsByName.put(info[i].getName(), info[i]);
            this._lafsByClassName.put(info[i].getClassName(), info[i]);
        }
        SubstanceLafPlaceholder substanceLaf = new SubstanceLafPlaceholder();
        UIManager.LookAndFeelInfo substanceLafInfo = substanceLaf.getLookAndFeelInfo();
        this._lafsByName.put(substanceLaf.getName(), substanceLafInfo);
        this._lafsByClassName.put(SubstanceLafPlaceholder.class.getName(), substanceLafInfo);
        JTattooLafPlaceholder jtattooLaf = new JTattooLafPlaceholder();
        UIManager.LookAndFeelInfo jtattooLafInfo = jtattooLaf.getLookAndFeelInfo();
        this._lafsByName.put(jtattooLaf.getName(), jtattooLafInfo);
        this._lafsByClassName.put(JTattooLafPlaceholder.class.getName(), jtattooLafInfo);
        Iterator<UIManager.LookAndFeelInfo> it = this._lafsByName.values().iterator();
        while (it.hasNext()) {
            this.addItem(it.next().getName());
        }
    }
}

