/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernateConnection;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernatePluginResources;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.MappedClassInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.MappedClassInfoData;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.ObjectSubstituteRoot;
import net.sourceforge.squirrel_sql.plugins.hibernate.util.HibernateSQLUtil;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.IType;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.ObjectResultTab;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.ObjectResultTabControllerListener;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.ResultsController;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.RootType;
import net.sourceforge.squirrel_sql.plugins.hibernate.viewobjects.ViewObjectsUtil;

public class ObjectResultTabController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(ObjectResultTabController.class);
    private ObjectResultTab _tab;
    private ResultsController _resultsController;

    public ObjectResultTabController(List<ObjectSubstituteRoot> objects, int maxNumResults, final HibernateConnection con, final String hqlQuery, HibernatePluginResources resource, final ObjectResultTabControllerListener l, final ISession session) {
        this._tab = new ObjectResultTab(resource);
        this.initHqlQueryLabel(objects, hqlQuery, objects.size(), maxNumResults);
        this._tab.btnClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                l.closeTab(ObjectResultTabController.this);
            }
        });
        this._tab.btnCopySql.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ObjectResultTabController.this.onCopySqlToClip(con, hqlQuery, session);
            }
        });
        if (0 == objects.size()) {
            return;
        }
        ArrayList mappedClassInfos = con.getMappedClassInfos();
        MappedClassInfo plainValueArrayMappedClassInfo = this.getBestPlainValueArrayMappedClassInfo(objects);
        if (null != plainValueArrayMappedClassInfo) {
            mappedClassInfos = (ArrayList)mappedClassInfos.clone();
            mappedClassInfos.add(plainValueArrayMappedClassInfo);
        }
        this._resultsController = new ResultsController(this._tab.pnlResults, hqlQuery, mappedClassInfos, session);
        RootType qrmr = new RootType(objects, mappedClassInfos);
        DefaultMutableTreeNode rootNode = new DefaultMutableTreeNode(qrmr);
        this._tab.treeTypes.setModel(new DefaultTreeModel(rootNode));
        this._tab.treeTypes.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                ObjectResultTabController.this.onTreeExpanded(event);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
            }
        });
        this._tab.treeTypes.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                ObjectResultTabController.this.onTreeSelectionChanged(e);
            }
        });
        this.initRoot(rootNode);
    }

    private MappedClassInfo getBestPlainValueArrayMappedClassInfo(List<ObjectSubstituteRoot> objects) {
        MappedClassInfoData plainValueArrayMappedClassInfo = objects.get(0).getPlainValueArrayMappedClassInfo();
        if (null == plainValueArrayMappedClassInfo) {
            return null;
        }
        return new MappedClassInfo(plainValueArrayMappedClassInfo);
    }

    private void onCopySqlToClip(HibernateConnection con, String hqlQuery, ISession session) {
        HibernateSQLUtil.copySqlToClipboard(con, hqlQuery, session);
    }

    private void initHqlQueryLabel(List objects, String hqlQuery, int numResults, int maxNumResults) {
        if (numResults == maxNumResults) {
            this._tab.lblHqlQuery.setText(s_stringMgr.getString("ObjectResultTabController.queryInfoLimited", new Object[]{objects.size(), hqlQuery}));
        } else {
            this._tab.lblHqlQuery.setText(s_stringMgr.getString("ObjectResultTabController.queryInfo", new Object[]{objects.size(), hqlQuery}));
        }
    }

    private void onTreeSelectionChanged(TreeSelectionEvent e) {
        TreePath path = e.getNewLeadSelectionPath();
        if (null == path) {
            this._resultsController.clear();
            return;
        }
        DefaultMutableTreeNode n = (DefaultMutableTreeNode)path.getLastPathComponent();
        if (null != n && null != n.getUserObject()) {
            this._resultsController.typeChanged(n.getUserObject());
        } else {
            this._resultsController.clear();
        }
    }

    private void onTreeExpanded(TreeExpansionEvent event) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)event.getPath().getLastPathComponent();
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode kidNode = (DefaultMutableTreeNode)node.getChildAt(i);
            if (0 < kidNode.getChildCount()) continue;
            IType type = (IType)kidNode.getUserObject();
            for (IType iType : type.getKidTypes()) {
                kidNode.add(new DefaultMutableTreeNode(iType));
            }
        }
        ViewObjectsUtil.nodeStructurChanged(node, this._tab.treeTypes);
    }

    private void initRoot(DefaultMutableTreeNode rootNode) {
        RootType rootType = (RootType)rootNode.getUserObject();
        IType resultType = rootType.getResultType();
        DefaultMutableTreeNode kidNode = new DefaultMutableTreeNode(resultType);
        rootNode.add(kidNode);
        for (IType iType : resultType.getKidTypes()) {
            kidNode.add(new DefaultMutableTreeNode(iType));
        }
        ViewObjectsUtil.nodeStructurChanged(rootNode, this._tab.treeTypes);
    }

    public ObjectResultTab getPanel() {
        return this._tab;
    }
}

