/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.util;

import java.awt.Toolkit;
import java.awt.datatransfer.StringSelection;
import java.util.ArrayList;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.util.codereformat.CodeReformator;
import net.sourceforge.squirrel_sql.client.util.codereformat.CodeReformatorConfigFactory;
import net.sourceforge.squirrel_sql.plugins.hibernate.HibernateConnection;

public class HibernateSQLUtil {
    public static String createAllSqlsString(ArrayList<String> sqls, ISession session) {
        String allSqls = "";
        String sep = session.getQueryTokenizer().getSQLStatementSeparator();
        for (String sql : sqls) {
            allSqls = allSqls + sql;
            if (1 < sep.length()) {
                allSqls = allSqls + "\n";
            }
            allSqls = allSqls + sep + "\n\n";
        }
        return HibernateSQLUtil.format(allSqls, session).trim();
    }

    private static String format(String sqls, ISession session) {
        CodeReformator cr = new CodeReformator(CodeReformatorConfigFactory.createConfig((ISession)session));
        sqls = cr.reformat(sqls) + "\n";
        return sqls;
    }

    public static void copySqlToClipboard(HibernateConnection con, String hqlQuery, ISession session) {
        ArrayList<String> sqls = con.generateSQL(hqlQuery);
        String allSqlsString = HibernateSQLUtil.createAllSqlsString(sqls, session);
        StringSelection ss = new StringSelection(allSqlsString);
        Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ss, ss);
    }
}

