/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.hibernate.mapping;

import net.sourceforge.squirrel_sql.fw.completion.CompletionInfo;
import net.sourceforge.squirrel_sql.fw.completion.util.CompletionParser;
import net.sourceforge.squirrel_sql.plugins.hibernate.mapping.MappedClassInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.server.HibernatePropertyInfo;
import net.sourceforge.squirrel_sql.plugins.hibernate.util.HibernateUtil;

public class PropertyInfo
extends CompletionInfo {
    private HibernatePropertyInfo _hibernatePropertyInfo;
    private MappedClassInfo _mappedClassInfo;
    private String _mappedClassNameWithEndingDot;
    private String _fullQualifiedName;
    private String _simpleQualifiedName;
    private String _simpleMappedClassNameWithEndingDot;

    public PropertyInfo(HibernatePropertyInfo hibernatePropertyInfo, String mappedClassName) {
        this._hibernatePropertyInfo = hibernatePropertyInfo;
        this._fullQualifiedName = mappedClassName + "." + hibernatePropertyInfo;
        this._simpleQualifiedName = HibernateUtil.getSimpleClassName(mappedClassName) + "." + hibernatePropertyInfo;
        this._mappedClassNameWithEndingDot = mappedClassName + ".";
        this._simpleMappedClassNameWithEndingDot = HibernateUtil.getSimpleClassName(mappedClassName) + ".";
    }

    public String getCompareString() {
        return this._hibernatePropertyInfo.getPropertyName();
    }

    public String toString() {
        return this._hibernatePropertyInfo.toString();
    }

    public boolean matchesQualified(CompletionParser parser) {
        String stringToParse = parser.getStringToParse();
        return this._fullQualifiedName.startsWith(stringToParse) && stringToParse.startsWith(this._mappedClassNameWithEndingDot) || this._simpleQualifiedName.startsWith(stringToParse) && stringToParse.startsWith(this._simpleMappedClassNameWithEndingDot);
    }

    public boolean matchesUnQualified(String attrCandidate) {
        return this._hibernatePropertyInfo.getPropertyName().startsWith(attrCandidate);
    }

    public String getClassName() {
        return this._hibernatePropertyInfo.getClassName();
    }

    public HibernatePropertyInfo getHibernatePropertyInfo() {
        return this._hibernatePropertyInfo;
    }

    public MappedClassInfo getMappedClassInfo() {
        return this._mappedClassInfo;
    }

    public void setMappedClassInfo(MappedClassInfo mappedClassInfo) {
        this._mappedClassInfo = mappedClassInfo;
    }
}

