/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.derby;

import java.net.MalformedURLException;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginQueryTokenizerPreferencesManager;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallbackAdaptor;
import net.sourceforge.squirrel_sql.client.plugin.gui.PluginGlobalPreferencesTab;
import net.sourceforge.squirrel_sql.client.plugin.gui.PluginQueryTokenizerPreferencesPanel;
import net.sourceforge.squirrel_sql.client.preferences.IGlobalPreferencesPanel;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.event.ISessionListener;
import net.sourceforge.squirrel_sql.client.session.event.SessionAdapter;
import net.sourceforge.squirrel_sql.client.session.event.SessionEvent;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.ITableTriggerExtractor;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.TableWithChildNodesExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.DatabaseObjectInfoTab;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.IObjectTab;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.CellComponentFactory;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponentFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.id.IIdentifier;
import net.sourceforge.squirrel_sql.fw.preferences.IQueryTokenizerPreferenceBean;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.IQueryTokenizer;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDriver;
import net.sourceforge.squirrel_sql.fw.sql.SQLDriverManager;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.derby.exp.DerbyTableTriggerExtractorImpl;
import net.sourceforge.squirrel_sql.plugins.derby.prefs.DerbyPluginPreferencesPanel;
import net.sourceforge.squirrel_sql.plugins.derby.prefs.DerbyPreferenceBean;
import net.sourceforge.squirrel_sql.plugins.derby.tab.ProcedureSourceTab;
import net.sourceforge.squirrel_sql.plugins.derby.tab.TriggerDetailsTab;
import net.sourceforge.squirrel_sql.plugins.derby.tab.TriggerSourceTab;
import net.sourceforge.squirrel_sql.plugins.derby.tab.ViewSourceTab;
import net.sourceforge.squirrel_sql.plugins.derby.tokenizer.DerbyQueryTokenizer;
import net.sourceforge.squirrel_sql.plugins.derby.types.DerbyClobDataTypeComponentFactory;

public class DerbyPlugin
extends DefaultSessionPlugin {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DerbyPlugin.class);
    private static final ILogger s_log = LoggerController.createLogger(DerbyPlugin.class);
    private IObjectTreeAPI _treeAPI;
    private PluginQueryTokenizerPreferencesManager _prefsManager = null;

    public String getInternalName() {
        return "derby";
    }

    public String getDescriptiveName() {
        return "Derby Plugin";
    }

    public String getVersion() {
        return "0.13";
    }

    public String getAuthor() {
        return "Rob Manning";
    }

    public String getContributors() {
        return "Alex Pivovarov";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "doc/readme.html";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public synchronized void load(IApplication app) throws PluginException {
        super.load(app);
    }

    public IGlobalPreferencesPanel[] getGlobalPreferencePanels() {
        DerbyPluginPreferencesPanel _prefsPanel = new DerbyPluginPreferencesPanel(this._prefsManager);
        PluginGlobalPreferencesTab tab = new PluginGlobalPreferencesTab((PluginQueryTokenizerPreferencesPanel)_prefsPanel);
        tab.setHint(i18n.PREFS_HINT);
        tab.setTitle(i18n.PREFS_TITLE);
        return new IGlobalPreferencesPanel[]{tab};
    }

    public synchronized void initialize() throws PluginException {
        super.initialize();
        this._app.getSessionManager().addSessionListener((ISessionListener)new SessionListener());
        this._prefsManager = new PluginQueryTokenizerPreferencesManager();
        this._prefsManager.initialize((IPlugin)this, (IQueryTokenizerPreferenceBean)new DerbyPreferenceBean());
        DerbyPreferenceBean prefBean = (DerbyPreferenceBean)this._prefsManager.getPreferences();
        if (prefBean.isReadClobsFully()) {
            CellComponentFactory.registerDataTypeFactory((IDataTypeComponentFactory)new DerbyClobDataTypeComponentFactory());
        }
    }

    public boolean allowsSessionStartedInBackground() {
        return true;
    }

    public PluginSessionCallback sessionStarted(final ISession session) {
        DerbyPreferenceBean prefBean;
        if (!this.isPluginSession(session)) {
            return null;
        }
        if (s_log.isInfoEnabled()) {
            s_log.info((Object)"Installing Derby query tokenizer");
        }
        if ((prefBean = (DerbyPreferenceBean)this._prefsManager.getPreferences()).isInstallCustomQueryTokenizer()) {
            DerbyQueryTokenizer tokenizer = new DerbyQueryTokenizer(prefBean.getStatementSeparator(), prefBean.getLineComment(), prefBean.isRemoveMultiLineComments());
            session.setQueryTokenizer((IQueryTokenizer)tokenizer);
        }
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                DerbyPlugin.this.updateTreeApi(session);
            }
        });
        return new PluginSessionCallbackAdaptor((IPlugin)this);
    }

    protected boolean isPluginSession(ISession session) {
        return DialectFactory.isDerby((ISQLDatabaseMetaData)session.getMetaData());
    }

    private void updateTreeApi(ISession session) {
        DerbyPreferenceBean prefBean = (DerbyPreferenceBean)this._prefsManager.getPreferences();
        this._treeAPI = session.getSessionInternalFrame().getObjectTreeAPI();
        this._treeAPI.addDetailTab(DatabaseObjectType.PROCEDURE, (IObjectTab)new ProcedureSourceTab(i18n.SHOW_PROCEDURE_SOURCE, prefBean.getStatementSeparator()));
        this._treeAPI.addDetailTab(DatabaseObjectType.VIEW, (IObjectTab)new ViewSourceTab(i18n.SHOW_VIEW_SOURCE));
        this._treeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new DatabaseObjectInfoTab());
        this._treeAPI.addDetailTab(DatabaseObjectType.TRIGGER_TYPE_DBO, (IObjectTab)new DatabaseObjectInfoTab());
        TableWithChildNodesExpander trigExp = new TableWithChildNodesExpander();
        trigExp.setTableTriggerExtractor((ITableTriggerExtractor)new DerbyTableTriggerExtractorImpl());
        this._treeAPI.addExpander(DatabaseObjectType.TABLE, (INodeExpander)trigExp);
        this._treeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new TriggerDetailsTab());
        this._treeAPI.addDetailTab(DatabaseObjectType.TRIGGER, (IObjectTab)new TriggerSourceTab("The source of the trigger"));
    }

    private void shutdownEmbeddedDerby(ISession session) {
        try {
            ISQLDriver iSqlDr = session.getDriver();
            if (!iSqlDr.getDriverClassName().startsWith("org.apache.derby.jdbc.EmbeddedDriver")) {
                return;
            }
            IIdentifier drId = iSqlDr.getIdentifier();
            SQLDriverManager sqlDrMan = this._app.getSQLDriverManager();
            Driver jdbcDr = sqlDrMan.getJDBCDriver(drId);
            try {
                jdbcDr.connect("jdbc:derby:;shutdown=true", new Properties());
            }
            catch (SQLException e) {
                s_log.info((Object)e.getMessage());
            }
            sqlDrMan.registerSQLDriver(iSqlDr);
        }
        catch (RuntimeException e) {
            s_log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (MalformedURLException e) {
            s_log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            s_log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (InstantiationException e) {
            s_log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (ClassNotFoundException e) {
            s_log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    private class SessionListener
    extends SessionAdapter {
        private SessionListener() {
        }

        public void sessionClosed(SessionEvent evt) {
            ISession session = evt.getSession();
            DerbyPlugin.this.shutdownEmbeddedDerby(session);
        }
    }

    static interface i18n {
        public static final String SHOW_VIEW_SOURCE = DerbyPlugin.access$000().getString("DerbyPlugin.showViewSource");
        public static final String SHOW_PROCEDURE_SOURCE = DerbyPlugin.access$000().getString("DerbyPlugin.showProcedureSource");
        public static final String PREFS_TITLE = DerbyPlugin.access$000().getString("DerbyPlugin.prefsTitle");
        public static final String PREFS_HINT = DerbyPlugin.access$000().getString("DerbyPlugin.prefsHint");
    }
}

