/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.mysql.action;

import java.awt.Component;
import java.awt.event.ActionEvent;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.action.ISessionAction;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.ObjectTreeNode;
import net.sourceforge.squirrel_sql.fw.gui.Dialogs;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.util.IResources;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.mysql.MysqlPlugin;
import net.sourceforge.squirrel_sql.plugins.mysql.action.DropDatabaseCommand;

public class DropDatabaseAction
extends SquirrelAction
implements ISessionAction {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(DropDatabaseAction.class);
    private static final String TITLE = s_stringMgr.getString("mysql.droppingDBs");
    private static final String MSG = s_stringMgr.getString("mysql.sureDropping");
    private ISession _session;
    private final MysqlPlugin _plugin;

    public DropDatabaseAction(IApplication app, IResources resources, MysqlPlugin plugin) {
        super(app, resources);
        this._plugin = plugin;
    }

    public void actionPerformed(ActionEvent evt) {
        if (this._session != null) {
            IPlugin plugin = this._session.getApplication().getDummyAppPlugin();
            IObjectTreeAPI treeAPI = this._session.getSessionInternalFrame().getObjectTreeAPI();
            IDatabaseObjectInfo[] dbs = treeAPI.getSelectedDatabaseObjects();
            ObjectTreeNode[] nodes = treeAPI.getSelectedNodes();
            if (dbs.length > 0 && Dialogs.showYesNo((Component)this._session.getSessionSheet(), (String)MSG, (String)TITLE)) {
                try {
                    new DropDatabaseCommand(this._session, this._plugin, dbs).execute();
                    treeAPI.removeNodes(nodes);
                }
                catch (Throwable th) {
                    this._session.showErrorMessage(th);
                }
            }
        }
    }

    public void setSession(ISession session) {
        this._session = session;
    }
}

