/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.example;

import java.awt.event.ActionEvent;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.SquirrelAction;
import net.sourceforge.squirrel_sql.client.gui.session.SessionInternalFrame;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.fw.sql.IDatabaseObjectInfo;
import net.sourceforge.squirrel_sql.fw.sql.IProcedureInfo;
import net.sourceforge.squirrel_sql.fw.sql.SQLUtilities;
import net.sourceforge.squirrel_sql.fw.util.IResources;
import net.sourceforge.squirrel_sql.fw.util.Resources;

public class ScriptDB2ProcedureAction
extends SquirrelAction {
    private static final long serialVersionUID = 1L;
    private transient ISession _session;
    private static final String SQL = "SELECT TEXT FROM SYSIBM.SYSPROCEDURES WHERE PROCNAME = ? ";

    public ScriptDB2ProcedureAction(IApplication app, Resources rsrc, ISession session) {
        super(app, (IResources)rsrc);
        this._session = session;
    }

    public void actionPerformed(ActionEvent evt) {
        PreparedStatement stat = null;
        ResultSet res = null;
        try {
            IDatabaseObjectInfo[] dbObjs = this._session.getSessionInternalFrame().getObjectTreeAPI().getSelectedDatabaseObjects();
            stat = this._session.getSQLConnection().prepareStatement(SQL);
            StringBuffer script = new StringBuffer();
            for (int i = 0; i < dbObjs.length; ++i) {
                IProcedureInfo pi = (IProcedureInfo)dbObjs[i];
                stat.setString(1, pi.getSimpleName());
                res = stat.executeQuery();
                res.next();
                res.getString("TEXT");
                script.append(res.getString("TEXT"));
                script.append(this.getStatementSeparator());
                res.close();
            }
            stat.close();
            SessionInternalFrame sessMainFrm = this._session.getSessionInternalFrame();
            sessMainFrm.getSQLPanelAPI().appendSQLScript(script.toString());
            sessMainFrm.getSessionPanel().selectMainTab(1);
        }
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                SQLUtilities.closeResultSet(res);
                SQLUtilities.closeStatement(stat);
                throw throwable;
            }
        }
        SQLUtilities.closeResultSet((ResultSet)res);
        SQLUtilities.closeStatement((Statement)stat);
    }

    private String getStatementSeparator() {
        String statementSeparator = this._session.getQueryTokenizer().getSQLStatementSeparator();
        if (1 < statementSeparator.length()) {
            statementSeparator = "\n" + statementSeparator + "\n";
        }
        return statementSeparator;
    }
}

