/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.i18n;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.prefs.Preferences;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFileChooser;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.plugin.PluginInfo;
import net.sourceforge.squirrel_sql.client.util.ApplicationFiles;
import net.sourceforge.squirrel_sql.fw.util.LocaleUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.i18n.BundlesTableModel;
import net.sourceforge.squirrel_sql.plugins.i18n.I18nBundle;
import net.sourceforge.squirrel_sql.plugins.i18n.I18nProps;
import net.sourceforge.squirrel_sql.plugins.i18n.TranslatorsPanel;
import org.apache.commons.lang.StringUtils;

public class TranslatorsController {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(TranslatorsController.class);
    private static ILogger logger = LoggerController.createLogger(TranslatorsController.class);
    private static final String PREF_KEY_WORK_DIR = "SquirrelSQL.i18n.workDir";
    private static final String PREF_KEY_EDITOR_COMMAND = "SquirrelSQL.i18n.editorCommand";
    private static final String PREF_KEY_SELECTED_LOCALE = "SquirrelSQL.i18n.selectedLocale";
    private static final String PREF_KEY_NATIVE2ASCII_COMMAND = "SquirrelSQL.i18n.native2AsciiCommand";
    private static final String PREF_KEY_NATIVE2ASCII_OUT_DIR = "SquirrelSQL.i18n.native2AsciiOutDir";
    private static final String PREF_KEY_INCLUDE_TIMESTAMP = "SquirrelSQL.i18n.includeTimestamp";
    TranslatorsPanel _panel;
    private IApplication _app;
    private BundlesTableModel _bundlesTableModel;
    private JPopupMenu _popUp = new JPopupMenu();
    private JMenuItem _mnuGenerateTemplateComments = new JMenuItem(s_stringMgr.getString("I18n.generateTemplateComments"));
    private JMenuItem _mnuOpenInEditor = new JMenuItem(s_stringMgr.getString("I18n.openIOnEditor"));
    private JMenuItem _mnuExecuteNativeToAscii = new JMenuItem(s_stringMgr.getString("I18n.ExecuteNativeToAscii"));

    TranslatorsController(TranslatorsPanel panel) {
        this._panel = panel;
        this._bundlesTableModel = new BundlesTableModel();
        this._panel.tblBundels.setModel(this._bundlesTableModel);
        this._panel.cbxIncludeTimestamp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String includeTimestamp = Boolean.valueOf(TranslatorsController.this._panel.cbxIncludeTimestamp.isSelected()).toString();
                Preferences.userRoot().put(TranslatorsController.PREF_KEY_INCLUDE_TIMESTAMP, includeTimestamp);
            }
        });
        this._panel.cbxExcludeComplete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TranslatorsController.this.onLoadBundels(TranslatorsController.this._app);
                String excludeComplete = Boolean.valueOf(TranslatorsController.this._panel.cbxExcludeComplete.isSelected()).toString();
                Preferences.userRoot().put("SquirrelSQL.i18n.excludeComplete", excludeComplete);
            }
        });
        this._panel.btnChooseWorkDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TranslatorsController.this.onChooseWorkDir();
            }
        });
        this._panel.cboLocales.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                TranslatorsController.this.onLocaleChanged(e);
            }
        });
        this._panel.btnChooseEditorCommand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TranslatorsController.this.onChooseEditorCommand();
            }
        });
        this._panel.btnChooseNativeToAsciiCommand.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TranslatorsController.this.onChooseNativeToAsciiCommand();
            }
        });
        this._panel.btnChooseNativeToAsciiOutDir.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TranslatorsController.this.onChooseNativeToAsciiOutDir();
            }
        });
        this._panel.tblBundels.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                TranslatorsController.this.maybeShowPopup(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                TranslatorsController.this.maybeShowPopup(e);
            }
        });
        this._popUp.add(this._mnuGenerateTemplateComments);
        this._popUp.add(this._mnuOpenInEditor);
        this._popUp.add(this._mnuExecuteNativeToAscii);
        this._mnuGenerateTemplateComments.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TranslatorsController.this.onGenerate();
            }
        });
        this._mnuOpenInEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TranslatorsController.this.onOpenInEditor();
            }
        });
        this._mnuExecuteNativeToAscii.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TranslatorsController.this.onExecuteNativeToAscii();
            }
        });
        Locale[] availableLocales = LocaleUtils.getAvailableLocales();
        Locale selectedLocale = Locale.getDefault();
        String prefLocale = Preferences.userRoot().get(PREF_KEY_SELECTED_LOCALE, null);
        for (int i = 0; i < availableLocales.length; ++i) {
            this._panel.cboLocales.addItem(availableLocales[i]);
            if (!availableLocales[i].toString().equals(prefLocale)) continue;
            selectedLocale = availableLocales[i];
        }
        this._panel.cboLocales.setSelectedItem(selectedLocale);
        this._panel.btnLoad.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TranslatorsController.this.onLoadBundels(TranslatorsController.this._app);
            }
        });
        String workDir = Preferences.userRoot().get(PREF_KEY_WORK_DIR, null);
        this._panel.txtWorkingDir.setText(workDir);
        String editorCommand = Preferences.userRoot().get(PREF_KEY_EDITOR_COMMAND, null);
        this._panel.txtEditorCommand.setText(editorCommand);
        String nativeToAsciiCommand = Preferences.userRoot().get(PREF_KEY_NATIVE2ASCII_COMMAND, null);
        this._panel.txtNativeToAsciiCommand.setText(nativeToAsciiCommand);
        String nativeToAsciiOutDir = Preferences.userRoot().get(PREF_KEY_NATIVE2ASCII_OUT_DIR, null);
        this._panel.txtNativeToAsciiOutDir.setText(nativeToAsciiOutDir);
    }

    private void onChooseWorkDir() {
        JFileChooser chooser = new JFileChooser(System.getProperties().getProperty("user.home"));
        chooser.setFileSelectionMode(1);
        chooser.showOpenDialog((Component)this._app.getMainFrame());
        if (null != chooser.getSelectedFile()) {
            this._panel.txtWorkingDir.setText(chooser.getSelectedFile().getPath());
        }
    }

    private void onLocaleChanged(ItemEvent e) {
        if (1 == e.getStateChange()) {
            this._bundlesTableModel.setBundles(new I18nBundle[0]);
        }
    }

    private void onChooseEditorCommand() {
        JFileChooser chooser = new JFileChooser(System.getProperties().getProperty("user.home"));
        chooser.setFileSelectionMode(0);
        chooser.showOpenDialog((Component)this._app.getMainFrame());
        if (null != chooser.getSelectedFile()) {
            this._panel.txtEditorCommand.setText(chooser.getSelectedFile().getPath());
        }
    }

    private void onChooseNativeToAsciiCommand() {
        JFileChooser chooser = new JFileChooser(System.getProperties().getProperty("user.home"));
        chooser.setFileSelectionMode(0);
        chooser.showOpenDialog((Component)this._app.getMainFrame());
        if (null != chooser.getSelectedFile()) {
            this._panel.txtNativeToAsciiCommand.setText(chooser.getSelectedFile().getPath());
        }
    }

    private void onChooseNativeToAsciiOutDir() {
        JFileChooser chooser = new JFileChooser(System.getProperties().getProperty("user.home"));
        chooser.setFileSelectionMode(1);
        chooser.showOpenDialog((Component)this._app.getMainFrame());
        if (null != chooser.getSelectedFile()) {
            this._panel.txtNativeToAsciiOutDir.setText(chooser.getSelectedFile().getPath());
        }
    }

    private void onExecuteNativeToAscii() {
        String nativeToAsciiCommmand = this._panel.txtNativeToAsciiCommand.getText();
        if (null == nativeToAsciiCommmand || 0 == nativeToAsciiCommmand.length()) {
            String msg = s_stringMgr.getString("i18n.noNativeToAsciiCommand");
            JOptionPane.showMessageDialog((Component)this._app.getMainFrame(), msg);
            return;
        }
        String nativeToAsciiOutDir = this._panel.txtNativeToAsciiOutDir.getText();
        if (null == nativeToAsciiOutDir || 0 == nativeToAsciiOutDir.length()) {
            String msg = s_stringMgr.getString("i18n.noNativeToAsciiOutDir");
            JOptionPane.showMessageDialog((Component)this._app.getMainFrame(), msg);
            return;
        }
        File outDir = new File(nativeToAsciiOutDir);
        outDir.mkdirs();
        if (!outDir.isDirectory()) {
            String msg = s_stringMgr.getString("i18n.noNativeToAsciiOutDirNoDir");
            JOptionPane.showMessageDialog((Component)this._app.getMainFrame(), msg);
            return;
        }
        this.executeCommand(nativeToAsciiCommmand, true, outDir);
    }

    private void onOpenInEditor() {
        String editorCommmand = this._panel.txtEditorCommand.getText();
        if (null == editorCommmand || 0 == editorCommmand.length()) {
            String msg = s_stringMgr.getString("i18n.noEditorCommand");
            JOptionPane.showMessageDialog((Component)this._app.getMainFrame(), msg);
            return;
        }
        this.executeCommand(editorCommmand, false, null);
    }

    private void executeCommand(String command, boolean nativeToAscii, File native2AsciiOutDir) {
        String msg;
        int i;
        File workDir = this.getWorkDir(true);
        int[] selRows = this._panel.tblBundels.getSelectedRows();
        I18nBundle[] selBundles = this._bundlesTableModel.getBundlesForRows(selRows);
        if (0 == selBundles.length) {
            return;
        }
        boolean filesFound = false;
        ArrayList<String> commands = new ArrayList<String>();
        for (i = 0; i < selBundles.length; ++i) {
            File f = selBundles[i].getPathRelativeTo(workDir);
            if (f.exists()) {
                if (nativeToAscii) {
                    File outFile = selBundles[i].getPathRelativeTo(native2AsciiOutDir);
                    outFile.getParentFile().mkdirs();
                    commands.add(command + " " + f.getPath() + " " + outFile.getPath());
                } else {
                    if (0 == commands.size()) {
                        commands.add(command);
                    }
                    commands.add((String)commands.remove(0) + " " + f.getPath());
                }
                filesFound = true;
                continue;
            }
            String msg2 = s_stringMgr.getString("i18n.notGeneratedInWorkDir", new Object[]{f.getPath()});
            this._app.getMessageHandler().showMessage(msg2);
        }
        if (!filesFound) {
            String msg3 = s_stringMgr.getString("i18n.noFilesOpened");
            JOptionPane.showMessageDialog((Component)this._app.getMainFrame(), msg3);
            return;
        }
        try {
            for (i = 0; i < commands.size(); ++i) {
                msg = s_stringMgr.getString("i18n.executingCommand", new Object[]{commands.get(i)});
                this._app.getMessageHandler().showMessage(msg);
                Runtime.getRuntime().exec((String)commands.get(i));
            }
        }
        catch (IOException e) {
            msg = s_stringMgr.getString("i18n.executingCommandFailed", new Object[]{e.getMessage()});
            this._app.getMessageHandler().showMessage(msg);
            throw new RuntimeException(e);
        }
    }

    public void uninitialize() {
        Preferences.userRoot().put(PREF_KEY_SELECTED_LOCALE, "" + this._panel.cboLocales.getSelectedItem());
        Preferences.userRoot().put(PREF_KEY_WORK_DIR, this._panel.txtWorkingDir.getText());
        Preferences.userRoot().put(PREF_KEY_EDITOR_COMMAND, this._panel.txtEditorCommand.getText());
        Preferences.userRoot().put(PREF_KEY_NATIVE2ASCII_COMMAND, this._panel.txtNativeToAsciiCommand.getText());
        Preferences.userRoot().put(PREF_KEY_NATIVE2ASCII_OUT_DIR, this._panel.txtNativeToAsciiOutDir.getText());
    }

    private void maybeShowPopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this._popUp.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    private void onGenerate() {
        File workDir = this.getWorkDir(true);
        if (null == workDir) {
            return;
        }
        int[] selRows = this._panel.tblBundels.getSelectedRows();
        I18nBundle[] selBundles = this._bundlesTableModel.getBundlesForRows(selRows);
        for (int i = 0; i < selBundles.length; ++i) {
            selBundles[i].writeMissingProps(this._app, workDir);
        }
    }

    private File getWorkDir(boolean withMessages) {
        String buf = this._panel.txtWorkingDir.getText();
        if (null == buf || 0 == buf.trim().length()) {
            if (withMessages) {
                String msg = s_stringMgr.getString("I18n.NoWorkDir");
                JOptionPane.showMessageDialog((Component)this._app.getMainFrame(), msg);
            }
            return null;
        }
        File workDir = new File(buf);
        if (!workDir.isDirectory()) {
            if (withMessages) {
                String msg = s_stringMgr.getString("I18n.WorkDirIsNotADirectory", new Object[]{workDir.getPath()});
                JOptionPane.showMessageDialog((Component)this._app.getMainFrame(), msg);
            }
            return null;
        }
        if (!workDir.exists()) {
            String msg = s_stringMgr.getString("I18n.WorkDirDoesNotExistQuestionCreate", new Object[]{workDir.getPath()});
            if (withMessages) {
                if (0 == JOptionPane.showConfirmDialog((Component)this._app.getMainFrame(), msg) && !workDir.mkdirs()) {
                    msg = s_stringMgr.getString("I18n.CouldNotCreateWorkDir", new Object[]{workDir.getPath()});
                    JOptionPane.showMessageDialog((Component)this._app.getMainFrame(), msg);
                    return null;
                }
            } else {
                return null;
            }
        }
        return workDir;
    }

    private void onLoadBundels(IApplication app) {
        int i;
        String msg;
        Locale selLocale = (Locale)this._panel.cboLocales.getSelectedItem();
        File workDir = null;
        if (null != this._panel.txtWorkingDir.getText() && 0 < this._panel.txtWorkingDir.getText().trim().length()) {
            workDir = new File(this._panel.txtWorkingDir.getText());
            if (!workDir.exists()) {
                msg = s_stringMgr.getString("I18n.noWorkdir");
                if (0 == JOptionPane.showConfirmDialog((Component)app.getMainFrame(), msg)) {
                    workDir.mkdirs();
                }
            } else if (!workDir.isDirectory()) {
                msg = s_stringMgr.getString("I18n.WorkdirIsNoDir", new Object[]{workDir.getAbsolutePath()});
                JOptionPane.showMessageDialog((Component)app.getMainFrame(), msg);
            }
        } else {
            msg = s_stringMgr.getString("I18n.noWorkdirSpecified");
            JOptionPane.showMessageDialog((Component)app.getMainFrame(), msg);
        }
        URL[] sourceUrls = this.getUrlsToLoadI18nPropertiesFrom(workDir);
        String pluginDir = new ApplicationFiles().getPluginsDirectory().getPath();
        ArrayList<I18nProps> defaultI18nProps = new ArrayList<I18nProps>();
        ArrayList<I18nProps> localizedI18nProps = new ArrayList<I18nProps>();
        for (int i2 = 0; i2 < sourceUrls.length; ++i2) {
            File file = new File(sourceUrls[i2].getFile().replaceAll("%20", " "));
            if (file.isDirectory()) {
                this.findI18nInDir(selLocale, file, defaultI18nProps, localizedI18nProps, sourceUrls);
                continue;
            }
            if (file.getName().equalsIgnoreCase("squirrel-sql.jar") || file.getName().equalsIgnoreCase("fw.jar")) {
                this.findI18nInArchive(selLocale, file, defaultI18nProps, localizedI18nProps, sourceUrls);
                continue;
            }
            if (!file.getPath().startsWith(pluginDir)) continue;
            this.findI18nInArchive(selLocale, file, defaultI18nProps, localizedI18nProps, sourceUrls);
        }
        Hashtable<String, I18nBundle> i18nBundlesByName = new Hashtable<String, I18nBundle>();
        for (i = 0; i < defaultI18nProps.size(); ++i) {
            I18nProps i18nProps = (I18nProps)defaultI18nProps.get(i);
            I18nBundle pack = new I18nBundle(i18nProps, selLocale, this.getWorkDir(false), sourceUrls);
            if (this._panel.cbxExcludeComplete.isSelected() && pack.getMissingTranslationsCount() == 0) continue;
            i18nBundlesByName.put(i18nProps.getPath(), pack);
        }
        for (i = 0; i < localizedI18nProps.size(); ++i) {
            I18nProps locI18nProps = (I18nProps)localizedI18nProps.get(i);
            String key = locI18nProps.getUnlocalizedPath(selLocale);
            I18nBundle bundle = (I18nBundle)i18nBundlesByName.get(key);
            if (null == bundle) continue;
            bundle.setLocalizedProp(locI18nProps);
        }
        I18nBundle[] bundles = i18nBundlesByName.values().toArray(new I18nBundle[0]);
        int[] selRows = this._panel.tblBundels.getSelectedRows();
        this._bundlesTableModel.setBundles(bundles);
        for (int i3 = 0; i3 < selRows.length; ++i3) {
            this._panel.tblBundels.getSelectionModel().addSelectionInterval(selRows[i3], selRows[i3]);
        }
    }

    private URL[] getUrlsToLoadI18nPropertiesFrom(File workDir) {
        ApplicationFiles af = new ApplicationFiles();
        ArrayList<URL> ret = new ArrayList<URL>();
        URL[] urls = ((URLClassLoader)this._app.getClass().getClassLoader()).getURLs();
        for (int i = 0; i < urls.length; ++i) {
            File file = new File(urls[i].getFile().replaceAll("%20", " "));
            if (file.getName().equals(af.getSQuirrelJarFile().getName())) {
                ret.add(urls[i]);
                continue;
            }
            if (!file.getName().equals(af.getFwJarFile().getName())) continue;
            ret.add(urls[i]);
        }
        PluginInfo[] pi = this._app.getPluginManager().getPluginInformation();
        urls = this._app.getPluginManager().getPluginURLs();
        for (int i = 0; i < urls.length; ++i) {
            String jarName = new File(urls[i].getFile()).getName();
            if (!jarName.endsWith(".jar")) continue;
            String cleanJarName = jarName.substring(0, jarName.length() - ".jar".length());
            for (int j = 0; j < pi.length; ++j) {
                if (!pi[j].getInternalName().equalsIgnoreCase(cleanJarName)) continue;
                ret.add(urls[i]);
            }
        }
        return ret.toArray(new URL[ret.size()]);
    }

    private void findI18nInArchive(Locale selLoc, File file, ArrayList<I18nProps> defaultI18nProps, ArrayList<I18nProps> localizedI18nProps, URL[] sourceUrls) {
        try {
            ZipFile zf = new ZipFile(file);
            Enumeration<? extends ZipEntry> e = zf.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                if (!this.isTranslationPropertyFile(entry.getName())) continue;
                Locale loc = I18nProps.parseLocaleFromPropsFileName(entry.getName());
                if (null == loc) {
                    defaultI18nProps.add(new I18nProps(file, entry.getName(), sourceUrls));
                }
                if (!selLoc.equals(loc)) continue;
                localizedI18nProps.add(new I18nProps(file, entry.getName(), sourceUrls));
            }
        }
        catch (IOException e) {
            String msg = s_stringMgr.getString("I18n.failedToOpenZip", new Object[]{file.getAbsolutePath()});
            this._app.getMessageHandler().showMessage(msg);
            logger.error((Object)msg, (Throwable)e);
        }
    }

    private void findI18nInDir(Locale selLoc, File dir, ArrayList<I18nProps> defaultI18nProps, ArrayList<I18nProps> localizedI18nProps, URL[] sourceUrls) {
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.findI18nInDir(selLoc, files[i], defaultI18nProps, localizedI18nProps, sourceUrls);
                continue;
            }
            if (!this.isTranslationPropertyFile(files[i].getName())) continue;
            Locale loc = I18nProps.parseLocaleFromPropsFileName(files[i].getName());
            if (null == loc) {
                defaultI18nProps.add(new I18nProps(files[i], sourceUrls));
            }
            if (!selLoc.equals(loc)) continue;
            localizedI18nProps.add(new I18nProps(files[i], sourceUrls));
        }
    }

    private boolean isTranslationPropertyFile(String filename) {
        if (StringUtils.isEmpty((String)filename)) {
            return false;
        }
        if (filename.endsWith(".properties") && filename.toLowerCase().contains("i18nstrings")) {
            return true;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("File (" + filename + " doesn't appear to be a translation properties file."));
        }
        return false;
    }

    public void initialize(IApplication app) {
        this._app = app;
    }
}

