/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.app;

import java.awt.Component;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;

public class MenuBar
extends JMenuBar {
    private static final String MNEMONIC_SUFFIX = ".Mnemonic";
    private Map namedMenus;

    public void addExtraMenu(JMenu menu) {
        this.add((Component)menu, this.getExtraMenuInsertionIndex());
    }

    private static final void configureMenuItem(JMenuItem item, String desc) {
        item.setToolTipText(null);
        item.getAccessibleContext().setAccessibleDescription(desc);
    }

    protected JCheckBoxMenuItem createCheckBoxMenuItem(Action action) {
        JCheckBoxMenuItem item = new JCheckBoxMenuItem(action);
        item.setToolTipText(null);
        return item;
    }

    protected JMenu createMenu(ResourceBundle msg, String textKey) {
        JMenu menu = new JMenu(msg.getString(textKey));
        String mnemonicKey = textKey + MNEMONIC_SUFFIX;
        try {
            menu.setMnemonic((int)msg.getString(mnemonicKey).charAt(0));
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
        return menu;
    }

    protected JMenuItem createMenuItem(ResourceBundle msg, String textKey) {
        JMenuItem item = new JMenuItem(msg.getString(textKey));
        String mnemonicKey = textKey + MNEMONIC_SUFFIX;
        try {
            item.setMnemonic((int)msg.getString(mnemonicKey).charAt(0));
        }
        catch (MissingResourceException mre) {
            // empty catch block
        }
        return item;
    }

    protected JMenuItem createMenuItem(Action a, ResourceBundle bundle, String textKey, String mnemonicKey) {
        return this.createMenuItem(a, bundle, textKey, mnemonicKey, null);
    }

    protected JMenuItem createMenuItem(Action a, ResourceBundle bundle, String textKey, String mnemonicKey, KeyStroke accelerator) {
        JMenuItem item = new JMenuItem(a);
        item.setText(bundle.getString(textKey));
        item.setMnemonic((int)bundle.getString(mnemonicKey).charAt(0));
        item.setAccelerator(accelerator);
        return item;
    }

    protected JMenuItem createMenuItem(Action a, String desc) {
        JMenuItem item = new JMenuItem(a);
        MenuBar.configureMenuItem(item, desc);
        return item;
    }

    protected JMenuItem createMenuItem(Action a) {
        JMenuItem item = new JMenuItem(a);
        String desc = (String)a.getValue("ShortDescription");
        MenuBar.configureMenuItem(item, desc);
        return item;
    }

    protected JRadioButtonMenuItem createRadioButtonMenuItem(Action a, String description) {
        JRadioButtonMenuItem item = new JRadioButtonMenuItem(a);
        MenuBar.configureMenuItem(item, description);
        return item;
    }

    private int getExtraMenuInsertionIndex() {
        int count = this.getMenuCount();
        if (count == 0) {
            return 0;
        }
        JMenu menu = this.getMenu(count - 1);
        return menu != null ? count - 1 : count - 2;
    }

    public JMenu getMenuByName(String name) {
        return this.namedMenus != null ? (JMenu)this.namedMenus.get(name) : null;
    }

    public void registerMenuByName(String name, JMenu menu) {
        if (name == null) {
            throw new NullPointerException("menu name cannot be null");
        }
        if (this.namedMenus == null) {
            this.namedMenus = new HashMap();
        }
        this.namedMenus.put(name, menu);
    }
}

