/*
 * Decompiled with CFR 0.152.
 */
package unity.predicates;

import java.io.Serializable;
import java.sql.SQLException;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.predicates.JoinPredicate;
import unity.predicates.SelectionPredicate;

public class IntJoinPredicate
extends JoinPredicate
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int attr1Loc;
    private int attr2Loc;

    public IntJoinPredicate(int n, int n2, SelectionPredicate selectionPredicate) {
        this.attr1Loc = n;
        this.attr2Loc = n2;
        this.filterPredicate = selectionPredicate;
    }

    public int getAttr1Loc() {
        return this.attr1Loc;
    }

    public int getAttr2Loc() {
        return this.attr2Loc;
    }

    @Override
    public boolean isEquiJoin() {
        return true;
    }

    @Override
    public JoinPredicate inversePredicate() {
        IntJoinPredicate intJoinPredicate = new IntJoinPredicate(this.attr2Loc, this.attr1Loc, this.filterPredicate);
        intJoinPredicate.inverse = true;
        intJoinPredicate.filterPredicate = this.filterPredicate;
        intJoinPredicate.queryNode = this.queryNode;
        return intJoinPredicate;
    }

    @Override
    public boolean isEqual(Tuple tuple, Tuple tuple2) throws SQLException {
        int n = tuple.getInt(this.attr1Loc);
        if (tuple.wasNull) {
            return false;
        }
        int n2 = tuple2.getInt(this.attr2Loc);
        if (tuple2.wasNull) {
            return false;
        }
        if (n != n2) {
            return false;
        }
        if (this.filterPredicate == null) {
            return true;
        }
        return this.evaluateFilter(tuple, tuple2);
    }

    @Override
    public boolean isLessThan(Tuple tuple, Tuple tuple2) throws SQLException {
        int n = tuple.getInt(this.attr1Loc);
        int n2 = tuple2.getInt(this.attr2Loc);
        if (tuple.wasNull) {
            return !tuple2.wasNull;
        }
        if (tuple2.wasNull) {
            return false;
        }
        return n < n2;
    }

    @Override
    public String toString(Relation relation, Relation relation2) {
        StringBuilder stringBuilder = new StringBuilder(250);
        stringBuilder.append(relation.getAttribute(this.attr1Loc).getName() + " = " + relation2.getAttribute(this.attr2Loc).getName());
        if (this.filterPredicate != null) {
            Relation relation3 = new Relation(relation);
            relation3.mergeRelation(relation2);
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" AND ");
            }
            stringBuilder.append(this.filterPredicate.toString(relation3));
        }
        return stringBuilder.toString();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("Relation1.attribute#" + this.attr1Loc + " = " + "Relation2.attribute#" + this.attr2Loc);
        if (this.filterPredicate != null) {
            if (stringBuffer.length() > 0) {
                stringBuffer.append(" AND ");
            }
            stringBuffer.append(this.filterPredicate.toString());
        }
        return stringBuffer.toString();
    }

    @Override
    public int getHashKeyInput1(Tuple tuple) throws SQLException {
        return this.getHashKey(tuple, this.attr1Loc);
    }

    @Override
    public int getHashKeyInput2(Tuple tuple) throws SQLException {
        return this.getHashKey(tuple, this.attr2Loc);
    }

    private int getHashKey(Tuple tuple, int n) throws SQLException {
        if (tuple.isNull(n)) {
            tuple.setStatus((byte)1);
            return 0;
        }
        tuple.setStatus((byte)0);
        return tuple.getInt(n);
    }
}

